<?php
/**
 *
 * @package           sb-churchtools-grouphomepage
 *
 * @wordpress-plugin
 * Plugin Name:             Churchtools Integration
 * Description:             Direkt-Integration einiger ChurchTools Funktionen in die eigene Webseite mittels Gutenberg-Blöcken
 * Version: 2.0.28
 * Author:                  Steven Bühner
 * Author URI:              https://plugins.sv-schoenaich.de/?action=download&slug=sb-churchtools-grouphomepage
 * Text Domain:             sb-churchtools-grouphomepage
 * Domain Path:             /languages
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
	die;
}

// Composer Autoload
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
	require __DIR__ . '/vendor/autoload.php';
}


/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-sbWissensportal-activator.php
 */
function activate_sbChurchtoolsGrouphomepage():void {
	$container = \StevenBuehner\sbChurchtoolsGrouphomepage\Always\MyContainer::getSingleton();

	/** @var \StevenBuehner\sbChurchtoolsGrouphomepage\Always\Activator $activator */
	$activator = $container['activator'];

	$activator->activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-sbWissensportal-deactivator.php
 */
function deactivate_sbChurchtoolsGrouphomepage():void {
	$container = \StevenBuehner\sbChurchtoolsGrouphomepage\Always\MyContainer::getSingleton();

	/** @var \StevenBuehner\sbChurchtoolsGrouphomepage\Always\Deactivator $deactivator */
	$deactivator = $container['deactivator'];

	$deactivator->deactivate();
}

register_activation_hook(__FILE__, 'activate_sbChurchtoolsGrouphomepage');
register_deactivation_hook(__FILE__, 'deactivate_sbChurchtoolsGrouphomepage');


/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_sbChurchtoolsGrouphomepage():void {

	$container = \StevenBuehner\sbChurchtoolsGrouphomepage\Always\MyContainer::getSingleton();

	/** @var \StevenBuehner\sbChurchtoolsGrouphomepage\Always\MainController $mainController */
	$mainController = $container['mainController'];

	$mainController->run();

}

run_sbChurchtoolsGrouphomepage();
