<?php

namespace StevenBuehner\sbChurchtoolsGrouphomepage\Backend;

abstract class AbstractChurchToolsSettingsController {

	protected string $domain;
	protected        $sectionLabel;
	protected        $sectionId;

	static $registerdOnce = FALSE;

	public function __construct($domain, $sectionId, $sectionLabel) {
		$this->domain       = $domain;
		$this->sectionId    = $sectionId;
		$this->sectionLabel = $sectionLabel;
	}

	public function registerAjax() {
		// Fires only for logged in users with ?action=sb_documents_import
		// add_action('wp_ajax_sb_documents_import', [$this, 'runAjaxImport']);
	}


	public function registerSettingsMenu() {

		if (self::$registerdOnce === FALSE) {
			add_submenu_page(
				'options-general.php',                                              // top level menu page
				__('ChurchTools Settings', $this->domain),                          // title of the settings page
				__('ChurchTools', $this->domain),                                   // title of the submenu
				'manage_options',                                                   // capability of the user to see this page
				$this->getSettingsPageSlug(),                                       // slug of the settings page
				[$this, 'render_settings_page_html']                               // callback function to be called when rendering the page
			);
			self::$registerdOnce = TRUE;
		}

		add_action('admin_init', [$this, 'initSettings']);

	}


	public function getSettingsPageSlug(): string {
		return strtolower($this->domain . '_settings');
	}

	public function initSettings() {

		// Register Section
		add_settings_section(
			$this->sectionId,                                      // id of the section
			__($this->sectionLabel, $this->domain),                // title to be displayed
			'',                                                    // callback function to be called when opening section
			$this->getSettingsPageSlug() // page on which to display the section, this should be the same as the slug used in add_submenu_page()
		);

		$this->registerSetting($pageId = $this->getSettingsPageSlug(), $sectionId = $this->sectionId);

	}

	protected function renderTextField($optionId, $fieldType = 'text', $defaultValue = '') {
		$optionValue = get_option($optionId, $defaultValue);

		?>
		<div id="id_<?php echo esc_attr($optionId); ?>">
			<input type="<?php echo $fieldType; ?>"
				   name="<?php echo esc_attr($optionId); ?>"
				   id="<?php echo esc_attr($optionId); ?>_id"
				   value="<?php echo esc_attr($optionValue); ?>"
				   style="width: 300px"
			/>
		</div>
		<?php
	}


	public abstract function registerSetting($pageId, $sectionId);

	public function render_settings_page_html() {
		// check user capabilities
		if (!current_user_can('manage_options')) {
			return;
		}
		?>

		<div class="wrap">
			<?php settings_errors(); ?>
			<form method="POST" action="options.php">
				<?php settings_fields($this->getSettingsPageSlug()); ?>
				<?php do_settings_sections($this->getSettingsPageSlug()) ?>
				<?php submit_button(); ?>
			</form>
		</div>
		<?php
	}


}
