<?php

namespace StevenBuehner\sbChurchtoolsGrouphomepage\Helper;

class ArrayHelper {

	/**
	 * Extract the keys from an array and return a new array with only those values
	 * @param array $inputArray
	 * @param array $outputKeys
	 * @return array
	 */
	public static function onlyKeys(array $inputArray, array $outputKeys = []): array {

		$response = [];

		foreach ($outputKeys as $value) {
			if (isset($inputArray[$value])) {
				$response[$value] = $inputArray[$value];
			}
		}

		return $response;

	}

	public static function extractKeys(array $array, array $keys) {
		return array_intersect_key($array, array_flip($keys));
	}



}
