<?php

namespace StevenBuehner\sbChurchtoolsGrouphomepage\Helper;

use Symfony\Component\Cache\Adapter\FilesystemAdapter;

class CacheHelper {

	private static ?FilesystemAdapter $instance = NULL;

	public static function getInstance(): FilesystemAdapter {
		if (self::$instance === NULL) {
			self::$instance = self::setup();
		}

		return self::$instance;
	}

	protected static function setup(): FilesystemAdapter {
		$uploadCacheDir = WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'cache/sb-churchtools-grouphomepage';
		return new FilesystemAdapter(
			'default',
			60 * 10,
			$uploadCacheDir
		);
	}


}