<?php

namespace StevenBuehner\sbChurchtoolsGrouphomepage\Service\Models;

use StevenBuehner\sbChurchtoolsGrouphomepage\Helper\iCalHelper;
use DateTime;

class Event implements \JsonSerializable {

	protected string    $title        = '';
	protected ?DateTime $start        = NULL;
	protected ?DateTime $end          = NULL;
	protected string    $description  = '';
	protected string    $location     = '';
	protected ?string   $url          = NULL;
	protected ?string   $color        = NULL;
	protected bool      $isAllDay     = FALSE;
	protected ?string   $calendarName = NULL;
	protected ?string   $imageUrl     = NULL;

	public function getTitle(): string {
		return $this->title;
	}

	/**
	 * @param string $title
	 */
	public function setTitle(string $title): void {
		$this->title = $title;
	}

	/**
	 * @return ?DateTime
	 */
	public function getStart(): ?DateTime {
		return $this->start;
	}

	/**
	 * @param DateTime|NULL $start
	 */
	public function setStart(?DateTime $start): void {
		$this->start = $start;
	}

	/**
	 * @return DateTime|NULL
	 */
	public function getEnd(): ?DateTime {
		return $this->end;
	}

	/**
	 * @param DateTime|NULL $end
	 */
	public function setEnd(?DateTime $end): void {
		$this->end = $end;
	}

	/**
	 * @return ?string
	 */
	public function getColor(): ?string {
		return $this->color;
	}

	/**
	 * @param ?string $color
	 */
	public function setColor(?string $color): void {
		$this->color = $color;
	}

	public function getLocalized(bool $onlyDisplayDateIfNeccessarry = TRUE): string {
		return iCalHelper::formatLocalizedDateRange($this->getStart(), $this->getEnd(), $onlyDisplayDateIfNeccessarry);
	}

	public function isAllDay(): bool {
		return $this->isAllDay;
	}

	public function setAllDay(bool $isAllDay): void {
		$this->isAllDay = $isAllDay;
	}

	public function getDescription(): string {
		return $this->description;
	}

	public function setDescription(string $description): void {
		$this->description = $description;
	}

	public function clearDescription(): void {
		$this->description = '';
	}

	public function getLocation(): string {
		return $this->location;
	}

	public function setLocation(string $location): void {
		$this->location = $location;
	}

	public function getUrl(): ?string {
		return $this->url;
	}

	public function setUrl(?string $url): void {
		$this->url = $url;
	}

	public function getCalendarName(): ?string {
		return $this->calendarName;
	}

	public function setCalendarName(?string $calendarName): void {
		$this->calendarName = $calendarName;
	}

	public function getImageUrl(): ?string {
		return $this->imageUrl;
	}

	public function setImageUrl(?string $imageUrl): void {
		$this->imageUrl = $imageUrl;
	}


	public function __toArray(): array {
		return [
			'title'        => $this->getTitle(),
			'start'        => ($this->getStart() instanceof \DateTime) ? $this->getStart()->format('Y/m/d H:i:s') : NULL,
			'end'          => ($this->getEnd() instanceof \DateTime) ? $this->getEnd()->format('Y/m/d H:i:s') : NULL,
			'localized'    => $this->getLocalized(),
			'isAllDay'     => $this->isAllDay(),
			'description'  => $this->getDescription(),
			'location'     => $this->getLocation(),
			'url'          => $this->getUrl() ?: NULL,
			'color'        => $this->getColor() ?: NULL,
			'calendarName' => $this->getCalendarName() ?: NULL,
			'imageUrl'     => $this->getImageUrl() ?: NULL,
		];
	}

	public function jsonSerialize(): array {
		return $this->__toArray();
	}
}
