<?php
/**
 * EventApi
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use StevenBuehner\ChurchTools\ApiException;
use StevenBuehner\ChurchTools\Configuration;
use StevenBuehner\ChurchTools\HeaderSelector;
use StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * EventApi Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class EventApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'agendaExport' => [
            'application/json',
        ],
        'deleteEventsEventIdFactsFactId' => [
            'application/json',
        ],
        'deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy' => [
            'application/json',
        ],
        'deletePersonIdExchangerequestsRequestId' => [
            'application/json',
        ],
        'getAgendaForEvent' => [
            'application/json',
        ],
        'getAllEvents' => [
            'application/json',
        ],
        'getEvent' => [
            'application/json',
        ],
        'getEventIcal' => [
            'application/json',
        ],
        'getEventMasterdata' => [
            'application/json',
        ],
        'getEventsEventIdFacts' => [
            'application/json',
        ],
        'getEventsEventIdFactsFactId' => [
            'application/json',
        ],
        'getPersonEvents' => [
            'application/json',
        ],
        'getSongsOfAgenda' => [
            'application/json',
        ],
        'personEventsServices' => [
            'application/json',
        ],
        'personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet' => [
            'application/json',
        ],
        'personsPersonIdExchangerequestsGet' => [
            'application/json',
        ],
        'postPersonIdEventsEventIdServicesServiceIdExchangerequests' => [
            'application/json',
        ],
        'putEventsEventIdFactsFactId' => [
            'application/json',
        ],
        'putPersonIdExchangerequestsRequestId' => [
            'application/json',
        ],
        'sendAgendaEmail' => [
            'application/json',
        ],
        'sendEventEmail' => [
            'application/json',
        ],
        'startStopEventChat' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation agendaExport
     *
     * Exports the agenda
     *
     * @param  string $agenda_id agenda_id (required)
     * @param  string $target target (required)
     * @param  \StevenBuehner\ChurchTools\Model\AgendaExportRequest $agenda_export_request agenda_export_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['agendaExport'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\AgendaExport200Response
     */
    public function agendaExport($agenda_id, $target, $agenda_export_request = null, string $contentType = self::contentTypes['agendaExport'][0])
    {
        list($response) = $this->agendaExportWithHttpInfo($agenda_id, $target, $agenda_export_request, $contentType);
        return $response;
    }

    /**
     * Operation agendaExportWithHttpInfo
     *
     * Exports the agenda
     *
     * @param  string $agenda_id (required)
     * @param  string $target (required)
     * @param  \StevenBuehner\ChurchTools\Model\AgendaExportRequest $agenda_export_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['agendaExport'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\AgendaExport200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function agendaExportWithHttpInfo($agenda_id, $target, $agenda_export_request = null, string $contentType = self::contentTypes['agendaExport'][0])
    {
        $request = $this->agendaExportRequest($agenda_id, $target, $agenda_export_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\AgendaExport200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\AgendaExport200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\AgendaExport200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\AgendaExport200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\AgendaExport200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation agendaExportAsync
     *
     * Exports the agenda
     *
     * @param  string $agenda_id (required)
     * @param  string $target (required)
     * @param  \StevenBuehner\ChurchTools\Model\AgendaExportRequest $agenda_export_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['agendaExport'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function agendaExportAsync($agenda_id, $target, $agenda_export_request = null, string $contentType = self::contentTypes['agendaExport'][0])
    {
        return $this->agendaExportAsyncWithHttpInfo($agenda_id, $target, $agenda_export_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation agendaExportAsyncWithHttpInfo
     *
     * Exports the agenda
     *
     * @param  string $agenda_id (required)
     * @param  string $target (required)
     * @param  \StevenBuehner\ChurchTools\Model\AgendaExportRequest $agenda_export_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['agendaExport'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function agendaExportAsyncWithHttpInfo($agenda_id, $target, $agenda_export_request = null, string $contentType = self::contentTypes['agendaExport'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\AgendaExport200Response';
        $request = $this->agendaExportRequest($agenda_id, $target, $agenda_export_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'agendaExport'
     *
     * @param  string $agenda_id (required)
     * @param  string $target (required)
     * @param  \StevenBuehner\ChurchTools\Model\AgendaExportRequest $agenda_export_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['agendaExport'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function agendaExportRequest($agenda_id, $target, $agenda_export_request = null, string $contentType = self::contentTypes['agendaExport'][0])
    {

        // verify the required parameter 'agenda_id' is set
        if ($agenda_id === null || (is_array($agenda_id) && count($agenda_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $agenda_id when calling agendaExport'
            );
        }

        // verify the required parameter 'target' is set
        if ($target === null || (is_array($target) && count($target) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $target when calling agendaExport'
            );
        }



        $resourcePath = '/agendas/{agendaId}/export';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $target,
            'target', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($agenda_id !== null) {
            $resourcePath = str_replace(
                '{' . 'agendaId' . '}',
                ObjectSerializer::toPathValue($agenda_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($agenda_export_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($agenda_export_request));
            } else {
                $httpBody = $agenda_export_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteEventsEventIdFactsFactId
     *
     * Delete event fact
     *
     * @param  string $event_id event_id (required)
     * @param  string $fact_id fact_id (required)
     * @param  bool $dry_run dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteEventsEventIdFactsFactId($event_id, $fact_id, $dry_run = null, string $contentType = self::contentTypes['deleteEventsEventIdFactsFactId'][0])
    {
        $this->deleteEventsEventIdFactsFactIdWithHttpInfo($event_id, $fact_id, $dry_run, $contentType);
    }

    /**
     * Operation deleteEventsEventIdFactsFactIdWithHttpInfo
     *
     * Delete event fact
     *
     * @param  string $event_id (required)
     * @param  string $fact_id (required)
     * @param  bool $dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEventsEventIdFactsFactIdWithHttpInfo($event_id, $fact_id, $dry_run = null, string $contentType = self::contentTypes['deleteEventsEventIdFactsFactId'][0])
    {
        $request = $this->deleteEventsEventIdFactsFactIdRequest($event_id, $fact_id, $dry_run, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteEventsEventIdFactsFactIdAsync
     *
     * Delete event fact
     *
     * @param  string $event_id (required)
     * @param  string $fact_id (required)
     * @param  bool $dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEventsEventIdFactsFactIdAsync($event_id, $fact_id, $dry_run = null, string $contentType = self::contentTypes['deleteEventsEventIdFactsFactId'][0])
    {
        return $this->deleteEventsEventIdFactsFactIdAsyncWithHttpInfo($event_id, $fact_id, $dry_run, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteEventsEventIdFactsFactIdAsyncWithHttpInfo
     *
     * Delete event fact
     *
     * @param  string $event_id (required)
     * @param  string $fact_id (required)
     * @param  bool $dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEventsEventIdFactsFactIdAsyncWithHttpInfo($event_id, $fact_id, $dry_run = null, string $contentType = self::contentTypes['deleteEventsEventIdFactsFactId'][0])
    {
        $returnType = '';
        $request = $this->deleteEventsEventIdFactsFactIdRequest($event_id, $fact_id, $dry_run, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteEventsEventIdFactsFactId'
     *
     * @param  string $event_id (required)
     * @param  string $fact_id (required)
     * @param  bool $dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteEventsEventIdFactsFactIdRequest($event_id, $fact_id, $dry_run = null, string $contentType = self::contentTypes['deleteEventsEventIdFactsFactId'][0])
    {

        // verify the required parameter 'event_id' is set
        if ($event_id === null || (is_array($event_id) && count($event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $event_id when calling deleteEventsEventIdFactsFactId'
            );
        }

        // verify the required parameter 'fact_id' is set
        if ($fact_id === null || (is_array($fact_id) && count($fact_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fact_id when calling deleteEventsEventIdFactsFactId'
            );
        }



        $resourcePath = '/events/{eventId}/facts/{factId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dry_run,
            'dry_run', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'eventId' . '}',
                ObjectSerializer::toPathValue($event_id),
                $resourcePath
            );
        }
        // path params
        if ($fact_id !== null) {
            $resourcePath = str_replace(
                '{' . 'factId' . '}',
                ObjectSerializer::toPathValue($fact_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy
     *
     * Delete a service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id service_id (required)
     * @param  string $request_id request_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\DeletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyRequest $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy($person_id, $event_id, $service_id, $request_id, $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request = null, string $contentType = self::contentTypes['deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'][0])
    {
        $this->deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyWithHttpInfo($person_id, $event_id, $service_id, $request_id, $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request, $contentType);
    }

    /**
     * Operation deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyWithHttpInfo
     *
     * Delete a service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  string $request_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\DeletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyRequest $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyWithHttpInfo($person_id, $event_id, $service_id, $request_id, $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request = null, string $contentType = self::contentTypes['deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'][0])
    {
        $request = $this->deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyRequest($person_id, $event_id, $service_id, $request_id, $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyAsync
     *
     * Delete a service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  string $request_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\DeletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyRequest $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyAsync($person_id, $event_id, $service_id, $request_id, $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request = null, string $contentType = self::contentTypes['deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'][0])
    {
        return $this->deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyAsyncWithHttpInfo($person_id, $event_id, $service_id, $request_id, $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyAsyncWithHttpInfo
     *
     * Delete a service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  string $request_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\DeletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyRequest $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyAsyncWithHttpInfo($person_id, $event_id, $service_id, $request_id, $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request = null, string $contentType = self::contentTypes['deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'][0])
    {
        $returnType = '';
        $request = $this->deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyRequest($person_id, $event_id, $service_id, $request_id, $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  string $request_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\DeletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyRequest $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopyRequest($person_id, $event_id, $service_id, $request_id, $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request = null, string $contentType = self::contentTypes['deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'][0])
    {

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'
            );
        }

        // verify the required parameter 'event_id' is set
        if ($event_id === null || (is_array($event_id) && count($event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $event_id when calling deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'
            );
        }

        // verify the required parameter 'service_id' is set
        if ($service_id === null || (is_array($service_id) && count($service_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_id when calling deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'
            );
        }

        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling deletePersonIdEventsEventIdServicesServiceIdExchangerequestsCopy'
            );
        }



        $resourcePath = '/persons/{personId}/events/{eventId}/services/{serviceId}/exchangerequests/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($person_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personId' . '}',
                ObjectSerializer::toPathValue($person_id),
                $resourcePath
            );
        }
        // path params
        if ($event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'eventId' . '}',
                ObjectSerializer::toPathValue($event_id),
                $resourcePath
            );
        }
        // path params
        if ($service_id !== null) {
            $resourcePath = str_replace(
                '{' . 'serviceId' . '}',
                ObjectSerializer::toPathValue($service_id),
                $resourcePath
            );
        }
        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request));
            } else {
                $httpBody = $delete_person_id_events_event_id_services_service_id_exchangerequests_copy_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deletePersonIdExchangerequestsRequestId
     *
     * Decline a service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  string $request_id request_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePersonIdExchangerequestsRequestId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deletePersonIdExchangerequestsRequestId($person_id, $request_id, string $contentType = self::contentTypes['deletePersonIdExchangerequestsRequestId'][0])
    {
        $this->deletePersonIdExchangerequestsRequestIdWithHttpInfo($person_id, $request_id, $contentType);
    }

    /**
     * Operation deletePersonIdExchangerequestsRequestIdWithHttpInfo
     *
     * Decline a service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  string $request_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePersonIdExchangerequestsRequestId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePersonIdExchangerequestsRequestIdWithHttpInfo($person_id, $request_id, string $contentType = self::contentTypes['deletePersonIdExchangerequestsRequestId'][0])
    {
        $request = $this->deletePersonIdExchangerequestsRequestIdRequest($person_id, $request_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deletePersonIdExchangerequestsRequestIdAsync
     *
     * Decline a service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  string $request_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePersonIdExchangerequestsRequestId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePersonIdExchangerequestsRequestIdAsync($person_id, $request_id, string $contentType = self::contentTypes['deletePersonIdExchangerequestsRequestId'][0])
    {
        return $this->deletePersonIdExchangerequestsRequestIdAsyncWithHttpInfo($person_id, $request_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePersonIdExchangerequestsRequestIdAsyncWithHttpInfo
     *
     * Decline a service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  string $request_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePersonIdExchangerequestsRequestId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePersonIdExchangerequestsRequestIdAsyncWithHttpInfo($person_id, $request_id, string $contentType = self::contentTypes['deletePersonIdExchangerequestsRequestId'][0])
    {
        $returnType = '';
        $request = $this->deletePersonIdExchangerequestsRequestIdRequest($person_id, $request_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePersonIdExchangerequestsRequestId'
     *
     * @param  int $person_id ID of person (required)
     * @param  string $request_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePersonIdExchangerequestsRequestId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deletePersonIdExchangerequestsRequestIdRequest($person_id, $request_id, string $contentType = self::contentTypes['deletePersonIdExchangerequestsRequestId'][0])
    {

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling deletePersonIdExchangerequestsRequestId'
            );
        }

        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling deletePersonIdExchangerequestsRequestId'
            );
        }


        $resourcePath = '/persons/{personId}/exchangerequests/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($person_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personId' . '}',
                ObjectSerializer::toPathValue($person_id),
                $resourcePath
            );
        }
        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAgendaForEvent
     *
     * Get agenda for event
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAgendaForEvent'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetAgendaForEvent200Response|string
     */
    public function getAgendaForEvent($event_id, string $contentType = self::contentTypes['getAgendaForEvent'][0])
    {
        list($response) = $this->getAgendaForEventWithHttpInfo($event_id, $contentType);
        return $response;
    }

    /**
     * Operation getAgendaForEventWithHttpInfo
     *
     * Get agenda for event
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAgendaForEvent'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetAgendaForEvent200Response|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAgendaForEventWithHttpInfo($event_id, string $contentType = self::contentTypes['getAgendaForEvent'][0])
    {
        $request = $this->getAgendaForEventRequest($event_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetAgendaForEvent200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetAgendaForEvent200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetAgendaForEvent200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetAgendaForEvent200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetAgendaForEvent200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAgendaForEventAsync
     *
     * Get agenda for event
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAgendaForEvent'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAgendaForEventAsync($event_id, string $contentType = self::contentTypes['getAgendaForEvent'][0])
    {
        return $this->getAgendaForEventAsyncWithHttpInfo($event_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAgendaForEventAsyncWithHttpInfo
     *
     * Get agenda for event
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAgendaForEvent'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAgendaForEventAsyncWithHttpInfo($event_id, string $contentType = self::contentTypes['getAgendaForEvent'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetAgendaForEvent200Response';
        $request = $this->getAgendaForEventRequest($event_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAgendaForEvent'
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAgendaForEvent'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAgendaForEventRequest($event_id, string $contentType = self::contentTypes['getAgendaForEvent'][0])
    {

        // verify the required parameter 'event_id' is set
        if ($event_id === null || (is_array($event_id) && count($event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $event_id when calling getAgendaForEvent'
            );
        }


        $resourcePath = '/events/{eventId}/agenda';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'eventId' . '}',
                ObjectSerializer::toPathValue($event_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllEvents
     *
     * Get all events
     *
     * @param  \DateTime $from Start date from when events are returned. Default value: today (optional)
     * @param  \DateTime $to End date until when events are returned. Default value: two month from now (optional)
     * @param  bool $canceled If true, include also canceled events (optional)
     * @param  string $direction direction (optional)
     * @param  int $page page (optional)
     * @param  int $limit limit (optional)
     * @param  string $include to include the eventServices (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllEvents'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetAllEvents200Response|string
     */
    public function getAllEvents($from = null, $to = null, $canceled = null, $direction = null, $page = null, $limit = null, $include = null, string $contentType = self::contentTypes['getAllEvents'][0])
    {
        list($response) = $this->getAllEventsWithHttpInfo($from, $to, $canceled, $direction, $page, $limit, $include, $contentType);
        return $response;
    }

    /**
     * Operation getAllEventsWithHttpInfo
     *
     * Get all events
     *
     * @param  \DateTime $from Start date from when events are returned. Default value: today (optional)
     * @param  \DateTime $to End date until when events are returned. Default value: two month from now (optional)
     * @param  bool $canceled If true, include also canceled events (optional)
     * @param  string $direction (optional)
     * @param  int $page (optional)
     * @param  int $limit (optional)
     * @param  string $include to include the eventServices (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllEvents'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetAllEvents200Response|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllEventsWithHttpInfo($from = null, $to = null, $canceled = null, $direction = null, $page = null, $limit = null, $include = null, string $contentType = self::contentTypes['getAllEvents'][0])
    {
        $request = $this->getAllEventsRequest($from, $to, $canceled, $direction, $page, $limit, $include, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetAllEvents200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetAllEvents200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetAllEvents200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetAllEvents200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetAllEvents200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllEventsAsync
     *
     * Get all events
     *
     * @param  \DateTime $from Start date from when events are returned. Default value: today (optional)
     * @param  \DateTime $to End date until when events are returned. Default value: two month from now (optional)
     * @param  bool $canceled If true, include also canceled events (optional)
     * @param  string $direction (optional)
     * @param  int $page (optional)
     * @param  int $limit (optional)
     * @param  string $include to include the eventServices (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllEvents'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllEventsAsync($from = null, $to = null, $canceled = null, $direction = null, $page = null, $limit = null, $include = null, string $contentType = self::contentTypes['getAllEvents'][0])
    {
        return $this->getAllEventsAsyncWithHttpInfo($from, $to, $canceled, $direction, $page, $limit, $include, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllEventsAsyncWithHttpInfo
     *
     * Get all events
     *
     * @param  \DateTime $from Start date from when events are returned. Default value: today (optional)
     * @param  \DateTime $to End date until when events are returned. Default value: two month from now (optional)
     * @param  bool $canceled If true, include also canceled events (optional)
     * @param  string $direction (optional)
     * @param  int $page (optional)
     * @param  int $limit (optional)
     * @param  string $include to include the eventServices (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllEvents'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllEventsAsyncWithHttpInfo($from = null, $to = null, $canceled = null, $direction = null, $page = null, $limit = null, $include = null, string $contentType = self::contentTypes['getAllEvents'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetAllEvents200Response';
        $request = $this->getAllEventsRequest($from, $to, $canceled, $direction, $page, $limit, $include, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllEvents'
     *
     * @param  \DateTime $from Start date from when events are returned. Default value: today (optional)
     * @param  \DateTime $to End date until when events are returned. Default value: two month from now (optional)
     * @param  bool $canceled If true, include also canceled events (optional)
     * @param  string $direction (optional)
     * @param  int $page (optional)
     * @param  int $limit (optional)
     * @param  string $include to include the eventServices (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllEvents'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllEventsRequest($from = null, $to = null, $canceled = null, $direction = null, $page = null, $limit = null, $include = null, string $contentType = self::contentTypes['getAllEvents'][0])
    {









        $resourcePath = '/events';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from,
            'from', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to,
            'to', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $canceled,
            'canceled', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $direction,
            'direction', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include,
            'include', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEvent
     *
     * Get a single event
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEvent'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetEvent200Response|string
     */
    public function getEvent($event_id, string $contentType = self::contentTypes['getEvent'][0])
    {
        list($response) = $this->getEventWithHttpInfo($event_id, $contentType);
        return $response;
    }

    /**
     * Operation getEventWithHttpInfo
     *
     * Get a single event
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEvent'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetEvent200Response|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEventWithHttpInfo($event_id, string $contentType = self::contentTypes['getEvent'][0])
    {
        $request = $this->getEventRequest($event_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetEvent200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetEvent200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetEvent200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetEvent200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetEvent200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getEventAsync
     *
     * Get a single event
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEvent'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEventAsync($event_id, string $contentType = self::contentTypes['getEvent'][0])
    {
        return $this->getEventAsyncWithHttpInfo($event_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEventAsyncWithHttpInfo
     *
     * Get a single event
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEvent'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEventAsyncWithHttpInfo($event_id, string $contentType = self::contentTypes['getEvent'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetEvent200Response';
        $request = $this->getEventRequest($event_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEvent'
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEvent'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEventRequest($event_id, string $contentType = self::contentTypes['getEvent'][0])
    {

        // verify the required parameter 'event_id' is set
        if ($event_id === null || (is_array($event_id) && count($event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $event_id when calling getEvent'
            );
        }


        $resourcePath = '/events/{eventId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'eventId' . '}',
                ObjectSerializer::toPathValue($event_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEventIcal
     *
     * 
     *
     * @param  int $person_id person_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventIcal'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetEventIcal200Response
     */
    public function getEventIcal($person_id, string $contentType = self::contentTypes['getEventIcal'][0])
    {
        list($response) = $this->getEventIcalWithHttpInfo($person_id, $contentType);
        return $response;
    }

    /**
     * Operation getEventIcalWithHttpInfo
     *
     * 
     *
     * @param  int $person_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventIcal'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetEventIcal200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEventIcalWithHttpInfo($person_id, string $contentType = self::contentTypes['getEventIcal'][0])
    {
        $request = $this->getEventIcalRequest($person_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetEventIcal200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetEventIcal200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetEventIcal200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetEventIcal200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetEventIcal200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getEventIcalAsync
     *
     * 
     *
     * @param  int $person_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventIcal'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEventIcalAsync($person_id, string $contentType = self::contentTypes['getEventIcal'][0])
    {
        return $this->getEventIcalAsyncWithHttpInfo($person_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEventIcalAsyncWithHttpInfo
     *
     * 
     *
     * @param  int $person_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventIcal'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEventIcalAsyncWithHttpInfo($person_id, string $contentType = self::contentTypes['getEventIcal'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetEventIcal200Response';
        $request = $this->getEventIcalRequest($person_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEventIcal'
     *
     * @param  int $person_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventIcal'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEventIcalRequest($person_id, string $contentType = self::contentTypes['getEventIcal'][0])
    {

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling getEventIcal'
            );
        }


        $resourcePath = '/events/ical';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $person_id,
            'personId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEventMasterdata
     *
     * Fetch MasterData for Module \&quot;Event\&quot;
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventMasterdata'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\EventMasterData1|string
     */
    public function getEventMasterdata(string $contentType = self::contentTypes['getEventMasterdata'][0])
    {
        list($response) = $this->getEventMasterdataWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getEventMasterdataWithHttpInfo
     *
     * Fetch MasterData for Module \&quot;Event\&quot;
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventMasterdata'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\EventMasterData1|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEventMasterdataWithHttpInfo(string $contentType = self::contentTypes['getEventMasterdata'][0])
    {
        $request = $this->getEventMasterdataRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\EventMasterData1' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\EventMasterData1' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\EventMasterData1', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\EventMasterData1';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\EventMasterData1',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getEventMasterdataAsync
     *
     * Fetch MasterData for Module \&quot;Event\&quot;
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventMasterdata'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEventMasterdataAsync(string $contentType = self::contentTypes['getEventMasterdata'][0])
    {
        return $this->getEventMasterdataAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEventMasterdataAsyncWithHttpInfo
     *
     * Fetch MasterData for Module \&quot;Event\&quot;
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventMasterdata'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEventMasterdataAsyncWithHttpInfo(string $contentType = self::contentTypes['getEventMasterdata'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\EventMasterData1';
        $request = $this->getEventMasterdataRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEventMasterdata'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventMasterdata'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEventMasterdataRequest(string $contentType = self::contentTypes['getEventMasterdata'][0])
    {


        $resourcePath = '/event/masterdata';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEventsEventIdFacts
     *
     * Read facts for event
     *
     * @param  string $event_id event_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventsEventIdFacts'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetEventsEventIdFacts200Response
     */
    public function getEventsEventIdFacts($event_id, string $contentType = self::contentTypes['getEventsEventIdFacts'][0])
    {
        list($response) = $this->getEventsEventIdFactsWithHttpInfo($event_id, $contentType);
        return $response;
    }

    /**
     * Operation getEventsEventIdFactsWithHttpInfo
     *
     * Read facts for event
     *
     * @param  string $event_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventsEventIdFacts'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetEventsEventIdFacts200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEventsEventIdFactsWithHttpInfo($event_id, string $contentType = self::contentTypes['getEventsEventIdFacts'][0])
    {
        $request = $this->getEventsEventIdFactsRequest($event_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetEventsEventIdFacts200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetEventsEventIdFacts200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetEventsEventIdFacts200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetEventsEventIdFacts200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetEventsEventIdFacts200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getEventsEventIdFactsAsync
     *
     * Read facts for event
     *
     * @param  string $event_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventsEventIdFacts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEventsEventIdFactsAsync($event_id, string $contentType = self::contentTypes['getEventsEventIdFacts'][0])
    {
        return $this->getEventsEventIdFactsAsyncWithHttpInfo($event_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEventsEventIdFactsAsyncWithHttpInfo
     *
     * Read facts for event
     *
     * @param  string $event_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventsEventIdFacts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEventsEventIdFactsAsyncWithHttpInfo($event_id, string $contentType = self::contentTypes['getEventsEventIdFacts'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetEventsEventIdFacts200Response';
        $request = $this->getEventsEventIdFactsRequest($event_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEventsEventIdFacts'
     *
     * @param  string $event_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventsEventIdFacts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEventsEventIdFactsRequest($event_id, string $contentType = self::contentTypes['getEventsEventIdFacts'][0])
    {

        // verify the required parameter 'event_id' is set
        if ($event_id === null || (is_array($event_id) && count($event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $event_id when calling getEventsEventIdFacts'
            );
        }


        $resourcePath = '/events/{eventId}/facts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'eventId' . '}',
                ObjectSerializer::toPathValue($event_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEventsEventIdFactsFactId
     *
     * Read one event fact
     *
     * @param  string $event_id event_id (required)
     * @param  string $fact_id fact_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response
     */
    public function getEventsEventIdFactsFactId($event_id, $fact_id, string $contentType = self::contentTypes['getEventsEventIdFactsFactId'][0])
    {
        list($response) = $this->getEventsEventIdFactsFactIdWithHttpInfo($event_id, $fact_id, $contentType);
        return $response;
    }

    /**
     * Operation getEventsEventIdFactsFactIdWithHttpInfo
     *
     * Read one event fact
     *
     * @param  string $event_id (required)
     * @param  string $fact_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEventsEventIdFactsFactIdWithHttpInfo($event_id, $fact_id, string $contentType = self::contentTypes['getEventsEventIdFactsFactId'][0])
    {
        $request = $this->getEventsEventIdFactsFactIdRequest($event_id, $fact_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getEventsEventIdFactsFactIdAsync
     *
     * Read one event fact
     *
     * @param  string $event_id (required)
     * @param  string $fact_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEventsEventIdFactsFactIdAsync($event_id, $fact_id, string $contentType = self::contentTypes['getEventsEventIdFactsFactId'][0])
    {
        return $this->getEventsEventIdFactsFactIdAsyncWithHttpInfo($event_id, $fact_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEventsEventIdFactsFactIdAsyncWithHttpInfo
     *
     * Read one event fact
     *
     * @param  string $event_id (required)
     * @param  string $fact_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEventsEventIdFactsFactIdAsyncWithHttpInfo($event_id, $fact_id, string $contentType = self::contentTypes['getEventsEventIdFactsFactId'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response';
        $request = $this->getEventsEventIdFactsFactIdRequest($event_id, $fact_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEventsEventIdFactsFactId'
     *
     * @param  string $event_id (required)
     * @param  string $fact_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEventsEventIdFactsFactIdRequest($event_id, $fact_id, string $contentType = self::contentTypes['getEventsEventIdFactsFactId'][0])
    {

        // verify the required parameter 'event_id' is set
        if ($event_id === null || (is_array($event_id) && count($event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $event_id when calling getEventsEventIdFactsFactId'
            );
        }

        // verify the required parameter 'fact_id' is set
        if ($fact_id === null || (is_array($fact_id) && count($fact_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fact_id when calling getEventsEventIdFactsFactId'
            );
        }


        $resourcePath = '/events/{eventId}/facts/{factId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'eventId' . '}',
                ObjectSerializer::toPathValue($event_id),
                $resourcePath
            );
        }
        // path params
        if ($fact_id !== null) {
            $resourcePath = str_replace(
                '{' . 'factId' . '}',
                ObjectSerializer::toPathValue($fact_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPersonEvents
     *
     * Get events that person is involved with
     *
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersonEvents'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetEvent200Response|string
     */
    public function getPersonEvents($person_id, string $contentType = self::contentTypes['getPersonEvents'][0])
    {
        list($response) = $this->getPersonEventsWithHttpInfo($person_id, $contentType);
        return $response;
    }

    /**
     * Operation getPersonEventsWithHttpInfo
     *
     * Get events that person is involved with
     *
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersonEvents'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetEvent200Response|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPersonEventsWithHttpInfo($person_id, string $contentType = self::contentTypes['getPersonEvents'][0])
    {
        $request = $this->getPersonEventsRequest($person_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetEvent200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetEvent200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetEvent200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetEvent200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetEvent200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPersonEventsAsync
     *
     * Get events that person is involved with
     *
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersonEvents'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPersonEventsAsync($person_id, string $contentType = self::contentTypes['getPersonEvents'][0])
    {
        return $this->getPersonEventsAsyncWithHttpInfo($person_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPersonEventsAsyncWithHttpInfo
     *
     * Get events that person is involved with
     *
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersonEvents'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPersonEventsAsyncWithHttpInfo($person_id, string $contentType = self::contentTypes['getPersonEvents'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetEvent200Response';
        $request = $this->getPersonEventsRequest($person_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPersonEvents'
     *
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersonEvents'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPersonEventsRequest($person_id, string $contentType = self::contentTypes['getPersonEvents'][0])
    {

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling getPersonEvents'
            );
        }


        $resourcePath = '/persons/{personId}/events';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($person_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personId' . '}',
                ObjectSerializer::toPathValue($person_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSongsOfAgenda
     *
     * Get All Songs of Agenda
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSongsOfAgenda'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSongsOfAgenda200Response|string
     */
    public function getSongsOfAgenda($event_id, string $contentType = self::contentTypes['getSongsOfAgenda'][0])
    {
        list($response) = $this->getSongsOfAgendaWithHttpInfo($event_id, $contentType);
        return $response;
    }

    /**
     * Operation getSongsOfAgendaWithHttpInfo
     *
     * Get All Songs of Agenda
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSongsOfAgenda'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSongsOfAgenda200Response|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSongsOfAgendaWithHttpInfo($event_id, string $contentType = self::contentTypes['getSongsOfAgenda'][0])
    {
        $request = $this->getSongsOfAgendaRequest($event_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSongsOfAgenda200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSongsOfAgenda200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSongsOfAgenda200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSongsOfAgenda200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSongsOfAgenda200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSongsOfAgendaAsync
     *
     * Get All Songs of Agenda
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSongsOfAgenda'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSongsOfAgendaAsync($event_id, string $contentType = self::contentTypes['getSongsOfAgenda'][0])
    {
        return $this->getSongsOfAgendaAsyncWithHttpInfo($event_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSongsOfAgendaAsyncWithHttpInfo
     *
     * Get All Songs of Agenda
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSongsOfAgenda'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSongsOfAgendaAsyncWithHttpInfo($event_id, string $contentType = self::contentTypes['getSongsOfAgenda'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSongsOfAgenda200Response';
        $request = $this->getSongsOfAgendaRequest($event_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSongsOfAgenda'
     *
     * @param  int $event_id ID of Event (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSongsOfAgenda'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSongsOfAgendaRequest($event_id, string $contentType = self::contentTypes['getSongsOfAgenda'][0])
    {

        // verify the required parameter 'event_id' is set
        if ($event_id === null || (is_array($event_id) && count($event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $event_id when calling getSongsOfAgenda'
            );
        }


        $resourcePath = '/events/{eventId}/agenda/songs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'eventId' . '}',
                ObjectSerializer::toPathValue($event_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation personEventsServices
     *
     * Get all service exchange requests of a user for a service
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id service_id (required)
     * @param  bool $incoming If set to true, service exchange requests from other users for the user are returned. Otherwise (default) requests from this user for other users are returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personEventsServices'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]
     */
    public function personEventsServices($person_id, $event_id, $service_id, $incoming = null, string $contentType = self::contentTypes['personEventsServices'][0])
    {
        list($response) = $this->personEventsServicesWithHttpInfo($person_id, $event_id, $service_id, $incoming, $contentType);
        return $response;
    }

    /**
     * Operation personEventsServicesWithHttpInfo
     *
     * Get all service exchange requests of a user for a service
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  bool $incoming If set to true, service exchange requests from other users for the user are returned. Otherwise (default) requests from this user for other users are returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personEventsServices'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[], HTTP status code, HTTP response headers (array of strings)
     */
    public function personEventsServicesWithHttpInfo($person_id, $event_id, $service_id, $incoming = null, string $contentType = self::contentTypes['personEventsServices'][0])
    {
        $request = $this->personEventsServicesRequest($person_id, $event_id, $service_id, $incoming, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation personEventsServicesAsync
     *
     * Get all service exchange requests of a user for a service
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  bool $incoming If set to true, service exchange requests from other users for the user are returned. Otherwise (default) requests from this user for other users are returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personEventsServices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function personEventsServicesAsync($person_id, $event_id, $service_id, $incoming = null, string $contentType = self::contentTypes['personEventsServices'][0])
    {
        return $this->personEventsServicesAsyncWithHttpInfo($person_id, $event_id, $service_id, $incoming, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation personEventsServicesAsyncWithHttpInfo
     *
     * Get all service exchange requests of a user for a service
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  bool $incoming If set to true, service exchange requests from other users for the user are returned. Otherwise (default) requests from this user for other users are returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personEventsServices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function personEventsServicesAsyncWithHttpInfo($person_id, $event_id, $service_id, $incoming = null, string $contentType = self::contentTypes['personEventsServices'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]';
        $request = $this->personEventsServicesRequest($person_id, $event_id, $service_id, $incoming, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'personEventsServices'
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  bool $incoming If set to true, service exchange requests from other users for the user are returned. Otherwise (default) requests from this user for other users are returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personEventsServices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function personEventsServicesRequest($person_id, $event_id, $service_id, $incoming = null, string $contentType = self::contentTypes['personEventsServices'][0])
    {

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling personEventsServices'
            );
        }

        // verify the required parameter 'event_id' is set
        if ($event_id === null || (is_array($event_id) && count($event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $event_id when calling personEventsServices'
            );
        }

        // verify the required parameter 'service_id' is set
        if ($service_id === null || (is_array($service_id) && count($service_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_id when calling personEventsServices'
            );
        }



        $resourcePath = '/persons/{personId}/events/{eventId}/services/{serviceId}/exchangerequests';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $incoming,
            'incoming', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($person_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personId' . '}',
                ObjectSerializer::toPathValue($person_id),
                $resourcePath
            );
        }
        // path params
        if ($event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'eventId' . '}',
                ObjectSerializer::toPathValue($event_id),
                $resourcePath
            );
        }
        // path params
        if ($service_id !== null) {
            $resourcePath = str_replace(
                '{' . 'serviceId' . '}',
                ObjectSerializer::toPathValue($service_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet
     *
     * Get candidates for service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id service_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\200Response
     */
    public function personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet($person_id, $event_id, $service_id, string $contentType = self::contentTypes['personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'][0])
    {
        list($response) = $this->personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGetWithHttpInfo($person_id, $event_id, $service_id, $contentType);
        return $response;
    }

    /**
     * Operation personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGetWithHttpInfo
     *
     * Get candidates for service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGetWithHttpInfo($person_id, $event_id, $service_id, string $contentType = self::contentTypes['personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'][0])
    {
        $request = $this->personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGetRequest($person_id, $event_id, $service_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGetAsync
     *
     * Get candidates for service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGetAsync($person_id, $event_id, $service_id, string $contentType = self::contentTypes['personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'][0])
    {
        return $this->personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGetAsyncWithHttpInfo($person_id, $event_id, $service_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGetAsyncWithHttpInfo
     *
     * Get candidates for service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGetAsyncWithHttpInfo($person_id, $event_id, $service_id, string $contentType = self::contentTypes['personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\200Response';
        $request = $this->personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGetRequest($person_id, $event_id, $service_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGetRequest($person_id, $event_id, $service_id, string $contentType = self::contentTypes['personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'][0])
    {

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'
            );
        }

        // verify the required parameter 'event_id' is set
        if ($event_id === null || (is_array($event_id) && count($event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $event_id when calling personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'
            );
        }

        // verify the required parameter 'service_id' is set
        if ($service_id === null || (is_array($service_id) && count($service_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_id when calling personsPersonIdEventsEventIdServicesServiceIdExchangerequestsCandidatesGet'
            );
        }


        $resourcePath = '/persons/{personId}/events/{eventId}/services/{serviceId}/exchangerequests/candidates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($person_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personId' . '}',
                ObjectSerializer::toPathValue($person_id),
                $resourcePath
            );
        }
        // path params
        if ($event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'eventId' . '}',
                ObjectSerializer::toPathValue($event_id),
                $resourcePath
            );
        }
        // path params
        if ($service_id !== null) {
            $resourcePath = str_replace(
                '{' . 'serviceId' . '}',
                ObjectSerializer::toPathValue($service_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation personsPersonIdExchangerequestsGet
     *
     * Get all service exchange requests for a user
     *
     * @param  int $person_id ID of person (required)
     * @param  bool $person_is_requester If set to true, service exchange requests that the user requested are returned. Otherwise (default) requests from other users for the user are returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personsPersonIdExchangerequestsGet'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]
     */
    public function personsPersonIdExchangerequestsGet($person_id, $person_is_requester = null, string $contentType = self::contentTypes['personsPersonIdExchangerequestsGet'][0])
    {
        list($response) = $this->personsPersonIdExchangerequestsGetWithHttpInfo($person_id, $person_is_requester, $contentType);
        return $response;
    }

    /**
     * Operation personsPersonIdExchangerequestsGetWithHttpInfo
     *
     * Get all service exchange requests for a user
     *
     * @param  int $person_id ID of person (required)
     * @param  bool $person_is_requester If set to true, service exchange requests that the user requested are returned. Otherwise (default) requests from other users for the user are returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personsPersonIdExchangerequestsGet'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[], HTTP status code, HTTP response headers (array of strings)
     */
    public function personsPersonIdExchangerequestsGetWithHttpInfo($person_id, $person_is_requester = null, string $contentType = self::contentTypes['personsPersonIdExchangerequestsGet'][0])
    {
        $request = $this->personsPersonIdExchangerequestsGetRequest($person_id, $person_is_requester, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation personsPersonIdExchangerequestsGetAsync
     *
     * Get all service exchange requests for a user
     *
     * @param  int $person_id ID of person (required)
     * @param  bool $person_is_requester If set to true, service exchange requests that the user requested are returned. Otherwise (default) requests from other users for the user are returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personsPersonIdExchangerequestsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function personsPersonIdExchangerequestsGetAsync($person_id, $person_is_requester = null, string $contentType = self::contentTypes['personsPersonIdExchangerequestsGet'][0])
    {
        return $this->personsPersonIdExchangerequestsGetAsyncWithHttpInfo($person_id, $person_is_requester, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation personsPersonIdExchangerequestsGetAsyncWithHttpInfo
     *
     * Get all service exchange requests for a user
     *
     * @param  int $person_id ID of person (required)
     * @param  bool $person_is_requester If set to true, service exchange requests that the user requested are returned. Otherwise (default) requests from other users for the user are returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personsPersonIdExchangerequestsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function personsPersonIdExchangerequestsGetAsyncWithHttpInfo($person_id, $person_is_requester = null, string $contentType = self::contentTypes['personsPersonIdExchangerequestsGet'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner[]';
        $request = $this->personsPersonIdExchangerequestsGetRequest($person_id, $person_is_requester, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'personsPersonIdExchangerequestsGet'
     *
     * @param  int $person_id ID of person (required)
     * @param  bool $person_is_requester If set to true, service exchange requests that the user requested are returned. Otherwise (default) requests from other users for the user are returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['personsPersonIdExchangerequestsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function personsPersonIdExchangerequestsGetRequest($person_id, $person_is_requester = null, string $contentType = self::contentTypes['personsPersonIdExchangerequestsGet'][0])
    {

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling personsPersonIdExchangerequestsGet'
            );
        }



        $resourcePath = '/persons/{personId}/exchangerequests';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $person_is_requester,
            'personIsRequester', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($person_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personId' . '}',
                ObjectSerializer::toPathValue($person_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postPersonIdEventsEventIdServicesServiceIdExchangerequests
     *
     * Create a new service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id service_id (required)
     * @param  bool $incoming If set to true, service exchange requests from other users for the user are returned. Otherwise (default) requests from this user for other users are returned. (optional)
     * @param  \StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner $person_events_services200_response_inner person_events_services200_response_inner (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPersonIdEventsEventIdServicesServiceIdExchangerequests'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postPersonIdEventsEventIdServicesServiceIdExchangerequests($person_id, $event_id, $service_id, $incoming = null, $person_events_services200_response_inner = null, string $contentType = self::contentTypes['postPersonIdEventsEventIdServicesServiceIdExchangerequests'][0])
    {
        $this->postPersonIdEventsEventIdServicesServiceIdExchangerequestsWithHttpInfo($person_id, $event_id, $service_id, $incoming, $person_events_services200_response_inner, $contentType);
    }

    /**
     * Operation postPersonIdEventsEventIdServicesServiceIdExchangerequestsWithHttpInfo
     *
     * Create a new service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  bool $incoming If set to true, service exchange requests from other users for the user are returned. Otherwise (default) requests from this user for other users are returned. (optional)
     * @param  \StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner $person_events_services200_response_inner (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPersonIdEventsEventIdServicesServiceIdExchangerequests'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postPersonIdEventsEventIdServicesServiceIdExchangerequestsWithHttpInfo($person_id, $event_id, $service_id, $incoming = null, $person_events_services200_response_inner = null, string $contentType = self::contentTypes['postPersonIdEventsEventIdServicesServiceIdExchangerequests'][0])
    {
        $request = $this->postPersonIdEventsEventIdServicesServiceIdExchangerequestsRequest($person_id, $event_id, $service_id, $incoming, $person_events_services200_response_inner, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation postPersonIdEventsEventIdServicesServiceIdExchangerequestsAsync
     *
     * Create a new service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  bool $incoming If set to true, service exchange requests from other users for the user are returned. Otherwise (default) requests from this user for other users are returned. (optional)
     * @param  \StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner $person_events_services200_response_inner (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPersonIdEventsEventIdServicesServiceIdExchangerequests'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postPersonIdEventsEventIdServicesServiceIdExchangerequestsAsync($person_id, $event_id, $service_id, $incoming = null, $person_events_services200_response_inner = null, string $contentType = self::contentTypes['postPersonIdEventsEventIdServicesServiceIdExchangerequests'][0])
    {
        return $this->postPersonIdEventsEventIdServicesServiceIdExchangerequestsAsyncWithHttpInfo($person_id, $event_id, $service_id, $incoming, $person_events_services200_response_inner, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postPersonIdEventsEventIdServicesServiceIdExchangerequestsAsyncWithHttpInfo
     *
     * Create a new service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  bool $incoming If set to true, service exchange requests from other users for the user are returned. Otherwise (default) requests from this user for other users are returned. (optional)
     * @param  \StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner $person_events_services200_response_inner (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPersonIdEventsEventIdServicesServiceIdExchangerequests'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postPersonIdEventsEventIdServicesServiceIdExchangerequestsAsyncWithHttpInfo($person_id, $event_id, $service_id, $incoming = null, $person_events_services200_response_inner = null, string $contentType = self::contentTypes['postPersonIdEventsEventIdServicesServiceIdExchangerequests'][0])
    {
        $returnType = '';
        $request = $this->postPersonIdEventsEventIdServicesServiceIdExchangerequestsRequest($person_id, $event_id, $service_id, $incoming, $person_events_services200_response_inner, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postPersonIdEventsEventIdServicesServiceIdExchangerequests'
     *
     * @param  int $person_id ID of person (required)
     * @param  int $event_id ID of Event (required)
     * @param  string $service_id (required)
     * @param  bool $incoming If set to true, service exchange requests from other users for the user are returned. Otherwise (default) requests from this user for other users are returned. (optional)
     * @param  \StevenBuehner\ChurchTools\Model\PersonEventsServices200ResponseInner $person_events_services200_response_inner (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPersonIdEventsEventIdServicesServiceIdExchangerequests'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postPersonIdEventsEventIdServicesServiceIdExchangerequestsRequest($person_id, $event_id, $service_id, $incoming = null, $person_events_services200_response_inner = null, string $contentType = self::contentTypes['postPersonIdEventsEventIdServicesServiceIdExchangerequests'][0])
    {

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling postPersonIdEventsEventIdServicesServiceIdExchangerequests'
            );
        }

        // verify the required parameter 'event_id' is set
        if ($event_id === null || (is_array($event_id) && count($event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $event_id when calling postPersonIdEventsEventIdServicesServiceIdExchangerequests'
            );
        }

        // verify the required parameter 'service_id' is set
        if ($service_id === null || (is_array($service_id) && count($service_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_id when calling postPersonIdEventsEventIdServicesServiceIdExchangerequests'
            );
        }




        $resourcePath = '/persons/{personId}/events/{eventId}/services/{serviceId}/exchangerequests';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $incoming,
            'incoming', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($person_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personId' . '}',
                ObjectSerializer::toPathValue($person_id),
                $resourcePath
            );
        }
        // path params
        if ($event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'eventId' . '}',
                ObjectSerializer::toPathValue($event_id),
                $resourcePath
            );
        }
        // path params
        if ($service_id !== null) {
            $resourcePath = str_replace(
                '{' . 'serviceId' . '}',
                ObjectSerializer::toPathValue($service_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($person_events_services200_response_inner)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($person_events_services200_response_inner));
            } else {
                $httpBody = $person_events_services200_response_inner;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putEventsEventIdFactsFactId
     *
     * Create or update event fact
     *
     * @param  string $event_id event_id (required)
     * @param  string $fact_id fact_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutEventsEventIdFactsFactIdRequest $put_events_event_id_facts_fact_id_request Pass the &#x60;value&#x60; for that fact as payload. The value is always a &#x60;string&#x60;. For numeric facts the value MUST be a numeric value. For select facts the value MUST be a valid option. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response|\StevenBuehner\ChurchTools\Model\PutEventsEventIdFactsFactId400Response
     */
    public function putEventsEventIdFactsFactId($event_id, $fact_id, $put_events_event_id_facts_fact_id_request = null, string $contentType = self::contentTypes['putEventsEventIdFactsFactId'][0])
    {
        list($response) = $this->putEventsEventIdFactsFactIdWithHttpInfo($event_id, $fact_id, $put_events_event_id_facts_fact_id_request, $contentType);
        return $response;
    }

    /**
     * Operation putEventsEventIdFactsFactIdWithHttpInfo
     *
     * Create or update event fact
     *
     * @param  string $event_id (required)
     * @param  string $fact_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutEventsEventIdFactsFactIdRequest $put_events_event_id_facts_fact_id_request Pass the &#x60;value&#x60; for that fact as payload. The value is always a &#x60;string&#x60;. For numeric facts the value MUST be a numeric value. For select facts the value MUST be a valid option. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response|\StevenBuehner\ChurchTools\Model\PutEventsEventIdFactsFactId400Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function putEventsEventIdFactsFactIdWithHttpInfo($event_id, $fact_id, $put_events_event_id_facts_fact_id_request = null, string $contentType = self::contentTypes['putEventsEventIdFactsFactId'][0])
    {
        $request = $this->putEventsEventIdFactsFactIdRequest($event_id, $fact_id, $put_events_event_id_facts_fact_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\StevenBuehner\ChurchTools\Model\PutEventsEventIdFactsFactId400Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PutEventsEventIdFactsFactId400Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PutEventsEventIdFactsFactId400Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PutEventsEventIdFactsFactId400Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putEventsEventIdFactsFactIdAsync
     *
     * Create or update event fact
     *
     * @param  string $event_id (required)
     * @param  string $fact_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutEventsEventIdFactsFactIdRequest $put_events_event_id_facts_fact_id_request Pass the &#x60;value&#x60; for that fact as payload. The value is always a &#x60;string&#x60;. For numeric facts the value MUST be a numeric value. For select facts the value MUST be a valid option. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putEventsEventIdFactsFactIdAsync($event_id, $fact_id, $put_events_event_id_facts_fact_id_request = null, string $contentType = self::contentTypes['putEventsEventIdFactsFactId'][0])
    {
        return $this->putEventsEventIdFactsFactIdAsyncWithHttpInfo($event_id, $fact_id, $put_events_event_id_facts_fact_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putEventsEventIdFactsFactIdAsyncWithHttpInfo
     *
     * Create or update event fact
     *
     * @param  string $event_id (required)
     * @param  string $fact_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutEventsEventIdFactsFactIdRequest $put_events_event_id_facts_fact_id_request Pass the &#x60;value&#x60; for that fact as payload. The value is always a &#x60;string&#x60;. For numeric facts the value MUST be a numeric value. For select facts the value MUST be a valid option. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putEventsEventIdFactsFactIdAsyncWithHttpInfo($event_id, $fact_id, $put_events_event_id_facts_fact_id_request = null, string $contentType = self::contentTypes['putEventsEventIdFactsFactId'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetEventsEventIdFactsFactId200Response';
        $request = $this->putEventsEventIdFactsFactIdRequest($event_id, $fact_id, $put_events_event_id_facts_fact_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putEventsEventIdFactsFactId'
     *
     * @param  string $event_id (required)
     * @param  string $fact_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutEventsEventIdFactsFactIdRequest $put_events_event_id_facts_fact_id_request Pass the &#x60;value&#x60; for that fact as payload. The value is always a &#x60;string&#x60;. For numeric facts the value MUST be a numeric value. For select facts the value MUST be a valid option. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putEventsEventIdFactsFactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putEventsEventIdFactsFactIdRequest($event_id, $fact_id, $put_events_event_id_facts_fact_id_request = null, string $contentType = self::contentTypes['putEventsEventIdFactsFactId'][0])
    {

        // verify the required parameter 'event_id' is set
        if ($event_id === null || (is_array($event_id) && count($event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $event_id when calling putEventsEventIdFactsFactId'
            );
        }

        // verify the required parameter 'fact_id' is set
        if ($fact_id === null || (is_array($fact_id) && count($fact_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fact_id when calling putEventsEventIdFactsFactId'
            );
        }



        $resourcePath = '/events/{eventId}/facts/{factId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'eventId' . '}',
                ObjectSerializer::toPathValue($event_id),
                $resourcePath
            );
        }
        // path params
        if ($fact_id !== null) {
            $resourcePath = str_replace(
                '{' . 'factId' . '}',
                ObjectSerializer::toPathValue($fact_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($put_events_event_id_facts_fact_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($put_events_event_id_facts_fact_id_request));
            } else {
                $httpBody = $put_events_event_id_facts_fact_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putPersonIdExchangerequestsRequestId
     *
     * Accept a service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  string $request_id request_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putPersonIdExchangerequestsRequestId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function putPersonIdExchangerequestsRequestId($person_id, $request_id, string $contentType = self::contentTypes['putPersonIdExchangerequestsRequestId'][0])
    {
        $this->putPersonIdExchangerequestsRequestIdWithHttpInfo($person_id, $request_id, $contentType);
    }

    /**
     * Operation putPersonIdExchangerequestsRequestIdWithHttpInfo
     *
     * Accept a service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  string $request_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putPersonIdExchangerequestsRequestId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function putPersonIdExchangerequestsRequestIdWithHttpInfo($person_id, $request_id, string $contentType = self::contentTypes['putPersonIdExchangerequestsRequestId'][0])
    {
        $request = $this->putPersonIdExchangerequestsRequestIdRequest($person_id, $request_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation putPersonIdExchangerequestsRequestIdAsync
     *
     * Accept a service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  string $request_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putPersonIdExchangerequestsRequestId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putPersonIdExchangerequestsRequestIdAsync($person_id, $request_id, string $contentType = self::contentTypes['putPersonIdExchangerequestsRequestId'][0])
    {
        return $this->putPersonIdExchangerequestsRequestIdAsyncWithHttpInfo($person_id, $request_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putPersonIdExchangerequestsRequestIdAsyncWithHttpInfo
     *
     * Accept a service exchange request
     *
     * @param  int $person_id ID of person (required)
     * @param  string $request_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putPersonIdExchangerequestsRequestId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putPersonIdExchangerequestsRequestIdAsyncWithHttpInfo($person_id, $request_id, string $contentType = self::contentTypes['putPersonIdExchangerequestsRequestId'][0])
    {
        $returnType = '';
        $request = $this->putPersonIdExchangerequestsRequestIdRequest($person_id, $request_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putPersonIdExchangerequestsRequestId'
     *
     * @param  int $person_id ID of person (required)
     * @param  string $request_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putPersonIdExchangerequestsRequestId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putPersonIdExchangerequestsRequestIdRequest($person_id, $request_id, string $contentType = self::contentTypes['putPersonIdExchangerequestsRequestId'][0])
    {

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling putPersonIdExchangerequestsRequestId'
            );
        }

        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling putPersonIdExchangerequestsRequestId'
            );
        }


        $resourcePath = '/persons/{personId}/exchangerequests/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($person_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personId' . '}',
                ObjectSerializer::toPathValue($person_id),
                $resourcePath
            );
        }
        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation sendAgendaEmail
     *
     * Send agenda email to recipients
     *
     * @param  \StevenBuehner\ChurchTools\Model\SendAgendaEmailRequest $send_agenda_email_request E-Mail information and recipients (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sendAgendaEmail'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\SendAgendaEmail200Response|string
     * @deprecated
     */
    public function sendAgendaEmail($send_agenda_email_request, string $contentType = self::contentTypes['sendAgendaEmail'][0])
    {
        list($response) = $this->sendAgendaEmailWithHttpInfo($send_agenda_email_request, $contentType);
        return $response;
    }

    /**
     * Operation sendAgendaEmailWithHttpInfo
     *
     * Send agenda email to recipients
     *
     * @param  \StevenBuehner\ChurchTools\Model\SendAgendaEmailRequest $send_agenda_email_request E-Mail information and recipients (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sendAgendaEmail'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\SendAgendaEmail200Response|string, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function sendAgendaEmailWithHttpInfo($send_agenda_email_request, string $contentType = self::contentTypes['sendAgendaEmail'][0])
    {
        $request = $this->sendAgendaEmailRequest($send_agenda_email_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\SendAgendaEmail200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\SendAgendaEmail200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\SendAgendaEmail200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\SendAgendaEmail200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\SendAgendaEmail200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation sendAgendaEmailAsync
     *
     * Send agenda email to recipients
     *
     * @param  \StevenBuehner\ChurchTools\Model\SendAgendaEmailRequest $send_agenda_email_request E-Mail information and recipients (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sendAgendaEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function sendAgendaEmailAsync($send_agenda_email_request, string $contentType = self::contentTypes['sendAgendaEmail'][0])
    {
        return $this->sendAgendaEmailAsyncWithHttpInfo($send_agenda_email_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendAgendaEmailAsyncWithHttpInfo
     *
     * Send agenda email to recipients
     *
     * @param  \StevenBuehner\ChurchTools\Model\SendAgendaEmailRequest $send_agenda_email_request E-Mail information and recipients (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sendAgendaEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function sendAgendaEmailAsyncWithHttpInfo($send_agenda_email_request, string $contentType = self::contentTypes['sendAgendaEmail'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\SendAgendaEmail200Response';
        $request = $this->sendAgendaEmailRequest($send_agenda_email_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'sendAgendaEmail'
     *
     * @param  \StevenBuehner\ChurchTools\Model\SendAgendaEmailRequest $send_agenda_email_request E-Mail information and recipients (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sendAgendaEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function sendAgendaEmailRequest($send_agenda_email_request, string $contentType = self::contentTypes['sendAgendaEmail'][0])
    {

        // verify the required parameter 'send_agenda_email_request' is set
        if ($send_agenda_email_request === null || (is_array($send_agenda_email_request) && count($send_agenda_email_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $send_agenda_email_request when calling sendAgendaEmail'
            );
        }


        $resourcePath = '/agendas/send';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($send_agenda_email_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($send_agenda_email_request));
            } else {
                $httpBody = $send_agenda_email_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation sendEventEmail
     *
     * Send Mail to Event Participants
     *
     * @param  \StevenBuehner\ChurchTools\Model\SendEventEmailRequest $send_event_email_request E-Mail information and recipients (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sendEventEmail'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\SendEventEmail200Response|string
     */
    public function sendEventEmail($send_event_email_request, string $contentType = self::contentTypes['sendEventEmail'][0])
    {
        list($response) = $this->sendEventEmailWithHttpInfo($send_event_email_request, $contentType);
        return $response;
    }

    /**
     * Operation sendEventEmailWithHttpInfo
     *
     * Send Mail to Event Participants
     *
     * @param  \StevenBuehner\ChurchTools\Model\SendEventEmailRequest $send_event_email_request E-Mail information and recipients (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sendEventEmail'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\SendEventEmail200Response|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendEventEmailWithHttpInfo($send_event_email_request, string $contentType = self::contentTypes['sendEventEmail'][0])
    {
        $request = $this->sendEventEmailRequest($send_event_email_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\SendEventEmail200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\SendEventEmail200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\SendEventEmail200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\SendEventEmail200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\SendEventEmail200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation sendEventEmailAsync
     *
     * Send Mail to Event Participants
     *
     * @param  \StevenBuehner\ChurchTools\Model\SendEventEmailRequest $send_event_email_request E-Mail information and recipients (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sendEventEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendEventEmailAsync($send_event_email_request, string $contentType = self::contentTypes['sendEventEmail'][0])
    {
        return $this->sendEventEmailAsyncWithHttpInfo($send_event_email_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendEventEmailAsyncWithHttpInfo
     *
     * Send Mail to Event Participants
     *
     * @param  \StevenBuehner\ChurchTools\Model\SendEventEmailRequest $send_event_email_request E-Mail information and recipients (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sendEventEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendEventEmailAsyncWithHttpInfo($send_event_email_request, string $contentType = self::contentTypes['sendEventEmail'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\SendEventEmail200Response';
        $request = $this->sendEventEmailRequest($send_event_email_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'sendEventEmail'
     *
     * @param  \StevenBuehner\ChurchTools\Model\SendEventEmailRequest $send_event_email_request E-Mail information and recipients (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sendEventEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function sendEventEmailRequest($send_event_email_request, string $contentType = self::contentTypes['sendEventEmail'][0])
    {

        // verify the required parameter 'send_event_email_request' is set
        if ($send_event_email_request === null || (is_array($send_event_email_request) && count($send_event_email_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $send_event_email_request when calling sendEventEmail'
            );
        }


        $resourcePath = '/events/send';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($send_event_email_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($send_event_email_request));
            } else {
                $httpBody = $send_event_email_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation startStopEventChat
     *
     * Start or stop an event chat
     *
     * @param  int $event_id ID of Event (required)
     * @param  \StevenBuehner\ChurchTools\Model\StartStopEventChatRequest $start_stop_event_chat_request start_stop_event_chat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startStopEventChat'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function startStopEventChat($event_id, $start_stop_event_chat_request, string $contentType = self::contentTypes['startStopEventChat'][0])
    {
        $this->startStopEventChatWithHttpInfo($event_id, $start_stop_event_chat_request, $contentType);
    }

    /**
     * Operation startStopEventChatWithHttpInfo
     *
     * Start or stop an event chat
     *
     * @param  int $event_id ID of Event (required)
     * @param  \StevenBuehner\ChurchTools\Model\StartStopEventChatRequest $start_stop_event_chat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startStopEventChat'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function startStopEventChatWithHttpInfo($event_id, $start_stop_event_chat_request, string $contentType = self::contentTypes['startStopEventChat'][0])
    {
        $request = $this->startStopEventChatRequest($event_id, $start_stop_event_chat_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation startStopEventChatAsync
     *
     * Start or stop an event chat
     *
     * @param  int $event_id ID of Event (required)
     * @param  \StevenBuehner\ChurchTools\Model\StartStopEventChatRequest $start_stop_event_chat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startStopEventChat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function startStopEventChatAsync($event_id, $start_stop_event_chat_request, string $contentType = self::contentTypes['startStopEventChat'][0])
    {
        return $this->startStopEventChatAsyncWithHttpInfo($event_id, $start_stop_event_chat_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation startStopEventChatAsyncWithHttpInfo
     *
     * Start or stop an event chat
     *
     * @param  int $event_id ID of Event (required)
     * @param  \StevenBuehner\ChurchTools\Model\StartStopEventChatRequest $start_stop_event_chat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startStopEventChat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function startStopEventChatAsyncWithHttpInfo($event_id, $start_stop_event_chat_request, string $contentType = self::contentTypes['startStopEventChat'][0])
    {
        $returnType = '';
        $request = $this->startStopEventChatRequest($event_id, $start_stop_event_chat_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'startStopEventChat'
     *
     * @param  int $event_id ID of Event (required)
     * @param  \StevenBuehner\ChurchTools\Model\StartStopEventChatRequest $start_stop_event_chat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startStopEventChat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function startStopEventChatRequest($event_id, $start_stop_event_chat_request, string $contentType = self::contentTypes['startStopEventChat'][0])
    {

        // verify the required parameter 'event_id' is set
        if ($event_id === null || (is_array($event_id) && count($event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $event_id when calling startStopEventChat'
            );
        }

        // verify the required parameter 'start_stop_event_chat_request' is set
        if ($start_stop_event_chat_request === null || (is_array($start_stop_event_chat_request) && count($start_stop_event_chat_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $start_stop_event_chat_request when calling startStopEventChat'
            );
        }


        $resourcePath = '/events/{eventId}/chat';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'eventId' . '}',
                ObjectSerializer::toPathValue($event_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($start_stop_event_chat_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($start_stop_event_chat_request));
            } else {
                $httpBody = $start_stop_event_chat_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
