<?php
/**
 * GroupApi
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use StevenBuehner\ChurchTools\ApiException;
use StevenBuehner\ChurchTools\Configuration;
use StevenBuehner\ChurchTools\HeaderSelector;
use StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * GroupApi Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class GroupApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'checkin' => [
            'application/json',
        ],
        'createMeeting' => [
            'application/json',
        ],
        'createOrUpdateMember' => [
            'application/json',
        ],
        'deleteAutomaticEmail' => [
            'application/json',
        ],
        'deleteGroup' => [
            'application/json',
        ],
        'deleteGroupAgegroupsAgeGroupId' => [
            'application/json',
        ],
        'deleteGroupGroupcategoriesGroupCategoryId' => [
            'application/json',
        ],
        'deleteGroupGrouptypesGroupTypeId' => [
            'application/json',
        ],
        'deleteGroupRolesRoleId' => [
            'application/json',
        ],
        'deleteGroupTargetgroupsTargetGroupId' => [
            'application/json',
        ],
        'deleteGroupsGroupIdMeetingsMeetingId' => [
            'application/json',
        ],
        'deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId' => [
            'application/json',
        ],
        'deleteGroupsGroupIdParentsParentGroupId' => [
            'application/json',
        ],
        'deleteGroupsGroupIdPlacesPlaceId' => [
            'application/json',
        ],
        'deleteGroupsGroupIdTagsTagId' => [
            'application/json',
        ],
        'deleteMember' => [
            'application/json',
        ],
        'getAllGroupMembers' => [
            'application/json',
        ],
        'getAllGroupsForPerson' => [
            'application/json',
        ],
        'getAllMeetings' => [
            'application/json',
        ],
        'getAutomaticEmail' => [
            'application/json',
        ],
        'getAutomaticEmails' => [
            'application/json',
        ],
        'getGroup' => [
            'application/json',
        ],
        'getGroupAgegroups' => [
            'application/json',
        ],
        'getGroupAgegroupsAgeGroupId' => [
            'application/json',
        ],
        'getGroupForHomepage' => [
            'application/json',
        ],
        'getGroupGroupcategories' => [
            'application/json',
        ],
        'getGroupGroupcategoriesGroupCategoryId' => [
            'application/json',
        ],
        'getGroupGrouptypes' => [
            'application/json',
        ],
        'getGroupGrouptypesGroupTypeId' => [
            'application/json',
        ],
        'getGroupHomepage' => [
            'application/json',
        ],
        'getGroupRoles' => [
            'application/json',
        ],
        'getGroupRolesRoleId' => [
            'application/json',
        ],
        'getGroupRoles_0' => [
            'application/json',
        ],
        'getGroupStatistics' => [
            'application/json',
        ],
        'getGroupTargetgroups' => [
            'application/json',
        ],
        'getGroupTargetgroupsTargetGroupId' => [
            'application/json',
        ],
        'getGroups' => [
            'application/json',
        ],
        'getGroupsGroupIdMeetingsMeetingIdMembers' => [
            'application/json',
        ],
        'getGroupsGroupIdMemberfields' => [
            'application/json',
        ],
        'getGroupsGroupIdMembersExport' => [
            'application/json',
        ],
        'getGroupsGroupIdMembersStatistics' => [
            'application/json',
        ],
        'getGroupsGroupIdTags' => [
            'application/json',
        ],
        'getGroupsHierarchies' => [
            'application/json',
        ],
        'getGroupsMembers' => [
            'application/json',
        ],
        'getGroupsTags' => [
            'application/json',
        ],
        'getGrupsIdPlaces' => [
            'application/json',
        ],
        'getPersonMasterdata' => [
            'application/json',
        ],
        'getPublicgroupsGroupIdForm' => [
            'application/json',
        ],
        'getQRCodeCheckin' => [
            'application/json',
        ],
        'issueSignUpToken' => [
            'application/json',
        ],
        'optIns' => [
            'application/json',
        ],
        'patchGroup' => [
            'application/json',
        ],
        'patchGroupsGroupIdRolesRoleId' => [
            'application/json',
        ],
        'postAutomaticEmail' => [
            'application/json',
        ],
        'postGroupAgegroups' => [
            'application/json',
        ],
        'postGroupGroupcategories' => [
            'application/json',
        ],
        'postGroupGrouptypes' => [
            'application/json',
        ],
        'postGroupRoles' => [
            'application/json',
        ],
        'postGroupTargetgroups' => [
            'application/json',
        ],
        'postGroups' => [
            'application/json',
        ],
        'postGroupsGroupIdGroupstatus' => [
            'application/json',
        ],
        'postGroupsGroupIdMeetingsMeetingIdMembersMissing' => [
            'application/json',
        ],
        'postGroupsGroupIdPlaces' => [
            'application/json',
        ],
        'postPublicgroupsGroupIdMailToLeaders' => [
            'application/json',
        ],
        'postPublicgroupsGroupIdSignup' => [
            'application/json',
        ],
        'putAutomaticEmail' => [
            'application/json',
        ],
        'putGroupAgegroupsAgeGroupId' => [
            'application/json',
        ],
        'putGroupGroupcategoriesGroupCategoryId' => [
            'application/json',
        ],
        'putGroupGrouptypesGroupTypeId' => [
            'application/json',
        ],
        'putGroupRolesRoleId' => [
            'application/json',
        ],
        'putGroupTargetgroupsTargetGroupId' => [
            'application/json',
        ],
        'putGroupsGroupIdMeetingsMeetingId' => [
            'application/json',
        ],
        'putGroupsGroupIdParentsParentGroupId' => [
            'application/json',
        ],
        'putGroupsGroupIdPlacesPlaceId' => [
            'application/json',
        ],
        'startStopGroupChat' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation checkin
     *
     * Checkin a person to a group
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CheckinRequest $checkin_request checkin_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkin'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\Checkin200Response|\StevenBuehner\ChurchTools\Model\Checkin403Response
     */
    public function checkin($group_id, $checkin_request, string $contentType = self::contentTypes['checkin'][0])
    {
        list($response) = $this->checkinWithHttpInfo($group_id, $checkin_request, $contentType);
        return $response;
    }

    /**
     * Operation checkinWithHttpInfo
     *
     * Checkin a person to a group
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CheckinRequest $checkin_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkin'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\Checkin200Response|\StevenBuehner\ChurchTools\Model\Checkin403Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function checkinWithHttpInfo($group_id, $checkin_request, string $contentType = self::contentTypes['checkin'][0])
    {
        $request = $this->checkinRequest($group_id, $checkin_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\Checkin200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\Checkin200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\Checkin200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\StevenBuehner\ChurchTools\Model\Checkin403Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\Checkin403Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\Checkin403Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\Checkin200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\Checkin200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\Checkin403Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation checkinAsync
     *
     * Checkin a person to a group
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CheckinRequest $checkin_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkinAsync($group_id, $checkin_request, string $contentType = self::contentTypes['checkin'][0])
    {
        return $this->checkinAsyncWithHttpInfo($group_id, $checkin_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation checkinAsyncWithHttpInfo
     *
     * Checkin a person to a group
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CheckinRequest $checkin_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkinAsyncWithHttpInfo($group_id, $checkin_request, string $contentType = self::contentTypes['checkin'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\Checkin200Response';
        $request = $this->checkinRequest($group_id, $checkin_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'checkin'
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CheckinRequest $checkin_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function checkinRequest($group_id, $checkin_request, string $contentType = self::contentTypes['checkin'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling checkin'
            );
        }

        // verify the required parameter 'checkin_request' is set
        if ($checkin_request === null || (is_array($checkin_request) && count($checkin_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $checkin_request when calling checkin'
            );
        }


        $resourcePath = '/groups/{groupId}/checkin';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($checkin_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($checkin_request));
            } else {
                $httpBody = $checkin_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createMeeting
     *
     * Create a group meeting
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CreateMeetingRequest $create_meeting_request create_meeting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createMeeting'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\CreateMeeting200Response
     */
    public function createMeeting($group_id, $create_meeting_request, string $contentType = self::contentTypes['createMeeting'][0])
    {
        list($response) = $this->createMeetingWithHttpInfo($group_id, $create_meeting_request, $contentType);
        return $response;
    }

    /**
     * Operation createMeetingWithHttpInfo
     *
     * Create a group meeting
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CreateMeetingRequest $create_meeting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createMeeting'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\CreateMeeting200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function createMeetingWithHttpInfo($group_id, $create_meeting_request, string $contentType = self::contentTypes['createMeeting'][0])
    {
        $request = $this->createMeetingRequest($group_id, $create_meeting_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\CreateMeeting200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\CreateMeeting200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\CreateMeeting200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\CreateMeeting200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\CreateMeeting200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createMeetingAsync
     *
     * Create a group meeting
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CreateMeetingRequest $create_meeting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createMeeting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createMeetingAsync($group_id, $create_meeting_request, string $contentType = self::contentTypes['createMeeting'][0])
    {
        return $this->createMeetingAsyncWithHttpInfo($group_id, $create_meeting_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createMeetingAsyncWithHttpInfo
     *
     * Create a group meeting
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CreateMeetingRequest $create_meeting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createMeeting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createMeetingAsyncWithHttpInfo($group_id, $create_meeting_request, string $contentType = self::contentTypes['createMeeting'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\CreateMeeting200Response';
        $request = $this->createMeetingRequest($group_id, $create_meeting_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createMeeting'
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CreateMeetingRequest $create_meeting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createMeeting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createMeetingRequest($group_id, $create_meeting_request, string $contentType = self::contentTypes['createMeeting'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling createMeeting'
            );
        }

        // verify the required parameter 'create_meeting_request' is set
        if ($create_meeting_request === null || (is_array($create_meeting_request) && count($create_meeting_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_meeting_request when calling createMeeting'
            );
        }


        $resourcePath = '/groups/{groupId}/meetings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_meeting_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_meeting_request));
            } else {
                $httpBody = $create_meeting_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createOrUpdateMember
     *
     * Create/Update a group member
     *
     * @param  int $person_id ID of person (required)
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CreateOrUpdateMemberRequest $create_or_update_member_request All fields are optional. If not set, default values are used. groupTypeRoleId defaults to the standard role of the group&#39;s grouptype, groupMemberStatus to the active status, comment and member start/end dates default to null. Additional custom group fields are not yet supported through this API. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrUpdateMember'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\CreateOrUpdateMember200Response|string
     */
    public function createOrUpdateMember($person_id, $group_id, $create_or_update_member_request, string $contentType = self::contentTypes['createOrUpdateMember'][0])
    {
        list($response) = $this->createOrUpdateMemberWithHttpInfo($person_id, $group_id, $create_or_update_member_request, $contentType);
        return $response;
    }

    /**
     * Operation createOrUpdateMemberWithHttpInfo
     *
     * Create/Update a group member
     *
     * @param  int $person_id ID of person (required)
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CreateOrUpdateMemberRequest $create_or_update_member_request All fields are optional. If not set, default values are used. groupTypeRoleId defaults to the standard role of the group&#39;s grouptype, groupMemberStatus to the active status, comment and member start/end dates default to null. Additional custom group fields are not yet supported through this API. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrUpdateMember'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\CreateOrUpdateMember200Response|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOrUpdateMemberWithHttpInfo($person_id, $group_id, $create_or_update_member_request, string $contentType = self::contentTypes['createOrUpdateMember'][0])
    {
        $request = $this->createOrUpdateMemberRequest($person_id, $group_id, $create_or_update_member_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\CreateOrUpdateMember200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\CreateOrUpdateMember200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\CreateOrUpdateMember200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\CreateOrUpdateMember200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\CreateOrUpdateMember200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createOrUpdateMemberAsync
     *
     * Create/Update a group member
     *
     * @param  int $person_id ID of person (required)
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CreateOrUpdateMemberRequest $create_or_update_member_request All fields are optional. If not set, default values are used. groupTypeRoleId defaults to the standard role of the group&#39;s grouptype, groupMemberStatus to the active status, comment and member start/end dates default to null. Additional custom group fields are not yet supported through this API. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrUpdateMember'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrUpdateMemberAsync($person_id, $group_id, $create_or_update_member_request, string $contentType = self::contentTypes['createOrUpdateMember'][0])
    {
        return $this->createOrUpdateMemberAsyncWithHttpInfo($person_id, $group_id, $create_or_update_member_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOrUpdateMemberAsyncWithHttpInfo
     *
     * Create/Update a group member
     *
     * @param  int $person_id ID of person (required)
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CreateOrUpdateMemberRequest $create_or_update_member_request All fields are optional. If not set, default values are used. groupTypeRoleId defaults to the standard role of the group&#39;s grouptype, groupMemberStatus to the active status, comment and member start/end dates default to null. Additional custom group fields are not yet supported through this API. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrUpdateMember'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrUpdateMemberAsyncWithHttpInfo($person_id, $group_id, $create_or_update_member_request, string $contentType = self::contentTypes['createOrUpdateMember'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\CreateOrUpdateMember200Response';
        $request = $this->createOrUpdateMemberRequest($person_id, $group_id, $create_or_update_member_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOrUpdateMember'
     *
     * @param  int $person_id ID of person (required)
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\CreateOrUpdateMemberRequest $create_or_update_member_request All fields are optional. If not set, default values are used. groupTypeRoleId defaults to the standard role of the group&#39;s grouptype, groupMemberStatus to the active status, comment and member start/end dates default to null. Additional custom group fields are not yet supported through this API. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrUpdateMember'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createOrUpdateMemberRequest($person_id, $group_id, $create_or_update_member_request, string $contentType = self::contentTypes['createOrUpdateMember'][0])
    {

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling createOrUpdateMember'
            );
        }

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling createOrUpdateMember'
            );
        }

        // verify the required parameter 'create_or_update_member_request' is set
        if ($create_or_update_member_request === null || (is_array($create_or_update_member_request) && count($create_or_update_member_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_or_update_member_request when calling createOrUpdateMember'
            );
        }


        $resourcePath = '/groups/{groupId}/members/{personId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($person_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personId' . '}',
                ObjectSerializer::toPathValue($person_id),
                $resourcePath
            );
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_or_update_member_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_or_update_member_request));
            } else {
                $httpBody = $create_or_update_member_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteAutomaticEmail
     *
     * Delete automatic email
     *
     * @param  string $email_id email_id (required)
     * @param  int $group_id ID or chat GUID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteAutomaticEmail($email_id, $group_id, string $contentType = self::contentTypes['deleteAutomaticEmail'][0])
    {
        $this->deleteAutomaticEmailWithHttpInfo($email_id, $group_id, $contentType);
    }

    /**
     * Operation deleteAutomaticEmailWithHttpInfo
     *
     * Delete automatic email
     *
     * @param  string $email_id (required)
     * @param  int $group_id ID or chat GUID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAutomaticEmailWithHttpInfo($email_id, $group_id, string $contentType = self::contentTypes['deleteAutomaticEmail'][0])
    {
        $request = $this->deleteAutomaticEmailRequest($email_id, $group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteAutomaticEmailAsync
     *
     * Delete automatic email
     *
     * @param  string $email_id (required)
     * @param  int $group_id ID or chat GUID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAutomaticEmailAsync($email_id, $group_id, string $contentType = self::contentTypes['deleteAutomaticEmail'][0])
    {
        return $this->deleteAutomaticEmailAsyncWithHttpInfo($email_id, $group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAutomaticEmailAsyncWithHttpInfo
     *
     * Delete automatic email
     *
     * @param  string $email_id (required)
     * @param  int $group_id ID or chat GUID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAutomaticEmailAsyncWithHttpInfo($email_id, $group_id, string $contentType = self::contentTypes['deleteAutomaticEmail'][0])
    {
        $returnType = '';
        $request = $this->deleteAutomaticEmailRequest($email_id, $group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteAutomaticEmail'
     *
     * @param  string $email_id (required)
     * @param  int $group_id ID or chat GUID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteAutomaticEmailRequest($email_id, $group_id, string $contentType = self::contentTypes['deleteAutomaticEmail'][0])
    {

        // verify the required parameter 'email_id' is set
        if ($email_id === null || (is_array($email_id) && count($email_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $email_id when calling deleteAutomaticEmail'
            );
        }

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling deleteAutomaticEmail'
            );
        }


        $resourcePath = '/groups/{groupId}/emails/{emailId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                '{' . 'emailId' . '}',
                ObjectSerializer::toPathValue($email_id),
                $resourcePath
            );
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroup
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  bool $dry_run If set to true, the deletion is simulated but nothing will be deleted. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroup'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteGroup($group_id, $dry_run = null, string $contentType = self::contentTypes['deleteGroup'][0])
    {
        $this->deleteGroupWithHttpInfo($group_id, $dry_run, $contentType);
    }

    /**
     * Operation deleteGroupWithHttpInfo
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  bool $dry_run If set to true, the deletion is simulated but nothing will be deleted. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroup'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupWithHttpInfo($group_id, $dry_run = null, string $contentType = self::contentTypes['deleteGroup'][0])
    {
        $request = $this->deleteGroupRequest($group_id, $dry_run, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupAsync
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  bool $dry_run If set to true, the deletion is simulated but nothing will be deleted. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupAsync($group_id, $dry_run = null, string $contentType = self::contentTypes['deleteGroup'][0])
    {
        return $this->deleteGroupAsyncWithHttpInfo($group_id, $dry_run, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupAsyncWithHttpInfo
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  bool $dry_run If set to true, the deletion is simulated but nothing will be deleted. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupAsyncWithHttpInfo($group_id, $dry_run = null, string $contentType = self::contentTypes['deleteGroup'][0])
    {
        $returnType = '';
        $request = $this->deleteGroupRequest($group_id, $dry_run, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroup'
     *
     * @param  int $group_id ID of group (required)
     * @param  bool $dry_run If set to true, the deletion is simulated but nothing will be deleted. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupRequest($group_id, $dry_run = null, string $contentType = self::contentTypes['deleteGroup'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling deleteGroup'
            );
        }



        $resourcePath = '/groups/{groupId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dry_run,
            'dry_run', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupAgegroupsAgeGroupId
     *
     * Delete agegroup
     *
     * @param  string $age_group_id age_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteGroupAgegroupsAgeGroupId($age_group_id, string $contentType = self::contentTypes['deleteGroupAgegroupsAgeGroupId'][0])
    {
        $this->deleteGroupAgegroupsAgeGroupIdWithHttpInfo($age_group_id, $contentType);
    }

    /**
     * Operation deleteGroupAgegroupsAgeGroupIdWithHttpInfo
     *
     * Delete agegroup
     *
     * @param  string $age_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupAgegroupsAgeGroupIdWithHttpInfo($age_group_id, string $contentType = self::contentTypes['deleteGroupAgegroupsAgeGroupId'][0])
    {
        $request = $this->deleteGroupAgegroupsAgeGroupIdRequest($age_group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupAgegroupsAgeGroupIdAsync
     *
     * Delete agegroup
     *
     * @param  string $age_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupAgegroupsAgeGroupIdAsync($age_group_id, string $contentType = self::contentTypes['deleteGroupAgegroupsAgeGroupId'][0])
    {
        return $this->deleteGroupAgegroupsAgeGroupIdAsyncWithHttpInfo($age_group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupAgegroupsAgeGroupIdAsyncWithHttpInfo
     *
     * Delete agegroup
     *
     * @param  string $age_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupAgegroupsAgeGroupIdAsyncWithHttpInfo($age_group_id, string $contentType = self::contentTypes['deleteGroupAgegroupsAgeGroupId'][0])
    {
        $returnType = '';
        $request = $this->deleteGroupAgegroupsAgeGroupIdRequest($age_group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupAgegroupsAgeGroupId'
     *
     * @param  string $age_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupAgegroupsAgeGroupIdRequest($age_group_id, string $contentType = self::contentTypes['deleteGroupAgegroupsAgeGroupId'][0])
    {

        // verify the required parameter 'age_group_id' is set
        if ($age_group_id === null || (is_array($age_group_id) && count($age_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $age_group_id when calling deleteGroupAgegroupsAgeGroupId'
            );
        }


        $resourcePath = '/group/agegroups/{ageGroupId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($age_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ageGroupId' . '}',
                ObjectSerializer::toPathValue($age_group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupGroupcategoriesGroupCategoryId
     *
     * 
     *
     * @param  string $group_category_id group_category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteGroupGroupcategoriesGroupCategoryId($group_category_id, string $contentType = self::contentTypes['deleteGroupGroupcategoriesGroupCategoryId'][0])
    {
        $this->deleteGroupGroupcategoriesGroupCategoryIdWithHttpInfo($group_category_id, $contentType);
    }

    /**
     * Operation deleteGroupGroupcategoriesGroupCategoryIdWithHttpInfo
     *
     * 
     *
     * @param  string $group_category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupGroupcategoriesGroupCategoryIdWithHttpInfo($group_category_id, string $contentType = self::contentTypes['deleteGroupGroupcategoriesGroupCategoryId'][0])
    {
        $request = $this->deleteGroupGroupcategoriesGroupCategoryIdRequest($group_category_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupGroupcategoriesGroupCategoryIdAsync
     *
     * 
     *
     * @param  string $group_category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupGroupcategoriesGroupCategoryIdAsync($group_category_id, string $contentType = self::contentTypes['deleteGroupGroupcategoriesGroupCategoryId'][0])
    {
        return $this->deleteGroupGroupcategoriesGroupCategoryIdAsyncWithHttpInfo($group_category_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupGroupcategoriesGroupCategoryIdAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $group_category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupGroupcategoriesGroupCategoryIdAsyncWithHttpInfo($group_category_id, string $contentType = self::contentTypes['deleteGroupGroupcategoriesGroupCategoryId'][0])
    {
        $returnType = '';
        $request = $this->deleteGroupGroupcategoriesGroupCategoryIdRequest($group_category_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupGroupcategoriesGroupCategoryId'
     *
     * @param  string $group_category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupGroupcategoriesGroupCategoryIdRequest($group_category_id, string $contentType = self::contentTypes['deleteGroupGroupcategoriesGroupCategoryId'][0])
    {

        // verify the required parameter 'group_category_id' is set
        if ($group_category_id === null || (is_array($group_category_id) && count($group_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_category_id when calling deleteGroupGroupcategoriesGroupCategoryId'
            );
        }


        $resourcePath = '/group/groupcategories/{groupCategoryId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupCategoryId' . '}',
                ObjectSerializer::toPathValue($group_category_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupGrouptypesGroupTypeId
     *
     * Delete group type
     *
     * @param  string $group_type_id group_type_id (required)
     * @param  bool $dry_run dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteGroupGrouptypesGroupTypeId($group_type_id, $dry_run = null, string $contentType = self::contentTypes['deleteGroupGrouptypesGroupTypeId'][0])
    {
        $this->deleteGroupGrouptypesGroupTypeIdWithHttpInfo($group_type_id, $dry_run, $contentType);
    }

    /**
     * Operation deleteGroupGrouptypesGroupTypeIdWithHttpInfo
     *
     * Delete group type
     *
     * @param  string $group_type_id (required)
     * @param  bool $dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupGrouptypesGroupTypeIdWithHttpInfo($group_type_id, $dry_run = null, string $contentType = self::contentTypes['deleteGroupGrouptypesGroupTypeId'][0])
    {
        $request = $this->deleteGroupGrouptypesGroupTypeIdRequest($group_type_id, $dry_run, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupGrouptypesGroupTypeIdAsync
     *
     * Delete group type
     *
     * @param  string $group_type_id (required)
     * @param  bool $dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupGrouptypesGroupTypeIdAsync($group_type_id, $dry_run = null, string $contentType = self::contentTypes['deleteGroupGrouptypesGroupTypeId'][0])
    {
        return $this->deleteGroupGrouptypesGroupTypeIdAsyncWithHttpInfo($group_type_id, $dry_run, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupGrouptypesGroupTypeIdAsyncWithHttpInfo
     *
     * Delete group type
     *
     * @param  string $group_type_id (required)
     * @param  bool $dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupGrouptypesGroupTypeIdAsyncWithHttpInfo($group_type_id, $dry_run = null, string $contentType = self::contentTypes['deleteGroupGrouptypesGroupTypeId'][0])
    {
        $returnType = '';
        $request = $this->deleteGroupGrouptypesGroupTypeIdRequest($group_type_id, $dry_run, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupGrouptypesGroupTypeId'
     *
     * @param  string $group_type_id (required)
     * @param  bool $dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupGrouptypesGroupTypeIdRequest($group_type_id, $dry_run = null, string $contentType = self::contentTypes['deleteGroupGrouptypesGroupTypeId'][0])
    {

        // verify the required parameter 'group_type_id' is set
        if ($group_type_id === null || (is_array($group_type_id) && count($group_type_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_type_id when calling deleteGroupGrouptypesGroupTypeId'
            );
        }



        $resourcePath = '/group/grouptypes/{groupTypeId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dry_run,
            'dryRun', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($group_type_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupTypeId' . '}',
                ObjectSerializer::toPathValue($group_type_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupRolesRoleId
     *
     * Delete role
     *
     * @param  string $role_id role_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteGroupRolesRoleId($role_id, string $contentType = self::contentTypes['deleteGroupRolesRoleId'][0])
    {
        $this->deleteGroupRolesRoleIdWithHttpInfo($role_id, $contentType);
    }

    /**
     * Operation deleteGroupRolesRoleIdWithHttpInfo
     *
     * Delete role
     *
     * @param  string $role_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupRolesRoleIdWithHttpInfo($role_id, string $contentType = self::contentTypes['deleteGroupRolesRoleId'][0])
    {
        $request = $this->deleteGroupRolesRoleIdRequest($role_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupRolesRoleIdAsync
     *
     * Delete role
     *
     * @param  string $role_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupRolesRoleIdAsync($role_id, string $contentType = self::contentTypes['deleteGroupRolesRoleId'][0])
    {
        return $this->deleteGroupRolesRoleIdAsyncWithHttpInfo($role_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupRolesRoleIdAsyncWithHttpInfo
     *
     * Delete role
     *
     * @param  string $role_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupRolesRoleIdAsyncWithHttpInfo($role_id, string $contentType = self::contentTypes['deleteGroupRolesRoleId'][0])
    {
        $returnType = '';
        $request = $this->deleteGroupRolesRoleIdRequest($role_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupRolesRoleId'
     *
     * @param  string $role_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupRolesRoleIdRequest($role_id, string $contentType = self::contentTypes['deleteGroupRolesRoleId'][0])
    {

        // verify the required parameter 'role_id' is set
        if ($role_id === null || (is_array($role_id) && count($role_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $role_id when calling deleteGroupRolesRoleId'
            );
        }


        $resourcePath = '/group/roles/{roleId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($role_id !== null) {
            $resourcePath = str_replace(
                '{' . 'roleId' . '}',
                ObjectSerializer::toPathValue($role_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupTargetgroupsTargetGroupId
     *
     * delete target group
     *
     * @param  string $target_group_id target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteGroupTargetgroupsTargetGroupId($target_group_id, string $contentType = self::contentTypes['deleteGroupTargetgroupsTargetGroupId'][0])
    {
        $this->deleteGroupTargetgroupsTargetGroupIdWithHttpInfo($target_group_id, $contentType);
    }

    /**
     * Operation deleteGroupTargetgroupsTargetGroupIdWithHttpInfo
     *
     * delete target group
     *
     * @param  string $target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupTargetgroupsTargetGroupIdWithHttpInfo($target_group_id, string $contentType = self::contentTypes['deleteGroupTargetgroupsTargetGroupId'][0])
    {
        $request = $this->deleteGroupTargetgroupsTargetGroupIdRequest($target_group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupTargetgroupsTargetGroupIdAsync
     *
     * delete target group
     *
     * @param  string $target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupTargetgroupsTargetGroupIdAsync($target_group_id, string $contentType = self::contentTypes['deleteGroupTargetgroupsTargetGroupId'][0])
    {
        return $this->deleteGroupTargetgroupsTargetGroupIdAsyncWithHttpInfo($target_group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupTargetgroupsTargetGroupIdAsyncWithHttpInfo
     *
     * delete target group
     *
     * @param  string $target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupTargetgroupsTargetGroupIdAsyncWithHttpInfo($target_group_id, string $contentType = self::contentTypes['deleteGroupTargetgroupsTargetGroupId'][0])
    {
        $returnType = '';
        $request = $this->deleteGroupTargetgroupsTargetGroupIdRequest($target_group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupTargetgroupsTargetGroupId'
     *
     * @param  string $target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupTargetgroupsTargetGroupIdRequest($target_group_id, string $contentType = self::contentTypes['deleteGroupTargetgroupsTargetGroupId'][0])
    {

        // verify the required parameter 'target_group_id' is set
        if ($target_group_id === null || (is_array($target_group_id) && count($target_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $target_group_id when calling deleteGroupTargetgroupsTargetGroupId'
            );
        }


        $resourcePath = '/group/targetgroups/{targetGroupId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($target_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'targetGroupId' . '}',
                ObjectSerializer::toPathValue($target_group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupsGroupIdMeetingsMeetingId
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id meeting_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdMeetingsMeetingId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteGroupsGroupIdMeetingsMeetingId($group_id, $meeting_id, string $contentType = self::contentTypes['deleteGroupsGroupIdMeetingsMeetingId'][0])
    {
        $this->deleteGroupsGroupIdMeetingsMeetingIdWithHttpInfo($group_id, $meeting_id, $contentType);
    }

    /**
     * Operation deleteGroupsGroupIdMeetingsMeetingIdWithHttpInfo
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdMeetingsMeetingId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupsGroupIdMeetingsMeetingIdWithHttpInfo($group_id, $meeting_id, string $contentType = self::contentTypes['deleteGroupsGroupIdMeetingsMeetingId'][0])
    {
        $request = $this->deleteGroupsGroupIdMeetingsMeetingIdRequest($group_id, $meeting_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupsGroupIdMeetingsMeetingIdAsync
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdMeetingsMeetingId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupsGroupIdMeetingsMeetingIdAsync($group_id, $meeting_id, string $contentType = self::contentTypes['deleteGroupsGroupIdMeetingsMeetingId'][0])
    {
        return $this->deleteGroupsGroupIdMeetingsMeetingIdAsyncWithHttpInfo($group_id, $meeting_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupsGroupIdMeetingsMeetingIdAsyncWithHttpInfo
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdMeetingsMeetingId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupsGroupIdMeetingsMeetingIdAsyncWithHttpInfo($group_id, $meeting_id, string $contentType = self::contentTypes['deleteGroupsGroupIdMeetingsMeetingId'][0])
    {
        $returnType = '';
        $request = $this->deleteGroupsGroupIdMeetingsMeetingIdRequest($group_id, $meeting_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupsGroupIdMeetingsMeetingId'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdMeetingsMeetingId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupsGroupIdMeetingsMeetingIdRequest($group_id, $meeting_id, string $contentType = self::contentTypes['deleteGroupsGroupIdMeetingsMeetingId'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling deleteGroupsGroupIdMeetingsMeetingId'
            );
        }

        // verify the required parameter 'meeting_id' is set
        if ($meeting_id === null || (is_array($meeting_id) && count($meeting_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meeting_id when calling deleteGroupsGroupIdMeetingsMeetingId'
            );
        }


        $resourcePath = '/groups/{groupId}/meetings/{meetingId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($meeting_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetingId' . '}',
                ObjectSerializer::toPathValue($meeting_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId
     *
     * Revoke checkin
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id meeting_id (required)
     * @param  string $member_id member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId($group_id, $meeting_id, $member_id, string $contentType = self::contentTypes['deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'][0])
    {
        $this->deleteGroupsGroupIdMeetingsMeetingIdMembersMemberIdWithHttpInfo($group_id, $meeting_id, $member_id, $contentType);
    }

    /**
     * Operation deleteGroupsGroupIdMeetingsMeetingIdMembersMemberIdWithHttpInfo
     *
     * Revoke checkin
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  string $member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupsGroupIdMeetingsMeetingIdMembersMemberIdWithHttpInfo($group_id, $meeting_id, $member_id, string $contentType = self::contentTypes['deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'][0])
    {
        $request = $this->deleteGroupsGroupIdMeetingsMeetingIdMembersMemberIdRequest($group_id, $meeting_id, $member_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupsGroupIdMeetingsMeetingIdMembersMemberIdAsync
     *
     * Revoke checkin
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  string $member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupsGroupIdMeetingsMeetingIdMembersMemberIdAsync($group_id, $meeting_id, $member_id, string $contentType = self::contentTypes['deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'][0])
    {
        return $this->deleteGroupsGroupIdMeetingsMeetingIdMembersMemberIdAsyncWithHttpInfo($group_id, $meeting_id, $member_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupsGroupIdMeetingsMeetingIdMembersMemberIdAsyncWithHttpInfo
     *
     * Revoke checkin
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  string $member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupsGroupIdMeetingsMeetingIdMembersMemberIdAsyncWithHttpInfo($group_id, $meeting_id, $member_id, string $contentType = self::contentTypes['deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'][0])
    {
        $returnType = '';
        $request = $this->deleteGroupsGroupIdMeetingsMeetingIdMembersMemberIdRequest($group_id, $meeting_id, $member_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  string $member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupsGroupIdMeetingsMeetingIdMembersMemberIdRequest($group_id, $meeting_id, $member_id, string $contentType = self::contentTypes['deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'
            );
        }

        // verify the required parameter 'meeting_id' is set
        if ($meeting_id === null || (is_array($meeting_id) && count($meeting_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meeting_id when calling deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'
            );
        }

        // verify the required parameter 'member_id' is set
        if ($member_id === null || (is_array($member_id) && count($member_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $member_id when calling deleteGroupsGroupIdMeetingsMeetingIdMembersMemberId'
            );
        }


        $resourcePath = '/groups/{groupId}/meetings/{meetingId}/members/{memberId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($meeting_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetingId' . '}',
                ObjectSerializer::toPathValue($meeting_id),
                $resourcePath
            );
        }
        // path params
        if ($member_id !== null) {
            $resourcePath = str_replace(
                '{' . 'memberId' . '}',
                ObjectSerializer::toPathValue($member_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupsGroupIdParentsParentGroupId
     *
     * Delete Parent Group connection
     *
     * @param  string $group_id group_id (required)
     * @param  string $parent_group_id parent_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdParentsParentGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteGroupsGroupIdParentsParentGroupId($group_id, $parent_group_id, string $contentType = self::contentTypes['deleteGroupsGroupIdParentsParentGroupId'][0])
    {
        $this->deleteGroupsGroupIdParentsParentGroupIdWithHttpInfo($group_id, $parent_group_id, $contentType);
    }

    /**
     * Operation deleteGroupsGroupIdParentsParentGroupIdWithHttpInfo
     *
     * Delete Parent Group connection
     *
     * @param  string $group_id (required)
     * @param  string $parent_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdParentsParentGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupsGroupIdParentsParentGroupIdWithHttpInfo($group_id, $parent_group_id, string $contentType = self::contentTypes['deleteGroupsGroupIdParentsParentGroupId'][0])
    {
        $request = $this->deleteGroupsGroupIdParentsParentGroupIdRequest($group_id, $parent_group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupsGroupIdParentsParentGroupIdAsync
     *
     * Delete Parent Group connection
     *
     * @param  string $group_id (required)
     * @param  string $parent_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdParentsParentGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupsGroupIdParentsParentGroupIdAsync($group_id, $parent_group_id, string $contentType = self::contentTypes['deleteGroupsGroupIdParentsParentGroupId'][0])
    {
        return $this->deleteGroupsGroupIdParentsParentGroupIdAsyncWithHttpInfo($group_id, $parent_group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupsGroupIdParentsParentGroupIdAsyncWithHttpInfo
     *
     * Delete Parent Group connection
     *
     * @param  string $group_id (required)
     * @param  string $parent_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdParentsParentGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupsGroupIdParentsParentGroupIdAsyncWithHttpInfo($group_id, $parent_group_id, string $contentType = self::contentTypes['deleteGroupsGroupIdParentsParentGroupId'][0])
    {
        $returnType = '';
        $request = $this->deleteGroupsGroupIdParentsParentGroupIdRequest($group_id, $parent_group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupsGroupIdParentsParentGroupId'
     *
     * @param  string $group_id (required)
     * @param  string $parent_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdParentsParentGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupsGroupIdParentsParentGroupIdRequest($group_id, $parent_group_id, string $contentType = self::contentTypes['deleteGroupsGroupIdParentsParentGroupId'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling deleteGroupsGroupIdParentsParentGroupId'
            );
        }

        // verify the required parameter 'parent_group_id' is set
        if ($parent_group_id === null || (is_array($parent_group_id) && count($parent_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $parent_group_id when calling deleteGroupsGroupIdParentsParentGroupId'
            );
        }


        $resourcePath = '/groups/{groupId}/parents/{parentGroupId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($parent_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'parentGroupId' . '}',
                ObjectSerializer::toPathValue($parent_group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupsGroupIdPlacesPlaceId
     *
     * 
     *
     * @param  string $group_id group_id (required)
     * @param  string $place_id place_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdPlacesPlaceId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteGroupsGroupIdPlacesPlaceId($group_id, $place_id, string $contentType = self::contentTypes['deleteGroupsGroupIdPlacesPlaceId'][0])
    {
        $this->deleteGroupsGroupIdPlacesPlaceIdWithHttpInfo($group_id, $place_id, $contentType);
    }

    /**
     * Operation deleteGroupsGroupIdPlacesPlaceIdWithHttpInfo
     *
     * 
     *
     * @param  string $group_id (required)
     * @param  string $place_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdPlacesPlaceId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupsGroupIdPlacesPlaceIdWithHttpInfo($group_id, $place_id, string $contentType = self::contentTypes['deleteGroupsGroupIdPlacesPlaceId'][0])
    {
        $request = $this->deleteGroupsGroupIdPlacesPlaceIdRequest($group_id, $place_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupsGroupIdPlacesPlaceIdAsync
     *
     * 
     *
     * @param  string $group_id (required)
     * @param  string $place_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdPlacesPlaceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupsGroupIdPlacesPlaceIdAsync($group_id, $place_id, string $contentType = self::contentTypes['deleteGroupsGroupIdPlacesPlaceId'][0])
    {
        return $this->deleteGroupsGroupIdPlacesPlaceIdAsyncWithHttpInfo($group_id, $place_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupsGroupIdPlacesPlaceIdAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $group_id (required)
     * @param  string $place_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdPlacesPlaceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupsGroupIdPlacesPlaceIdAsyncWithHttpInfo($group_id, $place_id, string $contentType = self::contentTypes['deleteGroupsGroupIdPlacesPlaceId'][0])
    {
        $returnType = '';
        $request = $this->deleteGroupsGroupIdPlacesPlaceIdRequest($group_id, $place_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupsGroupIdPlacesPlaceId'
     *
     * @param  string $group_id (required)
     * @param  string $place_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdPlacesPlaceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupsGroupIdPlacesPlaceIdRequest($group_id, $place_id, string $contentType = self::contentTypes['deleteGroupsGroupIdPlacesPlaceId'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling deleteGroupsGroupIdPlacesPlaceId'
            );
        }

        // verify the required parameter 'place_id' is set
        if ($place_id === null || (is_array($place_id) && count($place_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $place_id when calling deleteGroupsGroupIdPlacesPlaceId'
            );
        }


        $resourcePath = '/groups/{groupId}/places/{placeId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($place_id !== null) {
            $resourcePath = str_replace(
                '{' . 'placeId' . '}',
                ObjectSerializer::toPathValue($place_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupsGroupIdTagsTagId
     *
     * Delete group Tag
     *
     * @param  string $group_id group_id (required)
     * @param  string $tag_id tag_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdTagsTagId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteGroupsGroupIdTagsTagId($group_id, $tag_id, string $contentType = self::contentTypes['deleteGroupsGroupIdTagsTagId'][0])
    {
        $this->deleteGroupsGroupIdTagsTagIdWithHttpInfo($group_id, $tag_id, $contentType);
    }

    /**
     * Operation deleteGroupsGroupIdTagsTagIdWithHttpInfo
     *
     * Delete group Tag
     *
     * @param  string $group_id (required)
     * @param  string $tag_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdTagsTagId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupsGroupIdTagsTagIdWithHttpInfo($group_id, $tag_id, string $contentType = self::contentTypes['deleteGroupsGroupIdTagsTagId'][0])
    {
        $request = $this->deleteGroupsGroupIdTagsTagIdRequest($group_id, $tag_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupsGroupIdTagsTagIdAsync
     *
     * Delete group Tag
     *
     * @param  string $group_id (required)
     * @param  string $tag_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdTagsTagId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupsGroupIdTagsTagIdAsync($group_id, $tag_id, string $contentType = self::contentTypes['deleteGroupsGroupIdTagsTagId'][0])
    {
        return $this->deleteGroupsGroupIdTagsTagIdAsyncWithHttpInfo($group_id, $tag_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupsGroupIdTagsTagIdAsyncWithHttpInfo
     *
     * Delete group Tag
     *
     * @param  string $group_id (required)
     * @param  string $tag_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdTagsTagId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupsGroupIdTagsTagIdAsyncWithHttpInfo($group_id, $tag_id, string $contentType = self::contentTypes['deleteGroupsGroupIdTagsTagId'][0])
    {
        $returnType = '';
        $request = $this->deleteGroupsGroupIdTagsTagIdRequest($group_id, $tag_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupsGroupIdTagsTagId'
     *
     * @param  string $group_id (required)
     * @param  string $tag_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupsGroupIdTagsTagId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupsGroupIdTagsTagIdRequest($group_id, $tag_id, string $contentType = self::contentTypes['deleteGroupsGroupIdTagsTagId'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling deleteGroupsGroupIdTagsTagId'
            );
        }

        // verify the required parameter 'tag_id' is set
        if ($tag_id === null || (is_array($tag_id) && count($tag_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tag_id when calling deleteGroupsGroupIdTagsTagId'
            );
        }


        $resourcePath = '/groups/{groupId}/tags/{tagId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($tag_id !== null) {
            $resourcePath = str_replace(
                '{' . 'tagId' . '}',
                ObjectSerializer::toPathValue($tag_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteMember
     *
     * Delete a group member
     *
     * @param  int $person_id ID of person (required)
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteMember'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteMember($person_id, $group_id, string $contentType = self::contentTypes['deleteMember'][0])
    {
        $this->deleteMemberWithHttpInfo($person_id, $group_id, $contentType);
    }

    /**
     * Operation deleteMemberWithHttpInfo
     *
     * Delete a group member
     *
     * @param  int $person_id ID of person (required)
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteMember'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteMemberWithHttpInfo($person_id, $group_id, string $contentType = self::contentTypes['deleteMember'][0])
    {
        $request = $this->deleteMemberRequest($person_id, $group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteMemberAsync
     *
     * Delete a group member
     *
     * @param  int $person_id ID of person (required)
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteMember'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteMemberAsync($person_id, $group_id, string $contentType = self::contentTypes['deleteMember'][0])
    {
        return $this->deleteMemberAsyncWithHttpInfo($person_id, $group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteMemberAsyncWithHttpInfo
     *
     * Delete a group member
     *
     * @param  int $person_id ID of person (required)
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteMember'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteMemberAsyncWithHttpInfo($person_id, $group_id, string $contentType = self::contentTypes['deleteMember'][0])
    {
        $returnType = '';
        $request = $this->deleteMemberRequest($person_id, $group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteMember'
     *
     * @param  int $person_id ID of person (required)
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteMember'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteMemberRequest($person_id, $group_id, string $contentType = self::contentTypes['deleteMember'][0])
    {

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling deleteMember'
            );
        }

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling deleteMember'
            );
        }


        $resourcePath = '/groups/{groupId}/members/{personId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($person_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personId' . '}',
                ObjectSerializer::toPathValue($person_id),
                $resourcePath
            );
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllGroupMembers
     *
     * Get all group members
     *
     * @param  int $group_id ID of group (required)
     * @param  int $page Page number to show page in pagenation. If empty, start at first page. (optional, default to 1)
     * @param  int $limit Number of results per page. (optional, default to 10)
     * @param  int[] $role_ids roles to filter the members (optional)
     * @param  bool $allowed_chat_users_only If true, return only group members, that are allowed to chat in this group (optional)
     * @param  string $query searches in first and second name of group member (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllGroupMembers'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetAllGroupMembers200Response
     */
    public function getAllGroupMembers($group_id, $page = 1, $limit = 10, $role_ids = null, $allowed_chat_users_only = null, $query = null, string $contentType = self::contentTypes['getAllGroupMembers'][0])
    {
        list($response) = $this->getAllGroupMembersWithHttpInfo($group_id, $page, $limit, $role_ids, $allowed_chat_users_only, $query, $contentType);
        return $response;
    }

    /**
     * Operation getAllGroupMembersWithHttpInfo
     *
     * Get all group members
     *
     * @param  int $group_id ID of group (required)
     * @param  int $page Page number to show page in pagenation. If empty, start at first page. (optional, default to 1)
     * @param  int $limit Number of results per page. (optional, default to 10)
     * @param  int[] $role_ids roles to filter the members (optional)
     * @param  bool $allowed_chat_users_only If true, return only group members, that are allowed to chat in this group (optional)
     * @param  string $query searches in first and second name of group member (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllGroupMembers'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetAllGroupMembers200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllGroupMembersWithHttpInfo($group_id, $page = 1, $limit = 10, $role_ids = null, $allowed_chat_users_only = null, $query = null, string $contentType = self::contentTypes['getAllGroupMembers'][0])
    {
        $request = $this->getAllGroupMembersRequest($group_id, $page, $limit, $role_ids, $allowed_chat_users_only, $query, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetAllGroupMembers200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetAllGroupMembers200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetAllGroupMembers200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetAllGroupMembers200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetAllGroupMembers200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllGroupMembersAsync
     *
     * Get all group members
     *
     * @param  int $group_id ID of group (required)
     * @param  int $page Page number to show page in pagenation. If empty, start at first page. (optional, default to 1)
     * @param  int $limit Number of results per page. (optional, default to 10)
     * @param  int[] $role_ids roles to filter the members (optional)
     * @param  bool $allowed_chat_users_only If true, return only group members, that are allowed to chat in this group (optional)
     * @param  string $query searches in first and second name of group member (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllGroupMembers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllGroupMembersAsync($group_id, $page = 1, $limit = 10, $role_ids = null, $allowed_chat_users_only = null, $query = null, string $contentType = self::contentTypes['getAllGroupMembers'][0])
    {
        return $this->getAllGroupMembersAsyncWithHttpInfo($group_id, $page, $limit, $role_ids, $allowed_chat_users_only, $query, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllGroupMembersAsyncWithHttpInfo
     *
     * Get all group members
     *
     * @param  int $group_id ID of group (required)
     * @param  int $page Page number to show page in pagenation. If empty, start at first page. (optional, default to 1)
     * @param  int $limit Number of results per page. (optional, default to 10)
     * @param  int[] $role_ids roles to filter the members (optional)
     * @param  bool $allowed_chat_users_only If true, return only group members, that are allowed to chat in this group (optional)
     * @param  string $query searches in first and second name of group member (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllGroupMembers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllGroupMembersAsyncWithHttpInfo($group_id, $page = 1, $limit = 10, $role_ids = null, $allowed_chat_users_only = null, $query = null, string $contentType = self::contentTypes['getAllGroupMembers'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetAllGroupMembers200Response';
        $request = $this->getAllGroupMembersRequest($group_id, $page, $limit, $role_ids, $allowed_chat_users_only, $query, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllGroupMembers'
     *
     * @param  int $group_id ID of group (required)
     * @param  int $page Page number to show page in pagenation. If empty, start at first page. (optional, default to 1)
     * @param  int $limit Number of results per page. (optional, default to 10)
     * @param  int[] $role_ids roles to filter the members (optional)
     * @param  bool $allowed_chat_users_only If true, return only group members, that are allowed to chat in this group (optional)
     * @param  string $query searches in first and second name of group member (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllGroupMembers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllGroupMembersRequest($group_id, $page = 1, $limit = 10, $role_ids = null, $allowed_chat_users_only = null, $query = null, string $contentType = self::contentTypes['getAllGroupMembers'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getAllGroupMembers'
            );
        }







        $resourcePath = '/groups/{groupId}/members';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $role_ids,
            'role_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $allowed_chat_users_only,
            'allowed_chat_users_only', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllGroupsForPerson
     *
     * Get all groups a member is in
     *
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllGroupsForPerson'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetAllGroupsForPerson200Response
     */
    public function getAllGroupsForPerson($person_id, string $contentType = self::contentTypes['getAllGroupsForPerson'][0])
    {
        list($response) = $this->getAllGroupsForPersonWithHttpInfo($person_id, $contentType);
        return $response;
    }

    /**
     * Operation getAllGroupsForPersonWithHttpInfo
     *
     * Get all groups a member is in
     *
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllGroupsForPerson'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetAllGroupsForPerson200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllGroupsForPersonWithHttpInfo($person_id, string $contentType = self::contentTypes['getAllGroupsForPerson'][0])
    {
        $request = $this->getAllGroupsForPersonRequest($person_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetAllGroupsForPerson200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetAllGroupsForPerson200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetAllGroupsForPerson200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetAllGroupsForPerson200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetAllGroupsForPerson200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllGroupsForPersonAsync
     *
     * Get all groups a member is in
     *
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllGroupsForPerson'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllGroupsForPersonAsync($person_id, string $contentType = self::contentTypes['getAllGroupsForPerson'][0])
    {
        return $this->getAllGroupsForPersonAsyncWithHttpInfo($person_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllGroupsForPersonAsyncWithHttpInfo
     *
     * Get all groups a member is in
     *
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllGroupsForPerson'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllGroupsForPersonAsyncWithHttpInfo($person_id, string $contentType = self::contentTypes['getAllGroupsForPerson'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetAllGroupsForPerson200Response';
        $request = $this->getAllGroupsForPersonRequest($person_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllGroupsForPerson'
     *
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllGroupsForPerson'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllGroupsForPersonRequest($person_id, string $contentType = self::contentTypes['getAllGroupsForPerson'][0])
    {

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling getAllGroupsForPerson'
            );
        }


        $resourcePath = '/persons/{personId}/groups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($person_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personId' . '}',
                ObjectSerializer::toPathValue($person_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllMeetings
     *
     * Get all group meetings for a specific group
     *
     * @param  int $group_id ID of group (required)
     * @param  bool $is_canceled Whether to show canceled group meetings (optional)
     * @param  bool $is_completed Whether to show done group meetings (optional)
     * @param  \DateTime $start_date start_date (optional)
     * @param  \DateTime $end_date end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllMeetings'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetAllMeetings200Response
     */
    public function getAllMeetings($group_id, $is_canceled = null, $is_completed = null, $start_date = null, $end_date = null, string $contentType = self::contentTypes['getAllMeetings'][0])
    {
        list($response) = $this->getAllMeetingsWithHttpInfo($group_id, $is_canceled, $is_completed, $start_date, $end_date, $contentType);
        return $response;
    }

    /**
     * Operation getAllMeetingsWithHttpInfo
     *
     * Get all group meetings for a specific group
     *
     * @param  int $group_id ID of group (required)
     * @param  bool $is_canceled Whether to show canceled group meetings (optional)
     * @param  bool $is_completed Whether to show done group meetings (optional)
     * @param  \DateTime $start_date (optional)
     * @param  \DateTime $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllMeetings'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetAllMeetings200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllMeetingsWithHttpInfo($group_id, $is_canceled = null, $is_completed = null, $start_date = null, $end_date = null, string $contentType = self::contentTypes['getAllMeetings'][0])
    {
        $request = $this->getAllMeetingsRequest($group_id, $is_canceled, $is_completed, $start_date, $end_date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetAllMeetings200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetAllMeetings200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetAllMeetings200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetAllMeetings200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetAllMeetings200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllMeetingsAsync
     *
     * Get all group meetings for a specific group
     *
     * @param  int $group_id ID of group (required)
     * @param  bool $is_canceled Whether to show canceled group meetings (optional)
     * @param  bool $is_completed Whether to show done group meetings (optional)
     * @param  \DateTime $start_date (optional)
     * @param  \DateTime $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllMeetings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllMeetingsAsync($group_id, $is_canceled = null, $is_completed = null, $start_date = null, $end_date = null, string $contentType = self::contentTypes['getAllMeetings'][0])
    {
        return $this->getAllMeetingsAsyncWithHttpInfo($group_id, $is_canceled, $is_completed, $start_date, $end_date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllMeetingsAsyncWithHttpInfo
     *
     * Get all group meetings for a specific group
     *
     * @param  int $group_id ID of group (required)
     * @param  bool $is_canceled Whether to show canceled group meetings (optional)
     * @param  bool $is_completed Whether to show done group meetings (optional)
     * @param  \DateTime $start_date (optional)
     * @param  \DateTime $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllMeetings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllMeetingsAsyncWithHttpInfo($group_id, $is_canceled = null, $is_completed = null, $start_date = null, $end_date = null, string $contentType = self::contentTypes['getAllMeetings'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetAllMeetings200Response';
        $request = $this->getAllMeetingsRequest($group_id, $is_canceled, $is_completed, $start_date, $end_date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllMeetings'
     *
     * @param  int $group_id ID of group (required)
     * @param  bool $is_canceled Whether to show canceled group meetings (optional)
     * @param  bool $is_completed Whether to show done group meetings (optional)
     * @param  \DateTime $start_date (optional)
     * @param  \DateTime $end_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllMeetings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllMeetingsRequest($group_id, $is_canceled = null, $is_completed = null, $start_date = null, $end_date = null, string $contentType = self::contentTypes['getAllMeetings'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getAllMeetings'
            );
        }






        $resourcePath = '/groups/{groupId}/meetings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_canceled,
            'is_canceled', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_completed,
            'is_completed', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_date,
            'start_date', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_date,
            'end_date', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAutomaticEmail
     *
     * Get one automatic email
     *
     * @param  int $group_id ID of group (required)
     * @param  string $email_id email_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetAutomaticEmail200Response
     */
    public function getAutomaticEmail($group_id, $email_id, string $contentType = self::contentTypes['getAutomaticEmail'][0])
    {
        list($response) = $this->getAutomaticEmailWithHttpInfo($group_id, $email_id, $contentType);
        return $response;
    }

    /**
     * Operation getAutomaticEmailWithHttpInfo
     *
     * Get one automatic email
     *
     * @param  int $group_id ID of group (required)
     * @param  string $email_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetAutomaticEmail200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAutomaticEmailWithHttpInfo($group_id, $email_id, string $contentType = self::contentTypes['getAutomaticEmail'][0])
    {
        $request = $this->getAutomaticEmailRequest($group_id, $email_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetAutomaticEmail200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetAutomaticEmail200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetAutomaticEmail200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetAutomaticEmail200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetAutomaticEmail200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAutomaticEmailAsync
     *
     * Get one automatic email
     *
     * @param  int $group_id ID of group (required)
     * @param  string $email_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAutomaticEmailAsync($group_id, $email_id, string $contentType = self::contentTypes['getAutomaticEmail'][0])
    {
        return $this->getAutomaticEmailAsyncWithHttpInfo($group_id, $email_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAutomaticEmailAsyncWithHttpInfo
     *
     * Get one automatic email
     *
     * @param  int $group_id ID of group (required)
     * @param  string $email_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAutomaticEmailAsyncWithHttpInfo($group_id, $email_id, string $contentType = self::contentTypes['getAutomaticEmail'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetAutomaticEmail200Response';
        $request = $this->getAutomaticEmailRequest($group_id, $email_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAutomaticEmail'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $email_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAutomaticEmailRequest($group_id, $email_id, string $contentType = self::contentTypes['getAutomaticEmail'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getAutomaticEmail'
            );
        }

        // verify the required parameter 'email_id' is set
        if ($email_id === null || (is_array($email_id) && count($email_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $email_id when calling getAutomaticEmail'
            );
        }


        $resourcePath = '/groups/{groupId}/emails/{emailId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                '{' . 'emailId' . '}',
                ObjectSerializer::toPathValue($email_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAutomaticEmails
     *
     * Get all automatic emails of a group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomaticEmails'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetAutomaticEmails200Response
     */
    public function getAutomaticEmails($group_id, string $contentType = self::contentTypes['getAutomaticEmails'][0])
    {
        list($response) = $this->getAutomaticEmailsWithHttpInfo($group_id, $contentType);
        return $response;
    }

    /**
     * Operation getAutomaticEmailsWithHttpInfo
     *
     * Get all automatic emails of a group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomaticEmails'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetAutomaticEmails200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAutomaticEmailsWithHttpInfo($group_id, string $contentType = self::contentTypes['getAutomaticEmails'][0])
    {
        $request = $this->getAutomaticEmailsRequest($group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetAutomaticEmails200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetAutomaticEmails200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetAutomaticEmails200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetAutomaticEmails200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetAutomaticEmails200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAutomaticEmailsAsync
     *
     * Get all automatic emails of a group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomaticEmails'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAutomaticEmailsAsync($group_id, string $contentType = self::contentTypes['getAutomaticEmails'][0])
    {
        return $this->getAutomaticEmailsAsyncWithHttpInfo($group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAutomaticEmailsAsyncWithHttpInfo
     *
     * Get all automatic emails of a group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomaticEmails'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAutomaticEmailsAsyncWithHttpInfo($group_id, string $contentType = self::contentTypes['getAutomaticEmails'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetAutomaticEmails200Response';
        $request = $this->getAutomaticEmailsRequest($group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAutomaticEmails'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomaticEmails'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAutomaticEmailsRequest($group_id, string $contentType = self::contentTypes['getAutomaticEmails'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getAutomaticEmails'
            );
        }


        $resourcePath = '/groups/{groupId}/emails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroup
     *
     * Get a group
     *
     * @param  int $group_id ID or chat GUID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroup'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PostGroups201Response
     */
    public function getGroup($group_id, string $contentType = self::contentTypes['getGroup'][0])
    {
        list($response) = $this->getGroupWithHttpInfo($group_id, $contentType);
        return $response;
    }

    /**
     * Operation getGroupWithHttpInfo
     *
     * Get a group
     *
     * @param  int $group_id ID or chat GUID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroup'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PostGroups201Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupWithHttpInfo($group_id, string $contentType = self::contentTypes['getGroup'][0])
    {
        $request = $this->getGroupRequest($group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\PostGroups201Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PostGroups201Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PostGroups201Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PostGroups201Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PostGroups201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupAsync
     *
     * Get a group
     *
     * @param  int $group_id ID or chat GUID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupAsync($group_id, string $contentType = self::contentTypes['getGroup'][0])
    {
        return $this->getGroupAsyncWithHttpInfo($group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupAsyncWithHttpInfo
     *
     * Get a group
     *
     * @param  int $group_id ID or chat GUID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupAsyncWithHttpInfo($group_id, string $contentType = self::contentTypes['getGroup'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PostGroups201Response';
        $request = $this->getGroupRequest($group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroup'
     *
     * @param  int $group_id ID or chat GUID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupRequest($group_id, string $contentType = self::contentTypes['getGroup'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getGroup'
            );
        }


        $resourcePath = '/groups/{groupId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupAgegroups
     *
     * Get agegroups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupAgegroups'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupAgegroups200Response
     */
    public function getGroupAgegroups(string $contentType = self::contentTypes['getGroupAgegroups'][0])
    {
        list($response) = $this->getGroupAgegroupsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getGroupAgegroupsWithHttpInfo
     *
     * Get agegroups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupAgegroups'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupAgegroups200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupAgegroupsWithHttpInfo(string $contentType = self::contentTypes['getGroupAgegroups'][0])
    {
        $request = $this->getGroupAgegroupsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupAgegroups200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupAgegroups200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupAgegroups200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupAgegroups200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupAgegroups200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupAgegroupsAsync
     *
     * Get agegroups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupAgegroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupAgegroupsAsync(string $contentType = self::contentTypes['getGroupAgegroups'][0])
    {
        return $this->getGroupAgegroupsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupAgegroupsAsyncWithHttpInfo
     *
     * Get agegroups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupAgegroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupAgegroupsAsyncWithHttpInfo(string $contentType = self::contentTypes['getGroupAgegroups'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupAgegroups200Response';
        $request = $this->getGroupAgegroupsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupAgegroups'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupAgegroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupAgegroupsRequest(string $contentType = self::contentTypes['getGroupAgegroups'][0])
    {


        $resourcePath = '/group/agegroups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupAgegroupsAgeGroupId
     *
     * Get agegroup
     *
     * @param  string $age_group_id age_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupAgegroupsAgeGroupId200Response
     */
    public function getGroupAgegroupsAgeGroupId($age_group_id, string $contentType = self::contentTypes['getGroupAgegroupsAgeGroupId'][0])
    {
        list($response) = $this->getGroupAgegroupsAgeGroupIdWithHttpInfo($age_group_id, $contentType);
        return $response;
    }

    /**
     * Operation getGroupAgegroupsAgeGroupIdWithHttpInfo
     *
     * Get agegroup
     *
     * @param  string $age_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupAgegroupsAgeGroupId200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupAgegroupsAgeGroupIdWithHttpInfo($age_group_id, string $contentType = self::contentTypes['getGroupAgegroupsAgeGroupId'][0])
    {
        $request = $this->getGroupAgegroupsAgeGroupIdRequest($age_group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupAgegroupsAgeGroupId200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupAgegroupsAgeGroupId200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupAgegroupsAgeGroupId200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupAgegroupsAgeGroupId200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupAgegroupsAgeGroupId200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupAgegroupsAgeGroupIdAsync
     *
     * Get agegroup
     *
     * @param  string $age_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupAgegroupsAgeGroupIdAsync($age_group_id, string $contentType = self::contentTypes['getGroupAgegroupsAgeGroupId'][0])
    {
        return $this->getGroupAgegroupsAgeGroupIdAsyncWithHttpInfo($age_group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupAgegroupsAgeGroupIdAsyncWithHttpInfo
     *
     * Get agegroup
     *
     * @param  string $age_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupAgegroupsAgeGroupIdAsyncWithHttpInfo($age_group_id, string $contentType = self::contentTypes['getGroupAgegroupsAgeGroupId'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupAgegroupsAgeGroupId200Response';
        $request = $this->getGroupAgegroupsAgeGroupIdRequest($age_group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupAgegroupsAgeGroupId'
     *
     * @param  string $age_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupAgegroupsAgeGroupIdRequest($age_group_id, string $contentType = self::contentTypes['getGroupAgegroupsAgeGroupId'][0])
    {

        // verify the required parameter 'age_group_id' is set
        if ($age_group_id === null || (is_array($age_group_id) && count($age_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $age_group_id when calling getGroupAgegroupsAgeGroupId'
            );
        }


        $resourcePath = '/group/agegroups/{ageGroupId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($age_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ageGroupId' . '}',
                ObjectSerializer::toPathValue($age_group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupForHomepage
     *
     * Public information of group
     *
     * @param  string $hash Group Homepage Hash (required)
     * @param  string $group_id Group ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupForHomepage'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PublicGroup1
     */
    public function getGroupForHomepage($hash, $group_id, string $contentType = self::contentTypes['getGroupForHomepage'][0])
    {
        list($response) = $this->getGroupForHomepageWithHttpInfo($hash, $group_id, $contentType);
        return $response;
    }

    /**
     * Operation getGroupForHomepageWithHttpInfo
     *
     * Public information of group
     *
     * @param  string $hash Group Homepage Hash (required)
     * @param  string $group_id Group ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupForHomepage'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PublicGroup1, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupForHomepageWithHttpInfo($hash, $group_id, string $contentType = self::contentTypes['getGroupForHomepage'][0])
    {
        $request = $this->getGroupForHomepageRequest($hash, $group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\PublicGroup1' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PublicGroup1' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PublicGroup1', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PublicGroup1';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PublicGroup1',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupForHomepageAsync
     *
     * Public information of group
     *
     * @param  string $hash Group Homepage Hash (required)
     * @param  string $group_id Group ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupForHomepage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupForHomepageAsync($hash, $group_id, string $contentType = self::contentTypes['getGroupForHomepage'][0])
    {
        return $this->getGroupForHomepageAsyncWithHttpInfo($hash, $group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupForHomepageAsyncWithHttpInfo
     *
     * Public information of group
     *
     * @param  string $hash Group Homepage Hash (required)
     * @param  string $group_id Group ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupForHomepage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupForHomepageAsyncWithHttpInfo($hash, $group_id, string $contentType = self::contentTypes['getGroupForHomepage'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PublicGroup1';
        $request = $this->getGroupForHomepageRequest($hash, $group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupForHomepage'
     *
     * @param  string $hash Group Homepage Hash (required)
     * @param  string $group_id Group ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupForHomepage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupForHomepageRequest($hash, $group_id, string $contentType = self::contentTypes['getGroupForHomepage'][0])
    {

        // verify the required parameter 'hash' is set
        if ($hash === null || (is_array($hash) && count($hash) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $hash when calling getGroupForHomepage'
            );
        }

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getGroupForHomepage'
            );
        }


        $resourcePath = '/publicgroups/{groupId}/{hash}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($hash !== null) {
            $resourcePath = str_replace(
                '{' . 'hash' . '}',
                ObjectSerializer::toPathValue($hash),
                $resourcePath
            );
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupGroupcategories
     *
     * GET Group Categories
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGroupcategories'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupGroupcategories200Response
     */
    public function getGroupGroupcategories(string $contentType = self::contentTypes['getGroupGroupcategories'][0])
    {
        list($response) = $this->getGroupGroupcategoriesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getGroupGroupcategoriesWithHttpInfo
     *
     * GET Group Categories
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGroupcategories'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupGroupcategories200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupGroupcategoriesWithHttpInfo(string $contentType = self::contentTypes['getGroupGroupcategories'][0])
    {
        $request = $this->getGroupGroupcategoriesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupGroupcategories200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupGroupcategories200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupGroupcategories200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupGroupcategories200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupGroupcategories200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupGroupcategoriesAsync
     *
     * GET Group Categories
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGroupcategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupGroupcategoriesAsync(string $contentType = self::contentTypes['getGroupGroupcategories'][0])
    {
        return $this->getGroupGroupcategoriesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupGroupcategoriesAsyncWithHttpInfo
     *
     * GET Group Categories
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGroupcategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupGroupcategoriesAsyncWithHttpInfo(string $contentType = self::contentTypes['getGroupGroupcategories'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupGroupcategories200Response';
        $request = $this->getGroupGroupcategoriesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupGroupcategories'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGroupcategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupGroupcategoriesRequest(string $contentType = self::contentTypes['getGroupGroupcategories'][0])
    {


        $resourcePath = '/group/groupcategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupGroupcategoriesGroupCategoryId
     *
     * Get Group Category
     *
     * @param  string $group_category_id group_category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupGroupcategoriesGroupCategoryId200Response
     */
    public function getGroupGroupcategoriesGroupCategoryId($group_category_id, string $contentType = self::contentTypes['getGroupGroupcategoriesGroupCategoryId'][0])
    {
        list($response) = $this->getGroupGroupcategoriesGroupCategoryIdWithHttpInfo($group_category_id, $contentType);
        return $response;
    }

    /**
     * Operation getGroupGroupcategoriesGroupCategoryIdWithHttpInfo
     *
     * Get Group Category
     *
     * @param  string $group_category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupGroupcategoriesGroupCategoryId200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupGroupcategoriesGroupCategoryIdWithHttpInfo($group_category_id, string $contentType = self::contentTypes['getGroupGroupcategoriesGroupCategoryId'][0])
    {
        $request = $this->getGroupGroupcategoriesGroupCategoryIdRequest($group_category_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupGroupcategoriesGroupCategoryId200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupGroupcategoriesGroupCategoryId200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupGroupcategoriesGroupCategoryId200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupGroupcategoriesGroupCategoryId200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupGroupcategoriesGroupCategoryId200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupGroupcategoriesGroupCategoryIdAsync
     *
     * Get Group Category
     *
     * @param  string $group_category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupGroupcategoriesGroupCategoryIdAsync($group_category_id, string $contentType = self::contentTypes['getGroupGroupcategoriesGroupCategoryId'][0])
    {
        return $this->getGroupGroupcategoriesGroupCategoryIdAsyncWithHttpInfo($group_category_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupGroupcategoriesGroupCategoryIdAsyncWithHttpInfo
     *
     * Get Group Category
     *
     * @param  string $group_category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupGroupcategoriesGroupCategoryIdAsyncWithHttpInfo($group_category_id, string $contentType = self::contentTypes['getGroupGroupcategoriesGroupCategoryId'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupGroupcategoriesGroupCategoryId200Response';
        $request = $this->getGroupGroupcategoriesGroupCategoryIdRequest($group_category_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupGroupcategoriesGroupCategoryId'
     *
     * @param  string $group_category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupGroupcategoriesGroupCategoryIdRequest($group_category_id, string $contentType = self::contentTypes['getGroupGroupcategoriesGroupCategoryId'][0])
    {

        // verify the required parameter 'group_category_id' is set
        if ($group_category_id === null || (is_array($group_category_id) && count($group_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_category_id when calling getGroupGroupcategoriesGroupCategoryId'
            );
        }


        $resourcePath = '/group/groupcategories/{groupCategoryId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupCategoryId' . '}',
                ObjectSerializer::toPathValue($group_category_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupGrouptypes
     *
     * Get all group types
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGrouptypes'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupGrouptypes200Response
     */
    public function getGroupGrouptypes(string $contentType = self::contentTypes['getGroupGrouptypes'][0])
    {
        list($response) = $this->getGroupGrouptypesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getGroupGrouptypesWithHttpInfo
     *
     * Get all group types
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGrouptypes'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupGrouptypes200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupGrouptypesWithHttpInfo(string $contentType = self::contentTypes['getGroupGrouptypes'][0])
    {
        $request = $this->getGroupGrouptypesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupGrouptypes200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupGrouptypes200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupGrouptypes200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupGrouptypes200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupGrouptypes200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupGrouptypesAsync
     *
     * Get all group types
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGrouptypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupGrouptypesAsync(string $contentType = self::contentTypes['getGroupGrouptypes'][0])
    {
        return $this->getGroupGrouptypesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupGrouptypesAsyncWithHttpInfo
     *
     * Get all group types
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGrouptypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupGrouptypesAsyncWithHttpInfo(string $contentType = self::contentTypes['getGroupGrouptypes'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupGrouptypes200Response';
        $request = $this->getGroupGrouptypesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupGrouptypes'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGrouptypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupGrouptypesRequest(string $contentType = self::contentTypes['getGroupGrouptypes'][0])
    {


        $resourcePath = '/group/grouptypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupGrouptypesGroupTypeId
     *
     * Get grouptype
     *
     * @param  string $group_type_id group_type_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupGrouptypesGroupTypeId200Response
     */
    public function getGroupGrouptypesGroupTypeId($group_type_id, string $contentType = self::contentTypes['getGroupGrouptypesGroupTypeId'][0])
    {
        list($response) = $this->getGroupGrouptypesGroupTypeIdWithHttpInfo($group_type_id, $contentType);
        return $response;
    }

    /**
     * Operation getGroupGrouptypesGroupTypeIdWithHttpInfo
     *
     * Get grouptype
     *
     * @param  string $group_type_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupGrouptypesGroupTypeId200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupGrouptypesGroupTypeIdWithHttpInfo($group_type_id, string $contentType = self::contentTypes['getGroupGrouptypesGroupTypeId'][0])
    {
        $request = $this->getGroupGrouptypesGroupTypeIdRequest($group_type_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupGrouptypesGroupTypeId200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupGrouptypesGroupTypeId200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupGrouptypesGroupTypeId200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupGrouptypesGroupTypeId200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupGrouptypesGroupTypeId200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupGrouptypesGroupTypeIdAsync
     *
     * Get grouptype
     *
     * @param  string $group_type_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupGrouptypesGroupTypeIdAsync($group_type_id, string $contentType = self::contentTypes['getGroupGrouptypesGroupTypeId'][0])
    {
        return $this->getGroupGrouptypesGroupTypeIdAsyncWithHttpInfo($group_type_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupGrouptypesGroupTypeIdAsyncWithHttpInfo
     *
     * Get grouptype
     *
     * @param  string $group_type_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupGrouptypesGroupTypeIdAsyncWithHttpInfo($group_type_id, string $contentType = self::contentTypes['getGroupGrouptypesGroupTypeId'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupGrouptypesGroupTypeId200Response';
        $request = $this->getGroupGrouptypesGroupTypeIdRequest($group_type_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupGrouptypesGroupTypeId'
     *
     * @param  string $group_type_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupGrouptypesGroupTypeIdRequest($group_type_id, string $contentType = self::contentTypes['getGroupGrouptypesGroupTypeId'][0])
    {

        // verify the required parameter 'group_type_id' is set
        if ($group_type_id === null || (is_array($group_type_id) && count($group_type_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_type_id when calling getGroupGrouptypesGroupTypeId'
            );
        }


        $resourcePath = '/group/grouptypes/{groupTypeId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_type_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupTypeId' . '}',
                ObjectSerializer::toPathValue($group_type_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupHomepage
     *
     * Get information about public groups with settings
     *
     * @param  string $hash Random hash for public groups (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupHomepage'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupHomepage200Response
     */
    public function getGroupHomepage($hash, string $contentType = self::contentTypes['getGroupHomepage'][0])
    {
        list($response) = $this->getGroupHomepageWithHttpInfo($hash, $contentType);
        return $response;
    }

    /**
     * Operation getGroupHomepageWithHttpInfo
     *
     * Get information about public groups with settings
     *
     * @param  string $hash Random hash for public groups (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupHomepage'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupHomepage200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupHomepageWithHttpInfo($hash, string $contentType = self::contentTypes['getGroupHomepage'][0])
    {
        $request = $this->getGroupHomepageRequest($hash, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupHomepage200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupHomepage200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupHomepage200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupHomepage200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupHomepage200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupHomepageAsync
     *
     * Get information about public groups with settings
     *
     * @param  string $hash Random hash for public groups (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupHomepage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupHomepageAsync($hash, string $contentType = self::contentTypes['getGroupHomepage'][0])
    {
        return $this->getGroupHomepageAsyncWithHttpInfo($hash, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupHomepageAsyncWithHttpInfo
     *
     * Get information about public groups with settings
     *
     * @param  string $hash Random hash for public groups (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupHomepage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupHomepageAsyncWithHttpInfo($hash, string $contentType = self::contentTypes['getGroupHomepage'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupHomepage200Response';
        $request = $this->getGroupHomepageRequest($hash, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupHomepage'
     *
     * @param  string $hash Random hash for public groups (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupHomepage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupHomepageRequest($hash, string $contentType = self::contentTypes['getGroupHomepage'][0])
    {

        // verify the required parameter 'hash' is set
        if ($hash === null || (is_array($hash) && count($hash) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $hash when calling getGroupHomepage'
            );
        }


        $resourcePath = '/grouphomepages/{hash}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($hash !== null) {
            $resourcePath = str_replace(
                '{' . 'hash' . '}',
                ObjectSerializer::toPathValue($hash),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupRoles
     *
     * Get roles
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRoles'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupRoles200Response
     */
    public function getGroupRoles(string $contentType = self::contentTypes['getGroupRoles'][0])
    {
        list($response) = $this->getGroupRolesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getGroupRolesWithHttpInfo
     *
     * Get roles
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRoles'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupRoles200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupRolesWithHttpInfo(string $contentType = self::contentTypes['getGroupRoles'][0])
    {
        $request = $this->getGroupRolesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupRoles200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupRoles200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupRoles200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupRoles200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupRoles200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupRolesAsync
     *
     * Get roles
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRoles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupRolesAsync(string $contentType = self::contentTypes['getGroupRoles'][0])
    {
        return $this->getGroupRolesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupRolesAsyncWithHttpInfo
     *
     * Get roles
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRoles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupRolesAsyncWithHttpInfo(string $contentType = self::contentTypes['getGroupRoles'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupRoles200Response';
        $request = $this->getGroupRolesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupRoles'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRoles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupRolesRequest(string $contentType = self::contentTypes['getGroupRoles'][0])
    {


        $resourcePath = '/group/roles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupRolesRoleId
     *
     * Get role
     *
     * @param  string $role_id role_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupRolesRoleId200Response
     */
    public function getGroupRolesRoleId($role_id, string $contentType = self::contentTypes['getGroupRolesRoleId'][0])
    {
        list($response) = $this->getGroupRolesRoleIdWithHttpInfo($role_id, $contentType);
        return $response;
    }

    /**
     * Operation getGroupRolesRoleIdWithHttpInfo
     *
     * Get role
     *
     * @param  string $role_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupRolesRoleId200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupRolesRoleIdWithHttpInfo($role_id, string $contentType = self::contentTypes['getGroupRolesRoleId'][0])
    {
        $request = $this->getGroupRolesRoleIdRequest($role_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupRolesRoleId200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupRolesRoleId200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupRolesRoleId200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupRolesRoleId200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupRolesRoleId200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupRolesRoleIdAsync
     *
     * Get role
     *
     * @param  string $role_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupRolesRoleIdAsync($role_id, string $contentType = self::contentTypes['getGroupRolesRoleId'][0])
    {
        return $this->getGroupRolesRoleIdAsyncWithHttpInfo($role_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupRolesRoleIdAsyncWithHttpInfo
     *
     * Get role
     *
     * @param  string $role_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupRolesRoleIdAsyncWithHttpInfo($role_id, string $contentType = self::contentTypes['getGroupRolesRoleId'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupRolesRoleId200Response';
        $request = $this->getGroupRolesRoleIdRequest($role_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupRolesRoleId'
     *
     * @param  string $role_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupRolesRoleIdRequest($role_id, string $contentType = self::contentTypes['getGroupRolesRoleId'][0])
    {

        // verify the required parameter 'role_id' is set
        if ($role_id === null || (is_array($role_id) && count($role_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $role_id when calling getGroupRolesRoleId'
            );
        }


        $resourcePath = '/group/roles/{roleId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($role_id !== null) {
            $resourcePath = str_replace(
                '{' . 'roleId' . '}',
                ObjectSerializer::toPathValue($role_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupRoles_0
     *
     * Get all roles for this group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRoles_0'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupRoles200Response
     */
    public function getGroupRoles_0($group_id, string $contentType = self::contentTypes['getGroupRoles_0'][0])
    {
        list($response) = $this->getGroupRoles_0WithHttpInfo($group_id, $contentType);
        return $response;
    }

    /**
     * Operation getGroupRoles_0WithHttpInfo
     *
     * Get all roles for this group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRoles_0'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupRoles200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupRoles_0WithHttpInfo($group_id, string $contentType = self::contentTypes['getGroupRoles_0'][0])
    {
        $request = $this->getGroupRoles_0Request($group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupRoles200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupRoles200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupRoles200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupRoles200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupRoles200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupRoles_0Async
     *
     * Get all roles for this group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRoles_0'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupRoles_0Async($group_id, string $contentType = self::contentTypes['getGroupRoles_0'][0])
    {
        return $this->getGroupRoles_0AsyncWithHttpInfo($group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupRoles_0AsyncWithHttpInfo
     *
     * Get all roles for this group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRoles_0'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupRoles_0AsyncWithHttpInfo($group_id, string $contentType = self::contentTypes['getGroupRoles_0'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupRoles200Response';
        $request = $this->getGroupRoles_0Request($group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupRoles_0'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupRoles_0'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupRoles_0Request($group_id, string $contentType = self::contentTypes['getGroupRoles_0'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getGroupRoles_0'
            );
        }


        $resourcePath = '/groups/{groupId}/roles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupStatistics
     *
     * Fetch facts about group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupStatistics'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupStatistics200Response|string
     */
    public function getGroupStatistics($group_id, string $contentType = self::contentTypes['getGroupStatistics'][0])
    {
        list($response) = $this->getGroupStatisticsWithHttpInfo($group_id, $contentType);
        return $response;
    }

    /**
     * Operation getGroupStatisticsWithHttpInfo
     *
     * Fetch facts about group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupStatistics'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupStatistics200Response|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupStatisticsWithHttpInfo($group_id, string $contentType = self::contentTypes['getGroupStatistics'][0])
    {
        $request = $this->getGroupStatisticsRequest($group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupStatistics200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupStatistics200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupStatistics200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupStatistics200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupStatistics200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupStatisticsAsync
     *
     * Fetch facts about group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupStatistics'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupStatisticsAsync($group_id, string $contentType = self::contentTypes['getGroupStatistics'][0])
    {
        return $this->getGroupStatisticsAsyncWithHttpInfo($group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupStatisticsAsyncWithHttpInfo
     *
     * Fetch facts about group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupStatistics'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupStatisticsAsyncWithHttpInfo($group_id, string $contentType = self::contentTypes['getGroupStatistics'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupStatistics200Response';
        $request = $this->getGroupStatisticsRequest($group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupStatistics'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupStatistics'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupStatisticsRequest($group_id, string $contentType = self::contentTypes['getGroupStatistics'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getGroupStatistics'
            );
        }


        $resourcePath = '/groups/{groupId}/statistics';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupTargetgroups
     *
     * Get target groups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupTargetgroups'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupTargetgroups200Response
     */
    public function getGroupTargetgroups(string $contentType = self::contentTypes['getGroupTargetgroups'][0])
    {
        list($response) = $this->getGroupTargetgroupsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getGroupTargetgroupsWithHttpInfo
     *
     * Get target groups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupTargetgroups'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupTargetgroups200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupTargetgroupsWithHttpInfo(string $contentType = self::contentTypes['getGroupTargetgroups'][0])
    {
        $request = $this->getGroupTargetgroupsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupTargetgroups200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupTargetgroups200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupTargetgroups200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupTargetgroups200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupTargetgroups200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupTargetgroupsAsync
     *
     * Get target groups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupTargetgroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupTargetgroupsAsync(string $contentType = self::contentTypes['getGroupTargetgroups'][0])
    {
        return $this->getGroupTargetgroupsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupTargetgroupsAsyncWithHttpInfo
     *
     * Get target groups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupTargetgroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupTargetgroupsAsyncWithHttpInfo(string $contentType = self::contentTypes['getGroupTargetgroups'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupTargetgroups200Response';
        $request = $this->getGroupTargetgroupsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupTargetgroups'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupTargetgroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupTargetgroupsRequest(string $contentType = self::contentTypes['getGroupTargetgroups'][0])
    {


        $resourcePath = '/group/targetgroups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupTargetgroupsTargetGroupId
     *
     * Get target group
     *
     * @param  string $target_group_id target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupTargetgroupsTargetGroupId200Response
     */
    public function getGroupTargetgroupsTargetGroupId($target_group_id, string $contentType = self::contentTypes['getGroupTargetgroupsTargetGroupId'][0])
    {
        list($response) = $this->getGroupTargetgroupsTargetGroupIdWithHttpInfo($target_group_id, $contentType);
        return $response;
    }

    /**
     * Operation getGroupTargetgroupsTargetGroupIdWithHttpInfo
     *
     * Get target group
     *
     * @param  string $target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupTargetgroupsTargetGroupId200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupTargetgroupsTargetGroupIdWithHttpInfo($target_group_id, string $contentType = self::contentTypes['getGroupTargetgroupsTargetGroupId'][0])
    {
        $request = $this->getGroupTargetgroupsTargetGroupIdRequest($target_group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupTargetgroupsTargetGroupId200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupTargetgroupsTargetGroupId200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupTargetgroupsTargetGroupId200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupTargetgroupsTargetGroupId200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupTargetgroupsTargetGroupId200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupTargetgroupsTargetGroupIdAsync
     *
     * Get target group
     *
     * @param  string $target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupTargetgroupsTargetGroupIdAsync($target_group_id, string $contentType = self::contentTypes['getGroupTargetgroupsTargetGroupId'][0])
    {
        return $this->getGroupTargetgroupsTargetGroupIdAsyncWithHttpInfo($target_group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupTargetgroupsTargetGroupIdAsyncWithHttpInfo
     *
     * Get target group
     *
     * @param  string $target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupTargetgroupsTargetGroupIdAsyncWithHttpInfo($target_group_id, string $contentType = self::contentTypes['getGroupTargetgroupsTargetGroupId'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupTargetgroupsTargetGroupId200Response';
        $request = $this->getGroupTargetgroupsTargetGroupIdRequest($target_group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupTargetgroupsTargetGroupId'
     *
     * @param  string $target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupTargetgroupsTargetGroupIdRequest($target_group_id, string $contentType = self::contentTypes['getGroupTargetgroupsTargetGroupId'][0])
    {

        // verify the required parameter 'target_group_id' is set
        if ($target_group_id === null || (is_array($target_group_id) && count($target_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $target_group_id when calling getGroupTargetgroupsTargetGroupId'
            );
        }


        $resourcePath = '/group/targetgroups/{targetGroupId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($target_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'targetGroupId' . '}',
                ObjectSerializer::toPathValue($target_group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroups
     *
     * Get all groups
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  int[] $campus_ids Array of campus ids to filter the groups (optional)
     * @param  int[] $agegroup_ids Array of age group ids to filter the groups (optional)
     * @param  int[] $group_status_ids Array of group status ids to filter the groups (optional)
     * @param  int[] $group_category_ids Array of group category ids to filter the groups (optional)
     * @param  int[] $target_group_ids Array of target group ids to filter the groups (optional)
     * @param  int[] $weekdays Array of weekdays to filter the groups. Sunday &#x3D; 0, Monday &#x3D; 1 ... (optional)
     * @param  int[] $group_type_ids Array of group type ids to filter the groups (optional)
     * @param  bool $is_open_for_members Filters groups by its open status (optional)
     * @param  bool $is_public Filters groups by its public status (optional)
     * @param  bool $show_overdue_groups Determines if groups with overdue enddate should still be shown. (optional)
     * @param  bool $show_overdue_groups_respect_settings Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups. (optional)
     * @param  bool $show_inactive_groups Determines if inactive groups should be returned (optional)
     * @param  bool $without_my_groups Determines if groups should be omitted where I am in (optional)
     * @param  string $query query (optional)
     * @param  int $page Page number to show page in pagenation. If empty, start at first page. (optional, default to 1)
     * @param  int $limit Number of results per page. (optional, default to 10)
     * @param  bool $is_hidden Filters groups by hidden flag (optional)
     * @param  string[] $order_fields The fields to order by (optional)
     * @param  string $order_directions The order direction ASC or DESC for the order_fields (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroups'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroups200Response
     */
    public function getGroups($ids = null, $campus_ids = null, $agegroup_ids = null, $group_status_ids = null, $group_category_ids = null, $target_group_ids = null, $weekdays = null, $group_type_ids = null, $is_open_for_members = null, $is_public = null, $show_overdue_groups = null, $show_overdue_groups_respect_settings = null, $show_inactive_groups = null, $without_my_groups = null, $query = null, $page = 1, $limit = 10, $is_hidden = null, $order_fields = null, $order_directions = null, string $contentType = self::contentTypes['getGroups'][0])
    {
        list($response) = $this->getGroupsWithHttpInfo($ids, $campus_ids, $agegroup_ids, $group_status_ids, $group_category_ids, $target_group_ids, $weekdays, $group_type_ids, $is_open_for_members, $is_public, $show_overdue_groups, $show_overdue_groups_respect_settings, $show_inactive_groups, $without_my_groups, $query, $page, $limit, $is_hidden, $order_fields, $order_directions, $contentType);
        return $response;
    }

    /**
     * Operation getGroupsWithHttpInfo
     *
     * Get all groups
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  int[] $campus_ids Array of campus ids to filter the groups (optional)
     * @param  int[] $agegroup_ids Array of age group ids to filter the groups (optional)
     * @param  int[] $group_status_ids Array of group status ids to filter the groups (optional)
     * @param  int[] $group_category_ids Array of group category ids to filter the groups (optional)
     * @param  int[] $target_group_ids Array of target group ids to filter the groups (optional)
     * @param  int[] $weekdays Array of weekdays to filter the groups. Sunday &#x3D; 0, Monday &#x3D; 1 ... (optional)
     * @param  int[] $group_type_ids Array of group type ids to filter the groups (optional)
     * @param  bool $is_open_for_members Filters groups by its open status (optional)
     * @param  bool $is_public Filters groups by its public status (optional)
     * @param  bool $show_overdue_groups Determines if groups with overdue enddate should still be shown. (optional)
     * @param  bool $show_overdue_groups_respect_settings Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups. (optional)
     * @param  bool $show_inactive_groups Determines if inactive groups should be returned (optional)
     * @param  bool $without_my_groups Determines if groups should be omitted where I am in (optional)
     * @param  string $query (optional)
     * @param  int $page Page number to show page in pagenation. If empty, start at first page. (optional, default to 1)
     * @param  int $limit Number of results per page. (optional, default to 10)
     * @param  bool $is_hidden Filters groups by hidden flag (optional)
     * @param  string[] $order_fields The fields to order by (optional)
     * @param  string $order_directions The order direction ASC or DESC for the order_fields (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroups'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroups200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupsWithHttpInfo($ids = null, $campus_ids = null, $agegroup_ids = null, $group_status_ids = null, $group_category_ids = null, $target_group_ids = null, $weekdays = null, $group_type_ids = null, $is_open_for_members = null, $is_public = null, $show_overdue_groups = null, $show_overdue_groups_respect_settings = null, $show_inactive_groups = null, $without_my_groups = null, $query = null, $page = 1, $limit = 10, $is_hidden = null, $order_fields = null, $order_directions = null, string $contentType = self::contentTypes['getGroups'][0])
    {
        $request = $this->getGroupsRequest($ids, $campus_ids, $agegroup_ids, $group_status_ids, $group_category_ids, $target_group_ids, $weekdays, $group_type_ids, $is_open_for_members, $is_public, $show_overdue_groups, $show_overdue_groups_respect_settings, $show_inactive_groups, $without_my_groups, $query, $page, $limit, $is_hidden, $order_fields, $order_directions, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroups200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroups200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroups200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroups200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroups200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupsAsync
     *
     * Get all groups
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  int[] $campus_ids Array of campus ids to filter the groups (optional)
     * @param  int[] $agegroup_ids Array of age group ids to filter the groups (optional)
     * @param  int[] $group_status_ids Array of group status ids to filter the groups (optional)
     * @param  int[] $group_category_ids Array of group category ids to filter the groups (optional)
     * @param  int[] $target_group_ids Array of target group ids to filter the groups (optional)
     * @param  int[] $weekdays Array of weekdays to filter the groups. Sunday &#x3D; 0, Monday &#x3D; 1 ... (optional)
     * @param  int[] $group_type_ids Array of group type ids to filter the groups (optional)
     * @param  bool $is_open_for_members Filters groups by its open status (optional)
     * @param  bool $is_public Filters groups by its public status (optional)
     * @param  bool $show_overdue_groups Determines if groups with overdue enddate should still be shown. (optional)
     * @param  bool $show_overdue_groups_respect_settings Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups. (optional)
     * @param  bool $show_inactive_groups Determines if inactive groups should be returned (optional)
     * @param  bool $without_my_groups Determines if groups should be omitted where I am in (optional)
     * @param  string $query (optional)
     * @param  int $page Page number to show page in pagenation. If empty, start at first page. (optional, default to 1)
     * @param  int $limit Number of results per page. (optional, default to 10)
     * @param  bool $is_hidden Filters groups by hidden flag (optional)
     * @param  string[] $order_fields The fields to order by (optional)
     * @param  string $order_directions The order direction ASC or DESC for the order_fields (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsAsync($ids = null, $campus_ids = null, $agegroup_ids = null, $group_status_ids = null, $group_category_ids = null, $target_group_ids = null, $weekdays = null, $group_type_ids = null, $is_open_for_members = null, $is_public = null, $show_overdue_groups = null, $show_overdue_groups_respect_settings = null, $show_inactive_groups = null, $without_my_groups = null, $query = null, $page = 1, $limit = 10, $is_hidden = null, $order_fields = null, $order_directions = null, string $contentType = self::contentTypes['getGroups'][0])
    {
        return $this->getGroupsAsyncWithHttpInfo($ids, $campus_ids, $agegroup_ids, $group_status_ids, $group_category_ids, $target_group_ids, $weekdays, $group_type_ids, $is_open_for_members, $is_public, $show_overdue_groups, $show_overdue_groups_respect_settings, $show_inactive_groups, $without_my_groups, $query, $page, $limit, $is_hidden, $order_fields, $order_directions, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupsAsyncWithHttpInfo
     *
     * Get all groups
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  int[] $campus_ids Array of campus ids to filter the groups (optional)
     * @param  int[] $agegroup_ids Array of age group ids to filter the groups (optional)
     * @param  int[] $group_status_ids Array of group status ids to filter the groups (optional)
     * @param  int[] $group_category_ids Array of group category ids to filter the groups (optional)
     * @param  int[] $target_group_ids Array of target group ids to filter the groups (optional)
     * @param  int[] $weekdays Array of weekdays to filter the groups. Sunday &#x3D; 0, Monday &#x3D; 1 ... (optional)
     * @param  int[] $group_type_ids Array of group type ids to filter the groups (optional)
     * @param  bool $is_open_for_members Filters groups by its open status (optional)
     * @param  bool $is_public Filters groups by its public status (optional)
     * @param  bool $show_overdue_groups Determines if groups with overdue enddate should still be shown. (optional)
     * @param  bool $show_overdue_groups_respect_settings Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups. (optional)
     * @param  bool $show_inactive_groups Determines if inactive groups should be returned (optional)
     * @param  bool $without_my_groups Determines if groups should be omitted where I am in (optional)
     * @param  string $query (optional)
     * @param  int $page Page number to show page in pagenation. If empty, start at first page. (optional, default to 1)
     * @param  int $limit Number of results per page. (optional, default to 10)
     * @param  bool $is_hidden Filters groups by hidden flag (optional)
     * @param  string[] $order_fields The fields to order by (optional)
     * @param  string $order_directions The order direction ASC or DESC for the order_fields (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsAsyncWithHttpInfo($ids = null, $campus_ids = null, $agegroup_ids = null, $group_status_ids = null, $group_category_ids = null, $target_group_ids = null, $weekdays = null, $group_type_ids = null, $is_open_for_members = null, $is_public = null, $show_overdue_groups = null, $show_overdue_groups_respect_settings = null, $show_inactive_groups = null, $without_my_groups = null, $query = null, $page = 1, $limit = 10, $is_hidden = null, $order_fields = null, $order_directions = null, string $contentType = self::contentTypes['getGroups'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroups200Response';
        $request = $this->getGroupsRequest($ids, $campus_ids, $agegroup_ids, $group_status_ids, $group_category_ids, $target_group_ids, $weekdays, $group_type_ids, $is_open_for_members, $is_public, $show_overdue_groups, $show_overdue_groups_respect_settings, $show_inactive_groups, $without_my_groups, $query, $page, $limit, $is_hidden, $order_fields, $order_directions, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroups'
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  int[] $campus_ids Array of campus ids to filter the groups (optional)
     * @param  int[] $agegroup_ids Array of age group ids to filter the groups (optional)
     * @param  int[] $group_status_ids Array of group status ids to filter the groups (optional)
     * @param  int[] $group_category_ids Array of group category ids to filter the groups (optional)
     * @param  int[] $target_group_ids Array of target group ids to filter the groups (optional)
     * @param  int[] $weekdays Array of weekdays to filter the groups. Sunday &#x3D; 0, Monday &#x3D; 1 ... (optional)
     * @param  int[] $group_type_ids Array of group type ids to filter the groups (optional)
     * @param  bool $is_open_for_members Filters groups by its open status (optional)
     * @param  bool $is_public Filters groups by its public status (optional)
     * @param  bool $show_overdue_groups Determines if groups with overdue enddate should still be shown. (optional)
     * @param  bool $show_overdue_groups_respect_settings Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups. (optional)
     * @param  bool $show_inactive_groups Determines if inactive groups should be returned (optional)
     * @param  bool $without_my_groups Determines if groups should be omitted where I am in (optional)
     * @param  string $query (optional)
     * @param  int $page Page number to show page in pagenation. If empty, start at first page. (optional, default to 1)
     * @param  int $limit Number of results per page. (optional, default to 10)
     * @param  bool $is_hidden Filters groups by hidden flag (optional)
     * @param  string[] $order_fields The fields to order by (optional)
     * @param  string $order_directions The order direction ASC or DESC for the order_fields (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupsRequest($ids = null, $campus_ids = null, $agegroup_ids = null, $group_status_ids = null, $group_category_ids = null, $target_group_ids = null, $weekdays = null, $group_type_ids = null, $is_open_for_members = null, $is_public = null, $show_overdue_groups = null, $show_overdue_groups_respect_settings = null, $show_inactive_groups = null, $without_my_groups = null, $query = null, $page = 1, $limit = 10, $is_hidden = null, $order_fields = null, $order_directions = null, string $contentType = self::contentTypes['getGroups'][0])
    {















        if ($query !== null && strlen($query) < 2) {
            throw new \InvalidArgumentException('invalid length for "$query" when calling GroupApi.getGroups, must be bigger than or equal to 2.');
        }
        






        $resourcePath = '/groups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ids,
            'ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $campus_ids,
            'campus_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $agegroup_ids,
            'agegroup_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $group_status_ids,
            'group_status_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $group_category_ids,
            'group_category_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $target_group_ids,
            'target_group_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $weekdays,
            'weekdays[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $group_type_ids,
            'group_type_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_open_for_members,
            'is_open_for_members', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_public,
            'is_public', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_overdue_groups,
            'show_overdue_groups', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_overdue_groups_respect_settings,
            'show_overdue_groups_respect_settings', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_inactive_groups,
            'show_inactive_groups', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $without_my_groups,
            'without_my_groups', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_hidden,
            'is_hidden', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_fields,
            'order_fields', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_directions,
            'order_directions', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupsGroupIdMeetingsMeetingIdMembers
     *
     * Get Group Meeting Members
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id meeting_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMeetingsMeetingIdMembers'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMeetingsMeetingIdMembers200Response
     */
    public function getGroupsGroupIdMeetingsMeetingIdMembers($group_id, $meeting_id, string $contentType = self::contentTypes['getGroupsGroupIdMeetingsMeetingIdMembers'][0])
    {
        list($response) = $this->getGroupsGroupIdMeetingsMeetingIdMembersWithHttpInfo($group_id, $meeting_id, $contentType);
        return $response;
    }

    /**
     * Operation getGroupsGroupIdMeetingsMeetingIdMembersWithHttpInfo
     *
     * Get Group Meeting Members
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMeetingsMeetingIdMembers'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMeetingsMeetingIdMembers200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupsGroupIdMeetingsMeetingIdMembersWithHttpInfo($group_id, $meeting_id, string $contentType = self::contentTypes['getGroupsGroupIdMeetingsMeetingIdMembers'][0])
    {
        $request = $this->getGroupsGroupIdMeetingsMeetingIdMembersRequest($group_id, $meeting_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMeetingsMeetingIdMembers200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMeetingsMeetingIdMembers200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMeetingsMeetingIdMembers200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMeetingsMeetingIdMembers200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMeetingsMeetingIdMembers200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupsGroupIdMeetingsMeetingIdMembersAsync
     *
     * Get Group Meeting Members
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMeetingsMeetingIdMembers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsGroupIdMeetingsMeetingIdMembersAsync($group_id, $meeting_id, string $contentType = self::contentTypes['getGroupsGroupIdMeetingsMeetingIdMembers'][0])
    {
        return $this->getGroupsGroupIdMeetingsMeetingIdMembersAsyncWithHttpInfo($group_id, $meeting_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupsGroupIdMeetingsMeetingIdMembersAsyncWithHttpInfo
     *
     * Get Group Meeting Members
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMeetingsMeetingIdMembers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsGroupIdMeetingsMeetingIdMembersAsyncWithHttpInfo($group_id, $meeting_id, string $contentType = self::contentTypes['getGroupsGroupIdMeetingsMeetingIdMembers'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMeetingsMeetingIdMembers200Response';
        $request = $this->getGroupsGroupIdMeetingsMeetingIdMembersRequest($group_id, $meeting_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupsGroupIdMeetingsMeetingIdMembers'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMeetingsMeetingIdMembers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupsGroupIdMeetingsMeetingIdMembersRequest($group_id, $meeting_id, string $contentType = self::contentTypes['getGroupsGroupIdMeetingsMeetingIdMembers'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getGroupsGroupIdMeetingsMeetingIdMembers'
            );
        }

        // verify the required parameter 'meeting_id' is set
        if ($meeting_id === null || (is_array($meeting_id) && count($meeting_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meeting_id when calling getGroupsGroupIdMeetingsMeetingIdMembers'
            );
        }


        $resourcePath = '/groups/{groupId}/meetings/{meetingId}/members';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($meeting_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetingId' . '}',
                ObjectSerializer::toPathValue($meeting_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupsGroupIdMemberfields
     *
     * Get Group member fields
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMemberfields'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMemberfields200Response
     */
    public function getGroupsGroupIdMemberfields($group_id, string $contentType = self::contentTypes['getGroupsGroupIdMemberfields'][0])
    {
        list($response) = $this->getGroupsGroupIdMemberfieldsWithHttpInfo($group_id, $contentType);
        return $response;
    }

    /**
     * Operation getGroupsGroupIdMemberfieldsWithHttpInfo
     *
     * Get Group member fields
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMemberfields'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMemberfields200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupsGroupIdMemberfieldsWithHttpInfo($group_id, string $contentType = self::contentTypes['getGroupsGroupIdMemberfields'][0])
    {
        $request = $this->getGroupsGroupIdMemberfieldsRequest($group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMemberfields200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMemberfields200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMemberfields200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMemberfields200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMemberfields200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupsGroupIdMemberfieldsAsync
     *
     * Get Group member fields
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMemberfields'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsGroupIdMemberfieldsAsync($group_id, string $contentType = self::contentTypes['getGroupsGroupIdMemberfields'][0])
    {
        return $this->getGroupsGroupIdMemberfieldsAsyncWithHttpInfo($group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupsGroupIdMemberfieldsAsyncWithHttpInfo
     *
     * Get Group member fields
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMemberfields'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsGroupIdMemberfieldsAsyncWithHttpInfo($group_id, string $contentType = self::contentTypes['getGroupsGroupIdMemberfields'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMemberfields200Response';
        $request = $this->getGroupsGroupIdMemberfieldsRequest($group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupsGroupIdMemberfields'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMemberfields'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupsGroupIdMemberfieldsRequest($group_id, string $contentType = self::contentTypes['getGroupsGroupIdMemberfields'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getGroupsGroupIdMemberfields'
            );
        }


        $resourcePath = '/groups/{groupId}/memberfields';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupsGroupIdMembersExport
     *
     * Export Groupmebers
     *
     * @param  string $group_id group_id (required)
     * @param  string $type Type of export file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMembersExport'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function getGroupsGroupIdMembersExport($group_id, $type = null, string $contentType = self::contentTypes['getGroupsGroupIdMembersExport'][0])
    {
        $this->getGroupsGroupIdMembersExportWithHttpInfo($group_id, $type, $contentType);
    }

    /**
     * Operation getGroupsGroupIdMembersExportWithHttpInfo
     *
     * Export Groupmebers
     *
     * @param  string $group_id (required)
     * @param  string $type Type of export file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMembersExport'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupsGroupIdMembersExportWithHttpInfo($group_id, $type = null, string $contentType = self::contentTypes['getGroupsGroupIdMembersExport'][0])
    {
        $request = $this->getGroupsGroupIdMembersExportRequest($group_id, $type, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupsGroupIdMembersExportAsync
     *
     * Export Groupmebers
     *
     * @param  string $group_id (required)
     * @param  string $type Type of export file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMembersExport'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsGroupIdMembersExportAsync($group_id, $type = null, string $contentType = self::contentTypes['getGroupsGroupIdMembersExport'][0])
    {
        return $this->getGroupsGroupIdMembersExportAsyncWithHttpInfo($group_id, $type, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupsGroupIdMembersExportAsyncWithHttpInfo
     *
     * Export Groupmebers
     *
     * @param  string $group_id (required)
     * @param  string $type Type of export file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMembersExport'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsGroupIdMembersExportAsyncWithHttpInfo($group_id, $type = null, string $contentType = self::contentTypes['getGroupsGroupIdMembersExport'][0])
    {
        $returnType = '';
        $request = $this->getGroupsGroupIdMembersExportRequest($group_id, $type, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupsGroupIdMembersExport'
     *
     * @param  string $group_id (required)
     * @param  string $type Type of export file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMembersExport'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupsGroupIdMembersExportRequest($group_id, $type = null, string $contentType = self::contentTypes['getGroupsGroupIdMembersExport'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getGroupsGroupIdMembersExport'
            );
        }



        $resourcePath = '/groups/{groupId}/members/export';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $type,
            'type', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupsGroupIdMembersStatistics
     *
     * Get statistics for group members
     *
     * @param  int $group_id ID of group (required)
     * @param  int[] $group_type_role_ids  (optional)
     * @param  string[] $person_fields person field keys (optional)
     * @param  int[] $group_member_fields group member field ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMembersStatistics'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMembersStatistics200Response
     */
    public function getGroupsGroupIdMembersStatistics($group_id, $group_type_role_ids = null, $person_fields = null, $group_member_fields = null, string $contentType = self::contentTypes['getGroupsGroupIdMembersStatistics'][0])
    {
        list($response) = $this->getGroupsGroupIdMembersStatisticsWithHttpInfo($group_id, $group_type_role_ids, $person_fields, $group_member_fields, $contentType);
        return $response;
    }

    /**
     * Operation getGroupsGroupIdMembersStatisticsWithHttpInfo
     *
     * Get statistics for group members
     *
     * @param  int $group_id ID of group (required)
     * @param  int[] $group_type_role_ids  (optional)
     * @param  string[] $person_fields person field keys (optional)
     * @param  int[] $group_member_fields group member field ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMembersStatistics'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMembersStatistics200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupsGroupIdMembersStatisticsWithHttpInfo($group_id, $group_type_role_ids = null, $person_fields = null, $group_member_fields = null, string $contentType = self::contentTypes['getGroupsGroupIdMembersStatistics'][0])
    {
        $request = $this->getGroupsGroupIdMembersStatisticsRequest($group_id, $group_type_role_ids, $person_fields, $group_member_fields, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMembersStatistics200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMembersStatistics200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMembersStatistics200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMembersStatistics200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMembersStatistics200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupsGroupIdMembersStatisticsAsync
     *
     * Get statistics for group members
     *
     * @param  int $group_id ID of group (required)
     * @param  int[] $group_type_role_ids  (optional)
     * @param  string[] $person_fields person field keys (optional)
     * @param  int[] $group_member_fields group member field ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMembersStatistics'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsGroupIdMembersStatisticsAsync($group_id, $group_type_role_ids = null, $person_fields = null, $group_member_fields = null, string $contentType = self::contentTypes['getGroupsGroupIdMembersStatistics'][0])
    {
        return $this->getGroupsGroupIdMembersStatisticsAsyncWithHttpInfo($group_id, $group_type_role_ids, $person_fields, $group_member_fields, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupsGroupIdMembersStatisticsAsyncWithHttpInfo
     *
     * Get statistics for group members
     *
     * @param  int $group_id ID of group (required)
     * @param  int[] $group_type_role_ids  (optional)
     * @param  string[] $person_fields person field keys (optional)
     * @param  int[] $group_member_fields group member field ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMembersStatistics'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsGroupIdMembersStatisticsAsyncWithHttpInfo($group_id, $group_type_role_ids = null, $person_fields = null, $group_member_fields = null, string $contentType = self::contentTypes['getGroupsGroupIdMembersStatistics'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdMembersStatistics200Response';
        $request = $this->getGroupsGroupIdMembersStatisticsRequest($group_id, $group_type_role_ids, $person_fields, $group_member_fields, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupsGroupIdMembersStatistics'
     *
     * @param  int $group_id ID of group (required)
     * @param  int[] $group_type_role_ids  (optional)
     * @param  string[] $person_fields person field keys (optional)
     * @param  int[] $group_member_fields group member field ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdMembersStatistics'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupsGroupIdMembersStatisticsRequest($group_id, $group_type_role_ids = null, $person_fields = null, $group_member_fields = null, string $contentType = self::contentTypes['getGroupsGroupIdMembersStatistics'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getGroupsGroupIdMembersStatistics'
            );
        }





        $resourcePath = '/groups/{groupId}/members/statistics';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $group_type_role_ids,
            'group_type_role_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $person_fields,
            'personFields[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $group_member_fields,
            'groupMemberFields[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupsGroupIdTags
     *
     * Fetch group tags
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdTags'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupsGroupIdTags200Response
     */
    public function getGroupsGroupIdTags($group_id, string $contentType = self::contentTypes['getGroupsGroupIdTags'][0])
    {
        list($response) = $this->getGroupsGroupIdTagsWithHttpInfo($group_id, $contentType);
        return $response;
    }

    /**
     * Operation getGroupsGroupIdTagsWithHttpInfo
     *
     * Fetch group tags
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdTags'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupsGroupIdTags200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupsGroupIdTagsWithHttpInfo($group_id, string $contentType = self::contentTypes['getGroupsGroupIdTags'][0])
    {
        $request = $this->getGroupsGroupIdTagsRequest($group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdTags200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdTags200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdTags200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdTags200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdTags200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupsGroupIdTagsAsync
     *
     * Fetch group tags
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdTags'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsGroupIdTagsAsync($group_id, string $contentType = self::contentTypes['getGroupsGroupIdTags'][0])
    {
        return $this->getGroupsGroupIdTagsAsyncWithHttpInfo($group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupsGroupIdTagsAsyncWithHttpInfo
     *
     * Fetch group tags
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdTags'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsGroupIdTagsAsyncWithHttpInfo($group_id, string $contentType = self::contentTypes['getGroupsGroupIdTags'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsGroupIdTags200Response';
        $request = $this->getGroupsGroupIdTagsRequest($group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupsGroupIdTags'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsGroupIdTags'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupsGroupIdTagsRequest($group_id, string $contentType = self::contentTypes['getGroupsGroupIdTags'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getGroupsGroupIdTags'
            );
        }


        $resourcePath = '/groups/{groupId}/tags';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupsHierarchies
     *
     * Get all group hierarchies
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  int[] $campus_ids Array of campus ids to filter the groups (optional)
     * @param  int[] $agegroup_ids Array of age group ids to filter the groups (optional)
     * @param  int[] $group_status_ids Array of group status ids to filter the groups (optional)
     * @param  int[] $group_category_ids Array of group category ids to filter the groups (optional)
     * @param  int[] $target_group_ids Array of target group ids to filter the groups (optional)
     * @param  int[] $weekdays Array of weekdays to filter the groups. Sunday &#x3D; 0, Monday &#x3D; 1 ... (optional)
     * @param  int[] $group_type_ids Array of group type ids to filter the groups (optional)
     * @param  bool $is_open_for_members Filters groups by its open status (optional)
     * @param  bool $is_public Filters groups by its public status (optional)
     * @param  bool $show_overdue_groups Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups (optional)
     * @param  bool $show_overdue_groups_respect_settings Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups. (optional)
     * @param  bool $show_inactive_groups Determines if inactive groups should be returned (optional)
     * @param  bool $without_my_groups Determines if groups should be omitted where I am in (optional)
     * @param  string $query query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsHierarchies'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupsHierarchies200Response
     */
    public function getGroupsHierarchies($ids = null, $campus_ids = null, $agegroup_ids = null, $group_status_ids = null, $group_category_ids = null, $target_group_ids = null, $weekdays = null, $group_type_ids = null, $is_open_for_members = null, $is_public = null, $show_overdue_groups = null, $show_overdue_groups_respect_settings = null, $show_inactive_groups = null, $without_my_groups = null, $query = null, string $contentType = self::contentTypes['getGroupsHierarchies'][0])
    {
        list($response) = $this->getGroupsHierarchiesWithHttpInfo($ids, $campus_ids, $agegroup_ids, $group_status_ids, $group_category_ids, $target_group_ids, $weekdays, $group_type_ids, $is_open_for_members, $is_public, $show_overdue_groups, $show_overdue_groups_respect_settings, $show_inactive_groups, $without_my_groups, $query, $contentType);
        return $response;
    }

    /**
     * Operation getGroupsHierarchiesWithHttpInfo
     *
     * Get all group hierarchies
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  int[] $campus_ids Array of campus ids to filter the groups (optional)
     * @param  int[] $agegroup_ids Array of age group ids to filter the groups (optional)
     * @param  int[] $group_status_ids Array of group status ids to filter the groups (optional)
     * @param  int[] $group_category_ids Array of group category ids to filter the groups (optional)
     * @param  int[] $target_group_ids Array of target group ids to filter the groups (optional)
     * @param  int[] $weekdays Array of weekdays to filter the groups. Sunday &#x3D; 0, Monday &#x3D; 1 ... (optional)
     * @param  int[] $group_type_ids Array of group type ids to filter the groups (optional)
     * @param  bool $is_open_for_members Filters groups by its open status (optional)
     * @param  bool $is_public Filters groups by its public status (optional)
     * @param  bool $show_overdue_groups Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups (optional)
     * @param  bool $show_overdue_groups_respect_settings Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups. (optional)
     * @param  bool $show_inactive_groups Determines if inactive groups should be returned (optional)
     * @param  bool $without_my_groups Determines if groups should be omitted where I am in (optional)
     * @param  string $query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsHierarchies'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupsHierarchies200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupsHierarchiesWithHttpInfo($ids = null, $campus_ids = null, $agegroup_ids = null, $group_status_ids = null, $group_category_ids = null, $target_group_ids = null, $weekdays = null, $group_type_ids = null, $is_open_for_members = null, $is_public = null, $show_overdue_groups = null, $show_overdue_groups_respect_settings = null, $show_inactive_groups = null, $without_my_groups = null, $query = null, string $contentType = self::contentTypes['getGroupsHierarchies'][0])
    {
        $request = $this->getGroupsHierarchiesRequest($ids, $campus_ids, $agegroup_ids, $group_status_ids, $group_category_ids, $target_group_ids, $weekdays, $group_type_ids, $is_open_for_members, $is_public, $show_overdue_groups, $show_overdue_groups_respect_settings, $show_inactive_groups, $without_my_groups, $query, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupsHierarchies200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupsHierarchies200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupsHierarchies200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsHierarchies200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupsHierarchies200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupsHierarchiesAsync
     *
     * Get all group hierarchies
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  int[] $campus_ids Array of campus ids to filter the groups (optional)
     * @param  int[] $agegroup_ids Array of age group ids to filter the groups (optional)
     * @param  int[] $group_status_ids Array of group status ids to filter the groups (optional)
     * @param  int[] $group_category_ids Array of group category ids to filter the groups (optional)
     * @param  int[] $target_group_ids Array of target group ids to filter the groups (optional)
     * @param  int[] $weekdays Array of weekdays to filter the groups. Sunday &#x3D; 0, Monday &#x3D; 1 ... (optional)
     * @param  int[] $group_type_ids Array of group type ids to filter the groups (optional)
     * @param  bool $is_open_for_members Filters groups by its open status (optional)
     * @param  bool $is_public Filters groups by its public status (optional)
     * @param  bool $show_overdue_groups Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups (optional)
     * @param  bool $show_overdue_groups_respect_settings Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups. (optional)
     * @param  bool $show_inactive_groups Determines if inactive groups should be returned (optional)
     * @param  bool $without_my_groups Determines if groups should be omitted where I am in (optional)
     * @param  string $query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsHierarchies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsHierarchiesAsync($ids = null, $campus_ids = null, $agegroup_ids = null, $group_status_ids = null, $group_category_ids = null, $target_group_ids = null, $weekdays = null, $group_type_ids = null, $is_open_for_members = null, $is_public = null, $show_overdue_groups = null, $show_overdue_groups_respect_settings = null, $show_inactive_groups = null, $without_my_groups = null, $query = null, string $contentType = self::contentTypes['getGroupsHierarchies'][0])
    {
        return $this->getGroupsHierarchiesAsyncWithHttpInfo($ids, $campus_ids, $agegroup_ids, $group_status_ids, $group_category_ids, $target_group_ids, $weekdays, $group_type_ids, $is_open_for_members, $is_public, $show_overdue_groups, $show_overdue_groups_respect_settings, $show_inactive_groups, $without_my_groups, $query, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupsHierarchiesAsyncWithHttpInfo
     *
     * Get all group hierarchies
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  int[] $campus_ids Array of campus ids to filter the groups (optional)
     * @param  int[] $agegroup_ids Array of age group ids to filter the groups (optional)
     * @param  int[] $group_status_ids Array of group status ids to filter the groups (optional)
     * @param  int[] $group_category_ids Array of group category ids to filter the groups (optional)
     * @param  int[] $target_group_ids Array of target group ids to filter the groups (optional)
     * @param  int[] $weekdays Array of weekdays to filter the groups. Sunday &#x3D; 0, Monday &#x3D; 1 ... (optional)
     * @param  int[] $group_type_ids Array of group type ids to filter the groups (optional)
     * @param  bool $is_open_for_members Filters groups by its open status (optional)
     * @param  bool $is_public Filters groups by its public status (optional)
     * @param  bool $show_overdue_groups Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups (optional)
     * @param  bool $show_overdue_groups_respect_settings Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups. (optional)
     * @param  bool $show_inactive_groups Determines if inactive groups should be returned (optional)
     * @param  bool $without_my_groups Determines if groups should be omitted where I am in (optional)
     * @param  string $query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsHierarchies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsHierarchiesAsyncWithHttpInfo($ids = null, $campus_ids = null, $agegroup_ids = null, $group_status_ids = null, $group_category_ids = null, $target_group_ids = null, $weekdays = null, $group_type_ids = null, $is_open_for_members = null, $is_public = null, $show_overdue_groups = null, $show_overdue_groups_respect_settings = null, $show_inactive_groups = null, $without_my_groups = null, $query = null, string $contentType = self::contentTypes['getGroupsHierarchies'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsHierarchies200Response';
        $request = $this->getGroupsHierarchiesRequest($ids, $campus_ids, $agegroup_ids, $group_status_ids, $group_category_ids, $target_group_ids, $weekdays, $group_type_ids, $is_open_for_members, $is_public, $show_overdue_groups, $show_overdue_groups_respect_settings, $show_inactive_groups, $without_my_groups, $query, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupsHierarchies'
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  int[] $campus_ids Array of campus ids to filter the groups (optional)
     * @param  int[] $agegroup_ids Array of age group ids to filter the groups (optional)
     * @param  int[] $group_status_ids Array of group status ids to filter the groups (optional)
     * @param  int[] $group_category_ids Array of group category ids to filter the groups (optional)
     * @param  int[] $target_group_ids Array of target group ids to filter the groups (optional)
     * @param  int[] $weekdays Array of weekdays to filter the groups. Sunday &#x3D; 0, Monday &#x3D; 1 ... (optional)
     * @param  int[] $group_type_ids Array of group type ids to filter the groups (optional)
     * @param  bool $is_open_for_members Filters groups by its open status (optional)
     * @param  bool $is_public Filters groups by its public status (optional)
     * @param  bool $show_overdue_groups Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups (optional)
     * @param  bool $show_overdue_groups_respect_settings Determines if groups with overdue enddate should still be shown. To the enddate x dates are added specified by the admin settings for person &amp; groups. (optional)
     * @param  bool $show_inactive_groups Determines if inactive groups should be returned (optional)
     * @param  bool $without_my_groups Determines if groups should be omitted where I am in (optional)
     * @param  string $query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsHierarchies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupsHierarchiesRequest($ids = null, $campus_ids = null, $agegroup_ids = null, $group_status_ids = null, $group_category_ids = null, $target_group_ids = null, $weekdays = null, $group_type_ids = null, $is_open_for_members = null, $is_public = null, $show_overdue_groups = null, $show_overdue_groups_respect_settings = null, $show_inactive_groups = null, $without_my_groups = null, $query = null, string $contentType = self::contentTypes['getGroupsHierarchies'][0])
    {















        if ($query !== null && strlen($query) < 2) {
            throw new \InvalidArgumentException('invalid length for "$query" when calling GroupApi.getGroupsHierarchies, must be bigger than or equal to 2.');
        }
        

        $resourcePath = '/groups/hierarchies';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ids,
            'ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $campus_ids,
            'campus_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $agegroup_ids,
            'agegroup_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $group_status_ids,
            'group_status_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $group_category_ids,
            'group_category_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $target_group_ids,
            'target_group_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $weekdays,
            'weekdays[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $group_type_ids,
            'group_type_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_open_for_members,
            'is_open_for_members', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_public,
            'is_public', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_overdue_groups,
            'show_overdue_groups', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_overdue_groups_respect_settings,
            'show_overdue_groups_respect_settings', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_inactive_groups,
            'show_inactive_groups', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $without_my_groups,
            'without_my_groups', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupsMembers
     *
     * Get all group members
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  bool $with_deleted If true, return also deleted group members (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsMembers'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupsMembers200Response
     */
    public function getGroupsMembers($ids = null, $with_deleted = null, string $contentType = self::contentTypes['getGroupsMembers'][0])
    {
        list($response) = $this->getGroupsMembersWithHttpInfo($ids, $with_deleted, $contentType);
        return $response;
    }

    /**
     * Operation getGroupsMembersWithHttpInfo
     *
     * Get all group members
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  bool $with_deleted If true, return also deleted group members (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsMembers'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupsMembers200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupsMembersWithHttpInfo($ids = null, $with_deleted = null, string $contentType = self::contentTypes['getGroupsMembers'][0])
    {
        $request = $this->getGroupsMembersRequest($ids, $with_deleted, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupsMembers200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupsMembers200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupsMembers200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsMembers200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupsMembers200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupsMembersAsync
     *
     * Get all group members
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  bool $with_deleted If true, return also deleted group members (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsMembers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsMembersAsync($ids = null, $with_deleted = null, string $contentType = self::contentTypes['getGroupsMembers'][0])
    {
        return $this->getGroupsMembersAsyncWithHttpInfo($ids, $with_deleted, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupsMembersAsyncWithHttpInfo
     *
     * Get all group members
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  bool $with_deleted If true, return also deleted group members (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsMembers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsMembersAsyncWithHttpInfo($ids = null, $with_deleted = null, string $contentType = self::contentTypes['getGroupsMembers'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsMembers200Response';
        $request = $this->getGroupsMembersRequest($ids, $with_deleted, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupsMembers'
     *
     * @param  int[] $ids Array of group ids (optional)
     * @param  bool $with_deleted If true, return also deleted group members (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsMembers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupsMembersRequest($ids = null, $with_deleted = null, string $contentType = self::contentTypes['getGroupsMembers'][0])
    {




        $resourcePath = '/groups/members';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ids,
            'ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $with_deleted,
            'with_deleted', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGroupsTags
     *
     * Your GET endpoint
     *
     * @param  string[] $ids Group Ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsTags'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGroupsTags200Response
     */
    public function getGroupsTags($ids = null, string $contentType = self::contentTypes['getGroupsTags'][0])
    {
        list($response) = $this->getGroupsTagsWithHttpInfo($ids, $contentType);
        return $response;
    }

    /**
     * Operation getGroupsTagsWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string[] $ids Group Ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsTags'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGroupsTags200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGroupsTagsWithHttpInfo($ids = null, string $contentType = self::contentTypes['getGroupsTags'][0])
    {
        $request = $this->getGroupsTagsRequest($ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGroupsTags200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGroupsTags200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGroupsTags200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsTags200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGroupsTags200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGroupsTagsAsync
     *
     * Your GET endpoint
     *
     * @param  string[] $ids Group Ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsTags'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsTagsAsync($ids = null, string $contentType = self::contentTypes['getGroupsTags'][0])
    {
        return $this->getGroupsTagsAsyncWithHttpInfo($ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGroupsTagsAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string[] $ids Group Ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsTags'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGroupsTagsAsyncWithHttpInfo($ids = null, string $contentType = self::contentTypes['getGroupsTags'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGroupsTags200Response';
        $request = $this->getGroupsTagsRequest($ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGroupsTags'
     *
     * @param  string[] $ids Group Ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGroupsTags'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGroupsTagsRequest($ids = null, string $contentType = self::contentTypes['getGroupsTags'][0])
    {



        $resourcePath = '/groups/tags';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ids,
            'ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGrupsIdPlaces
     *
     * Get all places of a group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGrupsIdPlaces'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetGrupsIdPlaces200Response
     */
    public function getGrupsIdPlaces($group_id, string $contentType = self::contentTypes['getGrupsIdPlaces'][0])
    {
        list($response) = $this->getGrupsIdPlacesWithHttpInfo($group_id, $contentType);
        return $response;
    }

    /**
     * Operation getGrupsIdPlacesWithHttpInfo
     *
     * Get all places of a group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGrupsIdPlaces'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetGrupsIdPlaces200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGrupsIdPlacesWithHttpInfo($group_id, string $contentType = self::contentTypes['getGrupsIdPlaces'][0])
    {
        $request = $this->getGrupsIdPlacesRequest($group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetGrupsIdPlaces200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetGrupsIdPlaces200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetGrupsIdPlaces200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetGrupsIdPlaces200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetGrupsIdPlaces200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGrupsIdPlacesAsync
     *
     * Get all places of a group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGrupsIdPlaces'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGrupsIdPlacesAsync($group_id, string $contentType = self::contentTypes['getGrupsIdPlaces'][0])
    {
        return $this->getGrupsIdPlacesAsyncWithHttpInfo($group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGrupsIdPlacesAsyncWithHttpInfo
     *
     * Get all places of a group
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGrupsIdPlaces'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGrupsIdPlacesAsyncWithHttpInfo($group_id, string $contentType = self::contentTypes['getGrupsIdPlaces'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetGrupsIdPlaces200Response';
        $request = $this->getGrupsIdPlacesRequest($group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGrupsIdPlaces'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGrupsIdPlaces'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGrupsIdPlacesRequest($group_id, string $contentType = self::contentTypes['getGrupsIdPlaces'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getGrupsIdPlaces'
            );
        }


        $resourcePath = '/groups/{groupId}/places';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPersonMasterdata
     *
     * Get person &amp; groups masterdata
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersonMasterdata'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetPersonMasterdata200Response
     */
    public function getPersonMasterdata(string $contentType = self::contentTypes['getPersonMasterdata'][0])
    {
        list($response) = $this->getPersonMasterdataWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getPersonMasterdataWithHttpInfo
     *
     * Get person &amp; groups masterdata
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersonMasterdata'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetPersonMasterdata200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPersonMasterdataWithHttpInfo(string $contentType = self::contentTypes['getPersonMasterdata'][0])
    {
        $request = $this->getPersonMasterdataRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetPersonMasterdata200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetPersonMasterdata200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetPersonMasterdata200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetPersonMasterdata200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetPersonMasterdata200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPersonMasterdataAsync
     *
     * Get person &amp; groups masterdata
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersonMasterdata'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPersonMasterdataAsync(string $contentType = self::contentTypes['getPersonMasterdata'][0])
    {
        return $this->getPersonMasterdataAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPersonMasterdataAsyncWithHttpInfo
     *
     * Get person &amp; groups masterdata
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersonMasterdata'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPersonMasterdataAsyncWithHttpInfo(string $contentType = self::contentTypes['getPersonMasterdata'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetPersonMasterdata200Response';
        $request = $this->getPersonMasterdataRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPersonMasterdata'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersonMasterdata'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPersonMasterdataRequest(string $contentType = self::contentTypes['getPersonMasterdata'][0])
    {


        $resourcePath = '/person/masterdata';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPublicgroupsGroupIdForm
     *
     * Get a Group Sign Up Form
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  string $token Sign Up Token (required)
     * @param  string $person_id The name for which the signup should be made (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPublicgroupsGroupIdForm'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetPublicgroupsGroupIdForm200Response
     */
    public function getPublicgroupsGroupIdForm($group_id, $token, $person_id, string $contentType = self::contentTypes['getPublicgroupsGroupIdForm'][0])
    {
        list($response) = $this->getPublicgroupsGroupIdFormWithHttpInfo($group_id, $token, $person_id, $contentType);
        return $response;
    }

    /**
     * Operation getPublicgroupsGroupIdFormWithHttpInfo
     *
     * Get a Group Sign Up Form
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  string $token Sign Up Token (required)
     * @param  string $person_id The name for which the signup should be made (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPublicgroupsGroupIdForm'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetPublicgroupsGroupIdForm200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPublicgroupsGroupIdFormWithHttpInfo($group_id, $token, $person_id, string $contentType = self::contentTypes['getPublicgroupsGroupIdForm'][0])
    {
        $request = $this->getPublicgroupsGroupIdFormRequest($group_id, $token, $person_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetPublicgroupsGroupIdForm200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetPublicgroupsGroupIdForm200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetPublicgroupsGroupIdForm200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetPublicgroupsGroupIdForm200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetPublicgroupsGroupIdForm200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPublicgroupsGroupIdFormAsync
     *
     * Get a Group Sign Up Form
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  string $token Sign Up Token (required)
     * @param  string $person_id The name for which the signup should be made (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPublicgroupsGroupIdForm'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPublicgroupsGroupIdFormAsync($group_id, $token, $person_id, string $contentType = self::contentTypes['getPublicgroupsGroupIdForm'][0])
    {
        return $this->getPublicgroupsGroupIdFormAsyncWithHttpInfo($group_id, $token, $person_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPublicgroupsGroupIdFormAsyncWithHttpInfo
     *
     * Get a Group Sign Up Form
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  string $token Sign Up Token (required)
     * @param  string $person_id The name for which the signup should be made (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPublicgroupsGroupIdForm'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPublicgroupsGroupIdFormAsyncWithHttpInfo($group_id, $token, $person_id, string $contentType = self::contentTypes['getPublicgroupsGroupIdForm'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetPublicgroupsGroupIdForm200Response';
        $request = $this->getPublicgroupsGroupIdFormRequest($group_id, $token, $person_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPublicgroupsGroupIdForm'
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  string $token Sign Up Token (required)
     * @param  string $person_id The name for which the signup should be made (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPublicgroupsGroupIdForm'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPublicgroupsGroupIdFormRequest($group_id, $token, $person_id, string $contentType = self::contentTypes['getPublicgroupsGroupIdForm'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getPublicgroupsGroupIdForm'
            );
        }

        // verify the required parameter 'token' is set
        if ($token === null || (is_array($token) && count($token) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $token when calling getPublicgroupsGroupIdForm'
            );
        }

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling getPublicgroupsGroupIdForm'
            );
        }


        $resourcePath = '/publicgroups/{groupId}/form';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $token,
            'token', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $person_id,
            'personId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getQRCodeCheckin
     *
     * Get link to QR-Code for CheckIn PDF
     *
     * @param  int $group_id ID of group (required)
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getQRCodeCheckin'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetQRCodeCheckin200Response|string
     */
    public function getQRCodeCheckin($group_id, $person_id, string $contentType = self::contentTypes['getQRCodeCheckin'][0])
    {
        list($response) = $this->getQRCodeCheckinWithHttpInfo($group_id, $person_id, $contentType);
        return $response;
    }

    /**
     * Operation getQRCodeCheckinWithHttpInfo
     *
     * Get link to QR-Code for CheckIn PDF
     *
     * @param  int $group_id ID of group (required)
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getQRCodeCheckin'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetQRCodeCheckin200Response|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getQRCodeCheckinWithHttpInfo($group_id, $person_id, string $contentType = self::contentTypes['getQRCodeCheckin'][0])
    {
        $request = $this->getQRCodeCheckinRequest($group_id, $person_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetQRCodeCheckin200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetQRCodeCheckin200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetQRCodeCheckin200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetQRCodeCheckin200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetQRCodeCheckin200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getQRCodeCheckinAsync
     *
     * Get link to QR-Code for CheckIn PDF
     *
     * @param  int $group_id ID of group (required)
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getQRCodeCheckin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getQRCodeCheckinAsync($group_id, $person_id, string $contentType = self::contentTypes['getQRCodeCheckin'][0])
    {
        return $this->getQRCodeCheckinAsyncWithHttpInfo($group_id, $person_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getQRCodeCheckinAsyncWithHttpInfo
     *
     * Get link to QR-Code for CheckIn PDF
     *
     * @param  int $group_id ID of group (required)
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getQRCodeCheckin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getQRCodeCheckinAsyncWithHttpInfo($group_id, $person_id, string $contentType = self::contentTypes['getQRCodeCheckin'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetQRCodeCheckin200Response';
        $request = $this->getQRCodeCheckinRequest($group_id, $person_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getQRCodeCheckin'
     *
     * @param  int $group_id ID of group (required)
     * @param  int $person_id ID of person (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getQRCodeCheckin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getQRCodeCheckinRequest($group_id, $person_id, string $contentType = self::contentTypes['getQRCodeCheckin'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling getQRCodeCheckin'
            );
        }

        // verify the required parameter 'person_id' is set
        if ($person_id === null || (is_array($person_id) && count($person_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $person_id when calling getQRCodeCheckin'
            );
        }


        $resourcePath = '/groups/{groupId}/qrcodecheckin/{personId}/pdf';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($person_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personId' . '}',
                ObjectSerializer::toPathValue($person_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation issueSignUpToken
     *
     * Issue new sign up token.
     *
     * @param  int $group_id Group id of public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\IssueSignUpTokenRequest $issue_sign_up_token_request You MUST provide either &#x60;personId&#x60; OR &#x60;email&#x60;. Both fields cannot be present at the same time. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['issueSignUpToken'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\IssueSignUpToken200Response|object
     */
    public function issueSignUpToken($group_id, $issue_sign_up_token_request = null, string $contentType = self::contentTypes['issueSignUpToken'][0])
    {
        list($response) = $this->issueSignUpTokenWithHttpInfo($group_id, $issue_sign_up_token_request, $contentType);
        return $response;
    }

    /**
     * Operation issueSignUpTokenWithHttpInfo
     *
     * Issue new sign up token.
     *
     * @param  int $group_id Group id of public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\IssueSignUpTokenRequest $issue_sign_up_token_request You MUST provide either &#x60;personId&#x60; OR &#x60;email&#x60;. Both fields cannot be present at the same time. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['issueSignUpToken'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\IssueSignUpToken200Response|object, HTTP status code, HTTP response headers (array of strings)
     */
    public function issueSignUpTokenWithHttpInfo($group_id, $issue_sign_up_token_request = null, string $contentType = self::contentTypes['issueSignUpToken'][0])
    {
        $request = $this->issueSignUpTokenRequest($group_id, $issue_sign_up_token_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\IssueSignUpToken200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\IssueSignUpToken200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\IssueSignUpToken200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\IssueSignUpToken200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\IssueSignUpToken200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation issueSignUpTokenAsync
     *
     * Issue new sign up token.
     *
     * @param  int $group_id Group id of public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\IssueSignUpTokenRequest $issue_sign_up_token_request You MUST provide either &#x60;personId&#x60; OR &#x60;email&#x60;. Both fields cannot be present at the same time. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['issueSignUpToken'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function issueSignUpTokenAsync($group_id, $issue_sign_up_token_request = null, string $contentType = self::contentTypes['issueSignUpToken'][0])
    {
        return $this->issueSignUpTokenAsyncWithHttpInfo($group_id, $issue_sign_up_token_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation issueSignUpTokenAsyncWithHttpInfo
     *
     * Issue new sign up token.
     *
     * @param  int $group_id Group id of public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\IssueSignUpTokenRequest $issue_sign_up_token_request You MUST provide either &#x60;personId&#x60; OR &#x60;email&#x60;. Both fields cannot be present at the same time. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['issueSignUpToken'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function issueSignUpTokenAsyncWithHttpInfo($group_id, $issue_sign_up_token_request = null, string $contentType = self::contentTypes['issueSignUpToken'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\IssueSignUpToken200Response';
        $request = $this->issueSignUpTokenRequest($group_id, $issue_sign_up_token_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'issueSignUpToken'
     *
     * @param  int $group_id Group id of public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\IssueSignUpTokenRequest $issue_sign_up_token_request You MUST provide either &#x60;personId&#x60; OR &#x60;email&#x60;. Both fields cannot be present at the same time. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['issueSignUpToken'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function issueSignUpTokenRequest($group_id, $issue_sign_up_token_request = null, string $contentType = self::contentTypes['issueSignUpToken'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling issueSignUpToken'
            );
        }



        $resourcePath = '/publicgroups/{groupId}/token';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($issue_sign_up_token_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($issue_sign_up_token_request));
            } else {
                $httpBody = $issue_sign_up_token_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation optIns
     *
     * Get Opt In status of group members
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['optIns'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\OptIns200Response|string
     */
    public function optIns($group_id, string $contentType = self::contentTypes['optIns'][0])
    {
        list($response) = $this->optInsWithHttpInfo($group_id, $contentType);
        return $response;
    }

    /**
     * Operation optInsWithHttpInfo
     *
     * Get Opt In status of group members
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['optIns'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\OptIns200Response|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function optInsWithHttpInfo($group_id, string $contentType = self::contentTypes['optIns'][0])
    {
        $request = $this->optInsRequest($group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\OptIns200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\OptIns200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\OptIns200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\OptIns200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\OptIns200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation optInsAsync
     *
     * Get Opt In status of group members
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['optIns'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function optInsAsync($group_id, string $contentType = self::contentTypes['optIns'][0])
    {
        return $this->optInsAsyncWithHttpInfo($group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation optInsAsyncWithHttpInfo
     *
     * Get Opt In status of group members
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['optIns'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function optInsAsyncWithHttpInfo($group_id, string $contentType = self::contentTypes['optIns'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\OptIns200Response';
        $request = $this->optInsRequest($group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'optIns'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['optIns'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function optInsRequest($group_id, string $contentType = self::contentTypes['optIns'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling optIns'
            );
        }


        $resourcePath = '/groups/{groupId}/optins';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation patchGroup
     *
     * Update Group
     *
     * @param  int $group_id ID of group (required)
     * @param  object $body body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchGroup'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PatchGroup200Response
     */
    public function patchGroup($group_id, $body = null, string $contentType = self::contentTypes['patchGroup'][0])
    {
        list($response) = $this->patchGroupWithHttpInfo($group_id, $body, $contentType);
        return $response;
    }

    /**
     * Operation patchGroupWithHttpInfo
     *
     * Update Group
     *
     * @param  int $group_id ID of group (required)
     * @param  object $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchGroup'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PatchGroup200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchGroupWithHttpInfo($group_id, $body = null, string $contentType = self::contentTypes['patchGroup'][0])
    {
        $request = $this->patchGroupRequest($group_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\PatchGroup200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PatchGroup200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PatchGroup200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PatchGroup200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PatchGroup200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation patchGroupAsync
     *
     * Update Group
     *
     * @param  int $group_id ID of group (required)
     * @param  object $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function patchGroupAsync($group_id, $body = null, string $contentType = self::contentTypes['patchGroup'][0])
    {
        return $this->patchGroupAsyncWithHttpInfo($group_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation patchGroupAsyncWithHttpInfo
     *
     * Update Group
     *
     * @param  int $group_id ID of group (required)
     * @param  object $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function patchGroupAsyncWithHttpInfo($group_id, $body = null, string $contentType = self::contentTypes['patchGroup'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PatchGroup200Response';
        $request = $this->patchGroupRequest($group_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'patchGroup'
     *
     * @param  int $group_id ID of group (required)
     * @param  object $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function patchGroupRequest($group_id, $body = null, string $contentType = self::contentTypes['patchGroup'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling patchGroup'
            );
        }



        $resourcePath = '/groups/{groupId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation patchGroupsGroupIdRolesRoleId
     *
     * save role
     *
     * @param  int $group_id ID of group (required)
     * @param  int $role_id ID of group type role (required)
     * @param  \StevenBuehner\ChurchTools\Model\PatchGroupsGroupIdRolesRoleIdRequest $patch_groups_group_id_roles_role_id_request patch_groups_group_id_roles_role_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchGroupsGroupIdRolesRoleId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function patchGroupsGroupIdRolesRoleId($group_id, $role_id, $patch_groups_group_id_roles_role_id_request = null, string $contentType = self::contentTypes['patchGroupsGroupIdRolesRoleId'][0])
    {
        $this->patchGroupsGroupIdRolesRoleIdWithHttpInfo($group_id, $role_id, $patch_groups_group_id_roles_role_id_request, $contentType);
    }

    /**
     * Operation patchGroupsGroupIdRolesRoleIdWithHttpInfo
     *
     * save role
     *
     * @param  int $group_id ID of group (required)
     * @param  int $role_id ID of group type role (required)
     * @param  \StevenBuehner\ChurchTools\Model\PatchGroupsGroupIdRolesRoleIdRequest $patch_groups_group_id_roles_role_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchGroupsGroupIdRolesRoleId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchGroupsGroupIdRolesRoleIdWithHttpInfo($group_id, $role_id, $patch_groups_group_id_roles_role_id_request = null, string $contentType = self::contentTypes['patchGroupsGroupIdRolesRoleId'][0])
    {
        $request = $this->patchGroupsGroupIdRolesRoleIdRequest($group_id, $role_id, $patch_groups_group_id_roles_role_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation patchGroupsGroupIdRolesRoleIdAsync
     *
     * save role
     *
     * @param  int $group_id ID of group (required)
     * @param  int $role_id ID of group type role (required)
     * @param  \StevenBuehner\ChurchTools\Model\PatchGroupsGroupIdRolesRoleIdRequest $patch_groups_group_id_roles_role_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchGroupsGroupIdRolesRoleId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function patchGroupsGroupIdRolesRoleIdAsync($group_id, $role_id, $patch_groups_group_id_roles_role_id_request = null, string $contentType = self::contentTypes['patchGroupsGroupIdRolesRoleId'][0])
    {
        return $this->patchGroupsGroupIdRolesRoleIdAsyncWithHttpInfo($group_id, $role_id, $patch_groups_group_id_roles_role_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation patchGroupsGroupIdRolesRoleIdAsyncWithHttpInfo
     *
     * save role
     *
     * @param  int $group_id ID of group (required)
     * @param  int $role_id ID of group type role (required)
     * @param  \StevenBuehner\ChurchTools\Model\PatchGroupsGroupIdRolesRoleIdRequest $patch_groups_group_id_roles_role_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchGroupsGroupIdRolesRoleId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function patchGroupsGroupIdRolesRoleIdAsyncWithHttpInfo($group_id, $role_id, $patch_groups_group_id_roles_role_id_request = null, string $contentType = self::contentTypes['patchGroupsGroupIdRolesRoleId'][0])
    {
        $returnType = '';
        $request = $this->patchGroupsGroupIdRolesRoleIdRequest($group_id, $role_id, $patch_groups_group_id_roles_role_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'patchGroupsGroupIdRolesRoleId'
     *
     * @param  int $group_id ID of group (required)
     * @param  int $role_id ID of group type role (required)
     * @param  \StevenBuehner\ChurchTools\Model\PatchGroupsGroupIdRolesRoleIdRequest $patch_groups_group_id_roles_role_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchGroupsGroupIdRolesRoleId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function patchGroupsGroupIdRolesRoleIdRequest($group_id, $role_id, $patch_groups_group_id_roles_role_id_request = null, string $contentType = self::contentTypes['patchGroupsGroupIdRolesRoleId'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling patchGroupsGroupIdRolesRoleId'
            );
        }

        // verify the required parameter 'role_id' is set
        if ($role_id === null || (is_array($role_id) && count($role_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $role_id when calling patchGroupsGroupIdRolesRoleId'
            );
        }



        $resourcePath = '/groups/{groupId}/roles/{roleId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($role_id !== null) {
            $resourcePath = str_replace(
                '{' . 'roleId' . '}',
                ObjectSerializer::toPathValue($role_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($patch_groups_group_id_roles_role_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($patch_groups_group_id_roles_role_id_request));
            } else {
                $httpBody = $patch_groups_group_id_roles_role_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postAutomaticEmail
     *
     * Save new automatic email for a group role
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostAutomaticEmailRequest $post_automatic_email_request post_automatic_email_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PostAutomaticEmail201Response
     */
    public function postAutomaticEmail($group_id, $post_automatic_email_request = null, string $contentType = self::contentTypes['postAutomaticEmail'][0])
    {
        list($response) = $this->postAutomaticEmailWithHttpInfo($group_id, $post_automatic_email_request, $contentType);
        return $response;
    }

    /**
     * Operation postAutomaticEmailWithHttpInfo
     *
     * Save new automatic email for a group role
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostAutomaticEmailRequest $post_automatic_email_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PostAutomaticEmail201Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function postAutomaticEmailWithHttpInfo($group_id, $post_automatic_email_request = null, string $contentType = self::contentTypes['postAutomaticEmail'][0])
    {
        $request = $this->postAutomaticEmailRequest($group_id, $post_automatic_email_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\StevenBuehner\ChurchTools\Model\PostAutomaticEmail201Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PostAutomaticEmail201Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PostAutomaticEmail201Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PostAutomaticEmail201Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PostAutomaticEmail201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation postAutomaticEmailAsync
     *
     * Save new automatic email for a group role
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostAutomaticEmailRequest $post_automatic_email_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postAutomaticEmailAsync($group_id, $post_automatic_email_request = null, string $contentType = self::contentTypes['postAutomaticEmail'][0])
    {
        return $this->postAutomaticEmailAsyncWithHttpInfo($group_id, $post_automatic_email_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postAutomaticEmailAsyncWithHttpInfo
     *
     * Save new automatic email for a group role
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostAutomaticEmailRequest $post_automatic_email_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postAutomaticEmailAsyncWithHttpInfo($group_id, $post_automatic_email_request = null, string $contentType = self::contentTypes['postAutomaticEmail'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PostAutomaticEmail201Response';
        $request = $this->postAutomaticEmailRequest($group_id, $post_automatic_email_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postAutomaticEmail'
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostAutomaticEmailRequest $post_automatic_email_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postAutomaticEmailRequest($group_id, $post_automatic_email_request = null, string $contentType = self::contentTypes['postAutomaticEmail'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling postAutomaticEmail'
            );
        }



        $resourcePath = '/groups/{groupId}/emails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_automatic_email_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_automatic_email_request));
            } else {
                $httpBody = $post_automatic_email_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postGroupAgegroups
     *
     * Create agegroup
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupAgegroupsRequest $post_group_agegroups_request post_group_agegroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupAgegroups'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postGroupAgegroups($post_group_agegroups_request = null, string $contentType = self::contentTypes['postGroupAgegroups'][0])
    {
        $this->postGroupAgegroupsWithHttpInfo($post_group_agegroups_request, $contentType);
    }

    /**
     * Operation postGroupAgegroupsWithHttpInfo
     *
     * Create agegroup
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupAgegroupsRequest $post_group_agegroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupAgegroups'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postGroupAgegroupsWithHttpInfo($post_group_agegroups_request = null, string $contentType = self::contentTypes['postGroupAgegroups'][0])
    {
        $request = $this->postGroupAgegroupsRequest($post_group_agegroups_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation postGroupAgegroupsAsync
     *
     * Create agegroup
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupAgegroupsRequest $post_group_agegroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupAgegroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupAgegroupsAsync($post_group_agegroups_request = null, string $contentType = self::contentTypes['postGroupAgegroups'][0])
    {
        return $this->postGroupAgegroupsAsyncWithHttpInfo($post_group_agegroups_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postGroupAgegroupsAsyncWithHttpInfo
     *
     * Create agegroup
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupAgegroupsRequest $post_group_agegroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupAgegroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupAgegroupsAsyncWithHttpInfo($post_group_agegroups_request = null, string $contentType = self::contentTypes['postGroupAgegroups'][0])
    {
        $returnType = '';
        $request = $this->postGroupAgegroupsRequest($post_group_agegroups_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postGroupAgegroups'
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupAgegroupsRequest $post_group_agegroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupAgegroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postGroupAgegroupsRequest($post_group_agegroups_request = null, string $contentType = self::contentTypes['postGroupAgegroups'][0])
    {



        $resourcePath = '/group/agegroups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_group_agegroups_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_group_agegroups_request));
            } else {
                $httpBody = $post_group_agegroups_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postGroupGroupcategories
     *
     * Create Group Category
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGroupcategoriesRequest $post_group_groupcategories_request post_group_groupcategories_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupGroupcategories'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postGroupGroupcategories($post_group_groupcategories_request = null, string $contentType = self::contentTypes['postGroupGroupcategories'][0])
    {
        $this->postGroupGroupcategoriesWithHttpInfo($post_group_groupcategories_request, $contentType);
    }

    /**
     * Operation postGroupGroupcategoriesWithHttpInfo
     *
     * Create Group Category
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGroupcategoriesRequest $post_group_groupcategories_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupGroupcategories'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postGroupGroupcategoriesWithHttpInfo($post_group_groupcategories_request = null, string $contentType = self::contentTypes['postGroupGroupcategories'][0])
    {
        $request = $this->postGroupGroupcategoriesRequest($post_group_groupcategories_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation postGroupGroupcategoriesAsync
     *
     * Create Group Category
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGroupcategoriesRequest $post_group_groupcategories_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupGroupcategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupGroupcategoriesAsync($post_group_groupcategories_request = null, string $contentType = self::contentTypes['postGroupGroupcategories'][0])
    {
        return $this->postGroupGroupcategoriesAsyncWithHttpInfo($post_group_groupcategories_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postGroupGroupcategoriesAsyncWithHttpInfo
     *
     * Create Group Category
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGroupcategoriesRequest $post_group_groupcategories_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupGroupcategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupGroupcategoriesAsyncWithHttpInfo($post_group_groupcategories_request = null, string $contentType = self::contentTypes['postGroupGroupcategories'][0])
    {
        $returnType = '';
        $request = $this->postGroupGroupcategoriesRequest($post_group_groupcategories_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postGroupGroupcategories'
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGroupcategoriesRequest $post_group_groupcategories_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupGroupcategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postGroupGroupcategoriesRequest($post_group_groupcategories_request = null, string $contentType = self::contentTypes['postGroupGroupcategories'][0])
    {



        $resourcePath = '/group/groupcategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_group_groupcategories_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_group_groupcategories_request));
            } else {
                $httpBody = $post_group_groupcategories_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postGroupGrouptypes
     *
     * Create group type
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGrouptypesRequest $post_group_grouptypes_request post_group_grouptypes_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupGrouptypes'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postGroupGrouptypes($post_group_grouptypes_request = null, string $contentType = self::contentTypes['postGroupGrouptypes'][0])
    {
        $this->postGroupGrouptypesWithHttpInfo($post_group_grouptypes_request, $contentType);
    }

    /**
     * Operation postGroupGrouptypesWithHttpInfo
     *
     * Create group type
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGrouptypesRequest $post_group_grouptypes_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupGrouptypes'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postGroupGrouptypesWithHttpInfo($post_group_grouptypes_request = null, string $contentType = self::contentTypes['postGroupGrouptypes'][0])
    {
        $request = $this->postGroupGrouptypesRequest($post_group_grouptypes_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation postGroupGrouptypesAsync
     *
     * Create group type
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGrouptypesRequest $post_group_grouptypes_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupGrouptypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupGrouptypesAsync($post_group_grouptypes_request = null, string $contentType = self::contentTypes['postGroupGrouptypes'][0])
    {
        return $this->postGroupGrouptypesAsyncWithHttpInfo($post_group_grouptypes_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postGroupGrouptypesAsyncWithHttpInfo
     *
     * Create group type
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGrouptypesRequest $post_group_grouptypes_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupGrouptypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupGrouptypesAsyncWithHttpInfo($post_group_grouptypes_request = null, string $contentType = self::contentTypes['postGroupGrouptypes'][0])
    {
        $returnType = '';
        $request = $this->postGroupGrouptypesRequest($post_group_grouptypes_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postGroupGrouptypes'
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGrouptypesRequest $post_group_grouptypes_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupGrouptypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postGroupGrouptypesRequest($post_group_grouptypes_request = null, string $contentType = self::contentTypes['postGroupGrouptypes'][0])
    {



        $resourcePath = '/group/grouptypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_group_grouptypes_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_group_grouptypes_request));
            } else {
                $httpBody = $post_group_grouptypes_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postGroupRoles
     *
     * Create Role
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupRolesRequest $post_group_roles_request post_group_roles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupRoles'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postGroupRoles($post_group_roles_request = null, string $contentType = self::contentTypes['postGroupRoles'][0])
    {
        $this->postGroupRolesWithHttpInfo($post_group_roles_request, $contentType);
    }

    /**
     * Operation postGroupRolesWithHttpInfo
     *
     * Create Role
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupRolesRequest $post_group_roles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupRoles'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postGroupRolesWithHttpInfo($post_group_roles_request = null, string $contentType = self::contentTypes['postGroupRoles'][0])
    {
        $request = $this->postGroupRolesRequest($post_group_roles_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation postGroupRolesAsync
     *
     * Create Role
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupRolesRequest $post_group_roles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupRoles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupRolesAsync($post_group_roles_request = null, string $contentType = self::contentTypes['postGroupRoles'][0])
    {
        return $this->postGroupRolesAsyncWithHttpInfo($post_group_roles_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postGroupRolesAsyncWithHttpInfo
     *
     * Create Role
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupRolesRequest $post_group_roles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupRoles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupRolesAsyncWithHttpInfo($post_group_roles_request = null, string $contentType = self::contentTypes['postGroupRoles'][0])
    {
        $returnType = '';
        $request = $this->postGroupRolesRequest($post_group_roles_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postGroupRoles'
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupRolesRequest $post_group_roles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupRoles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postGroupRolesRequest($post_group_roles_request = null, string $contentType = self::contentTypes['postGroupRoles'][0])
    {



        $resourcePath = '/group/roles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_group_roles_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_group_roles_request));
            } else {
                $httpBody = $post_group_roles_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postGroupTargetgroups
     *
     * 
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest $post_group_targetgroups_request post_group_targetgroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupTargetgroups'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postGroupTargetgroups($post_group_targetgroups_request = null, string $contentType = self::contentTypes['postGroupTargetgroups'][0])
    {
        $this->postGroupTargetgroupsWithHttpInfo($post_group_targetgroups_request, $contentType);
    }

    /**
     * Operation postGroupTargetgroupsWithHttpInfo
     *
     * 
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest $post_group_targetgroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupTargetgroups'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postGroupTargetgroupsWithHttpInfo($post_group_targetgroups_request = null, string $contentType = self::contentTypes['postGroupTargetgroups'][0])
    {
        $request = $this->postGroupTargetgroupsRequest($post_group_targetgroups_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation postGroupTargetgroupsAsync
     *
     * 
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest $post_group_targetgroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupTargetgroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupTargetgroupsAsync($post_group_targetgroups_request = null, string $contentType = self::contentTypes['postGroupTargetgroups'][0])
    {
        return $this->postGroupTargetgroupsAsyncWithHttpInfo($post_group_targetgroups_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postGroupTargetgroupsAsyncWithHttpInfo
     *
     * 
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest $post_group_targetgroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupTargetgroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupTargetgroupsAsyncWithHttpInfo($post_group_targetgroups_request = null, string $contentType = self::contentTypes['postGroupTargetgroups'][0])
    {
        $returnType = '';
        $request = $this->postGroupTargetgroupsRequest($post_group_targetgroups_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postGroupTargetgroups'
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest $post_group_targetgroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupTargetgroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postGroupTargetgroupsRequest($post_group_targetgroups_request = null, string $contentType = self::contentTypes['postGroupTargetgroups'][0])
    {



        $resourcePath = '/group/targetgroups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_group_targetgroups_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_group_targetgroups_request));
            } else {
                $httpBody = $post_group_targetgroups_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postGroups
     *
     * Create Group
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsRequest $post_groups_request post_groups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroups'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PostGroups201Response
     */
    public function postGroups($post_groups_request = null, string $contentType = self::contentTypes['postGroups'][0])
    {
        list($response) = $this->postGroupsWithHttpInfo($post_groups_request, $contentType);
        return $response;
    }

    /**
     * Operation postGroupsWithHttpInfo
     *
     * Create Group
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsRequest $post_groups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroups'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PostGroups201Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function postGroupsWithHttpInfo($post_groups_request = null, string $contentType = self::contentTypes['postGroups'][0])
    {
        $request = $this->postGroupsRequest($post_groups_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\StevenBuehner\ChurchTools\Model\PostGroups201Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PostGroups201Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PostGroups201Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PostGroups201Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PostGroups201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation postGroupsAsync
     *
     * Create Group
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsRequest $post_groups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupsAsync($post_groups_request = null, string $contentType = self::contentTypes['postGroups'][0])
    {
        return $this->postGroupsAsyncWithHttpInfo($post_groups_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postGroupsAsyncWithHttpInfo
     *
     * Create Group
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsRequest $post_groups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupsAsyncWithHttpInfo($post_groups_request = null, string $contentType = self::contentTypes['postGroups'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PostGroups201Response';
        $request = $this->postGroupsRequest($post_groups_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postGroups'
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsRequest $post_groups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postGroupsRequest($post_groups_request = null, string $contentType = self::contentTypes['postGroups'][0])
    {



        $resourcePath = '/groups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_groups_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_groups_request));
            } else {
                $httpBody = $post_groups_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postGroupsGroupIdGroupstatus
     *
     * 
     *
     * @param  string $group_id group_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdGroupstatusRequest $post_groups_group_id_groupstatus_request post_groups_group_id_groupstatus_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdGroupstatus'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postGroupsGroupIdGroupstatus($group_id, $post_groups_group_id_groupstatus_request = null, string $contentType = self::contentTypes['postGroupsGroupIdGroupstatus'][0])
    {
        $this->postGroupsGroupIdGroupstatusWithHttpInfo($group_id, $post_groups_group_id_groupstatus_request, $contentType);
    }

    /**
     * Operation postGroupsGroupIdGroupstatusWithHttpInfo
     *
     * 
     *
     * @param  string $group_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdGroupstatusRequest $post_groups_group_id_groupstatus_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdGroupstatus'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postGroupsGroupIdGroupstatusWithHttpInfo($group_id, $post_groups_group_id_groupstatus_request = null, string $contentType = self::contentTypes['postGroupsGroupIdGroupstatus'][0])
    {
        $request = $this->postGroupsGroupIdGroupstatusRequest($group_id, $post_groups_group_id_groupstatus_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation postGroupsGroupIdGroupstatusAsync
     *
     * 
     *
     * @param  string $group_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdGroupstatusRequest $post_groups_group_id_groupstatus_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdGroupstatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupsGroupIdGroupstatusAsync($group_id, $post_groups_group_id_groupstatus_request = null, string $contentType = self::contentTypes['postGroupsGroupIdGroupstatus'][0])
    {
        return $this->postGroupsGroupIdGroupstatusAsyncWithHttpInfo($group_id, $post_groups_group_id_groupstatus_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postGroupsGroupIdGroupstatusAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $group_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdGroupstatusRequest $post_groups_group_id_groupstatus_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdGroupstatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupsGroupIdGroupstatusAsyncWithHttpInfo($group_id, $post_groups_group_id_groupstatus_request = null, string $contentType = self::contentTypes['postGroupsGroupIdGroupstatus'][0])
    {
        $returnType = '';
        $request = $this->postGroupsGroupIdGroupstatusRequest($group_id, $post_groups_group_id_groupstatus_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postGroupsGroupIdGroupstatus'
     *
     * @param  string $group_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdGroupstatusRequest $post_groups_group_id_groupstatus_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdGroupstatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postGroupsGroupIdGroupstatusRequest($group_id, $post_groups_group_id_groupstatus_request = null, string $contentType = self::contentTypes['postGroupsGroupIdGroupstatus'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling postGroupsGroupIdGroupstatus'
            );
        }



        $resourcePath = '/groups/{groupId}/grouptype';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_groups_group_id_groupstatus_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_groups_group_id_groupstatus_request));
            } else {
                $httpBody = $post_groups_group_id_groupstatus_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postGroupsGroupIdMeetingsMeetingIdMembersMissing
     *
     * 
     *
     * @param  string $group_id group_id (required)
     * @param  string $meeting_id meeting_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdMeetingsMeetingIdMembersMissingRequest $post_groups_group_id_meetings_meeting_id_members_missing_request post_groups_group_id_meetings_meeting_id_members_missing_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdMeetingsMeetingIdMembersMissing'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postGroupsGroupIdMeetingsMeetingIdMembersMissing($group_id, $meeting_id, $post_groups_group_id_meetings_meeting_id_members_missing_request = null, string $contentType = self::contentTypes['postGroupsGroupIdMeetingsMeetingIdMembersMissing'][0])
    {
        $this->postGroupsGroupIdMeetingsMeetingIdMembersMissingWithHttpInfo($group_id, $meeting_id, $post_groups_group_id_meetings_meeting_id_members_missing_request, $contentType);
    }

    /**
     * Operation postGroupsGroupIdMeetingsMeetingIdMembersMissingWithHttpInfo
     *
     * 
     *
     * @param  string $group_id (required)
     * @param  string $meeting_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdMeetingsMeetingIdMembersMissingRequest $post_groups_group_id_meetings_meeting_id_members_missing_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdMeetingsMeetingIdMembersMissing'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postGroupsGroupIdMeetingsMeetingIdMembersMissingWithHttpInfo($group_id, $meeting_id, $post_groups_group_id_meetings_meeting_id_members_missing_request = null, string $contentType = self::contentTypes['postGroupsGroupIdMeetingsMeetingIdMembersMissing'][0])
    {
        $request = $this->postGroupsGroupIdMeetingsMeetingIdMembersMissingRequest($group_id, $meeting_id, $post_groups_group_id_meetings_meeting_id_members_missing_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation postGroupsGroupIdMeetingsMeetingIdMembersMissingAsync
     *
     * 
     *
     * @param  string $group_id (required)
     * @param  string $meeting_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdMeetingsMeetingIdMembersMissingRequest $post_groups_group_id_meetings_meeting_id_members_missing_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdMeetingsMeetingIdMembersMissing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupsGroupIdMeetingsMeetingIdMembersMissingAsync($group_id, $meeting_id, $post_groups_group_id_meetings_meeting_id_members_missing_request = null, string $contentType = self::contentTypes['postGroupsGroupIdMeetingsMeetingIdMembersMissing'][0])
    {
        return $this->postGroupsGroupIdMeetingsMeetingIdMembersMissingAsyncWithHttpInfo($group_id, $meeting_id, $post_groups_group_id_meetings_meeting_id_members_missing_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postGroupsGroupIdMeetingsMeetingIdMembersMissingAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $group_id (required)
     * @param  string $meeting_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdMeetingsMeetingIdMembersMissingRequest $post_groups_group_id_meetings_meeting_id_members_missing_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdMeetingsMeetingIdMembersMissing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupsGroupIdMeetingsMeetingIdMembersMissingAsyncWithHttpInfo($group_id, $meeting_id, $post_groups_group_id_meetings_meeting_id_members_missing_request = null, string $contentType = self::contentTypes['postGroupsGroupIdMeetingsMeetingIdMembersMissing'][0])
    {
        $returnType = '';
        $request = $this->postGroupsGroupIdMeetingsMeetingIdMembersMissingRequest($group_id, $meeting_id, $post_groups_group_id_meetings_meeting_id_members_missing_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postGroupsGroupIdMeetingsMeetingIdMembersMissing'
     *
     * @param  string $group_id (required)
     * @param  string $meeting_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdMeetingsMeetingIdMembersMissingRequest $post_groups_group_id_meetings_meeting_id_members_missing_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdMeetingsMeetingIdMembersMissing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postGroupsGroupIdMeetingsMeetingIdMembersMissingRequest($group_id, $meeting_id, $post_groups_group_id_meetings_meeting_id_members_missing_request = null, string $contentType = self::contentTypes['postGroupsGroupIdMeetingsMeetingIdMembersMissing'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling postGroupsGroupIdMeetingsMeetingIdMembersMissing'
            );
        }

        // verify the required parameter 'meeting_id' is set
        if ($meeting_id === null || (is_array($meeting_id) && count($meeting_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meeting_id when calling postGroupsGroupIdMeetingsMeetingIdMembersMissing'
            );
        }



        $resourcePath = '/groups/{groupId}/meetings/{meetingId}/members/missing';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($meeting_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetingId' . '}',
                ObjectSerializer::toPathValue($meeting_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_groups_group_id_meetings_meeting_id_members_missing_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_groups_group_id_meetings_meeting_id_members_missing_request));
            } else {
                $httpBody = $post_groups_group_id_meetings_meeting_id_members_missing_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postGroupsGroupIdPlaces
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdPlacesRequest $post_groups_group_id_places_request post_groups_group_id_places_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdPlaces'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postGroupsGroupIdPlaces($group_id, $post_groups_group_id_places_request = null, string $contentType = self::contentTypes['postGroupsGroupIdPlaces'][0])
    {
        $this->postGroupsGroupIdPlacesWithHttpInfo($group_id, $post_groups_group_id_places_request, $contentType);
    }

    /**
     * Operation postGroupsGroupIdPlacesWithHttpInfo
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdPlacesRequest $post_groups_group_id_places_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdPlaces'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postGroupsGroupIdPlacesWithHttpInfo($group_id, $post_groups_group_id_places_request = null, string $contentType = self::contentTypes['postGroupsGroupIdPlaces'][0])
    {
        $request = $this->postGroupsGroupIdPlacesRequest($group_id, $post_groups_group_id_places_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation postGroupsGroupIdPlacesAsync
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdPlacesRequest $post_groups_group_id_places_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdPlaces'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupsGroupIdPlacesAsync($group_id, $post_groups_group_id_places_request = null, string $contentType = self::contentTypes['postGroupsGroupIdPlaces'][0])
    {
        return $this->postGroupsGroupIdPlacesAsyncWithHttpInfo($group_id, $post_groups_group_id_places_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postGroupsGroupIdPlacesAsyncWithHttpInfo
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdPlacesRequest $post_groups_group_id_places_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdPlaces'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postGroupsGroupIdPlacesAsyncWithHttpInfo($group_id, $post_groups_group_id_places_request = null, string $contentType = self::contentTypes['postGroupsGroupIdPlaces'][0])
    {
        $returnType = '';
        $request = $this->postGroupsGroupIdPlacesRequest($group_id, $post_groups_group_id_places_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postGroupsGroupIdPlaces'
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupsGroupIdPlacesRequest $post_groups_group_id_places_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postGroupsGroupIdPlaces'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postGroupsGroupIdPlacesRequest($group_id, $post_groups_group_id_places_request = null, string $contentType = self::contentTypes['postGroupsGroupIdPlaces'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling postGroupsGroupIdPlaces'
            );
        }



        $resourcePath = '/groups/{groupId}/places';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_groups_group_id_places_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_groups_group_id_places_request));
            } else {
                $httpBody = $post_groups_group_id_places_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postPublicgroupsGroupIdMailToLeaders
     *
     * Send a Mail to Public Group Leaders
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdMailToLeadersRequest $post_publicgroups_group_id_mail_to_leaders_request post_publicgroups_group_id_mail_to_leaders_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPublicgroupsGroupIdMailToLeaders'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postPublicgroupsGroupIdMailToLeaders($group_id, $post_publicgroups_group_id_mail_to_leaders_request = null, string $contentType = self::contentTypes['postPublicgroupsGroupIdMailToLeaders'][0])
    {
        $this->postPublicgroupsGroupIdMailToLeadersWithHttpInfo($group_id, $post_publicgroups_group_id_mail_to_leaders_request, $contentType);
    }

    /**
     * Operation postPublicgroupsGroupIdMailToLeadersWithHttpInfo
     *
     * Send a Mail to Public Group Leaders
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdMailToLeadersRequest $post_publicgroups_group_id_mail_to_leaders_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPublicgroupsGroupIdMailToLeaders'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postPublicgroupsGroupIdMailToLeadersWithHttpInfo($group_id, $post_publicgroups_group_id_mail_to_leaders_request = null, string $contentType = self::contentTypes['postPublicgroupsGroupIdMailToLeaders'][0])
    {
        $request = $this->postPublicgroupsGroupIdMailToLeadersRequest($group_id, $post_publicgroups_group_id_mail_to_leaders_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation postPublicgroupsGroupIdMailToLeadersAsync
     *
     * Send a Mail to Public Group Leaders
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdMailToLeadersRequest $post_publicgroups_group_id_mail_to_leaders_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPublicgroupsGroupIdMailToLeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postPublicgroupsGroupIdMailToLeadersAsync($group_id, $post_publicgroups_group_id_mail_to_leaders_request = null, string $contentType = self::contentTypes['postPublicgroupsGroupIdMailToLeaders'][0])
    {
        return $this->postPublicgroupsGroupIdMailToLeadersAsyncWithHttpInfo($group_id, $post_publicgroups_group_id_mail_to_leaders_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postPublicgroupsGroupIdMailToLeadersAsyncWithHttpInfo
     *
     * Send a Mail to Public Group Leaders
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdMailToLeadersRequest $post_publicgroups_group_id_mail_to_leaders_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPublicgroupsGroupIdMailToLeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postPublicgroupsGroupIdMailToLeadersAsyncWithHttpInfo($group_id, $post_publicgroups_group_id_mail_to_leaders_request = null, string $contentType = self::contentTypes['postPublicgroupsGroupIdMailToLeaders'][0])
    {
        $returnType = '';
        $request = $this->postPublicgroupsGroupIdMailToLeadersRequest($group_id, $post_publicgroups_group_id_mail_to_leaders_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postPublicgroupsGroupIdMailToLeaders'
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdMailToLeadersRequest $post_publicgroups_group_id_mail_to_leaders_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPublicgroupsGroupIdMailToLeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postPublicgroupsGroupIdMailToLeadersRequest($group_id, $post_publicgroups_group_id_mail_to_leaders_request = null, string $contentType = self::contentTypes['postPublicgroupsGroupIdMailToLeaders'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling postPublicgroupsGroupIdMailToLeaders'
            );
        }



        $resourcePath = '/publicgroups/{groupId}/mailToLeaders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_publicgroups_group_id_mail_to_leaders_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_publicgroups_group_id_mail_to_leaders_request));
            } else {
                $httpBody = $post_publicgroups_group_id_mail_to_leaders_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postPublicgroupsGroupIdSignup
     *
     * Send a Sign Up Form to Get Signed Up into a Public Group
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignupRequest $post_publicgroups_group_id_signup_request post_publicgroups_group_id_signup_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPublicgroupsGroupIdSignup'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignup200Response
     */
    public function postPublicgroupsGroupIdSignup($group_id, $post_publicgroups_group_id_signup_request = null, string $contentType = self::contentTypes['postPublicgroupsGroupIdSignup'][0])
    {
        list($response) = $this->postPublicgroupsGroupIdSignupWithHttpInfo($group_id, $post_publicgroups_group_id_signup_request, $contentType);
        return $response;
    }

    /**
     * Operation postPublicgroupsGroupIdSignupWithHttpInfo
     *
     * Send a Sign Up Form to Get Signed Up into a Public Group
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignupRequest $post_publicgroups_group_id_signup_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPublicgroupsGroupIdSignup'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignup200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function postPublicgroupsGroupIdSignupWithHttpInfo($group_id, $post_publicgroups_group_id_signup_request = null, string $contentType = self::contentTypes['postPublicgroupsGroupIdSignup'][0])
    {
        $request = $this->postPublicgroupsGroupIdSignupRequest($group_id, $post_publicgroups_group_id_signup_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignup200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignup200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignup200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignup200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignup200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation postPublicgroupsGroupIdSignupAsync
     *
     * Send a Sign Up Form to Get Signed Up into a Public Group
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignupRequest $post_publicgroups_group_id_signup_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPublicgroupsGroupIdSignup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postPublicgroupsGroupIdSignupAsync($group_id, $post_publicgroups_group_id_signup_request = null, string $contentType = self::contentTypes['postPublicgroupsGroupIdSignup'][0])
    {
        return $this->postPublicgroupsGroupIdSignupAsyncWithHttpInfo($group_id, $post_publicgroups_group_id_signup_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postPublicgroupsGroupIdSignupAsyncWithHttpInfo
     *
     * Send a Sign Up Form to Get Signed Up into a Public Group
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignupRequest $post_publicgroups_group_id_signup_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPublicgroupsGroupIdSignup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postPublicgroupsGroupIdSignupAsyncWithHttpInfo($group_id, $post_publicgroups_group_id_signup_request = null, string $contentType = self::contentTypes['postPublicgroupsGroupIdSignup'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignup200Response';
        $request = $this->postPublicgroupsGroupIdSignupRequest($group_id, $post_publicgroups_group_id_signup_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postPublicgroupsGroupIdSignup'
     *
     * @param  string $group_id Group ID of the public group (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostPublicgroupsGroupIdSignupRequest $post_publicgroups_group_id_signup_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postPublicgroupsGroupIdSignup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postPublicgroupsGroupIdSignupRequest($group_id, $post_publicgroups_group_id_signup_request = null, string $contentType = self::contentTypes['postPublicgroupsGroupIdSignup'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling postPublicgroupsGroupIdSignup'
            );
        }



        $resourcePath = '/publicgroups/{groupId}/signup';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_publicgroups_group_id_signup_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_publicgroups_group_id_signup_request));
            } else {
                $httpBody = $post_publicgroups_group_id_signup_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putAutomaticEmail
     *
     * Update automatic email
     *
     * @param  int $group_id ID of group (required)
     * @param  string $email_id email_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutAutomaticEmailRequest $put_automatic_email_request put_automatic_email_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function putAutomaticEmail($group_id, $email_id, $put_automatic_email_request = null, string $contentType = self::contentTypes['putAutomaticEmail'][0])
    {
        $this->putAutomaticEmailWithHttpInfo($group_id, $email_id, $put_automatic_email_request, $contentType);
    }

    /**
     * Operation putAutomaticEmailWithHttpInfo
     *
     * Update automatic email
     *
     * @param  int $group_id ID of group (required)
     * @param  string $email_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutAutomaticEmailRequest $put_automatic_email_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function putAutomaticEmailWithHttpInfo($group_id, $email_id, $put_automatic_email_request = null, string $contentType = self::contentTypes['putAutomaticEmail'][0])
    {
        $request = $this->putAutomaticEmailRequest($group_id, $email_id, $put_automatic_email_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation putAutomaticEmailAsync
     *
     * Update automatic email
     *
     * @param  int $group_id ID of group (required)
     * @param  string $email_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutAutomaticEmailRequest $put_automatic_email_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putAutomaticEmailAsync($group_id, $email_id, $put_automatic_email_request = null, string $contentType = self::contentTypes['putAutomaticEmail'][0])
    {
        return $this->putAutomaticEmailAsyncWithHttpInfo($group_id, $email_id, $put_automatic_email_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putAutomaticEmailAsyncWithHttpInfo
     *
     * Update automatic email
     *
     * @param  int $group_id ID of group (required)
     * @param  string $email_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutAutomaticEmailRequest $put_automatic_email_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putAutomaticEmailAsyncWithHttpInfo($group_id, $email_id, $put_automatic_email_request = null, string $contentType = self::contentTypes['putAutomaticEmail'][0])
    {
        $returnType = '';
        $request = $this->putAutomaticEmailRequest($group_id, $email_id, $put_automatic_email_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putAutomaticEmail'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $email_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutAutomaticEmailRequest $put_automatic_email_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putAutomaticEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putAutomaticEmailRequest($group_id, $email_id, $put_automatic_email_request = null, string $contentType = self::contentTypes['putAutomaticEmail'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling putAutomaticEmail'
            );
        }

        // verify the required parameter 'email_id' is set
        if ($email_id === null || (is_array($email_id) && count($email_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $email_id when calling putAutomaticEmail'
            );
        }



        $resourcePath = '/groups/{groupId}/emails/{emailId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                '{' . 'emailId' . '}',
                ObjectSerializer::toPathValue($email_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($put_automatic_email_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($put_automatic_email_request));
            } else {
                $httpBody = $put_automatic_email_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putGroupAgegroupsAgeGroupId
     *
     * Update agegroup
     *
     * @param  string $age_group_id age_group_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupAgegroupsRequest $post_group_agegroups_request post_group_agegroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function putGroupAgegroupsAgeGroupId($age_group_id, $post_group_agegroups_request = null, string $contentType = self::contentTypes['putGroupAgegroupsAgeGroupId'][0])
    {
        $this->putGroupAgegroupsAgeGroupIdWithHttpInfo($age_group_id, $post_group_agegroups_request, $contentType);
    }

    /**
     * Operation putGroupAgegroupsAgeGroupIdWithHttpInfo
     *
     * Update agegroup
     *
     * @param  string $age_group_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupAgegroupsRequest $post_group_agegroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function putGroupAgegroupsAgeGroupIdWithHttpInfo($age_group_id, $post_group_agegroups_request = null, string $contentType = self::contentTypes['putGroupAgegroupsAgeGroupId'][0])
    {
        $request = $this->putGroupAgegroupsAgeGroupIdRequest($age_group_id, $post_group_agegroups_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation putGroupAgegroupsAgeGroupIdAsync
     *
     * Update agegroup
     *
     * @param  string $age_group_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupAgegroupsRequest $post_group_agegroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupAgegroupsAgeGroupIdAsync($age_group_id, $post_group_agegroups_request = null, string $contentType = self::contentTypes['putGroupAgegroupsAgeGroupId'][0])
    {
        return $this->putGroupAgegroupsAgeGroupIdAsyncWithHttpInfo($age_group_id, $post_group_agegroups_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putGroupAgegroupsAgeGroupIdAsyncWithHttpInfo
     *
     * Update agegroup
     *
     * @param  string $age_group_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupAgegroupsRequest $post_group_agegroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupAgegroupsAgeGroupIdAsyncWithHttpInfo($age_group_id, $post_group_agegroups_request = null, string $contentType = self::contentTypes['putGroupAgegroupsAgeGroupId'][0])
    {
        $returnType = '';
        $request = $this->putGroupAgegroupsAgeGroupIdRequest($age_group_id, $post_group_agegroups_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putGroupAgegroupsAgeGroupId'
     *
     * @param  string $age_group_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupAgegroupsRequest $post_group_agegroups_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupAgegroupsAgeGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putGroupAgegroupsAgeGroupIdRequest($age_group_id, $post_group_agegroups_request = null, string $contentType = self::contentTypes['putGroupAgegroupsAgeGroupId'][0])
    {

        // verify the required parameter 'age_group_id' is set
        if ($age_group_id === null || (is_array($age_group_id) && count($age_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $age_group_id when calling putGroupAgegroupsAgeGroupId'
            );
        }



        $resourcePath = '/group/agegroups/{ageGroupId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($age_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ageGroupId' . '}',
                ObjectSerializer::toPathValue($age_group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_group_agegroups_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_group_agegroups_request));
            } else {
                $httpBody = $post_group_agegroups_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putGroupGroupcategoriesGroupCategoryId
     *
     * Update Group Category
     *
     * @param  string $group_category_id group_category_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGroupcategoriesRequest $post_group_groupcategories_request post_group_groupcategories_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function putGroupGroupcategoriesGroupCategoryId($group_category_id, $post_group_groupcategories_request = null, string $contentType = self::contentTypes['putGroupGroupcategoriesGroupCategoryId'][0])
    {
        $this->putGroupGroupcategoriesGroupCategoryIdWithHttpInfo($group_category_id, $post_group_groupcategories_request, $contentType);
    }

    /**
     * Operation putGroupGroupcategoriesGroupCategoryIdWithHttpInfo
     *
     * Update Group Category
     *
     * @param  string $group_category_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGroupcategoriesRequest $post_group_groupcategories_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function putGroupGroupcategoriesGroupCategoryIdWithHttpInfo($group_category_id, $post_group_groupcategories_request = null, string $contentType = self::contentTypes['putGroupGroupcategoriesGroupCategoryId'][0])
    {
        $request = $this->putGroupGroupcategoriesGroupCategoryIdRequest($group_category_id, $post_group_groupcategories_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation putGroupGroupcategoriesGroupCategoryIdAsync
     *
     * Update Group Category
     *
     * @param  string $group_category_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGroupcategoriesRequest $post_group_groupcategories_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupGroupcategoriesGroupCategoryIdAsync($group_category_id, $post_group_groupcategories_request = null, string $contentType = self::contentTypes['putGroupGroupcategoriesGroupCategoryId'][0])
    {
        return $this->putGroupGroupcategoriesGroupCategoryIdAsyncWithHttpInfo($group_category_id, $post_group_groupcategories_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putGroupGroupcategoriesGroupCategoryIdAsyncWithHttpInfo
     *
     * Update Group Category
     *
     * @param  string $group_category_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGroupcategoriesRequest $post_group_groupcategories_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupGroupcategoriesGroupCategoryIdAsyncWithHttpInfo($group_category_id, $post_group_groupcategories_request = null, string $contentType = self::contentTypes['putGroupGroupcategoriesGroupCategoryId'][0])
    {
        $returnType = '';
        $request = $this->putGroupGroupcategoriesGroupCategoryIdRequest($group_category_id, $post_group_groupcategories_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putGroupGroupcategoriesGroupCategoryId'
     *
     * @param  string $group_category_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupGroupcategoriesRequest $post_group_groupcategories_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupGroupcategoriesGroupCategoryId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putGroupGroupcategoriesGroupCategoryIdRequest($group_category_id, $post_group_groupcategories_request = null, string $contentType = self::contentTypes['putGroupGroupcategoriesGroupCategoryId'][0])
    {

        // verify the required parameter 'group_category_id' is set
        if ($group_category_id === null || (is_array($group_category_id) && count($group_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_category_id when calling putGroupGroupcategoriesGroupCategoryId'
            );
        }



        $resourcePath = '/group/groupcategories/{groupCategoryId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupCategoryId' . '}',
                ObjectSerializer::toPathValue($group_category_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_group_groupcategories_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_group_groupcategories_request));
            } else {
                $httpBody = $post_group_groupcategories_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putGroupGrouptypesGroupTypeId
     *
     * Update GroupType
     *
     * @param  string $group_type_id group_type_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupGrouptypesGroupTypeIdRequest $put_group_grouptypes_group_type_id_request put_group_grouptypes_group_type_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function putGroupGrouptypesGroupTypeId($group_type_id, $put_group_grouptypes_group_type_id_request = null, string $contentType = self::contentTypes['putGroupGrouptypesGroupTypeId'][0])
    {
        $this->putGroupGrouptypesGroupTypeIdWithHttpInfo($group_type_id, $put_group_grouptypes_group_type_id_request, $contentType);
    }

    /**
     * Operation putGroupGrouptypesGroupTypeIdWithHttpInfo
     *
     * Update GroupType
     *
     * @param  string $group_type_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupGrouptypesGroupTypeIdRequest $put_group_grouptypes_group_type_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function putGroupGrouptypesGroupTypeIdWithHttpInfo($group_type_id, $put_group_grouptypes_group_type_id_request = null, string $contentType = self::contentTypes['putGroupGrouptypesGroupTypeId'][0])
    {
        $request = $this->putGroupGrouptypesGroupTypeIdRequest($group_type_id, $put_group_grouptypes_group_type_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation putGroupGrouptypesGroupTypeIdAsync
     *
     * Update GroupType
     *
     * @param  string $group_type_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupGrouptypesGroupTypeIdRequest $put_group_grouptypes_group_type_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupGrouptypesGroupTypeIdAsync($group_type_id, $put_group_grouptypes_group_type_id_request = null, string $contentType = self::contentTypes['putGroupGrouptypesGroupTypeId'][0])
    {
        return $this->putGroupGrouptypesGroupTypeIdAsyncWithHttpInfo($group_type_id, $put_group_grouptypes_group_type_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putGroupGrouptypesGroupTypeIdAsyncWithHttpInfo
     *
     * Update GroupType
     *
     * @param  string $group_type_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupGrouptypesGroupTypeIdRequest $put_group_grouptypes_group_type_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupGrouptypesGroupTypeIdAsyncWithHttpInfo($group_type_id, $put_group_grouptypes_group_type_id_request = null, string $contentType = self::contentTypes['putGroupGrouptypesGroupTypeId'][0])
    {
        $returnType = '';
        $request = $this->putGroupGrouptypesGroupTypeIdRequest($group_type_id, $put_group_grouptypes_group_type_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putGroupGrouptypesGroupTypeId'
     *
     * @param  string $group_type_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupGrouptypesGroupTypeIdRequest $put_group_grouptypes_group_type_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupGrouptypesGroupTypeId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putGroupGrouptypesGroupTypeIdRequest($group_type_id, $put_group_grouptypes_group_type_id_request = null, string $contentType = self::contentTypes['putGroupGrouptypesGroupTypeId'][0])
    {

        // verify the required parameter 'group_type_id' is set
        if ($group_type_id === null || (is_array($group_type_id) && count($group_type_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_type_id when calling putGroupGrouptypesGroupTypeId'
            );
        }



        $resourcePath = '/group/grouptypes/{groupTypeId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_type_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupTypeId' . '}',
                ObjectSerializer::toPathValue($group_type_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($put_group_grouptypes_group_type_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($put_group_grouptypes_group_type_id_request));
            } else {
                $httpBody = $put_group_grouptypes_group_type_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putGroupRolesRoleId
     *
     * Update Role
     *
     * @param  string $role_id role_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupRolesRequest $post_group_roles_request post_group_roles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function putGroupRolesRoleId($role_id, $post_group_roles_request = null, string $contentType = self::contentTypes['putGroupRolesRoleId'][0])
    {
        $this->putGroupRolesRoleIdWithHttpInfo($role_id, $post_group_roles_request, $contentType);
    }

    /**
     * Operation putGroupRolesRoleIdWithHttpInfo
     *
     * Update Role
     *
     * @param  string $role_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupRolesRequest $post_group_roles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function putGroupRolesRoleIdWithHttpInfo($role_id, $post_group_roles_request = null, string $contentType = self::contentTypes['putGroupRolesRoleId'][0])
    {
        $request = $this->putGroupRolesRoleIdRequest($role_id, $post_group_roles_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation putGroupRolesRoleIdAsync
     *
     * Update Role
     *
     * @param  string $role_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupRolesRequest $post_group_roles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupRolesRoleIdAsync($role_id, $post_group_roles_request = null, string $contentType = self::contentTypes['putGroupRolesRoleId'][0])
    {
        return $this->putGroupRolesRoleIdAsyncWithHttpInfo($role_id, $post_group_roles_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putGroupRolesRoleIdAsyncWithHttpInfo
     *
     * Update Role
     *
     * @param  string $role_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupRolesRequest $post_group_roles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupRolesRoleIdAsyncWithHttpInfo($role_id, $post_group_roles_request = null, string $contentType = self::contentTypes['putGroupRolesRoleId'][0])
    {
        $returnType = '';
        $request = $this->putGroupRolesRoleIdRequest($role_id, $post_group_roles_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putGroupRolesRoleId'
     *
     * @param  string $role_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostGroupRolesRequest $post_group_roles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupRolesRoleId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putGroupRolesRoleIdRequest($role_id, $post_group_roles_request = null, string $contentType = self::contentTypes['putGroupRolesRoleId'][0])
    {

        // verify the required parameter 'role_id' is set
        if ($role_id === null || (is_array($role_id) && count($role_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $role_id when calling putGroupRolesRoleId'
            );
        }



        $resourcePath = '/group/roles/{roleId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($role_id !== null) {
            $resourcePath = str_replace(
                '{' . 'roleId' . '}',
                ObjectSerializer::toPathValue($role_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_group_roles_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_group_roles_request));
            } else {
                $httpBody = $post_group_roles_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putGroupTargetgroupsTargetGroupId
     *
     * Update target group
     *
     * @param  string $target_group_id target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest
     */
    public function putGroupTargetgroupsTargetGroupId($target_group_id, string $contentType = self::contentTypes['putGroupTargetgroupsTargetGroupId'][0])
    {
        list($response) = $this->putGroupTargetgroupsTargetGroupIdWithHttpInfo($target_group_id, $contentType);
        return $response;
    }

    /**
     * Operation putGroupTargetgroupsTargetGroupIdWithHttpInfo
     *
     * Update target group
     *
     * @param  string $target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function putGroupTargetgroupsTargetGroupIdWithHttpInfo($target_group_id, string $contentType = self::contentTypes['putGroupTargetgroupsTargetGroupId'][0])
    {
        $request = $this->putGroupTargetgroupsTargetGroupIdRequest($target_group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putGroupTargetgroupsTargetGroupIdAsync
     *
     * Update target group
     *
     * @param  string $target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupTargetgroupsTargetGroupIdAsync($target_group_id, string $contentType = self::contentTypes['putGroupTargetgroupsTargetGroupId'][0])
    {
        return $this->putGroupTargetgroupsTargetGroupIdAsyncWithHttpInfo($target_group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putGroupTargetgroupsTargetGroupIdAsyncWithHttpInfo
     *
     * Update target group
     *
     * @param  string $target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupTargetgroupsTargetGroupIdAsyncWithHttpInfo($target_group_id, string $contentType = self::contentTypes['putGroupTargetgroupsTargetGroupId'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PostGroupTargetgroupsRequest';
        $request = $this->putGroupTargetgroupsTargetGroupIdRequest($target_group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putGroupTargetgroupsTargetGroupId'
     *
     * @param  string $target_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupTargetgroupsTargetGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putGroupTargetgroupsTargetGroupIdRequest($target_group_id, string $contentType = self::contentTypes['putGroupTargetgroupsTargetGroupId'][0])
    {

        // verify the required parameter 'target_group_id' is set
        if ($target_group_id === null || (is_array($target_group_id) && count($target_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $target_group_id when calling putGroupTargetgroupsTargetGroupId'
            );
        }


        $resourcePath = '/group/targetgroups/{targetGroupId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($target_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'targetGroupId' . '}',
                ObjectSerializer::toPathValue($target_group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putGroupsGroupIdMeetingsMeetingId
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id meeting_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupsGroupIdMeetingsMeetingIdRequest $put_groups_group_id_meetings_meeting_id_request put_groups_group_id_meetings_meeting_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdMeetingsMeetingId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function putGroupsGroupIdMeetingsMeetingId($group_id, $meeting_id, $put_groups_group_id_meetings_meeting_id_request = null, string $contentType = self::contentTypes['putGroupsGroupIdMeetingsMeetingId'][0])
    {
        $this->putGroupsGroupIdMeetingsMeetingIdWithHttpInfo($group_id, $meeting_id, $put_groups_group_id_meetings_meeting_id_request, $contentType);
    }

    /**
     * Operation putGroupsGroupIdMeetingsMeetingIdWithHttpInfo
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupsGroupIdMeetingsMeetingIdRequest $put_groups_group_id_meetings_meeting_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdMeetingsMeetingId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function putGroupsGroupIdMeetingsMeetingIdWithHttpInfo($group_id, $meeting_id, $put_groups_group_id_meetings_meeting_id_request = null, string $contentType = self::contentTypes['putGroupsGroupIdMeetingsMeetingId'][0])
    {
        $request = $this->putGroupsGroupIdMeetingsMeetingIdRequest($group_id, $meeting_id, $put_groups_group_id_meetings_meeting_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation putGroupsGroupIdMeetingsMeetingIdAsync
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupsGroupIdMeetingsMeetingIdRequest $put_groups_group_id_meetings_meeting_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdMeetingsMeetingId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupsGroupIdMeetingsMeetingIdAsync($group_id, $meeting_id, $put_groups_group_id_meetings_meeting_id_request = null, string $contentType = self::contentTypes['putGroupsGroupIdMeetingsMeetingId'][0])
    {
        return $this->putGroupsGroupIdMeetingsMeetingIdAsyncWithHttpInfo($group_id, $meeting_id, $put_groups_group_id_meetings_meeting_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putGroupsGroupIdMeetingsMeetingIdAsyncWithHttpInfo
     *
     * 
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupsGroupIdMeetingsMeetingIdRequest $put_groups_group_id_meetings_meeting_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdMeetingsMeetingId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupsGroupIdMeetingsMeetingIdAsyncWithHttpInfo($group_id, $meeting_id, $put_groups_group_id_meetings_meeting_id_request = null, string $contentType = self::contentTypes['putGroupsGroupIdMeetingsMeetingId'][0])
    {
        $returnType = '';
        $request = $this->putGroupsGroupIdMeetingsMeetingIdRequest($group_id, $meeting_id, $put_groups_group_id_meetings_meeting_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putGroupsGroupIdMeetingsMeetingId'
     *
     * @param  int $group_id ID of group (required)
     * @param  string $meeting_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupsGroupIdMeetingsMeetingIdRequest $put_groups_group_id_meetings_meeting_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdMeetingsMeetingId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putGroupsGroupIdMeetingsMeetingIdRequest($group_id, $meeting_id, $put_groups_group_id_meetings_meeting_id_request = null, string $contentType = self::contentTypes['putGroupsGroupIdMeetingsMeetingId'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling putGroupsGroupIdMeetingsMeetingId'
            );
        }

        // verify the required parameter 'meeting_id' is set
        if ($meeting_id === null || (is_array($meeting_id) && count($meeting_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meeting_id when calling putGroupsGroupIdMeetingsMeetingId'
            );
        }



        $resourcePath = '/groups/{groupId}/meetings/{meetingId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($meeting_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetingId' . '}',
                ObjectSerializer::toPathValue($meeting_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($put_groups_group_id_meetings_meeting_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($put_groups_group_id_meetings_meeting_id_request));
            } else {
                $httpBody = $put_groups_group_id_meetings_meeting_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putGroupsGroupIdParentsParentGroupId
     *
     * Add Parent Group
     *
     * @param  string $group_id group_id (required)
     * @param  string $parent_group_id parent_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdParentsParentGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function putGroupsGroupIdParentsParentGroupId($group_id, $parent_group_id, string $contentType = self::contentTypes['putGroupsGroupIdParentsParentGroupId'][0])
    {
        $this->putGroupsGroupIdParentsParentGroupIdWithHttpInfo($group_id, $parent_group_id, $contentType);
    }

    /**
     * Operation putGroupsGroupIdParentsParentGroupIdWithHttpInfo
     *
     * Add Parent Group
     *
     * @param  string $group_id (required)
     * @param  string $parent_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdParentsParentGroupId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function putGroupsGroupIdParentsParentGroupIdWithHttpInfo($group_id, $parent_group_id, string $contentType = self::contentTypes['putGroupsGroupIdParentsParentGroupId'][0])
    {
        $request = $this->putGroupsGroupIdParentsParentGroupIdRequest($group_id, $parent_group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation putGroupsGroupIdParentsParentGroupIdAsync
     *
     * Add Parent Group
     *
     * @param  string $group_id (required)
     * @param  string $parent_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdParentsParentGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupsGroupIdParentsParentGroupIdAsync($group_id, $parent_group_id, string $contentType = self::contentTypes['putGroupsGroupIdParentsParentGroupId'][0])
    {
        return $this->putGroupsGroupIdParentsParentGroupIdAsyncWithHttpInfo($group_id, $parent_group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putGroupsGroupIdParentsParentGroupIdAsyncWithHttpInfo
     *
     * Add Parent Group
     *
     * @param  string $group_id (required)
     * @param  string $parent_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdParentsParentGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupsGroupIdParentsParentGroupIdAsyncWithHttpInfo($group_id, $parent_group_id, string $contentType = self::contentTypes['putGroupsGroupIdParentsParentGroupId'][0])
    {
        $returnType = '';
        $request = $this->putGroupsGroupIdParentsParentGroupIdRequest($group_id, $parent_group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putGroupsGroupIdParentsParentGroupId'
     *
     * @param  string $group_id (required)
     * @param  string $parent_group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdParentsParentGroupId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putGroupsGroupIdParentsParentGroupIdRequest($group_id, $parent_group_id, string $contentType = self::contentTypes['putGroupsGroupIdParentsParentGroupId'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling putGroupsGroupIdParentsParentGroupId'
            );
        }

        // verify the required parameter 'parent_group_id' is set
        if ($parent_group_id === null || (is_array($parent_group_id) && count($parent_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $parent_group_id when calling putGroupsGroupIdParentsParentGroupId'
            );
        }


        $resourcePath = '/groups/{groupId}/parents/{parentGroupId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($parent_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'parentGroupId' . '}',
                ObjectSerializer::toPathValue($parent_group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putGroupsGroupIdPlacesPlaceId
     *
     * 
     *
     * @param  string $group_id group_id (required)
     * @param  string $place_id place_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupsGroupIdPlacesPlaceIdRequest $put_groups_group_id_places_place_id_request put_groups_group_id_places_place_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdPlacesPlaceId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function putGroupsGroupIdPlacesPlaceId($group_id, $place_id, $put_groups_group_id_places_place_id_request = null, string $contentType = self::contentTypes['putGroupsGroupIdPlacesPlaceId'][0])
    {
        $this->putGroupsGroupIdPlacesPlaceIdWithHttpInfo($group_id, $place_id, $put_groups_group_id_places_place_id_request, $contentType);
    }

    /**
     * Operation putGroupsGroupIdPlacesPlaceIdWithHttpInfo
     *
     * 
     *
     * @param  string $group_id (required)
     * @param  string $place_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupsGroupIdPlacesPlaceIdRequest $put_groups_group_id_places_place_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdPlacesPlaceId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function putGroupsGroupIdPlacesPlaceIdWithHttpInfo($group_id, $place_id, $put_groups_group_id_places_place_id_request = null, string $contentType = self::contentTypes['putGroupsGroupIdPlacesPlaceId'][0])
    {
        $request = $this->putGroupsGroupIdPlacesPlaceIdRequest($group_id, $place_id, $put_groups_group_id_places_place_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation putGroupsGroupIdPlacesPlaceIdAsync
     *
     * 
     *
     * @param  string $group_id (required)
     * @param  string $place_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupsGroupIdPlacesPlaceIdRequest $put_groups_group_id_places_place_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdPlacesPlaceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupsGroupIdPlacesPlaceIdAsync($group_id, $place_id, $put_groups_group_id_places_place_id_request = null, string $contentType = self::contentTypes['putGroupsGroupIdPlacesPlaceId'][0])
    {
        return $this->putGroupsGroupIdPlacesPlaceIdAsyncWithHttpInfo($group_id, $place_id, $put_groups_group_id_places_place_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putGroupsGroupIdPlacesPlaceIdAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $group_id (required)
     * @param  string $place_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupsGroupIdPlacesPlaceIdRequest $put_groups_group_id_places_place_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdPlacesPlaceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putGroupsGroupIdPlacesPlaceIdAsyncWithHttpInfo($group_id, $place_id, $put_groups_group_id_places_place_id_request = null, string $contentType = self::contentTypes['putGroupsGroupIdPlacesPlaceId'][0])
    {
        $returnType = '';
        $request = $this->putGroupsGroupIdPlacesPlaceIdRequest($group_id, $place_id, $put_groups_group_id_places_place_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putGroupsGroupIdPlacesPlaceId'
     *
     * @param  string $group_id (required)
     * @param  string $place_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutGroupsGroupIdPlacesPlaceIdRequest $put_groups_group_id_places_place_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putGroupsGroupIdPlacesPlaceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putGroupsGroupIdPlacesPlaceIdRequest($group_id, $place_id, $put_groups_group_id_places_place_id_request = null, string $contentType = self::contentTypes['putGroupsGroupIdPlacesPlaceId'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling putGroupsGroupIdPlacesPlaceId'
            );
        }

        // verify the required parameter 'place_id' is set
        if ($place_id === null || (is_array($place_id) && count($place_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $place_id when calling putGroupsGroupIdPlacesPlaceId'
            );
        }



        $resourcePath = '/groups/{groupId}/places/{placeId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }
        // path params
        if ($place_id !== null) {
            $resourcePath = str_replace(
                '{' . 'placeId' . '}',
                ObjectSerializer::toPathValue($place_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($put_groups_group_id_places_place_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($put_groups_group_id_places_place_id_request));
            } else {
                $httpBody = $put_groups_group_id_places_place_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation startStopGroupChat
     *
     * Start or stop an event chat
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\StartStopEventChatRequest $start_stop_event_chat_request start_stop_event_chat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startStopGroupChat'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function startStopGroupChat($group_id, $start_stop_event_chat_request, string $contentType = self::contentTypes['startStopGroupChat'][0])
    {
        $this->startStopGroupChatWithHttpInfo($group_id, $start_stop_event_chat_request, $contentType);
    }

    /**
     * Operation startStopGroupChatWithHttpInfo
     *
     * Start or stop an event chat
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\StartStopEventChatRequest $start_stop_event_chat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startStopGroupChat'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function startStopGroupChatWithHttpInfo($group_id, $start_stop_event_chat_request, string $contentType = self::contentTypes['startStopGroupChat'][0])
    {
        $request = $this->startStopGroupChatRequest($group_id, $start_stop_event_chat_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation startStopGroupChatAsync
     *
     * Start or stop an event chat
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\StartStopEventChatRequest $start_stop_event_chat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startStopGroupChat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function startStopGroupChatAsync($group_id, $start_stop_event_chat_request, string $contentType = self::contentTypes['startStopGroupChat'][0])
    {
        return $this->startStopGroupChatAsyncWithHttpInfo($group_id, $start_stop_event_chat_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation startStopGroupChatAsyncWithHttpInfo
     *
     * Start or stop an event chat
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\StartStopEventChatRequest $start_stop_event_chat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startStopGroupChat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function startStopGroupChatAsyncWithHttpInfo($group_id, $start_stop_event_chat_request, string $contentType = self::contentTypes['startStopGroupChat'][0])
    {
        $returnType = '';
        $request = $this->startStopGroupChatRequest($group_id, $start_stop_event_chat_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'startStopGroupChat'
     *
     * @param  int $group_id ID of group (required)
     * @param  \StevenBuehner\ChurchTools\Model\StartStopEventChatRequest $start_stop_event_chat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startStopGroupChat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function startStopGroupChatRequest($group_id, $start_stop_event_chat_request, string $contentType = self::contentTypes['startStopGroupChat'][0])
    {

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling startStopGroupChat'
            );
        }

        // verify the required parameter 'start_stop_event_chat_request' is set
        if ($start_stop_event_chat_request === null || (is_array($start_stop_event_chat_request) && count($start_stop_event_chat_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $start_stop_event_chat_request when calling startStopGroupChat'
            );
        }


        $resourcePath = '/groups/{groupId}/chat';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'groupId' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($start_stop_event_chat_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($start_stop_event_chat_request));
            } else {
                $httpBody = $start_stop_event_chat_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
