<?php
/**
 * WikiApi
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use StevenBuehner\ChurchTools\ApiException;
use StevenBuehner\ChurchTools\Configuration;
use StevenBuehner\ChurchTools\HeaderSelector;
use StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * WikiApi Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class WikiApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getWikiCategories' => [
            'application/json',
        ],
        'getWikiCategoriesWikiCategoryIdPages' => [
            'application/json',
        ],
        'getWikiCategoriesWikiCategoryIdPagesIdentifier' => [
            'application/json',
        ],
        'getWikiCategoriesWikiCategoryIdPagesIdentifierVersions' => [
            'application/json',
        ],
        'getWikiCategoriesWikiCategoryIdPagesVersionsVersion' => [
            'application/json',
        ],
        'getWikiCategoriesWikiCategoryIdSearch' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getWikiCategories
     *
     * Get all wiki categories.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategories'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetWikiCategories200Response
     */
    public function getWikiCategories(string $contentType = self::contentTypes['getWikiCategories'][0])
    {
        list($response) = $this->getWikiCategoriesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getWikiCategoriesWithHttpInfo
     *
     * Get all wiki categories.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategories'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetWikiCategories200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWikiCategoriesWithHttpInfo(string $contentType = self::contentTypes['getWikiCategories'][0])
    {
        $request = $this->getWikiCategoriesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetWikiCategories200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetWikiCategories200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetWikiCategories200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetWikiCategories200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetWikiCategories200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWikiCategoriesAsync
     *
     * Get all wiki categories.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWikiCategoriesAsync(string $contentType = self::contentTypes['getWikiCategories'][0])
    {
        return $this->getWikiCategoriesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWikiCategoriesAsyncWithHttpInfo
     *
     * Get all wiki categories.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWikiCategoriesAsyncWithHttpInfo(string $contentType = self::contentTypes['getWikiCategories'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetWikiCategories200Response';
        $request = $this->getWikiCategoriesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWikiCategories'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWikiCategoriesRequest(string $contentType = self::contentTypes['getWikiCategories'][0])
    {


        $resourcePath = '/wiki/categories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPages
     *
     * Returns all Wiki Pages in the given Category.
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPages'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPages200Response
     */
    public function getWikiCategoriesWikiCategoryIdPages($wiki_category_id, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPages'][0])
    {
        list($response) = $this->getWikiCategoriesWikiCategoryIdPagesWithHttpInfo($wiki_category_id, $contentType);
        return $response;
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesWithHttpInfo
     *
     * Returns all Wiki Pages in the given Category.
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPages'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPages200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWikiCategoriesWikiCategoryIdPagesWithHttpInfo($wiki_category_id, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPages'][0])
    {
        $request = $this->getWikiCategoriesWikiCategoryIdPagesRequest($wiki_category_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPages200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPages200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPages200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPages200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPages200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesAsync
     *
     * Returns all Wiki Pages in the given Category.
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWikiCategoriesWikiCategoryIdPagesAsync($wiki_category_id, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPages'][0])
    {
        return $this->getWikiCategoriesWikiCategoryIdPagesAsyncWithHttpInfo($wiki_category_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesAsyncWithHttpInfo
     *
     * Returns all Wiki Pages in the given Category.
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWikiCategoriesWikiCategoryIdPagesAsyncWithHttpInfo($wiki_category_id, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPages'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPages200Response';
        $request = $this->getWikiCategoriesWikiCategoryIdPagesRequest($wiki_category_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWikiCategoriesWikiCategoryIdPages'
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWikiCategoriesWikiCategoryIdPagesRequest($wiki_category_id, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPages'][0])
    {

        // verify the required parameter 'wiki_category_id' is set
        if ($wiki_category_id === null || (is_array($wiki_category_id) && count($wiki_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $wiki_category_id when calling getWikiCategoriesWikiCategoryIdPages'
            );
        }


        $resourcePath = '/wiki/categories/{wikiCategoryId}/pages';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($wiki_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'wikiCategoryId' . '}',
                ObjectSerializer::toPathValue($wiki_category_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesIdentifier
     *
     * Returns the latest version of the wiki page with the given identifier.
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifier'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response
     */
    public function getWikiCategoriesWikiCategoryIdPagesIdentifier($wiki_category_id, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifier'][0])
    {
        list($response) = $this->getWikiCategoriesWikiCategoryIdPagesIdentifierWithHttpInfo($wiki_category_id, $identifier, $contentType);
        return $response;
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesIdentifierWithHttpInfo
     *
     * Returns the latest version of the wiki page with the given identifier.
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifier'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWikiCategoriesWikiCategoryIdPagesIdentifierWithHttpInfo($wiki_category_id, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifier'][0])
    {
        $request = $this->getWikiCategoriesWikiCategoryIdPagesIdentifierRequest($wiki_category_id, $identifier, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesIdentifierAsync
     *
     * Returns the latest version of the wiki page with the given identifier.
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifier'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWikiCategoriesWikiCategoryIdPagesIdentifierAsync($wiki_category_id, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifier'][0])
    {
        return $this->getWikiCategoriesWikiCategoryIdPagesIdentifierAsyncWithHttpInfo($wiki_category_id, $identifier, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesIdentifierAsyncWithHttpInfo
     *
     * Returns the latest version of the wiki page with the given identifier.
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifier'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWikiCategoriesWikiCategoryIdPagesIdentifierAsyncWithHttpInfo($wiki_category_id, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifier'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response';
        $request = $this->getWikiCategoriesWikiCategoryIdPagesIdentifierRequest($wiki_category_id, $identifier, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWikiCategoriesWikiCategoryIdPagesIdentifier'
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifier'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWikiCategoriesWikiCategoryIdPagesIdentifierRequest($wiki_category_id, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifier'][0])
    {

        // verify the required parameter 'wiki_category_id' is set
        if ($wiki_category_id === null || (is_array($wiki_category_id) && count($wiki_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $wiki_category_id when calling getWikiCategoriesWikiCategoryIdPagesIdentifier'
            );
        }

        // verify the required parameter 'identifier' is set
        if ($identifier === null || (is_array($identifier) && count($identifier) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $identifier when calling getWikiCategoriesWikiCategoryIdPagesIdentifier'
            );
        }


        $resourcePath = '/wiki/categories/{wikiCategoryId}/pages/{identifier}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($wiki_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'wikiCategoryId' . '}',
                ObjectSerializer::toPathValue($wiki_category_id),
                $resourcePath
            );
        }
        // path params
        if ($identifier !== null) {
            $resourcePath = str_replace(
                '{' . 'identifier' . '}',
                ObjectSerializer::toPathValue($identifier),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesIdentifierVersions
     *
     * Returns all version of the wiki page for the given
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response
     */
    public function getWikiCategoriesWikiCategoryIdPagesIdentifierVersions($wiki_category_id, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'][0])
    {
        list($response) = $this->getWikiCategoriesWikiCategoryIdPagesIdentifierVersionsWithHttpInfo($wiki_category_id, $identifier, $contentType);
        return $response;
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesIdentifierVersionsWithHttpInfo
     *
     * Returns all version of the wiki page for the given
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWikiCategoriesWikiCategoryIdPagesIdentifierVersionsWithHttpInfo($wiki_category_id, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'][0])
    {
        $request = $this->getWikiCategoriesWikiCategoryIdPagesIdentifierVersionsRequest($wiki_category_id, $identifier, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesIdentifierVersionsAsync
     *
     * Returns all version of the wiki page for the given
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWikiCategoriesWikiCategoryIdPagesIdentifierVersionsAsync($wiki_category_id, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'][0])
    {
        return $this->getWikiCategoriesWikiCategoryIdPagesIdentifierVersionsAsyncWithHttpInfo($wiki_category_id, $identifier, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesIdentifierVersionsAsyncWithHttpInfo
     *
     * Returns all version of the wiki page for the given
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWikiCategoriesWikiCategoryIdPagesIdentifierVersionsAsyncWithHttpInfo($wiki_category_id, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesIdentifier200Response';
        $request = $this->getWikiCategoriesWikiCategoryIdPagesIdentifierVersionsRequest($wiki_category_id, $identifier, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWikiCategoriesWikiCategoryIdPagesIdentifierVersionsRequest($wiki_category_id, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'][0])
    {

        // verify the required parameter 'wiki_category_id' is set
        if ($wiki_category_id === null || (is_array($wiki_category_id) && count($wiki_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $wiki_category_id when calling getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'
            );
        }

        // verify the required parameter 'identifier' is set
        if ($identifier === null || (is_array($identifier) && count($identifier) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $identifier when calling getWikiCategoriesWikiCategoryIdPagesIdentifierVersions'
            );
        }


        $resourcePath = '/wiki/categories/{wikiCategoryId}/pages/{identifier}/versions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($wiki_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'wikiCategoryId' . '}',
                ObjectSerializer::toPathValue($wiki_category_id),
                $resourcePath
            );
        }
        // path params
        if ($identifier !== null) {
            $resourcePath = str_replace(
                '{' . 'identifier' . '}',
                ObjectSerializer::toPathValue($identifier),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesVersionsVersion
     *
     * Returns the wiki page with the given identifier and version.
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $version version (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesVersionsVersion'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesVersionsVersion200Response
     */
    public function getWikiCategoriesWikiCategoryIdPagesVersionsVersion($wiki_category_id, $version, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesVersionsVersion'][0])
    {
        list($response) = $this->getWikiCategoriesWikiCategoryIdPagesVersionsVersionWithHttpInfo($wiki_category_id, $version, $identifier, $contentType);
        return $response;
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesVersionsVersionWithHttpInfo
     *
     * Returns the wiki page with the given identifier and version.
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $version (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesVersionsVersion'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesVersionsVersion200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWikiCategoriesWikiCategoryIdPagesVersionsVersionWithHttpInfo($wiki_category_id, $version, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesVersionsVersion'][0])
    {
        $request = $this->getWikiCategoriesWikiCategoryIdPagesVersionsVersionRequest($wiki_category_id, $version, $identifier, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesVersionsVersion200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesVersionsVersion200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesVersionsVersion200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesVersionsVersion200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesVersionsVersion200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesVersionsVersionAsync
     *
     * Returns the wiki page with the given identifier and version.
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $version (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesVersionsVersion'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWikiCategoriesWikiCategoryIdPagesVersionsVersionAsync($wiki_category_id, $version, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesVersionsVersion'][0])
    {
        return $this->getWikiCategoriesWikiCategoryIdPagesVersionsVersionAsyncWithHttpInfo($wiki_category_id, $version, $identifier, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdPagesVersionsVersionAsyncWithHttpInfo
     *
     * Returns the wiki page with the given identifier and version.
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $version (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesVersionsVersion'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWikiCategoriesWikiCategoryIdPagesVersionsVersionAsyncWithHttpInfo($wiki_category_id, $version, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesVersionsVersion'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdPagesVersionsVersion200Response';
        $request = $this->getWikiCategoriesWikiCategoryIdPagesVersionsVersionRequest($wiki_category_id, $version, $identifier, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWikiCategoriesWikiCategoryIdPagesVersionsVersion'
     *
     * @param  int $wiki_category_id ID of WikiCategory (required)
     * @param  string $version (required)
     * @param  string $identifier Can either be the pages identifier or its title (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdPagesVersionsVersion'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWikiCategoriesWikiCategoryIdPagesVersionsVersionRequest($wiki_category_id, $version, $identifier, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdPagesVersionsVersion'][0])
    {

        // verify the required parameter 'wiki_category_id' is set
        if ($wiki_category_id === null || (is_array($wiki_category_id) && count($wiki_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $wiki_category_id when calling getWikiCategoriesWikiCategoryIdPagesVersionsVersion'
            );
        }

        // verify the required parameter 'version' is set
        if ($version === null || (is_array($version) && count($version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $version when calling getWikiCategoriesWikiCategoryIdPagesVersionsVersion'
            );
        }

        // verify the required parameter 'identifier' is set
        if ($identifier === null || (is_array($identifier) && count($identifier) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $identifier when calling getWikiCategoriesWikiCategoryIdPagesVersionsVersion'
            );
        }


        $resourcePath = '/wiki/categories/{wikiCategoryId}/pages/{identifier}/versions/{version}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($wiki_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'wikiCategoryId' . '}',
                ObjectSerializer::toPathValue($wiki_category_id),
                $resourcePath
            );
        }
        // path params
        if ($version !== null) {
            $resourcePath = str_replace(
                '{' . 'version' . '}',
                ObjectSerializer::toPathValue($version),
                $resourcePath
            );
        }
        // path params
        if ($identifier !== null) {
            $resourcePath = str_replace(
                '{' . 'identifier' . '}',
                ObjectSerializer::toPathValue($identifier),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdSearch
     *
     * Your GET endpoint
     *
     * @param  string $query query (optional)
     * @param  int[] $wiki_category_ids wiki categories that should be searched. if noone is given all categories are searched (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdSearch'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdSearch200Response
     */
    public function getWikiCategoriesWikiCategoryIdSearch($query = null, $wiki_category_ids = null, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdSearch'][0])
    {
        list($response) = $this->getWikiCategoriesWikiCategoryIdSearchWithHttpInfo($query, $wiki_category_ids, $contentType);
        return $response;
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdSearchWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string $query (optional)
     * @param  int[] $wiki_category_ids wiki categories that should be searched. if noone is given all categories are searched (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdSearch'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdSearch200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWikiCategoriesWikiCategoryIdSearchWithHttpInfo($query = null, $wiki_category_ids = null, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdSearch'][0])
    {
        $request = $this->getWikiCategoriesWikiCategoryIdSearchRequest($query, $wiki_category_ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdSearch200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdSearch200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdSearch200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdSearch200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdSearch200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdSearchAsync
     *
     * Your GET endpoint
     *
     * @param  string $query (optional)
     * @param  int[] $wiki_category_ids wiki categories that should be searched. if noone is given all categories are searched (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdSearch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWikiCategoriesWikiCategoryIdSearchAsync($query = null, $wiki_category_ids = null, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdSearch'][0])
    {
        return $this->getWikiCategoriesWikiCategoryIdSearchAsyncWithHttpInfo($query, $wiki_category_ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWikiCategoriesWikiCategoryIdSearchAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string $query (optional)
     * @param  int[] $wiki_category_ids wiki categories that should be searched. if noone is given all categories are searched (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdSearch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWikiCategoriesWikiCategoryIdSearchAsyncWithHttpInfo($query = null, $wiki_category_ids = null, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdSearch'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetWikiCategoriesWikiCategoryIdSearch200Response';
        $request = $this->getWikiCategoriesWikiCategoryIdSearchRequest($query, $wiki_category_ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWikiCategoriesWikiCategoryIdSearch'
     *
     * @param  string $query (optional)
     * @param  int[] $wiki_category_ids wiki categories that should be searched. if noone is given all categories are searched (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWikiCategoriesWikiCategoryIdSearch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWikiCategoriesWikiCategoryIdSearchRequest($query = null, $wiki_category_ids = null, string $contentType = self::contentTypes['getWikiCategoriesWikiCategoryIdSearch'][0])
    {




        $resourcePath = '/wiki/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $wiki_category_ids,
            'wiki_category_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
