<?php
/**
 * 1
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * 1 Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class 1 implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = '_1';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'is_archived' => 'bool',
        'meta' => '\StevenBuehner\ChurchTools\Model\1Meta',
        'requested_event' => '\StevenBuehner\ChurchTools\Model\1RequestedEvent',
        'requested_person' => '\StevenBuehner\ChurchTools\Model\PutCheckinPersons200ResponseData',
        'requested_service_id' => 'int',
        'requesting_event' => '\StevenBuehner\ChurchTools\Model\1RequestedEvent',
        'requesting_person' => '\StevenBuehner\ChurchTools\Model\PutCheckinPersons200ResponseData',
        'requesting_service_id' => 'int',
        'status' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'is_archived' => null,
        'meta' => null,
        'requested_event' => null,
        'requested_person' => null,
        'requested_service_id' => null,
        'requesting_event' => null,
        'requesting_person' => null,
        'requesting_service_id' => null,
        'status' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
		'is_archived' => false,
		'meta' => false,
		'requested_event' => false,
		'requested_person' => false,
		'requested_service_id' => false,
		'requesting_event' => false,
		'requesting_person' => false,
		'requesting_service_id' => false,
		'status' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'is_archived' => 'isArchived',
        'meta' => 'meta',
        'requested_event' => 'requestedEvent',
        'requested_person' => 'requestedPerson',
        'requested_service_id' => 'requestedServiceId',
        'requesting_event' => 'requestingEvent',
        'requesting_person' => 'requestingPerson',
        'requesting_service_id' => 'requestingServiceId',
        'status' => 'status'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'is_archived' => 'setIsArchived',
        'meta' => 'setMeta',
        'requested_event' => 'setRequestedEvent',
        'requested_person' => 'setRequestedPerson',
        'requested_service_id' => 'setRequestedServiceId',
        'requesting_event' => 'setRequestingEvent',
        'requesting_person' => 'setRequestingPerson',
        'requesting_service_id' => 'setRequestingServiceId',
        'status' => 'setStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'is_archived' => 'getIsArchived',
        'meta' => 'getMeta',
        'requested_event' => 'getRequestedEvent',
        'requested_person' => 'getRequestedPerson',
        'requested_service_id' => 'getRequestedServiceId',
        'requesting_event' => 'getRequestingEvent',
        'requesting_person' => 'getRequestingPerson',
        'requesting_service_id' => 'getRequestingServiceId',
        'status' => 'getStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('is_archived', $data ?? [], null);
        $this->setIfExists('meta', $data ?? [], null);
        $this->setIfExists('requested_event', $data ?? [], null);
        $this->setIfExists('requested_person', $data ?? [], null);
        $this->setIfExists('requested_service_id', $data ?? [], null);
        $this->setIfExists('requesting_event', $data ?? [], null);
        $this->setIfExists('requesting_person', $data ?? [], null);
        $this->setIfExists('requesting_service_id', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets is_archived
     *
     * @return bool|null
     */
    public function getIsArchived()
    {
        return $this->container['is_archived'];
    }

    /**
     * Sets is_archived
     *
     * @param bool|null $is_archived is_archived
     *
     * @return self
     */
    public function setIsArchived($is_archived)
    {
        if (is_null($is_archived)) {
            throw new \InvalidArgumentException('non-nullable is_archived cannot be null');
        }
        $this->container['is_archived'] = $is_archived;

        return $this;
    }

    /**
     * Gets meta
     *
     * @return \StevenBuehner\ChurchTools\Model\1Meta|null
     */
    public function getMeta()
    {
        return $this->container['meta'];
    }

    /**
     * Sets meta
     *
     * @param \StevenBuehner\ChurchTools\Model\1Meta|null $meta meta
     *
     * @return self
     */
    public function setMeta($meta)
    {
        if (is_null($meta)) {
            throw new \InvalidArgumentException('non-nullable meta cannot be null');
        }
        $this->container['meta'] = $meta;

        return $this;
    }

    /**
     * Gets requested_event
     *
     * @return \StevenBuehner\ChurchTools\Model\1RequestedEvent|null
     */
    public function getRequestedEvent()
    {
        return $this->container['requested_event'];
    }

    /**
     * Sets requested_event
     *
     * @param \StevenBuehner\ChurchTools\Model\1RequestedEvent|null $requested_event requested_event
     *
     * @return self
     */
    public function setRequestedEvent($requested_event)
    {
        if (is_null($requested_event)) {
            throw new \InvalidArgumentException('non-nullable requested_event cannot be null');
        }
        $this->container['requested_event'] = $requested_event;

        return $this;
    }

    /**
     * Gets requested_person
     *
     * @return \StevenBuehner\ChurchTools\Model\PutCheckinPersons200ResponseData|null
     */
    public function getRequestedPerson()
    {
        return $this->container['requested_person'];
    }

    /**
     * Sets requested_person
     *
     * @param \StevenBuehner\ChurchTools\Model\PutCheckinPersons200ResponseData|null $requested_person requested_person
     *
     * @return self
     */
    public function setRequestedPerson($requested_person)
    {
        if (is_null($requested_person)) {
            throw new \InvalidArgumentException('non-nullable requested_person cannot be null');
        }
        $this->container['requested_person'] = $requested_person;

        return $this;
    }

    /**
     * Gets requested_service_id
     *
     * @return int|null
     */
    public function getRequestedServiceId()
    {
        return $this->container['requested_service_id'];
    }

    /**
     * Sets requested_service_id
     *
     * @param int|null $requested_service_id requested_service_id
     *
     * @return self
     */
    public function setRequestedServiceId($requested_service_id)
    {
        if (is_null($requested_service_id)) {
            throw new \InvalidArgumentException('non-nullable requested_service_id cannot be null');
        }
        $this->container['requested_service_id'] = $requested_service_id;

        return $this;
    }

    /**
     * Gets requesting_event
     *
     * @return \StevenBuehner\ChurchTools\Model\1RequestedEvent|null
     */
    public function getRequestingEvent()
    {
        return $this->container['requesting_event'];
    }

    /**
     * Sets requesting_event
     *
     * @param \StevenBuehner\ChurchTools\Model\1RequestedEvent|null $requesting_event requesting_event
     *
     * @return self
     */
    public function setRequestingEvent($requesting_event)
    {
        if (is_null($requesting_event)) {
            throw new \InvalidArgumentException('non-nullable requesting_event cannot be null');
        }
        $this->container['requesting_event'] = $requesting_event;

        return $this;
    }

    /**
     * Gets requesting_person
     *
     * @return \StevenBuehner\ChurchTools\Model\PutCheckinPersons200ResponseData|null
     */
    public function getRequestingPerson()
    {
        return $this->container['requesting_person'];
    }

    /**
     * Sets requesting_person
     *
     * @param \StevenBuehner\ChurchTools\Model\PutCheckinPersons200ResponseData|null $requesting_person requesting_person
     *
     * @return self
     */
    public function setRequestingPerson($requesting_person)
    {
        if (is_null($requesting_person)) {
            throw new \InvalidArgumentException('non-nullable requesting_person cannot be null');
        }
        $this->container['requesting_person'] = $requesting_person;

        return $this;
    }

    /**
     * Gets requesting_service_id
     *
     * @return int|null
     */
    public function getRequestingServiceId()
    {
        return $this->container['requesting_service_id'];
    }

    /**
     * Sets requesting_service_id
     *
     * @param int|null $requesting_service_id requesting_service_id
     *
     * @return self
     */
    public function setRequestingServiceId($requesting_service_id)
    {
        if (is_null($requesting_service_id)) {
            throw new \InvalidArgumentException('non-nullable requesting_service_id cannot be null');
        }
        $this->container['requesting_service_id'] = $requesting_service_id;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


