<?php
/**
 * EventMasterData1DataServicesInnerData
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * EventMasterData1DataServicesInnerData Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class EventMasterData1DataServicesInnerData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'EventMasterData_1_data_services_inner_data';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'allow_chat' => 'bool',
        'allow_control_live_agenda' => 'bool',
        'allow_decline' => 'bool',
        'allow_exchange' => 'bool',
        'cal_text_template' => 'string',
        'comment' => 'string',
        'comment_on_confirmation' => 'bool',
        'group_ids' => 'string',
        'hide_person_name' => 'bool',
        'id' => 'int',
        'name' => 'string',
        'send_reminder_mails' => 'bool',
        'send_service_request_emails' => 'bool',
        'service_group_id' => 'int',
        'sort_key' => 'int',
        'standard' => 'bool',
        'tag_ids' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'allow_chat' => null,
        'allow_control_live_agenda' => null,
        'allow_decline' => null,
        'allow_exchange' => null,
        'cal_text_template' => null,
        'comment' => null,
        'comment_on_confirmation' => null,
        'group_ids' => null,
        'hide_person_name' => null,
        'id' => null,
        'name' => null,
        'send_reminder_mails' => null,
        'send_service_request_emails' => null,
        'service_group_id' => null,
        'sort_key' => null,
        'standard' => null,
        'tag_ids' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'allow_chat' => false,
        'allow_control_live_agenda' => false,
        'allow_decline' => false,
        'allow_exchange' => false,
        'cal_text_template' => false,
        'comment' => false,
        'comment_on_confirmation' => false,
        'group_ids' => false,
        'hide_person_name' => false,
        'id' => false,
        'name' => false,
        'send_reminder_mails' => false,
        'send_service_request_emails' => false,
        'service_group_id' => false,
        'sort_key' => false,
        'standard' => false,
        'tag_ids' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'allow_chat' => 'allowChat',
        'allow_control_live_agenda' => 'allowControlLiveAgenda',
        'allow_decline' => 'allowDecline',
        'allow_exchange' => 'allowExchange',
        'cal_text_template' => 'calTextTemplate',
        'comment' => 'comment',
        'comment_on_confirmation' => 'commentOnConfirmation',
        'group_ids' => 'groupIds',
        'hide_person_name' => 'hidePersonName',
        'id' => 'id',
        'name' => 'name',
        'send_reminder_mails' => 'sendReminderMails',
        'send_service_request_emails' => 'sendServiceRequestEmails',
        'service_group_id' => 'serviceGroupId',
        'sort_key' => 'sortKey',
        'standard' => 'standard',
        'tag_ids' => 'tagIds'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'allow_chat' => 'setAllowChat',
        'allow_control_live_agenda' => 'setAllowControlLiveAgenda',
        'allow_decline' => 'setAllowDecline',
        'allow_exchange' => 'setAllowExchange',
        'cal_text_template' => 'setCalTextTemplate',
        'comment' => 'setComment',
        'comment_on_confirmation' => 'setCommentOnConfirmation',
        'group_ids' => 'setGroupIds',
        'hide_person_name' => 'setHidePersonName',
        'id' => 'setId',
        'name' => 'setName',
        'send_reminder_mails' => 'setSendReminderMails',
        'send_service_request_emails' => 'setSendServiceRequestEmails',
        'service_group_id' => 'setServiceGroupId',
        'sort_key' => 'setSortKey',
        'standard' => 'setStandard',
        'tag_ids' => 'setTagIds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'allow_chat' => 'getAllowChat',
        'allow_control_live_agenda' => 'getAllowControlLiveAgenda',
        'allow_decline' => 'getAllowDecline',
        'allow_exchange' => 'getAllowExchange',
        'cal_text_template' => 'getCalTextTemplate',
        'comment' => 'getComment',
        'comment_on_confirmation' => 'getCommentOnConfirmation',
        'group_ids' => 'getGroupIds',
        'hide_person_name' => 'getHidePersonName',
        'id' => 'getId',
        'name' => 'getName',
        'send_reminder_mails' => 'getSendReminderMails',
        'send_service_request_emails' => 'getSendServiceRequestEmails',
        'service_group_id' => 'getServiceGroupId',
        'sort_key' => 'getSortKey',
        'standard' => 'getStandard',
        'tag_ids' => 'getTagIds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('allow_chat', $data ?? [], null);
        $this->setIfExists('allow_control_live_agenda', $data ?? [], null);
        $this->setIfExists('allow_decline', $data ?? [], null);
        $this->setIfExists('allow_exchange', $data ?? [], null);
        $this->setIfExists('cal_text_template', $data ?? [], null);
        $this->setIfExists('comment', $data ?? [], null);
        $this->setIfExists('comment_on_confirmation', $data ?? [], null);
        $this->setIfExists('group_ids', $data ?? [], null);
        $this->setIfExists('hide_person_name', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('send_reminder_mails', $data ?? [], null);
        $this->setIfExists('send_service_request_emails', $data ?? [], null);
        $this->setIfExists('service_group_id', $data ?? [], null);
        $this->setIfExists('sort_key', $data ?? [], null);
        $this->setIfExists('standard', $data ?? [], null);
        $this->setIfExists('tag_ids', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets allow_chat
     *
     * @return bool|null
     */
    public function getAllowChat()
    {
        return $this->container['allow_chat'];
    }

    /**
     * Sets allow_chat
     *
     * @param bool|null $allow_chat allow_chat
     *
     * @return self
     */
    public function setAllowChat($allow_chat)
    {
        if (is_null($allow_chat)) {
            throw new \InvalidArgumentException('non-nullable allow_chat cannot be null');
        }
        $this->container['allow_chat'] = $allow_chat;

        return $this;
    }

    /**
     * Gets allow_control_live_agenda
     *
     * @return bool|null
     */
    public function getAllowControlLiveAgenda()
    {
        return $this->container['allow_control_live_agenda'];
    }

    /**
     * Sets allow_control_live_agenda
     *
     * @param bool|null $allow_control_live_agenda allow_control_live_agenda
     *
     * @return self
     */
    public function setAllowControlLiveAgenda($allow_control_live_agenda)
    {
        if (is_null($allow_control_live_agenda)) {
            throw new \InvalidArgumentException('non-nullable allow_control_live_agenda cannot be null');
        }
        $this->container['allow_control_live_agenda'] = $allow_control_live_agenda;

        return $this;
    }

    /**
     * Gets allow_decline
     *
     * @return bool|null
     */
    public function getAllowDecline()
    {
        return $this->container['allow_decline'];
    }

    /**
     * Sets allow_decline
     *
     * @param bool|null $allow_decline allow_decline
     *
     * @return self
     */
    public function setAllowDecline($allow_decline)
    {
        if (is_null($allow_decline)) {
            throw new \InvalidArgumentException('non-nullable allow_decline cannot be null');
        }
        $this->container['allow_decline'] = $allow_decline;

        return $this;
    }

    /**
     * Gets allow_exchange
     *
     * @return bool|null
     */
    public function getAllowExchange()
    {
        return $this->container['allow_exchange'];
    }

    /**
     * Sets allow_exchange
     *
     * @param bool|null $allow_exchange allow_exchange
     *
     * @return self
     */
    public function setAllowExchange($allow_exchange)
    {
        if (is_null($allow_exchange)) {
            throw new \InvalidArgumentException('non-nullable allow_exchange cannot be null');
        }
        $this->container['allow_exchange'] = $allow_exchange;

        return $this;
    }

    /**
     * Gets cal_text_template
     *
     * @return string|null
     */
    public function getCalTextTemplate()
    {
        return $this->container['cal_text_template'];
    }

    /**
     * Sets cal_text_template
     *
     * @param string|null $cal_text_template cal_text_template
     *
     * @return self
     */
    public function setCalTextTemplate($cal_text_template)
    {
        if (is_null($cal_text_template)) {
            throw new \InvalidArgumentException('non-nullable cal_text_template cannot be null');
        }
        $this->container['cal_text_template'] = $cal_text_template;

        return $this;
    }

    /**
     * Gets comment
     *
     * @return string|null
     */
    public function getComment()
    {
        return $this->container['comment'];
    }

    /**
     * Sets comment
     *
     * @param string|null $comment comment
     *
     * @return self
     */
    public function setComment($comment)
    {
        if (is_null($comment)) {
            throw new \InvalidArgumentException('non-nullable comment cannot be null');
        }
        $this->container['comment'] = $comment;

        return $this;
    }

    /**
     * Gets comment_on_confirmation
     *
     * @return bool|null
     */
    public function getCommentOnConfirmation()
    {
        return $this->container['comment_on_confirmation'];
    }

    /**
     * Sets comment_on_confirmation
     *
     * @param bool|null $comment_on_confirmation comment_on_confirmation
     *
     * @return self
     */
    public function setCommentOnConfirmation($comment_on_confirmation)
    {
        if (is_null($comment_on_confirmation)) {
            throw new \InvalidArgumentException('non-nullable comment_on_confirmation cannot be null');
        }
        $this->container['comment_on_confirmation'] = $comment_on_confirmation;

        return $this;
    }

    /**
     * Gets group_ids
     *
     * @return string|null
     */
    public function getGroupIds()
    {
        return $this->container['group_ids'];
    }

    /**
     * Sets group_ids
     *
     * @param string|null $group_ids group_ids
     *
     * @return self
     */
    public function setGroupIds($group_ids)
    {
        if (is_null($group_ids)) {
            throw new \InvalidArgumentException('non-nullable group_ids cannot be null');
        }
        $this->container['group_ids'] = $group_ids;

        return $this;
    }

    /**
     * Gets hide_person_name
     *
     * @return bool|null
     */
    public function getHidePersonName()
    {
        return $this->container['hide_person_name'];
    }

    /**
     * Sets hide_person_name
     *
     * @param bool|null $hide_person_name hide_person_name
     *
     * @return self
     */
    public function setHidePersonName($hide_person_name)
    {
        if (is_null($hide_person_name)) {
            throw new \InvalidArgumentException('non-nullable hide_person_name cannot be null');
        }
        $this->container['hide_person_name'] = $hide_person_name;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets send_reminder_mails
     *
     * @return bool|null
     */
    public function getSendReminderMails()
    {
        return $this->container['send_reminder_mails'];
    }

    /**
     * Sets send_reminder_mails
     *
     * @param bool|null $send_reminder_mails send_reminder_mails
     *
     * @return self
     */
    public function setSendReminderMails($send_reminder_mails)
    {
        if (is_null($send_reminder_mails)) {
            throw new \InvalidArgumentException('non-nullable send_reminder_mails cannot be null');
        }
        $this->container['send_reminder_mails'] = $send_reminder_mails;

        return $this;
    }

    /**
     * Gets send_service_request_emails
     *
     * @return bool|null
     */
    public function getSendServiceRequestEmails()
    {
        return $this->container['send_service_request_emails'];
    }

    /**
     * Sets send_service_request_emails
     *
     * @param bool|null $send_service_request_emails send_service_request_emails
     *
     * @return self
     */
    public function setSendServiceRequestEmails($send_service_request_emails)
    {
        if (is_null($send_service_request_emails)) {
            throw new \InvalidArgumentException('non-nullable send_service_request_emails cannot be null');
        }
        $this->container['send_service_request_emails'] = $send_service_request_emails;

        return $this;
    }

    /**
     * Gets service_group_id
     *
     * @return int|null
     */
    public function getServiceGroupId()
    {
        return $this->container['service_group_id'];
    }

    /**
     * Sets service_group_id
     *
     * @param int|null $service_group_id service_group_id
     *
     * @return self
     */
    public function setServiceGroupId($service_group_id)
    {
        if (is_null($service_group_id)) {
            throw new \InvalidArgumentException('non-nullable service_group_id cannot be null');
        }
        $this->container['service_group_id'] = $service_group_id;

        return $this;
    }

    /**
     * Gets sort_key
     *
     * @return int|null
     */
    public function getSortKey()
    {
        return $this->container['sort_key'];
    }

    /**
     * Sets sort_key
     *
     * @param int|null $sort_key sort_key
     *
     * @return self
     */
    public function setSortKey($sort_key)
    {
        if (is_null($sort_key)) {
            throw new \InvalidArgumentException('non-nullable sort_key cannot be null');
        }
        $this->container['sort_key'] = $sort_key;

        return $this;
    }

    /**
     * Gets standard
     *
     * @return bool|null
     */
    public function getStandard()
    {
        return $this->container['standard'];
    }

    /**
     * Sets standard
     *
     * @param bool|null $standard standard
     *
     * @return self
     */
    public function setStandard($standard)
    {
        if (is_null($standard)) {
            throw new \InvalidArgumentException('non-nullable standard cannot be null');
        }
        $this->container['standard'] = $standard;

        return $this;
    }

    /**
     * Gets tag_ids
     *
     * @return string|null
     */
    public function getTagIds()
    {
        return $this->container['tag_ids'];
    }

    /**
     * Sets tag_ids
     *
     * @param string|null $tag_ids tag_ids
     *
     * @return self
     */
    public function setTagIds($tag_ids)
    {
        if (is_null($tag_ids)) {
            throw new \InvalidArgumentException('non-nullable tag_ids cannot be null');
        }
        $this->container['tag_ids'] = $tag_ids;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


