<?php
/**
 * FieldMappingEntry
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * FieldMappingEntry Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class FieldMappingEntry implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Field_Mapping_Entry';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'from' => 'string',
        'from_filter' => 'string',
        'id' => 'int',
        'others' => 'mixed[]',
        'system' => 'string',
        'to' => 'string',
        'to_filter' => 'string',
        'value_mapping' => 'mixed[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'from' => null,
        'from_filter' => null,
        'id' => null,
        'others' => null,
        'system' => null,
        'to' => null,
        'to_filter' => null,
        'value_mapping' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'from' => false,
        'from_filter' => false,
        'id' => false,
        'others' => false,
        'system' => false,
        'to' => false,
        'to_filter' => false,
        'value_mapping' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'from' => 'from',
        'from_filter' => 'fromFilter',
        'id' => 'id',
        'others' => 'others',
        'system' => 'system',
        'to' => 'to',
        'to_filter' => 'toFilter',
        'value_mapping' => 'valueMapping'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'from' => 'setFrom',
        'from_filter' => 'setFromFilter',
        'id' => 'setId',
        'others' => 'setOthers',
        'system' => 'setSystem',
        'to' => 'setTo',
        'to_filter' => 'setToFilter',
        'value_mapping' => 'setValueMapping'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'from' => 'getFrom',
        'from_filter' => 'getFromFilter',
        'id' => 'getId',
        'others' => 'getOthers',
        'system' => 'getSystem',
        'to' => 'getTo',
        'to_filter' => 'getToFilter',
        'value_mapping' => 'getValueMapping'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const SYSTEM_MASTER = 'master';
    public const SYSTEM_EXTERNAL_SYSTEM = 'externalSystem';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSystemAllowableValues()
    {
        return [
            self::SYSTEM_MASTER,
            self::SYSTEM_EXTERNAL_SYSTEM,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('from', $data ?? [], null);
        $this->setIfExists('from_filter', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('others', $data ?? [], null);
        $this->setIfExists('system', $data ?? [], null);
        $this->setIfExists('to', $data ?? [], null);
        $this->setIfExists('to_filter', $data ?? [], null);
        $this->setIfExists('value_mapping', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['from'] === null) {
            $invalidProperties[] = "'from' can't be null";
        }
        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['system'] === null) {
            $invalidProperties[] = "'system' can't be null";
        }
        $allowedValues = $this->getSystemAllowableValues();
        if (!is_null($this->container['system']) && !in_array($this->container['system'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'system', must be one of '%s'",
                $this->container['system'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['to'] === null) {
            $invalidProperties[] = "'to' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets from
     *
     * @return string
     */
    public function getFrom()
    {
        return $this->container['from'];
    }

    /**
     * Sets from
     *
     * @param string $from from
     *
     * @return self
     */
    public function setFrom($from)
    {
        if (is_null($from)) {
            throw new \InvalidArgumentException('non-nullable from cannot be null');
        }
        $this->container['from'] = $from;

        return $this;
    }

    /**
     * Gets from_filter
     *
     * @return string|null
     */
    public function getFromFilter()
    {
        return $this->container['from_filter'];
    }

    /**
     * Sets from_filter
     *
     * @param string|null $from_filter from_filter
     *
     * @return self
     */
    public function setFromFilter($from_filter)
    {
        if (is_null($from_filter)) {
            throw new \InvalidArgumentException('non-nullable from_filter cannot be null');
        }
        $this->container['from_filter'] = $from_filter;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets others
     *
     * @return mixed[]|null
     */
    public function getOthers()
    {
        return $this->container['others'];
    }

    /**
     * Sets others
     *
     * @param mixed[]|null $others others
     *
     * @return self
     */
    public function setOthers($others)
    {
        if (is_null($others)) {
            throw new \InvalidArgumentException('non-nullable others cannot be null');
        }
        $this->container['others'] = $others;

        return $this;
    }

    /**
     * Gets system
     *
     * @return string
     */
    public function getSystem()
    {
        return $this->container['system'];
    }

    /**
     * Sets system
     *
     * @param string $system system
     *
     * @return self
     */
    public function setSystem($system)
    {
        if (is_null($system)) {
            throw new \InvalidArgumentException('non-nullable system cannot be null');
        }
        $allowedValues = $this->getSystemAllowableValues();
        if (!in_array($system, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'system', must be one of '%s'",
                    $system,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['system'] = $system;

        return $this;
    }

    /**
     * Gets to
     *
     * @return string
     */
    public function getTo()
    {
        return $this->container['to'];
    }

    /**
     * Sets to
     *
     * @param string $to to
     *
     * @return self
     */
    public function setTo($to)
    {
        if (is_null($to)) {
            throw new \InvalidArgumentException('non-nullable to cannot be null');
        }
        $this->container['to'] = $to;

        return $this;
    }

    /**
     * Gets to_filter
     *
     * @return string|null
     */
    public function getToFilter()
    {
        return $this->container['to_filter'];
    }

    /**
     * Sets to_filter
     *
     * @param string|null $to_filter to_filter
     *
     * @return self
     */
    public function setToFilter($to_filter)
    {
        if (is_null($to_filter)) {
            throw new \InvalidArgumentException('non-nullable to_filter cannot be null');
        }
        $this->container['to_filter'] = $to_filter;

        return $this;
    }

    /**
     * Gets value_mapping
     *
     * @return mixed[]|null
     */
    public function getValueMapping()
    {
        return $this->container['value_mapping'];
    }

    /**
     * Sets value_mapping
     *
     * @param mixed[]|null $value_mapping value_mapping
     *
     * @return self
     */
    public function setValueMapping($value_mapping)
    {
        if (is_null($value_mapping)) {
            throw new \InvalidArgumentException('non-nullable value_mapping cannot be null');
        }
        $this->container['value_mapping'] = $value_mapping;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


