<?php
/**
 * GetAllCampuses200ResponseDataInner
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * GetAllCampuses200ResponseDataInner Class Doc Comment
 *
 * @category Class
 * @description Profiles are representing campuses and the church itself.
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class GetAllCampuses200ResponseDataInner implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'getAllCampuses_200_response_data_inner';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'address' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerAddress',
        'association' => 'object',
        'banner' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerBanner',
        'denomination' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerDenomination',
        'description' => 'string',
        'email' => 'string',
        'finder_url' => 'string',
        'gallery' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerBanner[]',
        'groups' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerGroupsInner[]',
        'guid' => 'string',
        'id' => 'int',
        'is_published' => 'bool',
        'logo' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerBanner',
        'meta' => '\StevenBuehner\ChurchTools\Model\GetBookings200ResponseDataInnerBaseMeta',
        'name' => 'string',
        'name_translated' => 'string',
        'phone' => 'string',
        'profile_type' => 'string',
        'service_banner' => 'string',
        'services' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerServicesInner[]',
        'short_name' => 'string',
        'shorty' => 'string',
        'sign_up_group' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerGroupsInnerGroup',
        'slug' => 'string',
        'social_media' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerSocialMedia',
        'sort_key' => 'int',
        'tags' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerTagsInner[]',
        'team' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerTeamInner[]',
        'team_title' => 'string',
        'visitors' => 'int',
        'website' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'address' => null,
        'association' => null,
        'banner' => null,
        'denomination' => null,
        'description' => null,
        'email' => null,
        'finder_url' => null,
        'gallery' => null,
        'groups' => null,
        'guid' => null,
        'id' => null,
        'is_published' => null,
        'logo' => null,
        'meta' => null,
        'name' => null,
        'name_translated' => null,
        'phone' => null,
        'profile_type' => null,
        'service_banner' => null,
        'services' => null,
        'short_name' => null,
        'shorty' => null,
        'sign_up_group' => null,
        'slug' => null,
        'social_media' => null,
        'sort_key' => null,
        'tags' => null,
        'team' => null,
        'team_title' => null,
        'visitors' => null,
        'website' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'address' => false,
        'association' => false,
        'banner' => false,
        'denomination' => false,
        'description' => false,
        'email' => false,
        'finder_url' => false,
        'gallery' => false,
        'groups' => false,
        'guid' => false,
        'id' => false,
        'is_published' => false,
        'logo' => false,
        'meta' => false,
        'name' => false,
        'name_translated' => false,
        'phone' => false,
        'profile_type' => false,
        'service_banner' => false,
        'services' => false,
        'short_name' => false,
        'shorty' => false,
        'sign_up_group' => false,
        'slug' => false,
        'social_media' => false,
        'sort_key' => false,
        'tags' => false,
        'team' => false,
        'team_title' => false,
        'visitors' => false,
        'website' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'address' => 'address',
        'association' => 'association',
        'banner' => 'banner',
        'denomination' => 'denomination',
        'description' => 'description',
        'email' => 'email',
        'finder_url' => 'finderUrl',
        'gallery' => 'gallery',
        'groups' => 'groups',
        'guid' => 'guid',
        'id' => 'id',
        'is_published' => 'isPublished',
        'logo' => 'logo',
        'meta' => 'meta',
        'name' => 'name',
        'name_translated' => 'nameTranslated',
        'phone' => 'phone',
        'profile_type' => 'profileType',
        'service_banner' => 'serviceBanner',
        'services' => 'services',
        'short_name' => 'shortName',
        'shorty' => 'shorty',
        'sign_up_group' => 'signUpGroup',
        'slug' => 'slug',
        'social_media' => 'socialMedia',
        'sort_key' => 'sortKey',
        'tags' => 'tags',
        'team' => 'team',
        'team_title' => 'teamTitle',
        'visitors' => 'visitors',
        'website' => 'website'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'address' => 'setAddress',
        'association' => 'setAssociation',
        'banner' => 'setBanner',
        'denomination' => 'setDenomination',
        'description' => 'setDescription',
        'email' => 'setEmail',
        'finder_url' => 'setFinderUrl',
        'gallery' => 'setGallery',
        'groups' => 'setGroups',
        'guid' => 'setGuid',
        'id' => 'setId',
        'is_published' => 'setIsPublished',
        'logo' => 'setLogo',
        'meta' => 'setMeta',
        'name' => 'setName',
        'name_translated' => 'setNameTranslated',
        'phone' => 'setPhone',
        'profile_type' => 'setProfileType',
        'service_banner' => 'setServiceBanner',
        'services' => 'setServices',
        'short_name' => 'setShortName',
        'shorty' => 'setShorty',
        'sign_up_group' => 'setSignUpGroup',
        'slug' => 'setSlug',
        'social_media' => 'setSocialMedia',
        'sort_key' => 'setSortKey',
        'tags' => 'setTags',
        'team' => 'setTeam',
        'team_title' => 'setTeamTitle',
        'visitors' => 'setVisitors',
        'website' => 'setWebsite'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'address' => 'getAddress',
        'association' => 'getAssociation',
        'banner' => 'getBanner',
        'denomination' => 'getDenomination',
        'description' => 'getDescription',
        'email' => 'getEmail',
        'finder_url' => 'getFinderUrl',
        'gallery' => 'getGallery',
        'groups' => 'getGroups',
        'guid' => 'getGuid',
        'id' => 'getId',
        'is_published' => 'getIsPublished',
        'logo' => 'getLogo',
        'meta' => 'getMeta',
        'name' => 'getName',
        'name_translated' => 'getNameTranslated',
        'phone' => 'getPhone',
        'profile_type' => 'getProfileType',
        'service_banner' => 'getServiceBanner',
        'services' => 'getServices',
        'short_name' => 'getShortName',
        'shorty' => 'getShorty',
        'sign_up_group' => 'getSignUpGroup',
        'slug' => 'getSlug',
        'social_media' => 'getSocialMedia',
        'sort_key' => 'getSortKey',
        'tags' => 'getTags',
        'team' => 'getTeam',
        'team_title' => 'getTeamTitle',
        'visitors' => 'getVisitors',
        'website' => 'getWebsite'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const PROFILE_TYPE_CHURCH = 'church';
    public const PROFILE_TYPE_CAMPUS = 'campus';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getProfileTypeAllowableValues()
    {
        return [
            self::PROFILE_TYPE_CHURCH,
            self::PROFILE_TYPE_CAMPUS,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('address', $data ?? [], null);
        $this->setIfExists('association', $data ?? [], null);
        $this->setIfExists('banner', $data ?? [], null);
        $this->setIfExists('denomination', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('finder_url', $data ?? [], null);
        $this->setIfExists('gallery', $data ?? [], null);
        $this->setIfExists('groups', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('is_published', $data ?? [], null);
        $this->setIfExists('logo', $data ?? [], null);
        $this->setIfExists('meta', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('name_translated', $data ?? [], null);
        $this->setIfExists('phone', $data ?? [], null);
        $this->setIfExists('profile_type', $data ?? [], null);
        $this->setIfExists('service_banner', $data ?? [], null);
        $this->setIfExists('services', $data ?? [], null);
        $this->setIfExists('short_name', $data ?? [], null);
        $this->setIfExists('shorty', $data ?? [], null);
        $this->setIfExists('sign_up_group', $data ?? [], null);
        $this->setIfExists('slug', $data ?? [], null);
        $this->setIfExists('social_media', $data ?? [], null);
        $this->setIfExists('sort_key', $data ?? [], null);
        $this->setIfExists('tags', $data ?? [], null);
        $this->setIfExists('team', $data ?? [], null);
        $this->setIfExists('team_title', $data ?? [], null);
        $this->setIfExists('visitors', $data ?? [], null);
        $this->setIfExists('website', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['address'] === null) {
            $invalidProperties[] = "'address' can't be null";
        }
        if ($this->container['banner'] === null) {
            $invalidProperties[] = "'banner' can't be null";
        }
        if ($this->container['denomination'] === null) {
            $invalidProperties[] = "'denomination' can't be null";
        }
        if ($this->container['description'] === null) {
            $invalidProperties[] = "'description' can't be null";
        }
        if ((mb_strlen($this->container['description']) < 0)) {
            $invalidProperties[] = "invalid value for 'description', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['email'] === null) {
            $invalidProperties[] = "'email' can't be null";
        }
        if ((mb_strlen($this->container['email']) < 1)) {
            $invalidProperties[] = "invalid value for 'email', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['finder_url'] === null) {
            $invalidProperties[] = "'finder_url' can't be null";
        }
        if ((mb_strlen($this->container['finder_url']) < 1)) {
            $invalidProperties[] = "invalid value for 'finder_url', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['gallery'] === null) {
            $invalidProperties[] = "'gallery' can't be null";
        }
        if ((count($this->container['gallery']) < 0)) {
            $invalidProperties[] = "invalid value for 'gallery', number of items must be greater than or equal to 0.";
        }

        if ($this->container['groups'] === null) {
            $invalidProperties[] = "'groups' can't be null";
        }
        if ((count($this->container['groups']) < 0)) {
            $invalidProperties[] = "invalid value for 'groups', number of items must be greater than or equal to 0.";
        }

        if ($this->container['guid'] === null) {
            $invalidProperties[] = "'guid' can't be null";
        }
        if ((mb_strlen($this->container['guid']) < 1)) {
            $invalidProperties[] = "invalid value for 'guid', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['is_published'] === null) {
            $invalidProperties[] = "'is_published' can't be null";
        }
        if ($this->container['logo'] === null) {
            $invalidProperties[] = "'logo' can't be null";
        }
        if ($this->container['meta'] === null) {
            $invalidProperties[] = "'meta' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ((mb_strlen($this->container['name']) < 1)) {
            $invalidProperties[] = "invalid value for 'name', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['name_translated'] === null) {
            $invalidProperties[] = "'name_translated' can't be null";
        }
        if ((mb_strlen($this->container['name_translated']) < 1)) {
            $invalidProperties[] = "invalid value for 'name_translated', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['phone'] === null) {
            $invalidProperties[] = "'phone' can't be null";
        }
        if ((mb_strlen($this->container['phone']) < 1)) {
            $invalidProperties[] = "invalid value for 'phone', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['profile_type'] === null) {
            $invalidProperties[] = "'profile_type' can't be null";
        }
        $allowedValues = $this->getProfileTypeAllowableValues();
        if (!is_null($this->container['profile_type']) && !in_array($this->container['profile_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'profile_type', must be one of '%s'",
                $this->container['profile_type'],
                implode("', '", $allowedValues)
            );
        }

        if ((mb_strlen($this->container['profile_type']) < 1)) {
            $invalidProperties[] = "invalid value for 'profile_type', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['service_banner'] === null) {
            $invalidProperties[] = "'service_banner' can't be null";
        }
        if ((mb_strlen($this->container['service_banner']) < 1)) {
            $invalidProperties[] = "invalid value for 'service_banner', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['services'] === null) {
            $invalidProperties[] = "'services' can't be null";
        }
        if ((count($this->container['services']) < 0)) {
            $invalidProperties[] = "invalid value for 'services', number of items must be greater than or equal to 0.";
        }

        if ($this->container['short_name'] === null) {
            $invalidProperties[] = "'short_name' can't be null";
        }
        if ((mb_strlen($this->container['short_name']) < 0)) {
            $invalidProperties[] = "invalid value for 'short_name', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['shorty'] === null) {
            $invalidProperties[] = "'shorty' can't be null";
        }
        if ((mb_strlen($this->container['shorty']) < 1)) {
            $invalidProperties[] = "invalid value for 'shorty', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['slug'] === null) {
            $invalidProperties[] = "'slug' can't be null";
        }
        if ((mb_strlen($this->container['slug']) < 1)) {
            $invalidProperties[] = "invalid value for 'slug', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['social_media'] === null) {
            $invalidProperties[] = "'social_media' can't be null";
        }
        if ($this->container['sort_key'] === null) {
            $invalidProperties[] = "'sort_key' can't be null";
        }
        if ($this->container['tags'] === null) {
            $invalidProperties[] = "'tags' can't be null";
        }
        if ($this->container['team'] === null) {
            $invalidProperties[] = "'team' can't be null";
        }
        if ((count($this->container['team']) < 0)) {
            $invalidProperties[] = "invalid value for 'team', number of items must be greater than or equal to 0.";
        }

        if ($this->container['team_title'] === null) {
            $invalidProperties[] = "'team_title' can't be null";
        }
        if ((mb_strlen($this->container['team_title']) < 1)) {
            $invalidProperties[] = "invalid value for 'team_title', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['visitors'] === null) {
            $invalidProperties[] = "'visitors' can't be null";
        }
        if ($this->container['website'] === null) {
            $invalidProperties[] = "'website' can't be null";
        }
        if ((mb_strlen($this->container['website']) < 1)) {
            $invalidProperties[] = "invalid value for 'website', the character length must be bigger than or equal to 1.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets address
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerAddress
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerAddress $address address
     *
     * @return self
     */
    public function setAddress($address)
    {
        if (is_null($address)) {
            throw new \InvalidArgumentException('non-nullable address cannot be null');
        }
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets association
     *
     * @return object|null
     */
    public function getAssociation()
    {
        return $this->container['association'];
    }

    /**
     * Sets association
     *
     * @param object|null $association Will be the same for all profiles.
     *
     * @return self
     */
    public function setAssociation($association)
    {
        if (is_null($association)) {
            throw new \InvalidArgumentException('non-nullable association cannot be null');
        }
        $this->container['association'] = $association;

        return $this;
    }

    /**
     * Gets banner
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerBanner
     */
    public function getBanner()
    {
        return $this->container['banner'];
    }

    /**
     * Sets banner
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerBanner $banner banner
     *
     * @return self
     */
    public function setBanner($banner)
    {
        if (is_null($banner)) {
            throw new \InvalidArgumentException('non-nullable banner cannot be null');
        }
        $this->container['banner'] = $banner;

        return $this;
    }

    /**
     * Gets denomination
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerDenomination
     */
    public function getDenomination()
    {
        return $this->container['denomination'];
    }

    /**
     * Sets denomination
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerDenomination $denomination denomination
     *
     * @return self
     */
    public function setDenomination($denomination)
    {
        if (is_null($denomination)) {
            throw new \InvalidArgumentException('non-nullable denomination cannot be null');
        }
        $this->container['denomination'] = $denomination;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }

        if ((mb_strlen($description) < 0)) {
            throw new \InvalidArgumentException('invalid length for $description when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 0.');
        }

        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string $email email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }

        if ((mb_strlen($email) < 1)) {
            throw new \InvalidArgumentException('invalid length for $email when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets finder_url
     *
     * @return string
     */
    public function getFinderUrl()
    {
        return $this->container['finder_url'];
    }

    /**
     * Sets finder_url
     *
     * @param string $finder_url finder_url
     *
     * @return self
     */
    public function setFinderUrl($finder_url)
    {
        if (is_null($finder_url)) {
            throw new \InvalidArgumentException('non-nullable finder_url cannot be null');
        }

        if ((mb_strlen($finder_url) < 1)) {
            throw new \InvalidArgumentException('invalid length for $finder_url when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['finder_url'] = $finder_url;

        return $this;
    }

    /**
     * Gets gallery
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerBanner[]
     */
    public function getGallery()
    {
        return $this->container['gallery'];
    }

    /**
     * Sets gallery
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerBanner[] $gallery gallery
     *
     * @return self
     */
    public function setGallery($gallery)
    {
        if (is_null($gallery)) {
            throw new \InvalidArgumentException('non-nullable gallery cannot be null');
        }


        if ((count($gallery) < 0)) {
            throw new \InvalidArgumentException('invalid length for $gallery when calling GetAllCampuses200ResponseDataInner., number of items must be greater than or equal to 0.');
        }
        $this->container['gallery'] = $gallery;

        return $this;
    }

    /**
     * Gets groups
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerGroupsInner[]
     */
    public function getGroups()
    {
        return $this->container['groups'];
    }

    /**
     * Sets groups
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerGroupsInner[] $groups groups
     *
     * @return self
     */
    public function setGroups($groups)
    {
        if (is_null($groups)) {
            throw new \InvalidArgumentException('non-nullable groups cannot be null');
        }


        if ((count($groups) < 0)) {
            throw new \InvalidArgumentException('invalid length for $groups when calling GetAllCampuses200ResponseDataInner., number of items must be greater than or equal to 0.');
        }
        $this->container['groups'] = $groups;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }

        if ((mb_strlen($guid) < 1)) {
            throw new \InvalidArgumentException('invalid length for $guid when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets is_published
     *
     * @return bool
     */
    public function getIsPublished()
    {
        return $this->container['is_published'];
    }

    /**
     * Sets is_published
     *
     * @param bool $is_published is_published
     *
     * @return self
     */
    public function setIsPublished($is_published)
    {
        if (is_null($is_published)) {
            throw new \InvalidArgumentException('non-nullable is_published cannot be null');
        }
        $this->container['is_published'] = $is_published;

        return $this;
    }

    /**
     * Gets logo
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerBanner
     */
    public function getLogo()
    {
        return $this->container['logo'];
    }

    /**
     * Sets logo
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerBanner $logo logo
     *
     * @return self
     */
    public function setLogo($logo)
    {
        if (is_null($logo)) {
            throw new \InvalidArgumentException('non-nullable logo cannot be null');
        }
        $this->container['logo'] = $logo;

        return $this;
    }

    /**
     * Gets meta
     *
     * @return \StevenBuehner\ChurchTools\Model\GetBookings200ResponseDataInnerBaseMeta
     */
    public function getMeta()
    {
        return $this->container['meta'];
    }

    /**
     * Sets meta
     *
     * @param \StevenBuehner\ChurchTools\Model\GetBookings200ResponseDataInnerBaseMeta $meta meta
     *
     * @return self
     */
    public function setMeta($meta)
    {
        if (is_null($meta)) {
            throw new \InvalidArgumentException('non-nullable meta cannot be null');
        }
        $this->container['meta'] = $meta;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }

        if ((mb_strlen($name) < 1)) {
            throw new \InvalidArgumentException('invalid length for $name when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets name_translated
     *
     * @return string
     */
    public function getNameTranslated()
    {
        return $this->container['name_translated'];
    }

    /**
     * Sets name_translated
     *
     * @param string $name_translated name_translated
     *
     * @return self
     */
    public function setNameTranslated($name_translated)
    {
        if (is_null($name_translated)) {
            throw new \InvalidArgumentException('non-nullable name_translated cannot be null');
        }

        if ((mb_strlen($name_translated) < 1)) {
            throw new \InvalidArgumentException('invalid length for $name_translated when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['name_translated'] = $name_translated;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string $phone phone
     *
     * @return self
     */
    public function setPhone($phone)
    {
        if (is_null($phone)) {
            throw new \InvalidArgumentException('non-nullable phone cannot be null');
        }

        if ((mb_strlen($phone) < 1)) {
            throw new \InvalidArgumentException('invalid length for $phone when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets profile_type
     *
     * @return string
     */
    public function getProfileType()
    {
        return $this->container['profile_type'];
    }

    /**
     * Sets profile_type
     *
     * @param string $profile_type church: Church profile for this installation; campus: one specific campus profile
     *
     * @return self
     */
    public function setProfileType($profile_type)
    {
        if (is_null($profile_type)) {
            throw new \InvalidArgumentException('non-nullable profile_type cannot be null');
        }
        $allowedValues = $this->getProfileTypeAllowableValues();
        if (!in_array($profile_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'profile_type', must be one of '%s'",
                    $profile_type,
                    implode("', '", $allowedValues)
                )
            );
        }

        if ((mb_strlen($profile_type) < 1)) {
            throw new \InvalidArgumentException('invalid length for $profile_type when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['profile_type'] = $profile_type;

        return $this;
    }

    /**
     * Gets service_banner
     *
     * @return string
     */
    public function getServiceBanner()
    {
        return $this->container['service_banner'];
    }

    /**
     * Sets service_banner
     *
     * @param string $service_banner service_banner
     *
     * @return self
     */
    public function setServiceBanner($service_banner)
    {
        if (is_null($service_banner)) {
            throw new \InvalidArgumentException('non-nullable service_banner cannot be null');
        }

        if ((mb_strlen($service_banner) < 1)) {
            throw new \InvalidArgumentException('invalid length for $service_banner when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['service_banner'] = $service_banner;

        return $this;
    }

    /**
     * Gets services
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerServicesInner[]
     */
    public function getServices()
    {
        return $this->container['services'];
    }

    /**
     * Sets services
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerServicesInner[] $services services
     *
     * @return self
     */
    public function setServices($services)
    {
        if (is_null($services)) {
            throw new \InvalidArgumentException('non-nullable services cannot be null');
        }


        if ((count($services) < 0)) {
            throw new \InvalidArgumentException('invalid length for $services when calling GetAllCampuses200ResponseDataInner., number of items must be greater than or equal to 0.');
        }
        $this->container['services'] = $services;

        return $this;
    }

    /**
     * Gets short_name
     *
     * @return string
     */
    public function getShortName()
    {
        return $this->container['short_name'];
    }

    /**
     * Sets short_name
     *
     * @param string $short_name short_name
     *
     * @return self
     */
    public function setShortName($short_name)
    {
        if (is_null($short_name)) {
            throw new \InvalidArgumentException('non-nullable short_name cannot be null');
        }

        if ((mb_strlen($short_name) < 0)) {
            throw new \InvalidArgumentException('invalid length for $short_name when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 0.');
        }

        $this->container['short_name'] = $short_name;

        return $this;
    }

    /**
     * Gets shorty
     *
     * @return string
     */
    public function getShorty()
    {
        return $this->container['shorty'];
    }

    /**
     * Sets shorty
     *
     * @param string $shorty shorty
     *
     * @return self
     */
    public function setShorty($shorty)
    {
        if (is_null($shorty)) {
            throw new \InvalidArgumentException('non-nullable shorty cannot be null');
        }

        if ((mb_strlen($shorty) < 1)) {
            throw new \InvalidArgumentException('invalid length for $shorty when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['shorty'] = $shorty;

        return $this;
    }

    /**
     * Gets sign_up_group
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerGroupsInnerGroup|null
     */
    public function getSignUpGroup()
    {
        return $this->container['sign_up_group'];
    }

    /**
     * Sets sign_up_group
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerGroupsInnerGroup|null $sign_up_group sign_up_group
     *
     * @return self
     */
    public function setSignUpGroup($sign_up_group)
    {
        if (is_null($sign_up_group)) {
            throw new \InvalidArgumentException('non-nullable sign_up_group cannot be null');
        }
        $this->container['sign_up_group'] = $sign_up_group;

        return $this;
    }

    /**
     * Gets slug
     *
     * @return string
     */
    public function getSlug()
    {
        return $this->container['slug'];
    }

    /**
     * Sets slug
     *
     * @param string $slug slug
     *
     * @return self
     */
    public function setSlug($slug)
    {
        if (is_null($slug)) {
            throw new \InvalidArgumentException('non-nullable slug cannot be null');
        }

        if ((mb_strlen($slug) < 1)) {
            throw new \InvalidArgumentException('invalid length for $slug when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['slug'] = $slug;

        return $this;
    }

    /**
     * Gets social_media
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerSocialMedia
     */
    public function getSocialMedia()
    {
        return $this->container['social_media'];
    }

    /**
     * Sets social_media
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerSocialMedia $social_media social_media
     *
     * @return self
     */
    public function setSocialMedia($social_media)
    {
        if (is_null($social_media)) {
            throw new \InvalidArgumentException('non-nullable social_media cannot be null');
        }
        $this->container['social_media'] = $social_media;

        return $this;
    }

    /**
     * Gets sort_key
     *
     * @return int
     */
    public function getSortKey()
    {
        return $this->container['sort_key'];
    }

    /**
     * Sets sort_key
     *
     * @param int $sort_key sort_key
     *
     * @return self
     */
    public function setSortKey($sort_key)
    {
        if (is_null($sort_key)) {
            throw new \InvalidArgumentException('non-nullable sort_key cannot be null');
        }
        $this->container['sort_key'] = $sort_key;

        return $this;
    }

    /**
     * Gets tags
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerTagsInner[]
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerTagsInner[] $tags tags
     *
     * @return self
     */
    public function setTags($tags)
    {
        if (is_null($tags)) {
            throw new \InvalidArgumentException('non-nullable tags cannot be null');
        }
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets team
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerTeamInner[]
     */
    public function getTeam()
    {
        return $this->container['team'];
    }

    /**
     * Sets team
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerTeamInner[] $team team
     *
     * @return self
     */
    public function setTeam($team)
    {
        if (is_null($team)) {
            throw new \InvalidArgumentException('non-nullable team cannot be null');
        }


        if ((count($team) < 0)) {
            throw new \InvalidArgumentException('invalid length for $team when calling GetAllCampuses200ResponseDataInner., number of items must be greater than or equal to 0.');
        }
        $this->container['team'] = $team;

        return $this;
    }

    /**
     * Gets team_title
     *
     * @return string
     */
    public function getTeamTitle()
    {
        return $this->container['team_title'];
    }

    /**
     * Sets team_title
     *
     * @param string $team_title team_title
     *
     * @return self
     */
    public function setTeamTitle($team_title)
    {
        if (is_null($team_title)) {
            throw new \InvalidArgumentException('non-nullable team_title cannot be null');
        }

        if ((mb_strlen($team_title) < 1)) {
            throw new \InvalidArgumentException('invalid length for $team_title when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['team_title'] = $team_title;

        return $this;
    }

    /**
     * Gets visitors
     *
     * @return int
     */
    public function getVisitors()
    {
        return $this->container['visitors'];
    }

    /**
     * Sets visitors
     *
     * @param int $visitors visitors
     *
     * @return self
     */
    public function setVisitors($visitors)
    {
        if (is_null($visitors)) {
            throw new \InvalidArgumentException('non-nullable visitors cannot be null');
        }
        $this->container['visitors'] = $visitors;

        return $this;
    }

    /**
     * Gets website
     *
     * @return string
     */
    public function getWebsite()
    {
        return $this->container['website'];
    }

    /**
     * Sets website
     *
     * @param string $website website
     *
     * @return self
     */
    public function setWebsite($website)
    {
        if (is_null($website)) {
            throw new \InvalidArgumentException('non-nullable website cannot be null');
        }

        if ((mb_strlen($website) < 1)) {
            throw new \InvalidArgumentException('invalid length for $website when calling GetAllCampuses200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['website'] = $website;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


