<?php
/**
 * GetPermissionsInternalGroupsGroupId200ResponseDataChurchdb
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * GetPermissionsInternalGroupsGroupId200ResponseDataChurchdb Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class GetPermissionsInternalGroupsGroupId200ResponseDataChurchdb implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'get_permissions_internal_groups_groupId_200_response_data_churchdb';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'add_person' => 'bool',
        'admin_automatic_emails' => 'bool',
        'admin_group_chat' => 'bool',
        'admin_group_fields' => 'bool',
        'do_followup' => 'bool',
        'do_group_meeting' => 'bool',
        'edit_group' => 'bool',
        'edit_group_hierachy' => 'bool',
        'edit_groupmemberstatus' => 'bool',
        'export_group_members' => 'bool',
        'get_emails' => 'bool',
        'remove_from_group' => 'bool',
        'see_group' => 'int',
        'see_group_tags' => 'bool',
        'see_hidden_group' => 'bool',
        'see_persons' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'add_person' => null,
        'admin_automatic_emails' => null,
        'admin_group_chat' => null,
        'admin_group_fields' => null,
        'do_followup' => null,
        'do_group_meeting' => null,
        'edit_group' => null,
        'edit_group_hierachy' => null,
        'edit_groupmemberstatus' => null,
        'export_group_members' => null,
        'get_emails' => null,
        'remove_from_group' => null,
        'see_group' => null,
        'see_group_tags' => null,
        'see_hidden_group' => null,
        'see_persons' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'add_person' => false,
        'admin_automatic_emails' => false,
        'admin_group_chat' => false,
        'admin_group_fields' => false,
        'do_followup' => false,
        'do_group_meeting' => false,
        'edit_group' => false,
        'edit_group_hierachy' => false,
        'edit_groupmemberstatus' => false,
        'export_group_members' => false,
        'get_emails' => false,
        'remove_from_group' => false,
        'see_group' => false,
        'see_group_tags' => false,
        'see_hidden_group' => false,
        'see_persons' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'add_person' => '+add person',
        'admin_automatic_emails' => '+admin automatic emails',
        'admin_group_chat' => '+admin group chat',
        'admin_group_fields' => '+admin group fields',
        'do_followup' => '+do followup',
        'do_group_meeting' => '+do group meeting',
        'edit_group' => '+edit group',
        'edit_group_hierachy' => '+edit group hierachy',
        'edit_groupmemberstatus' => '+edit groupmemberstatus',
        'export_group_members' => '+export group members',
        'get_emails' => '+get emails',
        'remove_from_group' => '+remove from group',
        'see_group' => '+see group',
        'see_group_tags' => '+see group tags',
        'see_hidden_group' => '+see hidden group',
        'see_persons' => '+see persons'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'add_person' => 'setAddPerson',
        'admin_automatic_emails' => 'setAdminAutomaticEmails',
        'admin_group_chat' => 'setAdminGroupChat',
        'admin_group_fields' => 'setAdminGroupFields',
        'do_followup' => 'setDoFollowup',
        'do_group_meeting' => 'setDoGroupMeeting',
        'edit_group' => 'setEditGroup',
        'edit_group_hierachy' => 'setEditGroupHierachy',
        'edit_groupmemberstatus' => 'setEditGroupmemberstatus',
        'export_group_members' => 'setExportGroupMembers',
        'get_emails' => 'setGetEmails',
        'remove_from_group' => 'setRemoveFromGroup',
        'see_group' => 'setSeeGroup',
        'see_group_tags' => 'setSeeGroupTags',
        'see_hidden_group' => 'setSeeHiddenGroup',
        'see_persons' => 'setSeePersons'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'add_person' => 'getAddPerson',
        'admin_automatic_emails' => 'getAdminAutomaticEmails',
        'admin_group_chat' => 'getAdminGroupChat',
        'admin_group_fields' => 'getAdminGroupFields',
        'do_followup' => 'getDoFollowup',
        'do_group_meeting' => 'getDoGroupMeeting',
        'edit_group' => 'getEditGroup',
        'edit_group_hierachy' => 'getEditGroupHierachy',
        'edit_groupmemberstatus' => 'getEditGroupmemberstatus',
        'export_group_members' => 'getExportGroupMembers',
        'get_emails' => 'getGetEmails',
        'remove_from_group' => 'getRemoveFromGroup',
        'see_group' => 'getSeeGroup',
        'see_group_tags' => 'getSeeGroupTags',
        'see_hidden_group' => 'getSeeHiddenGroup',
        'see_persons' => 'getSeePersons'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('add_person', $data ?? [], null);
        $this->setIfExists('admin_automatic_emails', $data ?? [], null);
        $this->setIfExists('admin_group_chat', $data ?? [], null);
        $this->setIfExists('admin_group_fields', $data ?? [], null);
        $this->setIfExists('do_followup', $data ?? [], null);
        $this->setIfExists('do_group_meeting', $data ?? [], null);
        $this->setIfExists('edit_group', $data ?? [], null);
        $this->setIfExists('edit_group_hierachy', $data ?? [], null);
        $this->setIfExists('edit_groupmemberstatus', $data ?? [], null);
        $this->setIfExists('export_group_members', $data ?? [], null);
        $this->setIfExists('get_emails', $data ?? [], null);
        $this->setIfExists('remove_from_group', $data ?? [], null);
        $this->setIfExists('see_group', $data ?? [], null);
        $this->setIfExists('see_group_tags', $data ?? [], null);
        $this->setIfExists('see_hidden_group', $data ?? [], null);
        $this->setIfExists('see_persons', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets add_person
     *
     * @return bool|null
     */
    public function getAddPerson()
    {
        return $this->container['add_person'];
    }

    /**
     * Sets add_person
     *
     * @param bool|null $add_person add_person
     *
     * @return self
     */
    public function setAddPerson($add_person)
    {
        if (is_null($add_person)) {
            throw new \InvalidArgumentException('non-nullable add_person cannot be null');
        }
        $this->container['add_person'] = $add_person;

        return $this;
    }

    /**
     * Gets admin_automatic_emails
     *
     * @return bool|null
     */
    public function getAdminAutomaticEmails()
    {
        return $this->container['admin_automatic_emails'];
    }

    /**
     * Sets admin_automatic_emails
     *
     * @param bool|null $admin_automatic_emails admin_automatic_emails
     *
     * @return self
     */
    public function setAdminAutomaticEmails($admin_automatic_emails)
    {
        if (is_null($admin_automatic_emails)) {
            throw new \InvalidArgumentException('non-nullable admin_automatic_emails cannot be null');
        }
        $this->container['admin_automatic_emails'] = $admin_automatic_emails;

        return $this;
    }

    /**
     * Gets admin_group_chat
     *
     * @return bool|null
     */
    public function getAdminGroupChat()
    {
        return $this->container['admin_group_chat'];
    }

    /**
     * Sets admin_group_chat
     *
     * @param bool|null $admin_group_chat admin_group_chat
     *
     * @return self
     */
    public function setAdminGroupChat($admin_group_chat)
    {
        if (is_null($admin_group_chat)) {
            throw new \InvalidArgumentException('non-nullable admin_group_chat cannot be null');
        }
        $this->container['admin_group_chat'] = $admin_group_chat;

        return $this;
    }

    /**
     * Gets admin_group_fields
     *
     * @return bool|null
     */
    public function getAdminGroupFields()
    {
        return $this->container['admin_group_fields'];
    }

    /**
     * Sets admin_group_fields
     *
     * @param bool|null $admin_group_fields admin_group_fields
     *
     * @return self
     */
    public function setAdminGroupFields($admin_group_fields)
    {
        if (is_null($admin_group_fields)) {
            throw new \InvalidArgumentException('non-nullable admin_group_fields cannot be null');
        }
        $this->container['admin_group_fields'] = $admin_group_fields;

        return $this;
    }

    /**
     * Gets do_followup
     *
     * @return bool|null
     */
    public function getDoFollowup()
    {
        return $this->container['do_followup'];
    }

    /**
     * Sets do_followup
     *
     * @param bool|null $do_followup do_followup
     *
     * @return self
     */
    public function setDoFollowup($do_followup)
    {
        if (is_null($do_followup)) {
            throw new \InvalidArgumentException('non-nullable do_followup cannot be null');
        }
        $this->container['do_followup'] = $do_followup;

        return $this;
    }

    /**
     * Gets do_group_meeting
     *
     * @return bool|null
     */
    public function getDoGroupMeeting()
    {
        return $this->container['do_group_meeting'];
    }

    /**
     * Sets do_group_meeting
     *
     * @param bool|null $do_group_meeting do_group_meeting
     *
     * @return self
     */
    public function setDoGroupMeeting($do_group_meeting)
    {
        if (is_null($do_group_meeting)) {
            throw new \InvalidArgumentException('non-nullable do_group_meeting cannot be null');
        }
        $this->container['do_group_meeting'] = $do_group_meeting;

        return $this;
    }

    /**
     * Gets edit_group
     *
     * @return bool|null
     */
    public function getEditGroup()
    {
        return $this->container['edit_group'];
    }

    /**
     * Sets edit_group
     *
     * @param bool|null $edit_group edit_group
     *
     * @return self
     */
    public function setEditGroup($edit_group)
    {
        if (is_null($edit_group)) {
            throw new \InvalidArgumentException('non-nullable edit_group cannot be null');
        }
        $this->container['edit_group'] = $edit_group;

        return $this;
    }

    /**
     * Gets edit_group_hierachy
     *
     * @return bool|null
     */
    public function getEditGroupHierachy()
    {
        return $this->container['edit_group_hierachy'];
    }

    /**
     * Sets edit_group_hierachy
     *
     * @param bool|null $edit_group_hierachy edit_group_hierachy
     *
     * @return self
     */
    public function setEditGroupHierachy($edit_group_hierachy)
    {
        if (is_null($edit_group_hierachy)) {
            throw new \InvalidArgumentException('non-nullable edit_group_hierachy cannot be null');
        }
        $this->container['edit_group_hierachy'] = $edit_group_hierachy;

        return $this;
    }

    /**
     * Gets edit_groupmemberstatus
     *
     * @return bool|null
     */
    public function getEditGroupmemberstatus()
    {
        return $this->container['edit_groupmemberstatus'];
    }

    /**
     * Sets edit_groupmemberstatus
     *
     * @param bool|null $edit_groupmemberstatus edit_groupmemberstatus
     *
     * @return self
     */
    public function setEditGroupmemberstatus($edit_groupmemberstatus)
    {
        if (is_null($edit_groupmemberstatus)) {
            throw new \InvalidArgumentException('non-nullable edit_groupmemberstatus cannot be null');
        }
        $this->container['edit_groupmemberstatus'] = $edit_groupmemberstatus;

        return $this;
    }

    /**
     * Gets export_group_members
     *
     * @return bool|null
     */
    public function getExportGroupMembers()
    {
        return $this->container['export_group_members'];
    }

    /**
     * Sets export_group_members
     *
     * @param bool|null $export_group_members export_group_members
     *
     * @return self
     */
    public function setExportGroupMembers($export_group_members)
    {
        if (is_null($export_group_members)) {
            throw new \InvalidArgumentException('non-nullable export_group_members cannot be null');
        }
        $this->container['export_group_members'] = $export_group_members;

        return $this;
    }

    /**
     * Gets get_emails
     *
     * @return bool|null
     */
    public function getGetEmails()
    {
        return $this->container['get_emails'];
    }

    /**
     * Sets get_emails
     *
     * @param bool|null $get_emails get_emails
     *
     * @return self
     */
    public function setGetEmails($get_emails)
    {
        if (is_null($get_emails)) {
            throw new \InvalidArgumentException('non-nullable get_emails cannot be null');
        }
        $this->container['get_emails'] = $get_emails;

        return $this;
    }

    /**
     * Gets remove_from_group
     *
     * @return bool|null
     */
    public function getRemoveFromGroup()
    {
        return $this->container['remove_from_group'];
    }

    /**
     * Sets remove_from_group
     *
     * @param bool|null $remove_from_group remove_from_group
     *
     * @return self
     */
    public function setRemoveFromGroup($remove_from_group)
    {
        if (is_null($remove_from_group)) {
            throw new \InvalidArgumentException('non-nullable remove_from_group cannot be null');
        }
        $this->container['remove_from_group'] = $remove_from_group;

        return $this;
    }

    /**
     * Gets see_group
     *
     * @return int|null
     */
    public function getSeeGroup()
    {
        return $this->container['see_group'];
    }

    /**
     * Sets see_group
     *
     * @param int|null $see_group see_group
     *
     * @return self
     */
    public function setSeeGroup($see_group)
    {
        if (is_null($see_group)) {
            throw new \InvalidArgumentException('non-nullable see_group cannot be null');
        }
        $this->container['see_group'] = $see_group;

        return $this;
    }

    /**
     * Gets see_group_tags
     *
     * @return bool|null
     */
    public function getSeeGroupTags()
    {
        return $this->container['see_group_tags'];
    }

    /**
     * Sets see_group_tags
     *
     * @param bool|null $see_group_tags see_group_tags
     *
     * @return self
     */
    public function setSeeGroupTags($see_group_tags)
    {
        if (is_null($see_group_tags)) {
            throw new \InvalidArgumentException('non-nullable see_group_tags cannot be null');
        }
        $this->container['see_group_tags'] = $see_group_tags;

        return $this;
    }

    /**
     * Gets see_hidden_group
     *
     * @return bool|null
     */
    public function getSeeHiddenGroup()
    {
        return $this->container['see_hidden_group'];
    }

    /**
     * Sets see_hidden_group
     *
     * @param bool|null $see_hidden_group see_hidden_group
     *
     * @return self
     */
    public function setSeeHiddenGroup($see_hidden_group)
    {
        if (is_null($see_hidden_group)) {
            throw new \InvalidArgumentException('non-nullable see_hidden_group cannot be null');
        }
        $this->container['see_hidden_group'] = $see_hidden_group;

        return $this;
    }

    /**
     * Gets see_persons
     *
     * @return int|null
     */
    public function getSeePersons()
    {
        return $this->container['see_persons'];
    }

    /**
     * Sets see_persons
     *
     * @param int|null $see_persons see_persons
     *
     * @return self
     */
    public function setSeePersons($see_persons)
    {
        if (is_null($see_persons)) {
            throw new \InvalidArgumentException('non-nullable see_persons cannot be null');
        }
        $this->container['see_persons'] = $see_persons;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


