<?php
/**
 * GetPublicGroupSignoutData200ResponseData
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * GetPublicGroupSignoutData200ResponseData Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class GetPublicGroupSignoutData200ResponseData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'getPublicGroupSignoutData_200_response_data';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'group' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerGroupsInnerGroup',
        'group_has_auto_accept' => 'bool',
        'leader_sign_out_persons' => 'object[]',
        'requester' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerTeamInnerPerson',
        'requester_email' => 'string',
        'self_sign_out_persons' => 'object[]',
        'token' => 'mixed'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'group' => null,
        'group_has_auto_accept' => null,
        'leader_sign_out_persons' => null,
        'requester' => null,
        'requester_email' => null,
        'self_sign_out_persons' => null,
        'token' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'group' => false,
        'group_has_auto_accept' => false,
        'leader_sign_out_persons' => false,
        'requester' => false,
        'requester_email' => false,
        'self_sign_out_persons' => false,
        'token' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'group' => 'group',
        'group_has_auto_accept' => 'groupHasAutoAccept',
        'leader_sign_out_persons' => 'leaderSignOutPersons',
        'requester' => 'requester',
        'requester_email' => 'requesterEmail',
        'self_sign_out_persons' => 'selfSignOutPersons',
        'token' => 'token'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'group' => 'setGroup',
        'group_has_auto_accept' => 'setGroupHasAutoAccept',
        'leader_sign_out_persons' => 'setLeaderSignOutPersons',
        'requester' => 'setRequester',
        'requester_email' => 'setRequesterEmail',
        'self_sign_out_persons' => 'setSelfSignOutPersons',
        'token' => 'setToken'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'group' => 'getGroup',
        'group_has_auto_accept' => 'getGroupHasAutoAccept',
        'leader_sign_out_persons' => 'getLeaderSignOutPersons',
        'requester' => 'getRequester',
        'requester_email' => 'getRequesterEmail',
        'self_sign_out_persons' => 'getSelfSignOutPersons',
        'token' => 'getToken'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('group', $data ?? [], null);
        $this->setIfExists('group_has_auto_accept', $data ?? [], null);
        $this->setIfExists('leader_sign_out_persons', $data ?? [], null);
        $this->setIfExists('requester', $data ?? [], null);
        $this->setIfExists('requester_email', $data ?? [], null);
        $this->setIfExists('self_sign_out_persons', $data ?? [], null);
        $this->setIfExists('token', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets group
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerGroupsInnerGroup|null
     */
    public function getGroup()
    {
        return $this->container['group'];
    }

    /**
     * Sets group
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerGroupsInnerGroup|null $group group
     *
     * @return self
     */
    public function setGroup($group)
    {
        if (is_null($group)) {
            throw new \InvalidArgumentException('non-nullable group cannot be null');
        }
        $this->container['group'] = $group;

        return $this;
    }

    /**
     * Gets group_has_auto_accept
     *
     * @return bool|null
     */
    public function getGroupHasAutoAccept()
    {
        return $this->container['group_has_auto_accept'];
    }

    /**
     * Sets group_has_auto_accept
     *
     * @param bool|null $group_has_auto_accept group_has_auto_accept
     *
     * @return self
     */
    public function setGroupHasAutoAccept($group_has_auto_accept)
    {
        if (is_null($group_has_auto_accept)) {
            throw new \InvalidArgumentException('non-nullable group_has_auto_accept cannot be null');
        }
        $this->container['group_has_auto_accept'] = $group_has_auto_accept;

        return $this;
    }

    /**
     * Gets leader_sign_out_persons
     *
     * @return object[]|null
     */
    public function getLeaderSignOutPersons()
    {
        return $this->container['leader_sign_out_persons'];
    }

    /**
     * Sets leader_sign_out_persons
     *
     * @param object[]|null $leader_sign_out_persons leader_sign_out_persons
     *
     * @return self
     */
    public function setLeaderSignOutPersons($leader_sign_out_persons)
    {
        if (is_null($leader_sign_out_persons)) {
            throw new \InvalidArgumentException('non-nullable leader_sign_out_persons cannot be null');
        }
        $this->container['leader_sign_out_persons'] = $leader_sign_out_persons;

        return $this;
    }

    /**
     * Gets requester
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerTeamInnerPerson|null
     */
    public function getRequester()
    {
        return $this->container['requester'];
    }

    /**
     * Sets requester
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerTeamInnerPerson|null $requester requester
     *
     * @return self
     */
    public function setRequester($requester)
    {
        if (is_null($requester)) {
            throw new \InvalidArgumentException('non-nullable requester cannot be null');
        }
        $this->container['requester'] = $requester;

        return $this;
    }

    /**
     * Gets requester_email
     *
     * @return string|null
     */
    public function getRequesterEmail()
    {
        return $this->container['requester_email'];
    }

    /**
     * Sets requester_email
     *
     * @param string|null $requester_email requester_email
     *
     * @return self
     */
    public function setRequesterEmail($requester_email)
    {
        if (is_null($requester_email)) {
            throw new \InvalidArgumentException('non-nullable requester_email cannot be null');
        }
        $this->container['requester_email'] = $requester_email;

        return $this;
    }

    /**
     * Gets self_sign_out_persons
     *
     * @return object[]|null
     */
    public function getSelfSignOutPersons()
    {
        return $this->container['self_sign_out_persons'];
    }

    /**
     * Sets self_sign_out_persons
     *
     * @param object[]|null $self_sign_out_persons self_sign_out_persons
     *
     * @return self
     */
    public function setSelfSignOutPersons($self_sign_out_persons)
    {
        if (is_null($self_sign_out_persons)) {
            throw new \InvalidArgumentException('non-nullable self_sign_out_persons cannot be null');
        }
        $this->container['self_sign_out_persons'] = $self_sign_out_persons;

        return $this;
    }

    /**
     * Gets token
     *
     * @return mixed|null
     */
    public function getToken()
    {
        return $this->container['token'];
    }

    /**
     * Sets token
     *
     * @param mixed|null $token token
     *
     * @return self
     */
    public function setToken($token)
    {
        if (is_null($token)) {
            array_push($this->openAPINullablesSetToNull, 'token');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('token', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['token'] = $token;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


