<?php
/**
 * PatchGroup200ResponseSettings
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * PatchGroup200ResponseSettings Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PatchGroup200ResponseSettings implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'patchGroup_200_response_settings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'allow_child_registration' => 'bool',
        'allow_other_registration' => 'bool',
        'allow_same_email_registration' => 'bool',
        'allow_spouse_registration' => 'bool',
        'allow_waitinglist' => 'bool',
        'auto_accept' => 'bool',
        'automatic_move_up' => 'bool',
        'group_meeting' => '\StevenBuehner\ChurchTools\Model\PatchGroup200ResponseSettingsGroupMeeting',
        'in_statistic' => 'bool',
        'inform_leader' => 'bool',
        'is_hidden' => 'bool',
        'is_open_for_members' => 'bool',
        'is_public' => 'bool',
        'new_member' => '\StevenBuehner\ChurchTools\Model\PatchGroup200ResponseSettingsNewMember',
        'qr_code_checkin' => 'bool',
        'visibility' => 'string',
        'waitinglist_max_persons' => 'Null'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'allow_child_registration' => null,
        'allow_other_registration' => null,
        'allow_same_email_registration' => null,
        'allow_spouse_registration' => null,
        'allow_waitinglist' => null,
        'auto_accept' => null,
        'automatic_move_up' => null,
        'group_meeting' => null,
        'in_statistic' => null,
        'inform_leader' => null,
        'is_hidden' => null,
        'is_open_for_members' => null,
        'is_public' => null,
        'new_member' => null,
        'qr_code_checkin' => null,
        'visibility' => null,
        'waitinglist_max_persons' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'allow_child_registration' => false,
        'allow_other_registration' => false,
        'allow_same_email_registration' => false,
        'allow_spouse_registration' => false,
        'allow_waitinglist' => false,
        'auto_accept' => false,
        'automatic_move_up' => false,
        'group_meeting' => false,
        'in_statistic' => false,
        'inform_leader' => false,
        'is_hidden' => false,
        'is_open_for_members' => false,
        'is_public' => false,
        'new_member' => false,
        'qr_code_checkin' => false,
        'visibility' => false,
        'waitinglist_max_persons' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'allow_child_registration' => 'allowChildRegistration',
        'allow_other_registration' => 'allowOtherRegistration',
        'allow_same_email_registration' => 'allowSameEmailRegistration',
        'allow_spouse_registration' => 'allowSpouseRegistration',
        'allow_waitinglist' => 'allowWaitinglist',
        'auto_accept' => 'autoAccept',
        'automatic_move_up' => 'automaticMoveUp',
        'group_meeting' => 'groupMeeting',
        'in_statistic' => 'inStatistic',
        'inform_leader' => 'informLeader',
        'is_hidden' => 'isHidden',
        'is_open_for_members' => 'isOpenForMembers',
        'is_public' => 'isPublic',
        'new_member' => 'newMember',
        'qr_code_checkin' => 'qrCodeCheckin',
        'visibility' => 'visibility',
        'waitinglist_max_persons' => 'waitinglistMaxPersons'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'allow_child_registration' => 'setAllowChildRegistration',
        'allow_other_registration' => 'setAllowOtherRegistration',
        'allow_same_email_registration' => 'setAllowSameEmailRegistration',
        'allow_spouse_registration' => 'setAllowSpouseRegistration',
        'allow_waitinglist' => 'setAllowWaitinglist',
        'auto_accept' => 'setAutoAccept',
        'automatic_move_up' => 'setAutomaticMoveUp',
        'group_meeting' => 'setGroupMeeting',
        'in_statistic' => 'setInStatistic',
        'inform_leader' => 'setInformLeader',
        'is_hidden' => 'setIsHidden',
        'is_open_for_members' => 'setIsOpenForMembers',
        'is_public' => 'setIsPublic',
        'new_member' => 'setNewMember',
        'qr_code_checkin' => 'setQrCodeCheckin',
        'visibility' => 'setVisibility',
        'waitinglist_max_persons' => 'setWaitinglistMaxPersons'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'allow_child_registration' => 'getAllowChildRegistration',
        'allow_other_registration' => 'getAllowOtherRegistration',
        'allow_same_email_registration' => 'getAllowSameEmailRegistration',
        'allow_spouse_registration' => 'getAllowSpouseRegistration',
        'allow_waitinglist' => 'getAllowWaitinglist',
        'auto_accept' => 'getAutoAccept',
        'automatic_move_up' => 'getAutomaticMoveUp',
        'group_meeting' => 'getGroupMeeting',
        'in_statistic' => 'getInStatistic',
        'inform_leader' => 'getInformLeader',
        'is_hidden' => 'getIsHidden',
        'is_open_for_members' => 'getIsOpenForMembers',
        'is_public' => 'getIsPublic',
        'new_member' => 'getNewMember',
        'qr_code_checkin' => 'getQrCodeCheckin',
        'visibility' => 'getVisibility',
        'waitinglist_max_persons' => 'getWaitinglistMaxPersons'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('allow_child_registration', $data ?? [], null);
        $this->setIfExists('allow_other_registration', $data ?? [], null);
        $this->setIfExists('allow_same_email_registration', $data ?? [], null);
        $this->setIfExists('allow_spouse_registration', $data ?? [], null);
        $this->setIfExists('allow_waitinglist', $data ?? [], null);
        $this->setIfExists('auto_accept', $data ?? [], null);
        $this->setIfExists('automatic_move_up', $data ?? [], null);
        $this->setIfExists('group_meeting', $data ?? [], null);
        $this->setIfExists('in_statistic', $data ?? [], null);
        $this->setIfExists('inform_leader', $data ?? [], null);
        $this->setIfExists('is_hidden', $data ?? [], null);
        $this->setIfExists('is_open_for_members', $data ?? [], null);
        $this->setIfExists('is_public', $data ?? [], null);
        $this->setIfExists('new_member', $data ?? [], null);
        $this->setIfExists('qr_code_checkin', $data ?? [], null);
        $this->setIfExists('visibility', $data ?? [], null);
        $this->setIfExists('waitinglist_max_persons', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets allow_child_registration
     *
     * @return bool|null
     */
    public function getAllowChildRegistration()
    {
        return $this->container['allow_child_registration'];
    }

    /**
     * Sets allow_child_registration
     *
     * @param bool|null $allow_child_registration allow_child_registration
     *
     * @return self
     */
    public function setAllowChildRegistration($allow_child_registration)
    {
        if (is_null($allow_child_registration)) {
            throw new \InvalidArgumentException('non-nullable allow_child_registration cannot be null');
        }
        $this->container['allow_child_registration'] = $allow_child_registration;

        return $this;
    }

    /**
     * Gets allow_other_registration
     *
     * @return bool|null
     */
    public function getAllowOtherRegistration()
    {
        return $this->container['allow_other_registration'];
    }

    /**
     * Sets allow_other_registration
     *
     * @param bool|null $allow_other_registration allow_other_registration
     *
     * @return self
     */
    public function setAllowOtherRegistration($allow_other_registration)
    {
        if (is_null($allow_other_registration)) {
            throw new \InvalidArgumentException('non-nullable allow_other_registration cannot be null');
        }
        $this->container['allow_other_registration'] = $allow_other_registration;

        return $this;
    }

    /**
     * Gets allow_same_email_registration
     *
     * @return bool|null
     */
    public function getAllowSameEmailRegistration()
    {
        return $this->container['allow_same_email_registration'];
    }

    /**
     * Sets allow_same_email_registration
     *
     * @param bool|null $allow_same_email_registration allow_same_email_registration
     *
     * @return self
     */
    public function setAllowSameEmailRegistration($allow_same_email_registration)
    {
        if (is_null($allow_same_email_registration)) {
            throw new \InvalidArgumentException('non-nullable allow_same_email_registration cannot be null');
        }
        $this->container['allow_same_email_registration'] = $allow_same_email_registration;

        return $this;
    }

    /**
     * Gets allow_spouse_registration
     *
     * @return bool|null
     */
    public function getAllowSpouseRegistration()
    {
        return $this->container['allow_spouse_registration'];
    }

    /**
     * Sets allow_spouse_registration
     *
     * @param bool|null $allow_spouse_registration allow_spouse_registration
     *
     * @return self
     */
    public function setAllowSpouseRegistration($allow_spouse_registration)
    {
        if (is_null($allow_spouse_registration)) {
            throw new \InvalidArgumentException('non-nullable allow_spouse_registration cannot be null');
        }
        $this->container['allow_spouse_registration'] = $allow_spouse_registration;

        return $this;
    }

    /**
     * Gets allow_waitinglist
     *
     * @return bool|null
     */
    public function getAllowWaitinglist()
    {
        return $this->container['allow_waitinglist'];
    }

    /**
     * Sets allow_waitinglist
     *
     * @param bool|null $allow_waitinglist allow_waitinglist
     *
     * @return self
     */
    public function setAllowWaitinglist($allow_waitinglist)
    {
        if (is_null($allow_waitinglist)) {
            throw new \InvalidArgumentException('non-nullable allow_waitinglist cannot be null');
        }
        $this->container['allow_waitinglist'] = $allow_waitinglist;

        return $this;
    }

    /**
     * Gets auto_accept
     *
     * @return bool|null
     */
    public function getAutoAccept()
    {
        return $this->container['auto_accept'];
    }

    /**
     * Sets auto_accept
     *
     * @param bool|null $auto_accept auto_accept
     *
     * @return self
     */
    public function setAutoAccept($auto_accept)
    {
        if (is_null($auto_accept)) {
            throw new \InvalidArgumentException('non-nullable auto_accept cannot be null');
        }
        $this->container['auto_accept'] = $auto_accept;

        return $this;
    }

    /**
     * Gets automatic_move_up
     *
     * @return bool|null
     */
    public function getAutomaticMoveUp()
    {
        return $this->container['automatic_move_up'];
    }

    /**
     * Sets automatic_move_up
     *
     * @param bool|null $automatic_move_up automatic_move_up
     *
     * @return self
     */
    public function setAutomaticMoveUp($automatic_move_up)
    {
        if (is_null($automatic_move_up)) {
            throw new \InvalidArgumentException('non-nullable automatic_move_up cannot be null');
        }
        $this->container['automatic_move_up'] = $automatic_move_up;

        return $this;
    }

    /**
     * Gets group_meeting
     *
     * @return \StevenBuehner\ChurchTools\Model\PatchGroup200ResponseSettingsGroupMeeting|null
     */
    public function getGroupMeeting()
    {
        return $this->container['group_meeting'];
    }

    /**
     * Sets group_meeting
     *
     * @param \StevenBuehner\ChurchTools\Model\PatchGroup200ResponseSettingsGroupMeeting|null $group_meeting group_meeting
     *
     * @return self
     */
    public function setGroupMeeting($group_meeting)
    {
        if (is_null($group_meeting)) {
            throw new \InvalidArgumentException('non-nullable group_meeting cannot be null');
        }
        $this->container['group_meeting'] = $group_meeting;

        return $this;
    }

    /**
     * Gets in_statistic
     *
     * @return bool|null
     */
    public function getInStatistic()
    {
        return $this->container['in_statistic'];
    }

    /**
     * Sets in_statistic
     *
     * @param bool|null $in_statistic in_statistic
     *
     * @return self
     */
    public function setInStatistic($in_statistic)
    {
        if (is_null($in_statistic)) {
            throw new \InvalidArgumentException('non-nullable in_statistic cannot be null');
        }
        $this->container['in_statistic'] = $in_statistic;

        return $this;
    }

    /**
     * Gets inform_leader
     *
     * @return bool|null
     */
    public function getInformLeader()
    {
        return $this->container['inform_leader'];
    }

    /**
     * Sets inform_leader
     *
     * @param bool|null $inform_leader inform_leader
     *
     * @return self
     */
    public function setInformLeader($inform_leader)
    {
        if (is_null($inform_leader)) {
            throw new \InvalidArgumentException('non-nullable inform_leader cannot be null');
        }
        $this->container['inform_leader'] = $inform_leader;

        return $this;
    }

    /**
     * Gets is_hidden
     *
     * @return bool|null
     */
    public function getIsHidden()
    {
        return $this->container['is_hidden'];
    }

    /**
     * Sets is_hidden
     *
     * @param bool|null $is_hidden is_hidden
     *
     * @return self
     */
    public function setIsHidden($is_hidden)
    {
        if (is_null($is_hidden)) {
            throw new \InvalidArgumentException('non-nullable is_hidden cannot be null');
        }
        $this->container['is_hidden'] = $is_hidden;

        return $this;
    }

    /**
     * Gets is_open_for_members
     *
     * @return bool|null
     */
    public function getIsOpenForMembers()
    {
        return $this->container['is_open_for_members'];
    }

    /**
     * Sets is_open_for_members
     *
     * @param bool|null $is_open_for_members is_open_for_members
     *
     * @return self
     */
    public function setIsOpenForMembers($is_open_for_members)
    {
        if (is_null($is_open_for_members)) {
            throw new \InvalidArgumentException('non-nullable is_open_for_members cannot be null');
        }
        $this->container['is_open_for_members'] = $is_open_for_members;

        return $this;
    }

    /**
     * Gets is_public
     *
     * @return bool|null
     */
    public function getIsPublic()
    {
        return $this->container['is_public'];
    }

    /**
     * Sets is_public
     *
     * @param bool|null $is_public is_public
     *
     * @return self
     */
    public function setIsPublic($is_public)
    {
        if (is_null($is_public)) {
            throw new \InvalidArgumentException('non-nullable is_public cannot be null');
        }
        $this->container['is_public'] = $is_public;

        return $this;
    }

    /**
     * Gets new_member
     *
     * @return \StevenBuehner\ChurchTools\Model\PatchGroup200ResponseSettingsNewMember|null
     */
    public function getNewMember()
    {
        return $this->container['new_member'];
    }

    /**
     * Sets new_member
     *
     * @param \StevenBuehner\ChurchTools\Model\PatchGroup200ResponseSettingsNewMember|null $new_member new_member
     *
     * @return self
     */
    public function setNewMember($new_member)
    {
        if (is_null($new_member)) {
            throw new \InvalidArgumentException('non-nullable new_member cannot be null');
        }
        $this->container['new_member'] = $new_member;

        return $this;
    }

    /**
     * Gets qr_code_checkin
     *
     * @return bool|null
     */
    public function getQrCodeCheckin()
    {
        return $this->container['qr_code_checkin'];
    }

    /**
     * Sets qr_code_checkin
     *
     * @param bool|null $qr_code_checkin qr_code_checkin
     *
     * @return self
     */
    public function setQrCodeCheckin($qr_code_checkin)
    {
        if (is_null($qr_code_checkin)) {
            throw new \InvalidArgumentException('non-nullable qr_code_checkin cannot be null');
        }
        $this->container['qr_code_checkin'] = $qr_code_checkin;

        return $this;
    }

    /**
     * Gets visibility
     *
     * @return string|null
     */
    public function getVisibility()
    {
        return $this->container['visibility'];
    }

    /**
     * Sets visibility
     *
     * @param string|null $visibility visibility
     *
     * @return self
     */
    public function setVisibility($visibility)
    {
        if (is_null($visibility)) {
            throw new \InvalidArgumentException('non-nullable visibility cannot be null');
        }
        $this->container['visibility'] = $visibility;

        return $this;
    }

    /**
     * Gets waitinglist_max_persons
     *
     * @return Null|null
     */
    public function getWaitinglistMaxPersons()
    {
        return $this->container['waitinglist_max_persons'];
    }

    /**
     * Sets waitinglist_max_persons
     *
     * @param Null|null $waitinglist_max_persons waitinglist_max_persons
     *
     * @return self
     */
    public function setWaitinglistMaxPersons($waitinglist_max_persons)
    {
        if (is_null($waitinglist_max_persons)) {
            throw new \InvalidArgumentException('non-nullable waitinglist_max_persons cannot be null');
        }
        $this->container['waitinglist_max_persons'] = $waitinglist_max_persons;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


