<?php
/**
 * PublicGroup1
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * PublicGroup1 Class Doc Comment
 *
 * @category Class
 * @description Information about a public group, e.g. to be displayed on a group homepage.
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PublicGroup1 implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PublicGroup_1';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'allow_waitinglist' => 'bool',
        'auto_accept' => 'bool',
        'can_sign_up' => 'bool',
        'children' => 'int[]',
        'current_member_count' => 'int',
        'id' => 'int',
        'information' => '\StevenBuehner\ChurchTools\Model\PublicGroup1Information',
        'max_member_count' => 'int',
        'name' => 'string',
        'requested_places_count' => 'int',
        'requested_waitinglist_places_count' => 'int',
        'sign_up_conditions' => '\StevenBuehner\ChurchTools\Model\PublicGroup1SignUpConditions',
        'sign_up_headline' => 'string',
        'sign_up_persons' => '\StevenBuehner\ChurchTools\Model\PublicGroup1SignUpPersonsInner[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'allow_waitinglist' => null,
        'auto_accept' => null,
        'can_sign_up' => null,
        'children' => null,
        'current_member_count' => null,
        'id' => null,
        'information' => null,
        'max_member_count' => null,
        'name' => null,
        'requested_places_count' => null,
        'requested_waitinglist_places_count' => null,
        'sign_up_conditions' => null,
        'sign_up_headline' => null,
        'sign_up_persons' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'allow_waitinglist' => false,
        'auto_accept' => false,
        'can_sign_up' => false,
        'children' => false,
        'current_member_count' => false,
        'id' => false,
        'information' => false,
        'max_member_count' => false,
        'name' => false,
        'requested_places_count' => false,
        'requested_waitinglist_places_count' => false,
        'sign_up_conditions' => false,
        'sign_up_headline' => false,
        'sign_up_persons' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'allow_waitinglist' => 'allowWaitinglist',
        'auto_accept' => 'autoAccept',
        'can_sign_up' => 'canSignUp',
        'children' => 'children',
        'current_member_count' => 'currentMemberCount',
        'id' => 'id',
        'information' => 'information',
        'max_member_count' => 'maxMemberCount',
        'name' => 'name',
        'requested_places_count' => 'requestedPlacesCount',
        'requested_waitinglist_places_count' => 'requestedWaitinglistPlacesCount',
        'sign_up_conditions' => 'signUpConditions',
        'sign_up_headline' => 'signUpHeadline',
        'sign_up_persons' => 'signUpPersons'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'allow_waitinglist' => 'setAllowWaitinglist',
        'auto_accept' => 'setAutoAccept',
        'can_sign_up' => 'setCanSignUp',
        'children' => 'setChildren',
        'current_member_count' => 'setCurrentMemberCount',
        'id' => 'setId',
        'information' => 'setInformation',
        'max_member_count' => 'setMaxMemberCount',
        'name' => 'setName',
        'requested_places_count' => 'setRequestedPlacesCount',
        'requested_waitinglist_places_count' => 'setRequestedWaitinglistPlacesCount',
        'sign_up_conditions' => 'setSignUpConditions',
        'sign_up_headline' => 'setSignUpHeadline',
        'sign_up_persons' => 'setSignUpPersons'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'allow_waitinglist' => 'getAllowWaitinglist',
        'auto_accept' => 'getAutoAccept',
        'can_sign_up' => 'getCanSignUp',
        'children' => 'getChildren',
        'current_member_count' => 'getCurrentMemberCount',
        'id' => 'getId',
        'information' => 'getInformation',
        'max_member_count' => 'getMaxMemberCount',
        'name' => 'getName',
        'requested_places_count' => 'getRequestedPlacesCount',
        'requested_waitinglist_places_count' => 'getRequestedWaitinglistPlacesCount',
        'sign_up_conditions' => 'getSignUpConditions',
        'sign_up_headline' => 'getSignUpHeadline',
        'sign_up_persons' => 'getSignUpPersons'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('allow_waitinglist', $data ?? [], null);
        $this->setIfExists('auto_accept', $data ?? [], null);
        $this->setIfExists('can_sign_up', $data ?? [], null);
        $this->setIfExists('children', $data ?? [], null);
        $this->setIfExists('current_member_count', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('information', $data ?? [], null);
        $this->setIfExists('max_member_count', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('requested_places_count', $data ?? [], null);
        $this->setIfExists('requested_waitinglist_places_count', $data ?? [], null);
        $this->setIfExists('sign_up_conditions', $data ?? [], null);
        $this->setIfExists('sign_up_headline', $data ?? [], null);
        $this->setIfExists('sign_up_persons', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['allow_waitinglist'] === null) {
            $invalidProperties[] = "'allow_waitinglist' can't be null";
        }
        if ($this->container['auto_accept'] === null) {
            $invalidProperties[] = "'auto_accept' can't be null";
        }
        if ($this->container['can_sign_up'] === null) {
            $invalidProperties[] = "'can_sign_up' can't be null";
        }
        if ($this->container['current_member_count'] === null) {
            $invalidProperties[] = "'current_member_count' can't be null";
        }
        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['information'] === null) {
            $invalidProperties[] = "'information' can't be null";
        }
        if ($this->container['max_member_count'] === null) {
            $invalidProperties[] = "'max_member_count' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['requested_places_count'] === null) {
            $invalidProperties[] = "'requested_places_count' can't be null";
        }
        if ($this->container['requested_waitinglist_places_count'] === null) {
            $invalidProperties[] = "'requested_waitinglist_places_count' can't be null";
        }
        if ($this->container['sign_up_conditions'] === null) {
            $invalidProperties[] = "'sign_up_conditions' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets allow_waitinglist
     *
     * @return bool
     */
    public function getAllowWaitinglist()
    {
        return $this->container['allow_waitinglist'];
    }

    /**
     * Sets allow_waitinglist
     *
     * @param bool $allow_waitinglist If true, group sign is allowed even if group is full.
     *
     * @return self
     */
    public function setAllowWaitinglist($allow_waitinglist)
    {
        if (is_null($allow_waitinglist)) {
            throw new \InvalidArgumentException('non-nullable allow_waitinglist cannot be null');
        }
        $this->container['allow_waitinglist'] = $allow_waitinglist;

        return $this;
    }

    /**
     * Gets auto_accept
     *
     * @return bool
     */
    public function getAutoAccept()
    {
        return $this->container['auto_accept'];
    }

    /**
     * Sets auto_accept
     *
     * @param bool $auto_accept If true, group sign up requests will be accepted automatically.
     *
     * @return self
     */
    public function setAutoAccept($auto_accept)
    {
        if (is_null($auto_accept)) {
            throw new \InvalidArgumentException('non-nullable auto_accept cannot be null');
        }
        $this->container['auto_accept'] = $auto_accept;

        return $this;
    }

    /**
     * Gets can_sign_up
     *
     * @return bool
     */
    public function getCanSignUp()
    {
        return $this->container['can_sign_up'];
    }

    /**
     * Sets can_sign_up
     *
     * @param bool $can_sign_up Indicates if the current user (either logged in or not) can sign up. This summarizes the information in signUpConditions.
     *
     * @return self
     */
    public function setCanSignUp($can_sign_up)
    {
        if (is_null($can_sign_up)) {
            throw new \InvalidArgumentException('non-nullable can_sign_up cannot be null');
        }
        $this->container['can_sign_up'] = $can_sign_up;

        return $this;
    }

    /**
     * Gets children
     *
     * @return int[]|null
     */
    public function getChildren()
    {
        return $this->container['children'];
    }

    /**
     * Sets children
     *
     * @param int[]|null $children Lists all (direct) child group IDs for the current group.
     *
     * @return self
     */
    public function setChildren($children)
    {
        if (is_null($children)) {
            throw new \InvalidArgumentException('non-nullable children cannot be null');
        }
        $this->container['children'] = $children;

        return $this;
    }

    /**
     * Gets current_member_count
     *
     * @return int
     */
    public function getCurrentMemberCount()
    {
        return $this->container['current_member_count'];
    }

    /**
     * Sets current_member_count
     *
     * @param int $current_member_count Current number of members in the group.
     *
     * @return self
     */
    public function setCurrentMemberCount($current_member_count)
    {
        if (is_null($current_member_count)) {
            throw new \InvalidArgumentException('non-nullable current_member_count cannot be null');
        }
        $this->container['current_member_count'] = $current_member_count;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id The public group ID.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets information
     *
     * @return \StevenBuehner\ChurchTools\Model\PublicGroup1Information
     */
    public function getInformation()
    {
        return $this->container['information'];
    }

    /**
     * Sets information
     *
     * @param \StevenBuehner\ChurchTools\Model\PublicGroup1Information $information information
     *
     * @return self
     */
    public function setInformation($information)
    {
        if (is_null($information)) {
            throw new \InvalidArgumentException('non-nullable information cannot be null');
        }
        $this->container['information'] = $information;

        return $this;
    }

    /**
     * Gets max_member_count
     *
     * @return int
     */
    public function getMaxMemberCount()
    {
        return $this->container['max_member_count'];
    }

    /**
     * Sets max_member_count
     *
     * @param int $max_member_count Maximum number of members until the group is considered as full.
     *
     * @return self
     */
    public function setMaxMemberCount($max_member_count)
    {
        if (is_null($max_member_count)) {
            throw new \InvalidArgumentException('non-nullable max_member_count cannot be null');
        }
        $this->container['max_member_count'] = $max_member_count;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Name of the group, e.g. to be displayed as title.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets requested_places_count
     *
     * @return int
     */
    public function getRequestedPlacesCount()
    {
        return $this->container['requested_places_count'];
    }

    /**
     * Sets requested_places_count
     *
     * @param int $requested_places_count Number of member requests
     *
     * @return self
     */
    public function setRequestedPlacesCount($requested_places_count)
    {
        if (is_null($requested_places_count)) {
            throw new \InvalidArgumentException('non-nullable requested_places_count cannot be null');
        }
        $this->container['requested_places_count'] = $requested_places_count;

        return $this;
    }

    /**
     * Gets requested_waitinglist_places_count
     *
     * @return int
     */
    public function getRequestedWaitinglistPlacesCount()
    {
        return $this->container['requested_waitinglist_places_count'];
    }

    /**
     * Sets requested_waitinglist_places_count
     *
     * @param int $requested_waitinglist_places_count Number of member requests with waiting list position
     *
     * @return self
     */
    public function setRequestedWaitinglistPlacesCount($requested_waitinglist_places_count)
    {
        if (is_null($requested_waitinglist_places_count)) {
            throw new \InvalidArgumentException('non-nullable requested_waitinglist_places_count cannot be null');
        }
        $this->container['requested_waitinglist_places_count'] = $requested_waitinglist_places_count;

        return $this;
    }

    /**
     * Gets sign_up_conditions
     *
     * @return \StevenBuehner\ChurchTools\Model\PublicGroup1SignUpConditions
     */
    public function getSignUpConditions()
    {
        return $this->container['sign_up_conditions'];
    }

    /**
     * Sets sign_up_conditions
     *
     * @param \StevenBuehner\ChurchTools\Model\PublicGroup1SignUpConditions $sign_up_conditions sign_up_conditions
     *
     * @return self
     */
    public function setSignUpConditions($sign_up_conditions)
    {
        if (is_null($sign_up_conditions)) {
            throw new \InvalidArgumentException('non-nullable sign_up_conditions cannot be null');
        }
        $this->container['sign_up_conditions'] = $sign_up_conditions;

        return $this;
    }

    /**
     * Gets sign_up_headline
     *
     * @return string|null
     */
    public function getSignUpHeadline()
    {
        return $this->container['sign_up_headline'];
    }

    /**
     * Sets sign_up_headline
     *
     * @param string|null $sign_up_headline Text which can be displayed as a headline for the sign up section
     *
     * @return self
     */
    public function setSignUpHeadline($sign_up_headline)
    {
        if (is_null($sign_up_headline)) {
            throw new \InvalidArgumentException('non-nullable sign_up_headline cannot be null');
        }
        $this->container['sign_up_headline'] = $sign_up_headline;

        return $this;
    }

    /**
     * Gets sign_up_persons
     *
     * @return \StevenBuehner\ChurchTools\Model\PublicGroup1SignUpPersonsInner[]|null
     */
    public function getSignUpPersons()
    {
        return $this->container['sign_up_persons'];
    }

    /**
     * Sets sign_up_persons
     *
     * @param \StevenBuehner\ChurchTools\Model\PublicGroup1SignUpPersonsInner[]|null $sign_up_persons Lists all persons the current user is allowed to sign up for. This includes spouses, children below the age of 16 and all persons with the same email address.
     *
     * @return self
     */
    public function setSignUpPersons($sign_up_persons)
    {
        if (is_null($sign_up_persons)) {
            throw new \InvalidArgumentException('non-nullable sign_up_persons cannot be null');
        }
        $this->container['sign_up_persons'] = $sign_up_persons;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


