<?php

namespace StevenBuehner\sbChurchtoolsGrouphomepage\Always;

use StevenBuehner\sbChurchtoolsGrouphomepage\Backend\MailerSettingsController;
use StevenBuehner\sbChurchtoolsGrouphomepage\Controller\NewsletterSettingsController;
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;


/**
 * The core plugin class.
 *
 * @since      1.0.0
 * @package    sbChurchtoolsGrouphomepage
 * @author     Steven Buehner <buehner@me.com>
 */
class MainController {


	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string $domain The string used to uniquely identify this plugin.
	 */
	protected string $domain;


	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct($domain) {

		$this->domain = $domain;

		$container = MyContainer::getSingleton();

		$container->getGlobalRestController();
		$container->getAppointmentListController();
		$container->getGrouphomepageController();
		$container->getNewsletterController();
		$container->getCountdownController();
		$container->getEventMetaDataController();
		// $container->getPersonsController();

	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {

		$this->setUpHooks();

		if (!MyContainer::isDebugMode()) {
			// Nur auf einem Remote-Syste auf Debugs prüfen
			$this->check_for_updates();
		}

	}

	protected function setUpHooks(): void {

		add_action('plugins_loaded', [$this, 'hook_plugins_loaded']);

		add_filter('admin_enqueue_scripts', [$this, 'hook_admin_enqueue_scripts']);

		// Admin-Settings
		add_action('admin_menu', [$this, 'hook_admin_menu']);
		add_action('admin_init', [$this, 'hook_admin_init']);

		// Hook in die Plugin-Links
		add_filter('plugin_action_links_sb-churchtools-grouphomepage/sb-churchtools-grouphomepage.php', [$this, 'linkPluginToSettingsPage']);

	}


	public function hook_admin_enqueue_scripts(): void {

		$backendController = MyContainer::getBackendController();
		$backendController->enqueue_styles();
		$backendController->enqueue_scripts();

	}


	public function hook_plugins_loaded() {

		// see: https://developer.wordpress.org/plugins/internationalization/how-to-internationalize-your-plugin/
		/*
		load_plugin_textdomain(
			$this->domain,
			FALSE,
			dirname(plugin_basename(__FILE__), 3) . '/languages'
		);
		*/

	}


	public function hook_admin_init() {

		$container = MyContainer::getSingleton();

		/** @var NewsletterSettingsController $settingsController */
		$settingsController = $container['newsletterSettingsController'];
		$settingsController->registerAjax();

		/** @var MailerSettingsController $mailerSettingsController */
		$mailerSettingsController = $container['mailerSettingsController'];
		// $settingsController->registerAjax();

	}


	public function hook_admin_menu() {

		$container = MyContainer::getSingleton();

		/** @var NewsletterSettingsController $settingsController */
		$settingsController = $container['newsletterSettingsController'];
		$settingsController->registerSettingsMenu();

		/** @var MailerSettingsController $mailerSettingsController */
		$mailerSettingsController = $container['mailerSettingsController'];
		$mailerSettingsController->registerSettingsMenu();

	}

	public function check_for_updates() {

		// @see https://github.com/YahnisElsts/wp-update-server
		$pluginSlug     = basename(dirname(__DIR__, 2));
		$mainPluginFile = dirname(__DIR__, 2) . "/sb-churchtools-grouphomepage.php";
		$query          = [
			'action' => 'get_metadata',
			'slug'   => $pluginSlug,
		];

		$MyUpdateChecker = PucFactory::buildUpdateChecker(
			'https://plugins.sv-schoenaich.de/?' . http_build_query($query),        //Metadata URL.
			$mainPluginFile,                                                        //Full path to the main plugin file.
			$pluginSlug                                                             //Plugin slug. Usually it's the same as the name of the directory.
		);

		// Download via: https://plugins.sv-schoenaich.de/?action=download&slug=sb-churchtools-grouphomepage

	}

	/**
	 * Fügt einen Link zu den Einstellungen in der Plugin-Auflistung hinzu.
	 *
	 * @param array $actions Bestehende Links.
	 * @return array Angepasste Links.
	 */
	public function linkPluginToSettingsPage(array $actions): array {

		// URL zu den Einstellungen (ersetze 'options-general.php?page=mein-plugin' durch die URL deiner Einstellungen)
		$einstellungen_link = '<a href="' . admin_url('options-general.php?page=sb-churchtools-grouphomepage_settings') . '">' . _('Settings') . '</a>';

		$actions['settings'] = $einstellungen_link;

		return $actions;
	}

}
