<?php

namespace StevenBuehner\sbChurchtoolsGrouphomepage\Helper;

class FilteredMultiSelectControlHelper {

	/**
	 * Helper Funktion um aus dem Rückgabewert (Json-String aus [{value, label}, {value, label}] oder aus {value, label}) ein Array mit den values zu bekommen
	 * Diese Funktion gibt genau die selben Werte zurück wie die HelperFuntkion in "FilteredMultiSelectControl.js"
	 * @param $jsonValue
	 * @return array
	 */
	public static function parseStrValueToArray($jsonValue) {
		// Wenn der Wert eine leere Zeichenkette ist, gib ein leeres Array zurück
		if ($jsonValue === "") {
			return [];
		}

		// Versuche den Wert als JSON zu parsen
		$parsed = json_decode($jsonValue, TRUE);

		// Überprüfen, ob json_decode einen Fehler zurückgegeben hat
		if (json_last_error() !== JSON_ERROR_NONE) {
			return [];
		}

		// Überprüfen, ob der geparste Wert ein Array ist
		if (is_array($parsed)) {
			// Nur die values zurückgeben
			return array_map(function ($el) {
				return $el['value'];
			}, $parsed);
		} else if (is_object($parsed) && property_exists($parsed, 'value')) {
			return [$parsed->value];
		} else if (is_array($parsed) && array_key_exists('value', $parsed)) {
			return [$parsed['value']];
		} else {
			// Wenn der geparste Wert kein Array ist, gib ein leeres Array zurück
			return [];
		}
	}
}
