<?php

namespace StevenBuehner\sbChurchtoolsGrouphomepage\Service;

use StevenBuehner\sbChurchtoolsGrouphomepage\Always\MyContainer;
use Symfony\Contracts\Cache\ItemInterface;

class CtCampusService {

	protected $campusCached = FALSE;

	public function getChurchToolsCampusesCached() {

		if ($this->campusCached === FALSE) {
			$cacheAdapter = MyContainer::getCacheAdapter();

			$this->campusCached = $cacheAdapter->get('churchtools_api_campuses', function (ItemInterface $item) {

				$item->expiresAfter(60 * 60 * 24); // 24h

				MyContainer::churchToolsLogin();
				$calApi = MyContainer::getCampusApi();
				return $calApi->getAllCampuses()->getData();

			});


		}

		return $this->campusCached;
	}

}
