<?php

namespace StevenBuehner\sbChurchtoolsGrouphomepage\Service;

use StevenBuehner\ChurchTools\Api\PersonApi;
use StevenBuehner\sbChurchtoolsGrouphomepage\Always\MyContainer;
use Symfony\Contracts\Cache\ItemInterface;

class CtPersonService {

	/**
	 * @var array|bool
	 */
	protected mixed $personCached        = FALSE;
	protected int   $personCachedSeconds = 60;

	public function __construct(protected PersonApi $personApi) {
	}

	public function getPerson(int $personId) {

		if ($this->personCached === FALSE) {
			$cacheAdapter = MyContainer::getCacheAdapter();

			$cacheAdapter->clear('churchtools_api_all_groups');


			$this->personCached = $cacheAdapter->get('churchtools_api_all_groups', function (ItemInterface $item) use ($personId) {

				$item->expiresAfter($this->personCachedSeconds); // 60 Sek
				$item->expiresAfter(1);

				MyContainer::churchToolsLogin();

				return $this->personApi->getPersonById($personId);

			});

		}

		return $this->personCached;
	}

}
