<?php

namespace StevenBuehner\sbChurchtoolsGrouphomepage\Service\Mail;

class SmtpMailer extends \Nette\Mail\SmtpMailer {

	// Check only once ...
	protected $credentialsCheckedSuccessfully = NULL;
	protected $from                           = NULL;

	public function __construct(array $options = []) {
		parent::__construct($options);

		if (isset($options['username']) && is_email($options['username'])) {
			$this->from = $options['username'];
		}

	}

	protected function connect(): void {
		// TODO: Get Connection-Settings
		parent::connect();
	}

	public function credentialsValid() {

		if ($this->credentialsCheckedSuccessfully === TRUE || $this->credentialsCheckedSuccessfully === FALSE) {
			return $this->credentialsCheckedSuccessfully;
		}

		try {
			$this->connect();
			$this->credentialsCheckedSuccessfully = TRUE;
		} catch (\Exception $e) {
			$this->credentialsCheckedSuccessfully = FALSE;
		}

		return $this->credentialsCheckedSuccessfully;

	}

	public function getFrom() {
		return $this->from;
	}


}