<?php

namespace StevenBuehner\sbChurchtoolsGrouphomepage\Service;

use StevenBuehner\sbChurchtoolsGrouphomepage\Service\Models\NewsletterBlockSettings;

interface NewsletterServiceInterface {

	public function getAllNewsletterGroupCandidates(): array;

	public function getAllGroupTypes(): array;

	public function sendEmailVerification(string $email, NewsletterBlockSettings $nlSettings, array $replacementsVars);

	public function getRegisteredAccountNewsletters(string $email, NewsletterBlockSettings $nbSettings);

	public function registerNewChurchtoolsPerson(string $email, string $firstname, string $lastname);

	/**
	 * @param NewsletterBlockSettings $nbSettings
	 * @param int $newsletterGroupId
	 * @param $userId
	 * @return bool Success
	 */
	public function subscribe(NewsletterBlockSettings $nbSettings, int $newsletterGroupId, $userId): bool;

	/**
	 * @param NewsletterBlockSettings $nbSettings
	 * @param int $newsletterGroupId
	 * @param $userId
	 * @return bool Success
	 */
	public function unsubscribe(NewsletterBlockSettings $nbSettings, int $newsletterGroupId, $userId): bool;

	public function getAllAvailableNewsletter(NewsletterBlockSettings $nbSettings, ?int $ctUserId = NULL): array;


}
