<?php
/**
 * SyncApi
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use StevenBuehner\ChurchTools\ApiException;
use StevenBuehner\ChurchTools\Configuration;
use StevenBuehner\ChurchTools\HeaderSelector;
use StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * SyncApi Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SyncApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createSyncMapping' => [
            'application/json',
        ],
        'deleteEntityMapping' => [
            'application/json',
        ],
        'deleteSyncConflict' => [
            'application/json',
        ],
        'deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId' => [
            'application/json',
        ],
        'deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter' => [
            'application/json',
        ],
        'deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties' => [
            'application/json',
        ],
        'deleteSyncExternalsystemsId' => [
            'application/json',
        ],
        'deleteSyncFieldMappings' => [
            'application/json',
        ],
        'getEntityMapping' => [
            'application/json',
        ],
        'getSyncAdapters' => [
            'application/json',
        ],
        'getSyncConflict' => [
            'application/json',
        ],
        'getSyncConflicts' => [
            'application/json',
        ],
        'getSyncExecutions' => [
            'application/json',
        ],
        'getSyncExternalsystems' => [
            'application/json',
        ],
        'getSyncExternalsystemsExternalSystemIdJobconfigsJobId' => [
            'application/json',
        ],
        'getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter' => [
            'application/json',
        ],
        'getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties' => [
            'application/json',
        ],
        'getSyncExternalsystemsExternalSystemIdJobconfigurations' => [
            'application/json',
        ],
        'getSyncExternalsystemsId' => [
            'application/json',
        ],
        'getSyncFieldMappings' => [
            'application/json',
        ],
        'getSyncFieldMappingsNoSuggestions' => [
            'application/json',
        ],
        'getSyncJobconfigs' => [
            'application/json',
        ],
        'getSyncLogs' => [
            'application/json',
        ],
        'getSyncMappings' => [
            'application/json',
        ],
        'postSyncExternalsystems' => [
            'application/json',
        ],
        'postSyncExternalsystemsExternalSystemIdJobconfigs' => [
            'application/json',
        ],
        'postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart' => [
            'application/json',
        ],
        'postSyncExternalsystemsIdTest' => [
            'application/json',
        ],
        'postSyncLogs' => [
            'application/json',
        ],
        'putSyncExternalsystemsExternalSystemIdJobconfigs' => [
            'application/json',
        ],
        'putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter' => [
            'application/json',
        ],
        'putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties' => [
            'application/json',
        ],
        'putSyncExternalsystemsId' => [
            'application/json',
        ],
        'putSyncFieldMappings' => [
            'application/json',
        ],
        'saveSyncConflict' => [
            'application/json',
        ],
        'updateEntityMapping' => [
            'application/json',
        ],
        'updateSyncConflict' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createSyncMapping
     *
     * Create new mapping
     *
     * @param  \StevenBuehner\ChurchTools\Model\CreateSyncMappingRequest $create_sync_mapping_request New Entity Mapping of a Person. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSyncMapping'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\SyncEntityMapping
     */
    public function createSyncMapping($create_sync_mapping_request = null, string $contentType = self::contentTypes['createSyncMapping'][0])
    {
        list($response) = $this->createSyncMappingWithHttpInfo($create_sync_mapping_request, $contentType);
        return $response;
    }

    /**
     * Operation createSyncMappingWithHttpInfo
     *
     * Create new mapping
     *
     * @param  \StevenBuehner\ChurchTools\Model\CreateSyncMappingRequest $create_sync_mapping_request New Entity Mapping of a Person. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSyncMapping'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\SyncEntityMapping, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSyncMappingWithHttpInfo($create_sync_mapping_request = null, string $contentType = self::contentTypes['createSyncMapping'][0])
    {
        $request = $this->createSyncMappingRequest($create_sync_mapping_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\StevenBuehner\ChurchTools\Model\SyncEntityMapping' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\SyncEntityMapping' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\SyncEntityMapping', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\SyncEntityMapping';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\SyncEntityMapping',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createSyncMappingAsync
     *
     * Create new mapping
     *
     * @param  \StevenBuehner\ChurchTools\Model\CreateSyncMappingRequest $create_sync_mapping_request New Entity Mapping of a Person. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSyncMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSyncMappingAsync($create_sync_mapping_request = null, string $contentType = self::contentTypes['createSyncMapping'][0])
    {
        return $this->createSyncMappingAsyncWithHttpInfo($create_sync_mapping_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createSyncMappingAsyncWithHttpInfo
     *
     * Create new mapping
     *
     * @param  \StevenBuehner\ChurchTools\Model\CreateSyncMappingRequest $create_sync_mapping_request New Entity Mapping of a Person. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSyncMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSyncMappingAsyncWithHttpInfo($create_sync_mapping_request = null, string $contentType = self::contentTypes['createSyncMapping'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\SyncEntityMapping';
        $request = $this->createSyncMappingRequest($create_sync_mapping_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createSyncMapping'
     *
     * @param  \StevenBuehner\ChurchTools\Model\CreateSyncMappingRequest $create_sync_mapping_request New Entity Mapping of a Person. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSyncMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createSyncMappingRequest($create_sync_mapping_request = null, string $contentType = self::contentTypes['createSyncMapping'][0])
    {



        $resourcePath = '/sync/entitymappings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_sync_mapping_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_sync_mapping_request));
            } else {
                $httpBody = $create_sync_mapping_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteEntityMapping
     *
     * Delete Mapping from Database.
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEntityMapping'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteEntityMapping($id, string $contentType = self::contentTypes['deleteEntityMapping'][0])
    {
        $this->deleteEntityMappingWithHttpInfo($id, $contentType);
    }

    /**
     * Operation deleteEntityMappingWithHttpInfo
     *
     * Delete Mapping from Database.
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEntityMapping'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEntityMappingWithHttpInfo($id, string $contentType = self::contentTypes['deleteEntityMapping'][0])
    {
        $request = $this->deleteEntityMappingRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteEntityMappingAsync
     *
     * Delete Mapping from Database.
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEntityMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEntityMappingAsync($id, string $contentType = self::contentTypes['deleteEntityMapping'][0])
    {
        return $this->deleteEntityMappingAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteEntityMappingAsyncWithHttpInfo
     *
     * Delete Mapping from Database.
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEntityMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEntityMappingAsyncWithHttpInfo($id, string $contentType = self::contentTypes['deleteEntityMapping'][0])
    {
        $returnType = '';
        $request = $this->deleteEntityMappingRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteEntityMapping'
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEntityMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteEntityMappingRequest($id, string $contentType = self::contentTypes['deleteEntityMapping'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling deleteEntityMapping'
            );
        }


        $resourcePath = '/sync/entitymappings/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSyncConflict
     *
     * Delete Conflict
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncConflict'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSyncConflict($id, string $contentType = self::contentTypes['deleteSyncConflict'][0])
    {
        $this->deleteSyncConflictWithHttpInfo($id, $contentType);
    }

    /**
     * Operation deleteSyncConflictWithHttpInfo
     *
     * Delete Conflict
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncConflict'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSyncConflictWithHttpInfo($id, string $contentType = self::contentTypes['deleteSyncConflict'][0])
    {
        $request = $this->deleteSyncConflictRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSyncConflictAsync
     *
     * Delete Conflict
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncConflict'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSyncConflictAsync($id, string $contentType = self::contentTypes['deleteSyncConflict'][0])
    {
        return $this->deleteSyncConflictAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSyncConflictAsyncWithHttpInfo
     *
     * Delete Conflict
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncConflict'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSyncConflictAsyncWithHttpInfo($id, string $contentType = self::contentTypes['deleteSyncConflict'][0])
    {
        $returnType = '';
        $request = $this->deleteSyncConflictRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSyncConflict'
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncConflict'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSyncConflictRequest($id, string $contentType = self::contentTypes['deleteSyncConflict'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling deleteSyncConflict'
            );
        }


        $resourcePath = '/sync/conflicts/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId
     *
     * Delete job config
     *
     * @param  string $external_system_id external_system_id (required)
     * @param  string $job_id job_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'][0])
    {
        $this->deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdWithHttpInfo($external_system_id, $job_id, $contentType);
    }

    /**
     * Operation deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdWithHttpInfo
     *
     * Delete job config
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdWithHttpInfo($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'][0])
    {
        $request = $this->deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdRequest($external_system_id, $job_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdAsync
     *
     * Delete job config
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdAsync($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'][0])
    {
        return $this->deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdAsyncWithHttpInfo($external_system_id, $job_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdAsyncWithHttpInfo
     *
     * Delete job config
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdAsyncWithHttpInfo($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'][0])
    {
        $returnType = '';
        $request = $this->deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdRequest($external_system_id, $job_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdRequest($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'
            );
        }

        // verify the required parameter 'job_id' is set
        if ($job_id === null || (is_array($job_id) && count($job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling deleteSyncExternalsystemsExternalSystemIdJobconfigsJobId'
            );
        }


        $resourcePath = '/sync/externalsystems/{externalSystemId}/jobconfigs/{jobId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }
        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter
     *
     * Delete all filter entities
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {
        $this->deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterWithHttpInfo($external_system_id, $job_id, $contentType);
    }

    /**
     * Operation deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterWithHttpInfo
     *
     * Delete all filter entities
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterWithHttpInfo($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {
        $request = $this->deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest($external_system_id, $job_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsync
     *
     * Delete all filter entities
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsync($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {
        return $this->deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsyncWithHttpInfo($external_system_id, $job_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsyncWithHttpInfo
     *
     * Delete all filter entities
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsyncWithHttpInfo($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {
        $returnType = '';
        $request = $this->deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest($external_system_id, $job_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'
            );
        }

        // verify the required parameter 'job_id' is set
        if ($job_id === null || (is_array($job_id) && count($job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'
            );
        }


        $resourcePath = '/sync/externalsystems/{externalSystemId}/jobconfigs/{jobId}/filter';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }
        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('login_token');
        if ($apiKey !== null) {
            $queryParams['login_token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties
     *
     * Delete all Properties for This Job
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {
        $this->deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesWithHttpInfo($external_system_id, $job_id, $contentType);
    }

    /**
     * Operation deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesWithHttpInfo
     *
     * Delete all Properties for This Job
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesWithHttpInfo($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {
        $request = $this->deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest($external_system_id, $job_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsync
     *
     * Delete all Properties for This Job
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsync($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {
        return $this->deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsyncWithHttpInfo($external_system_id, $job_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsyncWithHttpInfo
     *
     * Delete all Properties for This Job
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsyncWithHttpInfo($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {
        $returnType = '';
        $request = $this->deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest($external_system_id, $job_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest($external_system_id, $job_id, string $contentType = self::contentTypes['deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'
            );
        }

        // verify the required parameter 'job_id' is set
        if ($job_id === null || (is_array($job_id) && count($job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling deleteSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'
            );
        }


        $resourcePath = '/sync/externalsystems/{externalSystemId}/jobconfigs/{jobId}/properties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }
        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('login_token');
        if ($apiKey !== null) {
            $queryParams['login_token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSyncExternalsystemsId
     *
     * DELETE external system
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSyncExternalsystemsId($id, string $contentType = self::contentTypes['deleteSyncExternalsystemsId'][0])
    {
        $this->deleteSyncExternalsystemsIdWithHttpInfo($id, $contentType);
    }

    /**
     * Operation deleteSyncExternalsystemsIdWithHttpInfo
     *
     * DELETE external system
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSyncExternalsystemsIdWithHttpInfo($id, string $contentType = self::contentTypes['deleteSyncExternalsystemsId'][0])
    {
        $request = $this->deleteSyncExternalsystemsIdRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSyncExternalsystemsIdAsync
     *
     * DELETE external system
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSyncExternalsystemsIdAsync($id, string $contentType = self::contentTypes['deleteSyncExternalsystemsId'][0])
    {
        return $this->deleteSyncExternalsystemsIdAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSyncExternalsystemsIdAsyncWithHttpInfo
     *
     * DELETE external system
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSyncExternalsystemsIdAsyncWithHttpInfo($id, string $contentType = self::contentTypes['deleteSyncExternalsystemsId'][0])
    {
        $returnType = '';
        $request = $this->deleteSyncExternalsystemsIdRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSyncExternalsystemsId'
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSyncExternalsystemsIdRequest($id, string $contentType = self::contentTypes['deleteSyncExternalsystemsId'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling deleteSyncExternalsystemsId'
            );
        }


        $resourcePath = '/sync/externalsystems/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSyncFieldMappings
     *
     * Delete Mapping for Domain Type
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSyncFieldMappings($domain_type, $external_system_id, string $contentType = self::contentTypes['deleteSyncFieldMappings'][0])
    {
        $this->deleteSyncFieldMappingsWithHttpInfo($domain_type, $external_system_id, $contentType);
    }

    /**
     * Operation deleteSyncFieldMappingsWithHttpInfo
     *
     * Delete Mapping for Domain Type
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSyncFieldMappingsWithHttpInfo($domain_type, $external_system_id, string $contentType = self::contentTypes['deleteSyncFieldMappings'][0])
    {
        $request = $this->deleteSyncFieldMappingsRequest($domain_type, $external_system_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSyncFieldMappingsAsync
     *
     * Delete Mapping for Domain Type
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSyncFieldMappingsAsync($domain_type, $external_system_id, string $contentType = self::contentTypes['deleteSyncFieldMappings'][0])
    {
        return $this->deleteSyncFieldMappingsAsyncWithHttpInfo($domain_type, $external_system_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSyncFieldMappingsAsyncWithHttpInfo
     *
     * Delete Mapping for Domain Type
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSyncFieldMappingsAsyncWithHttpInfo($domain_type, $external_system_id, string $contentType = self::contentTypes['deleteSyncFieldMappings'][0])
    {
        $returnType = '';
        $request = $this->deleteSyncFieldMappingsRequest($domain_type, $external_system_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSyncFieldMappings'
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSyncFieldMappingsRequest($domain_type, $external_system_id, string $contentType = self::contentTypes['deleteSyncFieldMappings'][0])
    {

        // verify the required parameter 'domain_type' is set
        if ($domain_type === null || (is_array($domain_type) && count($domain_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_type when calling deleteSyncFieldMappings'
            );
        }

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling deleteSyncFieldMappings'
            );
        }


        $resourcePath = '/sync/externalsystems/{externalSystemId}/fieldmappings/{domainType}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($domain_type !== null) {
            $resourcePath = str_replace(
                '{' . 'domainType' . '}',
                ObjectSerializer::toPathValue($domain_type),
                $resourcePath
            );
        }
        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEntityMapping
     *
     * Get One Entity Mapping
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEntityMapping'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\SyncEntityMapping
     */
    public function getEntityMapping($id, string $contentType = self::contentTypes['getEntityMapping'][0])
    {
        list($response) = $this->getEntityMappingWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation getEntityMappingWithHttpInfo
     *
     * Get One Entity Mapping
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEntityMapping'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\SyncEntityMapping, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEntityMappingWithHttpInfo($id, string $contentType = self::contentTypes['getEntityMapping'][0])
    {
        $request = $this->getEntityMappingRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\SyncEntityMapping' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\SyncEntityMapping' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\SyncEntityMapping', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\SyncEntityMapping';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\SyncEntityMapping',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getEntityMappingAsync
     *
     * Get One Entity Mapping
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEntityMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEntityMappingAsync($id, string $contentType = self::contentTypes['getEntityMapping'][0])
    {
        return $this->getEntityMappingAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEntityMappingAsyncWithHttpInfo
     *
     * Get One Entity Mapping
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEntityMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEntityMappingAsyncWithHttpInfo($id, string $contentType = self::contentTypes['getEntityMapping'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\SyncEntityMapping';
        $request = $this->getEntityMappingRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEntityMapping'
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEntityMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEntityMappingRequest($id, string $contentType = self::contentTypes['getEntityMapping'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getEntityMapping'
            );
        }


        $resourcePath = '/sync/entitymappings/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncAdapters
     *
     * GET Sync Adapters
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncAdapters'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncAdapters200Response
     */
    public function getSyncAdapters(string $contentType = self::contentTypes['getSyncAdapters'][0])
    {
        list($response) = $this->getSyncAdaptersWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getSyncAdaptersWithHttpInfo
     *
     * GET Sync Adapters
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncAdapters'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncAdapters200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncAdaptersWithHttpInfo(string $contentType = self::contentTypes['getSyncAdapters'][0])
    {
        $request = $this->getSyncAdaptersRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncAdapters200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncAdapters200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncAdapters200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncAdapters200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncAdapters200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncAdaptersAsync
     *
     * GET Sync Adapters
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncAdapters'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncAdaptersAsync(string $contentType = self::contentTypes['getSyncAdapters'][0])
    {
        return $this->getSyncAdaptersAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncAdaptersAsyncWithHttpInfo
     *
     * GET Sync Adapters
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncAdapters'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncAdaptersAsyncWithHttpInfo(string $contentType = self::contentTypes['getSyncAdapters'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncAdapters200Response';
        $request = $this->getSyncAdaptersRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncAdapters'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncAdapters'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncAdaptersRequest(string $contentType = self::contentTypes['getSyncAdapters'][0])
    {


        $resourcePath = '/sync/adapters';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncConflict
     *
     * Fetch One Conflict
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncConflict'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response
     */
    public function getSyncConflict($id, string $contentType = self::contentTypes['getSyncConflict'][0])
    {
        list($response) = $this->getSyncConflictWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation getSyncConflictWithHttpInfo
     *
     * Fetch One Conflict
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncConflict'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncConflictWithHttpInfo($id, string $contentType = self::contentTypes['getSyncConflict'][0])
    {
        $request = $this->getSyncConflictRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncConflictAsync
     *
     * Fetch One Conflict
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncConflict'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncConflictAsync($id, string $contentType = self::contentTypes['getSyncConflict'][0])
    {
        return $this->getSyncConflictAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncConflictAsyncWithHttpInfo
     *
     * Fetch One Conflict
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncConflict'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncConflictAsyncWithHttpInfo($id, string $contentType = self::contentTypes['getSyncConflict'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response';
        $request = $this->getSyncConflictRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncConflict'
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncConflict'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncConflictRequest($id, string $contentType = self::contentTypes['getSyncConflict'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getSyncConflict'
            );
        }


        $resourcePath = '/sync/conflicts/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncConflicts
     *
     * Fetch all conflicts
     *
     * @param  string[] $types Filter Response by Conflict Type (optional)
     * @param  string[] $domain_types Filter Response by Domain Types of Related Entity Mappings (optional)
     * @param  int[] $source_ids Filter Response by Source Ids of Related Entity Mappings (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncConflicts'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncConflicts200Response
     */
    public function getSyncConflicts($types = null, $domain_types = null, $source_ids = null, string $contentType = self::contentTypes['getSyncConflicts'][0])
    {
        list($response) = $this->getSyncConflictsWithHttpInfo($types, $domain_types, $source_ids, $contentType);
        return $response;
    }

    /**
     * Operation getSyncConflictsWithHttpInfo
     *
     * Fetch all conflicts
     *
     * @param  string[] $types Filter Response by Conflict Type (optional)
     * @param  string[] $domain_types Filter Response by Domain Types of Related Entity Mappings (optional)
     * @param  int[] $source_ids Filter Response by Source Ids of Related Entity Mappings (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncConflicts'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncConflicts200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncConflictsWithHttpInfo($types = null, $domain_types = null, $source_ids = null, string $contentType = self::contentTypes['getSyncConflicts'][0])
    {
        $request = $this->getSyncConflictsRequest($types, $domain_types, $source_ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncConflicts200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncConflicts200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncConflicts200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncConflicts200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncConflicts200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncConflictsAsync
     *
     * Fetch all conflicts
     *
     * @param  string[] $types Filter Response by Conflict Type (optional)
     * @param  string[] $domain_types Filter Response by Domain Types of Related Entity Mappings (optional)
     * @param  int[] $source_ids Filter Response by Source Ids of Related Entity Mappings (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncConflicts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncConflictsAsync($types = null, $domain_types = null, $source_ids = null, string $contentType = self::contentTypes['getSyncConflicts'][0])
    {
        return $this->getSyncConflictsAsyncWithHttpInfo($types, $domain_types, $source_ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncConflictsAsyncWithHttpInfo
     *
     * Fetch all conflicts
     *
     * @param  string[] $types Filter Response by Conflict Type (optional)
     * @param  string[] $domain_types Filter Response by Domain Types of Related Entity Mappings (optional)
     * @param  int[] $source_ids Filter Response by Source Ids of Related Entity Mappings (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncConflicts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncConflictsAsyncWithHttpInfo($types = null, $domain_types = null, $source_ids = null, string $contentType = self::contentTypes['getSyncConflicts'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncConflicts200Response';
        $request = $this->getSyncConflictsRequest($types, $domain_types, $source_ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncConflicts'
     *
     * @param  string[] $types Filter Response by Conflict Type (optional)
     * @param  string[] $domain_types Filter Response by Domain Types of Related Entity Mappings (optional)
     * @param  int[] $source_ids Filter Response by Source Ids of Related Entity Mappings (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncConflicts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncConflictsRequest($types = null, $domain_types = null, $source_ids = null, string $contentType = self::contentTypes['getSyncConflicts'][0])
    {

        



        $resourcePath = '/sync/conflicts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $types,
            'types[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $domain_types,
            'domain_types[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $source_ids,
            'source_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncExecutions
     *
     * Statistical Information about Sync Executions
     *
     * @param  int[] $es_ids Filter by external system (optional)
     * @param  int[] $job_ids Filter by sync job configuration (optional)
     * @param  \DateTime $start_date Return executions after that date (optional)
     * @param  \DateTime $end_date Return executions before that date (optional)
     * @param  string[] $statuses Filter by status (optional)
     * @param  int $page Query page (optional)
     * @param  int $limit Number of results per page (optional)
     * @param  bool $is_dry_run is_dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExecutions'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncExecutions200Response
     */
    public function getSyncExecutions($es_ids = null, $job_ids = null, $start_date = null, $end_date = null, $statuses = null, $page = null, $limit = null, $is_dry_run = null, string $contentType = self::contentTypes['getSyncExecutions'][0])
    {
        list($response) = $this->getSyncExecutionsWithHttpInfo($es_ids, $job_ids, $start_date, $end_date, $statuses, $page, $limit, $is_dry_run, $contentType);
        return $response;
    }

    /**
     * Operation getSyncExecutionsWithHttpInfo
     *
     * Statistical Information about Sync Executions
     *
     * @param  int[] $es_ids Filter by external system (optional)
     * @param  int[] $job_ids Filter by sync job configuration (optional)
     * @param  \DateTime $start_date Return executions after that date (optional)
     * @param  \DateTime $end_date Return executions before that date (optional)
     * @param  string[] $statuses Filter by status (optional)
     * @param  int $page Query page (optional)
     * @param  int $limit Number of results per page (optional)
     * @param  bool $is_dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExecutions'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncExecutions200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncExecutionsWithHttpInfo($es_ids = null, $job_ids = null, $start_date = null, $end_date = null, $statuses = null, $page = null, $limit = null, $is_dry_run = null, string $contentType = self::contentTypes['getSyncExecutions'][0])
    {
        $request = $this->getSyncExecutionsRequest($es_ids, $job_ids, $start_date, $end_date, $statuses, $page, $limit, $is_dry_run, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncExecutions200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncExecutions200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncExecutions200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExecutions200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncExecutions200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncExecutionsAsync
     *
     * Statistical Information about Sync Executions
     *
     * @param  int[] $es_ids Filter by external system (optional)
     * @param  int[] $job_ids Filter by sync job configuration (optional)
     * @param  \DateTime $start_date Return executions after that date (optional)
     * @param  \DateTime $end_date Return executions before that date (optional)
     * @param  string[] $statuses Filter by status (optional)
     * @param  int $page Query page (optional)
     * @param  int $limit Number of results per page (optional)
     * @param  bool $is_dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExecutions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExecutionsAsync($es_ids = null, $job_ids = null, $start_date = null, $end_date = null, $statuses = null, $page = null, $limit = null, $is_dry_run = null, string $contentType = self::contentTypes['getSyncExecutions'][0])
    {
        return $this->getSyncExecutionsAsyncWithHttpInfo($es_ids, $job_ids, $start_date, $end_date, $statuses, $page, $limit, $is_dry_run, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncExecutionsAsyncWithHttpInfo
     *
     * Statistical Information about Sync Executions
     *
     * @param  int[] $es_ids Filter by external system (optional)
     * @param  int[] $job_ids Filter by sync job configuration (optional)
     * @param  \DateTime $start_date Return executions after that date (optional)
     * @param  \DateTime $end_date Return executions before that date (optional)
     * @param  string[] $statuses Filter by status (optional)
     * @param  int $page Query page (optional)
     * @param  int $limit Number of results per page (optional)
     * @param  bool $is_dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExecutions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExecutionsAsyncWithHttpInfo($es_ids = null, $job_ids = null, $start_date = null, $end_date = null, $statuses = null, $page = null, $limit = null, $is_dry_run = null, string $contentType = self::contentTypes['getSyncExecutions'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExecutions200Response';
        $request = $this->getSyncExecutionsRequest($es_ids, $job_ids, $start_date, $end_date, $statuses, $page, $limit, $is_dry_run, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncExecutions'
     *
     * @param  int[] $es_ids Filter by external system (optional)
     * @param  int[] $job_ids Filter by sync job configuration (optional)
     * @param  \DateTime $start_date Return executions after that date (optional)
     * @param  \DateTime $end_date Return executions before that date (optional)
     * @param  string[] $statuses Filter by status (optional)
     * @param  int $page Query page (optional)
     * @param  int $limit Number of results per page (optional)
     * @param  bool $is_dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExecutions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncExecutionsRequest($es_ids = null, $job_ids = null, $start_date = null, $end_date = null, $statuses = null, $page = null, $limit = null, $is_dry_run = null, string $contentType = self::contentTypes['getSyncExecutions'][0])
    {










        $resourcePath = '/sync/executions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $es_ids,
            'es_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $job_ids,
            'job_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_date,
            'start_date', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_date,
            'end_date', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $statuses,
            'statuses', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_dry_run,
            'is_dry_run', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncExternalsystems
     *
     * GET External Systems
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystems'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncExternalsystems200Response
     */
    public function getSyncExternalsystems(string $contentType = self::contentTypes['getSyncExternalsystems'][0])
    {
        list($response) = $this->getSyncExternalsystemsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getSyncExternalsystemsWithHttpInfo
     *
     * GET External Systems
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystems'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncExternalsystems200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncExternalsystemsWithHttpInfo(string $contentType = self::contentTypes['getSyncExternalsystems'][0])
    {
        $request = $this->getSyncExternalsystemsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystems200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystems200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystems200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystems200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystems200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncExternalsystemsAsync
     *
     * GET External Systems
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExternalsystemsAsync(string $contentType = self::contentTypes['getSyncExternalsystems'][0])
    {
        return $this->getSyncExternalsystemsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncExternalsystemsAsyncWithHttpInfo
     *
     * GET External Systems
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExternalsystemsAsyncWithHttpInfo(string $contentType = self::contentTypes['getSyncExternalsystems'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystems200Response';
        $request = $this->getSyncExternalsystemsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncExternalsystems'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncExternalsystemsRequest(string $contentType = self::contentTypes['getSyncExternalsystems'][0])
    {


        $resourcePath = '/sync/externalsystems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigsJobId
     *
     * Your Job Configuration
     *
     * @param  string $external_system_id external_system_id (required)
     * @param  string $job_id job_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobId($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobId'][0])
    {
        list($response) = $this->getSyncExternalsystemsExternalSystemIdJobconfigsJobIdWithHttpInfo($external_system_id, $job_id, $contentType);
        return $response;
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigsJobIdWithHttpInfo
     *
     * Your Job Configuration
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdWithHttpInfo($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobId'][0])
    {
        $request = $this->getSyncExternalsystemsExternalSystemIdJobconfigsJobIdRequest($external_system_id, $job_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigsJobIdAsync
     *
     * Your Job Configuration
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdAsync($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobId'][0])
    {
        return $this->getSyncExternalsystemsExternalSystemIdJobconfigsJobIdAsyncWithHttpInfo($external_system_id, $job_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigsJobIdAsyncWithHttpInfo
     *
     * Your Job Configuration
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdAsyncWithHttpInfo($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobId'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response';
        $request = $this->getSyncExternalsystemsExternalSystemIdJobconfigsJobIdRequest($external_system_id, $job_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncExternalsystemsExternalSystemIdJobconfigsJobId'
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdRequest($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobId'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling getSyncExternalsystemsExternalSystemIdJobconfigsJobId'
            );
        }

        // verify the required parameter 'job_id' is set
        if ($job_id === null || (is_array($job_id) && count($job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling getSyncExternalsystemsExternalSystemIdJobconfigsJobId'
            );
        }


        $resourcePath = '/sync/externalsystems/{externalSystemId}/jobconfigs/{jobId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }
        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter
     *
     * Fetch all entity filters for this job
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {
        list($response) = $this->getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterWithHttpInfo($external_system_id, $job_id, $contentType);
        return $response;
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterWithHttpInfo
     *
     * Fetch all entity filters for this job
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterWithHttpInfo($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {
        $request = $this->getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest($external_system_id, $job_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsync
     *
     * Fetch all entity filters for this job
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsync($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {
        return $this->getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsyncWithHttpInfo($external_system_id, $job_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsyncWithHttpInfo
     *
     * Fetch all entity filters for this job
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsyncWithHttpInfo($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response';
        $request = $this->getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest($external_system_id, $job_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'
            );
        }

        // verify the required parameter 'job_id' is set
        if ($job_id === null || (is_array($job_id) && count($job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling getSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'
            );
        }


        $resourcePath = '/sync/externalsystems/{externalSystemId}/jobconfigs/{jobId}/filter';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }
        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('login_token');
        if ($apiKey !== null) {
            $queryParams['login_token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties
     *
     * Fetch all Properties for This Job
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {
        list($response) = $this->getSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesWithHttpInfo($external_system_id, $job_id, $contentType);
        return $response;
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesWithHttpInfo
     *
     * Fetch all Properties for This Job
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesWithHttpInfo($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {
        $request = $this->getSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest($external_system_id, $job_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsync
     *
     * Fetch all Properties for This Job
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsync($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {
        return $this->getSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsyncWithHttpInfo($external_system_id, $job_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsyncWithHttpInfo
     *
     * Fetch all Properties for This Job
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsyncWithHttpInfo($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response';
        $request = $this->getSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest($external_system_id, $job_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest($external_system_id, $job_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'
            );
        }

        // verify the required parameter 'job_id' is set
        if ($job_id === null || (is_array($job_id) && count($job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling getSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'
            );
        }


        $resourcePath = '/sync/externalsystems/{externalSystemId}/jobconfigs/{jobId}/properties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }
        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('login_token');
        if ($apiKey !== null) {
            $queryParams['login_token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigurations
     *
     * GET Job configurations
     *
     * @param  string $external_system_id external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigurations'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigurations($external_system_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigurations'][0])
    {
        list($response) = $this->getSyncExternalsystemsExternalSystemIdJobconfigurationsWithHttpInfo($external_system_id, $contentType);
        return $response;
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigurationsWithHttpInfo
     *
     * GET Job configurations
     *
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigurations'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigurationsWithHttpInfo($external_system_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigurations'][0])
    {
        $request = $this->getSyncExternalsystemsExternalSystemIdJobconfigurationsRequest($external_system_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigurationsAsync
     *
     * GET Job configurations
     *
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigurations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigurationsAsync($external_system_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigurations'][0])
    {
        return $this->getSyncExternalsystemsExternalSystemIdJobconfigurationsAsyncWithHttpInfo($external_system_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncExternalsystemsExternalSystemIdJobconfigurationsAsyncWithHttpInfo
     *
     * GET Job configurations
     *
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigurations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigurationsAsyncWithHttpInfo($external_system_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigurations'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response';
        $request = $this->getSyncExternalsystemsExternalSystemIdJobconfigurationsRequest($external_system_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncExternalsystemsExternalSystemIdJobconfigurations'
     *
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigurations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncExternalsystemsExternalSystemIdJobconfigurationsRequest($external_system_id, string $contentType = self::contentTypes['getSyncExternalsystemsExternalSystemIdJobconfigurations'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling getSyncExternalsystemsExternalSystemIdJobconfigurations'
            );
        }


        $resourcePath = '/sync/externalsystems/{externalSystemId}/jobconfigs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncExternalsystemsId
     *
     * GET an external system by id
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsId200Response
     */
    public function getSyncExternalsystemsId($id, string $contentType = self::contentTypes['getSyncExternalsystemsId'][0])
    {
        list($response) = $this->getSyncExternalsystemsIdWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation getSyncExternalsystemsIdWithHttpInfo
     *
     * GET an external system by id
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsId200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncExternalsystemsIdWithHttpInfo($id, string $contentType = self::contentTypes['getSyncExternalsystemsId'][0])
    {
        $request = $this->getSyncExternalsystemsIdRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsId200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsId200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsId200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsId200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsId200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncExternalsystemsIdAsync
     *
     * GET an external system by id
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExternalsystemsIdAsync($id, string $contentType = self::contentTypes['getSyncExternalsystemsId'][0])
    {
        return $this->getSyncExternalsystemsIdAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncExternalsystemsIdAsyncWithHttpInfo
     *
     * GET an external system by id
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncExternalsystemsIdAsyncWithHttpInfo($id, string $contentType = self::contentTypes['getSyncExternalsystemsId'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsId200Response';
        $request = $this->getSyncExternalsystemsIdRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncExternalsystemsId'
     *
     * @param  int $id ID of Entity (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncExternalsystemsIdRequest($id, string $contentType = self::contentTypes['getSyncExternalsystemsId'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getSyncExternalsystemsId'
            );
        }


        $resourcePath = '/sync/externalsystems/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncFieldMappings
     *
     * Get Mapping for Domain Type
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncFieldMappings200Response
     */
    public function getSyncFieldMappings($domain_type, $external_system_id, string $contentType = self::contentTypes['getSyncFieldMappings'][0])
    {
        list($response) = $this->getSyncFieldMappingsWithHttpInfo($domain_type, $external_system_id, $contentType);
        return $response;
    }

    /**
     * Operation getSyncFieldMappingsWithHttpInfo
     *
     * Get Mapping for Domain Type
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncFieldMappings200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncFieldMappingsWithHttpInfo($domain_type, $external_system_id, string $contentType = self::contentTypes['getSyncFieldMappings'][0])
    {
        $request = $this->getSyncFieldMappingsRequest($domain_type, $external_system_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncFieldMappings200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncFieldMappings200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncFieldMappings200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncFieldMappings200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncFieldMappings200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncFieldMappingsAsync
     *
     * Get Mapping for Domain Type
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncFieldMappingsAsync($domain_type, $external_system_id, string $contentType = self::contentTypes['getSyncFieldMappings'][0])
    {
        return $this->getSyncFieldMappingsAsyncWithHttpInfo($domain_type, $external_system_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncFieldMappingsAsyncWithHttpInfo
     *
     * Get Mapping for Domain Type
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncFieldMappingsAsyncWithHttpInfo($domain_type, $external_system_id, string $contentType = self::contentTypes['getSyncFieldMappings'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncFieldMappings200Response';
        $request = $this->getSyncFieldMappingsRequest($domain_type, $external_system_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncFieldMappings'
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncFieldMappingsRequest($domain_type, $external_system_id, string $contentType = self::contentTypes['getSyncFieldMappings'][0])
    {

        // verify the required parameter 'domain_type' is set
        if ($domain_type === null || (is_array($domain_type) && count($domain_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_type when calling getSyncFieldMappings'
            );
        }

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling getSyncFieldMappings'
            );
        }


        $resourcePath = '/sync/externalsystems/{externalSystemId}/fieldmappings/{domainType}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($domain_type !== null) {
            $resourcePath = str_replace(
                '{' . 'domainType' . '}',
                ObjectSerializer::toPathValue($domain_type),
                $resourcePath
            );
        }
        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncFieldMappingsNoSuggestions
     *
     * Get fields for which no suggestions should be shown
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncFieldMappingsNoSuggestions'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncFieldMappingsNoSuggestions200Response
     */
    public function getSyncFieldMappingsNoSuggestions($domain_type, $external_system_id, string $contentType = self::contentTypes['getSyncFieldMappingsNoSuggestions'][0])
    {
        list($response) = $this->getSyncFieldMappingsNoSuggestionsWithHttpInfo($domain_type, $external_system_id, $contentType);
        return $response;
    }

    /**
     * Operation getSyncFieldMappingsNoSuggestionsWithHttpInfo
     *
     * Get fields for which no suggestions should be shown
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncFieldMappingsNoSuggestions'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncFieldMappingsNoSuggestions200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncFieldMappingsNoSuggestionsWithHttpInfo($domain_type, $external_system_id, string $contentType = self::contentTypes['getSyncFieldMappingsNoSuggestions'][0])
    {
        $request = $this->getSyncFieldMappingsNoSuggestionsRequest($domain_type, $external_system_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncFieldMappingsNoSuggestions200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncFieldMappingsNoSuggestions200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncFieldMappingsNoSuggestions200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncFieldMappingsNoSuggestions200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncFieldMappingsNoSuggestions200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncFieldMappingsNoSuggestionsAsync
     *
     * Get fields for which no suggestions should be shown
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncFieldMappingsNoSuggestions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncFieldMappingsNoSuggestionsAsync($domain_type, $external_system_id, string $contentType = self::contentTypes['getSyncFieldMappingsNoSuggestions'][0])
    {
        return $this->getSyncFieldMappingsNoSuggestionsAsyncWithHttpInfo($domain_type, $external_system_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncFieldMappingsNoSuggestionsAsyncWithHttpInfo
     *
     * Get fields for which no suggestions should be shown
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncFieldMappingsNoSuggestions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncFieldMappingsNoSuggestionsAsyncWithHttpInfo($domain_type, $external_system_id, string $contentType = self::contentTypes['getSyncFieldMappingsNoSuggestions'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncFieldMappingsNoSuggestions200Response';
        $request = $this->getSyncFieldMappingsNoSuggestionsRequest($domain_type, $external_system_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncFieldMappingsNoSuggestions'
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncFieldMappingsNoSuggestions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncFieldMappingsNoSuggestionsRequest($domain_type, $external_system_id, string $contentType = self::contentTypes['getSyncFieldMappingsNoSuggestions'][0])
    {

        // verify the required parameter 'domain_type' is set
        if ($domain_type === null || (is_array($domain_type) && count($domain_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_type when calling getSyncFieldMappingsNoSuggestions'
            );
        }

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling getSyncFieldMappingsNoSuggestions'
            );
        }


        $resourcePath = '/sync/externalsystems/{externalSystemId}/fieldmappings/{domainType}/nosuggestions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($domain_type !== null) {
            $resourcePath = str_replace(
                '{' . 'domainType' . '}',
                ObjectSerializer::toPathValue($domain_type),
                $resourcePath
            );
        }
        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncJobconfigs
     *
     * Your GET endpoint
     *
     * @param  int[] $external_system_ids external_system_ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncJobconfigs'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response
     */
    public function getSyncJobconfigs($external_system_ids = null, string $contentType = self::contentTypes['getSyncJobconfigs'][0])
    {
        list($response) = $this->getSyncJobconfigsWithHttpInfo($external_system_ids, $contentType);
        return $response;
    }

    /**
     * Operation getSyncJobconfigsWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  int[] $external_system_ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncJobconfigs'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncJobconfigsWithHttpInfo($external_system_ids = null, string $contentType = self::contentTypes['getSyncJobconfigs'][0])
    {
        $request = $this->getSyncJobconfigsRequest($external_system_ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncJobconfigsAsync
     *
     * Your GET endpoint
     *
     * @param  int[] $external_system_ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncJobconfigs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncJobconfigsAsync($external_system_ids = null, string $contentType = self::contentTypes['getSyncJobconfigs'][0])
    {
        return $this->getSyncJobconfigsAsyncWithHttpInfo($external_system_ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncJobconfigsAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  int[] $external_system_ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncJobconfigs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncJobconfigsAsyncWithHttpInfo($external_system_ids = null, string $contentType = self::contentTypes['getSyncJobconfigs'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigurations200Response';
        $request = $this->getSyncJobconfigsRequest($external_system_ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncJobconfigs'
     *
     * @param  int[] $external_system_ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncJobconfigs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncJobconfigsRequest($external_system_ids = null, string $contentType = self::contentTypes['getSyncJobconfigs'][0])
    {



        $resourcePath = '/sync/jobconfigs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $external_system_ids,
            'external_system_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncLogs
     *
     * Get Sync Logs
     *
     * @param  int $page Page Number (optional, default to 1)
     * @param  int $limit Number of Logs per Page (optional, default to 10)
     * @param  int[] $es_ids Filter by External Systems (optional)
     * @param  int[] $job_ids Filter by Jobs (optional)
     * @param  \DateTime $start_date Show Logs From This Date on (optional)
     * @param  \DateTime $end_date Show Logs Until This Date (optional)
     * @param  int[] $types Filter by Types (optional)
     * @param  string $query Search Through Log Messages (optional)
     * @param  string[] $levels the log levels (optional)
     * @param  bool $is_dry_run is_dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncLogs'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncLogs200Response
     */
    public function getSyncLogs($page = 1, $limit = 10, $es_ids = null, $job_ids = null, $start_date = null, $end_date = null, $types = null, $query = null, $levels = null, $is_dry_run = null, string $contentType = self::contentTypes['getSyncLogs'][0])
    {
        list($response) = $this->getSyncLogsWithHttpInfo($page, $limit, $es_ids, $job_ids, $start_date, $end_date, $types, $query, $levels, $is_dry_run, $contentType);
        return $response;
    }

    /**
     * Operation getSyncLogsWithHttpInfo
     *
     * Get Sync Logs
     *
     * @param  int $page Page Number (optional, default to 1)
     * @param  int $limit Number of Logs per Page (optional, default to 10)
     * @param  int[] $es_ids Filter by External Systems (optional)
     * @param  int[] $job_ids Filter by Jobs (optional)
     * @param  \DateTime $start_date Show Logs From This Date on (optional)
     * @param  \DateTime $end_date Show Logs Until This Date (optional)
     * @param  int[] $types Filter by Types (optional)
     * @param  string $query Search Through Log Messages (optional)
     * @param  string[] $levels the log levels (optional)
     * @param  bool $is_dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncLogs'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncLogs200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncLogsWithHttpInfo($page = 1, $limit = 10, $es_ids = null, $job_ids = null, $start_date = null, $end_date = null, $types = null, $query = null, $levels = null, $is_dry_run = null, string $contentType = self::contentTypes['getSyncLogs'][0])
    {
        $request = $this->getSyncLogsRequest($page, $limit, $es_ids, $job_ids, $start_date, $end_date, $types, $query, $levels, $is_dry_run, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncLogs200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncLogs200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncLogs200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncLogs200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncLogs200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncLogsAsync
     *
     * Get Sync Logs
     *
     * @param  int $page Page Number (optional, default to 1)
     * @param  int $limit Number of Logs per Page (optional, default to 10)
     * @param  int[] $es_ids Filter by External Systems (optional)
     * @param  int[] $job_ids Filter by Jobs (optional)
     * @param  \DateTime $start_date Show Logs From This Date on (optional)
     * @param  \DateTime $end_date Show Logs Until This Date (optional)
     * @param  int[] $types Filter by Types (optional)
     * @param  string $query Search Through Log Messages (optional)
     * @param  string[] $levels the log levels (optional)
     * @param  bool $is_dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncLogs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncLogsAsync($page = 1, $limit = 10, $es_ids = null, $job_ids = null, $start_date = null, $end_date = null, $types = null, $query = null, $levels = null, $is_dry_run = null, string $contentType = self::contentTypes['getSyncLogs'][0])
    {
        return $this->getSyncLogsAsyncWithHttpInfo($page, $limit, $es_ids, $job_ids, $start_date, $end_date, $types, $query, $levels, $is_dry_run, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncLogsAsyncWithHttpInfo
     *
     * Get Sync Logs
     *
     * @param  int $page Page Number (optional, default to 1)
     * @param  int $limit Number of Logs per Page (optional, default to 10)
     * @param  int[] $es_ids Filter by External Systems (optional)
     * @param  int[] $job_ids Filter by Jobs (optional)
     * @param  \DateTime $start_date Show Logs From This Date on (optional)
     * @param  \DateTime $end_date Show Logs Until This Date (optional)
     * @param  int[] $types Filter by Types (optional)
     * @param  string $query Search Through Log Messages (optional)
     * @param  string[] $levels the log levels (optional)
     * @param  bool $is_dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncLogs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncLogsAsyncWithHttpInfo($page = 1, $limit = 10, $es_ids = null, $job_ids = null, $start_date = null, $end_date = null, $types = null, $query = null, $levels = null, $is_dry_run = null, string $contentType = self::contentTypes['getSyncLogs'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncLogs200Response';
        $request = $this->getSyncLogsRequest($page, $limit, $es_ids, $job_ids, $start_date, $end_date, $types, $query, $levels, $is_dry_run, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncLogs'
     *
     * @param  int $page Page Number (optional, default to 1)
     * @param  int $limit Number of Logs per Page (optional, default to 10)
     * @param  int[] $es_ids Filter by External Systems (optional)
     * @param  int[] $job_ids Filter by Jobs (optional)
     * @param  \DateTime $start_date Show Logs From This Date on (optional)
     * @param  \DateTime $end_date Show Logs Until This Date (optional)
     * @param  int[] $types Filter by Types (optional)
     * @param  string $query Search Through Log Messages (optional)
     * @param  string[] $levels the log levels (optional)
     * @param  bool $is_dry_run (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncLogs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncLogsRequest($page = 1, $limit = 10, $es_ids = null, $job_ids = null, $start_date = null, $end_date = null, $types = null, $query = null, $levels = null, $is_dry_run = null, string $contentType = self::contentTypes['getSyncLogs'][0])
    {


        









        $resourcePath = '/sync/logs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $es_ids,
            'es_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $job_ids,
            'job_ids[]', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_date,
            'start_date', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_date,
            'end_date', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $types,
            'types', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $levels,
            'levels', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_dry_run,
            'is_dry_run', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSyncMappings
     *
     * Fetch all registered mappings
     *
     * @param  string[] $domain_type Filter by Domain Types (optional)
     * @param  string $domain_id Filter by Domain Id (optional)
     * @param  string $source_id Filter by Source Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncMappings'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncMappings200Response
     */
    public function getSyncMappings($domain_type = null, $domain_id = null, $source_id = null, string $contentType = self::contentTypes['getSyncMappings'][0])
    {
        list($response) = $this->getSyncMappingsWithHttpInfo($domain_type, $domain_id, $source_id, $contentType);
        return $response;
    }

    /**
     * Operation getSyncMappingsWithHttpInfo
     *
     * Fetch all registered mappings
     *
     * @param  string[] $domain_type Filter by Domain Types (optional)
     * @param  string $domain_id Filter by Domain Id (optional)
     * @param  string $source_id Filter by Source Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncMappings'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncMappings200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSyncMappingsWithHttpInfo($domain_type = null, $domain_id = null, $source_id = null, string $contentType = self::contentTypes['getSyncMappings'][0])
    {
        $request = $this->getSyncMappingsRequest($domain_type, $domain_id, $source_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncMappings200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncMappings200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncMappings200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncMappings200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncMappings200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSyncMappingsAsync
     *
     * Fetch all registered mappings
     *
     * @param  string[] $domain_type Filter by Domain Types (optional)
     * @param  string $domain_id Filter by Domain Id (optional)
     * @param  string $source_id Filter by Source Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncMappingsAsync($domain_type = null, $domain_id = null, $source_id = null, string $contentType = self::contentTypes['getSyncMappings'][0])
    {
        return $this->getSyncMappingsAsyncWithHttpInfo($domain_type, $domain_id, $source_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSyncMappingsAsyncWithHttpInfo
     *
     * Fetch all registered mappings
     *
     * @param  string[] $domain_type Filter by Domain Types (optional)
     * @param  string $domain_id Filter by Domain Id (optional)
     * @param  string $source_id Filter by Source Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSyncMappingsAsyncWithHttpInfo($domain_type = null, $domain_id = null, $source_id = null, string $contentType = self::contentTypes['getSyncMappings'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncMappings200Response';
        $request = $this->getSyncMappingsRequest($domain_type, $domain_id, $source_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSyncMappings'
     *
     * @param  string[] $domain_type Filter by Domain Types (optional)
     * @param  string $domain_id Filter by Domain Id (optional)
     * @param  string $source_id Filter by Source Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSyncMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSyncMappingsRequest($domain_type = null, $domain_id = null, $source_id = null, string $contentType = self::contentTypes['getSyncMappings'][0])
    {





        $resourcePath = '/sync/entitymappings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $domain_type,
            'domain_type', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $domain_id,
            'domain_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $source_id,
            'source_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSyncExternalsystems
     *
     * Create external system
     *
     * @param  \StevenBuehner\ChurchTools\Model\ExternalSystem2 $external_system2 external_system2 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystems'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postSyncExternalsystems($external_system2 = null, string $contentType = self::contentTypes['postSyncExternalsystems'][0])
    {
        $this->postSyncExternalsystemsWithHttpInfo($external_system2, $contentType);
    }

    /**
     * Operation postSyncExternalsystemsWithHttpInfo
     *
     * Create external system
     *
     * @param  \StevenBuehner\ChurchTools\Model\ExternalSystem2 $external_system2 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystems'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSyncExternalsystemsWithHttpInfo($external_system2 = null, string $contentType = self::contentTypes['postSyncExternalsystems'][0])
    {
        $request = $this->postSyncExternalsystemsRequest($external_system2, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation postSyncExternalsystemsAsync
     *
     * Create external system
     *
     * @param  \StevenBuehner\ChurchTools\Model\ExternalSystem2 $external_system2 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSyncExternalsystemsAsync($external_system2 = null, string $contentType = self::contentTypes['postSyncExternalsystems'][0])
    {
        return $this->postSyncExternalsystemsAsyncWithHttpInfo($external_system2, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSyncExternalsystemsAsyncWithHttpInfo
     *
     * Create external system
     *
     * @param  \StevenBuehner\ChurchTools\Model\ExternalSystem2 $external_system2 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSyncExternalsystemsAsyncWithHttpInfo($external_system2 = null, string $contentType = self::contentTypes['postSyncExternalsystems'][0])
    {
        $returnType = '';
        $request = $this->postSyncExternalsystemsRequest($external_system2, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSyncExternalsystems'
     *
     * @param  \StevenBuehner\ChurchTools\Model\ExternalSystem2 $external_system2 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSyncExternalsystemsRequest($external_system2 = null, string $contentType = self::contentTypes['postSyncExternalsystems'][0])
    {



        $resourcePath = '/sync/externalsystems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($external_system2)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($external_system2));
            } else {
                $httpBody = $external_system2;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSyncExternalsystemsExternalSystemIdJobconfigs
     *
     * Create job configuration
     *
     * @param  string $external_system_id external_system_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\JobConfiguration1 $job_configuration1 job_configuration1 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigs'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response
     */
    public function postSyncExternalsystemsExternalSystemIdJobconfigs($external_system_id, $job_configuration1 = null, string $contentType = self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigs'][0])
    {
        list($response) = $this->postSyncExternalsystemsExternalSystemIdJobconfigsWithHttpInfo($external_system_id, $job_configuration1, $contentType);
        return $response;
    }

    /**
     * Operation postSyncExternalsystemsExternalSystemIdJobconfigsWithHttpInfo
     *
     * Create job configuration
     *
     * @param  string $external_system_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\JobConfiguration1 $job_configuration1 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigs'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSyncExternalsystemsExternalSystemIdJobconfigsWithHttpInfo($external_system_id, $job_configuration1 = null, string $contentType = self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigs'][0])
    {
        $request = $this->postSyncExternalsystemsExternalSystemIdJobconfigsRequest($external_system_id, $job_configuration1, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation postSyncExternalsystemsExternalSystemIdJobconfigsAsync
     *
     * Create job configuration
     *
     * @param  string $external_system_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\JobConfiguration1 $job_configuration1 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSyncExternalsystemsExternalSystemIdJobconfigsAsync($external_system_id, $job_configuration1 = null, string $contentType = self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigs'][0])
    {
        return $this->postSyncExternalsystemsExternalSystemIdJobconfigsAsyncWithHttpInfo($external_system_id, $job_configuration1, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSyncExternalsystemsExternalSystemIdJobconfigsAsyncWithHttpInfo
     *
     * Create job configuration
     *
     * @param  string $external_system_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\JobConfiguration1 $job_configuration1 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSyncExternalsystemsExternalSystemIdJobconfigsAsyncWithHttpInfo($external_system_id, $job_configuration1 = null, string $contentType = self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigs'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigs201Response';
        $request = $this->postSyncExternalsystemsExternalSystemIdJobconfigsRequest($external_system_id, $job_configuration1, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSyncExternalsystemsExternalSystemIdJobconfigs'
     *
     * @param  string $external_system_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\JobConfiguration1 $job_configuration1 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSyncExternalsystemsExternalSystemIdJobconfigsRequest($external_system_id, $job_configuration1 = null, string $contentType = self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigs'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling postSyncExternalsystemsExternalSystemIdJobconfigs'
            );
        }



        $resourcePath = '/sync/externalsystems/{externalSystemId}/jobconfigs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($job_configuration1)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($job_configuration1));
            } else {
                $httpBody = $job_configuration1;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart
     *
     * Start Execution
     *
     * @param  string $external_system_id external_system_id (required)
     * @param  string $job_id job_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartRequest $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart($external_system_id, $job_id, $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request = null, string $contentType = self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'][0])
    {
        $this->postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartWithHttpInfo($external_system_id, $job_id, $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request, $contentType);
    }

    /**
     * Operation postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartWithHttpInfo
     *
     * Start Execution
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartRequest $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartWithHttpInfo($external_system_id, $job_id, $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request = null, string $contentType = self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'][0])
    {
        $request = $this->postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartRequest($external_system_id, $job_id, $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartAsync
     *
     * Start Execution
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartRequest $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartAsync($external_system_id, $job_id, $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request = null, string $contentType = self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'][0])
    {
        return $this->postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartAsyncWithHttpInfo($external_system_id, $job_id, $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartAsyncWithHttpInfo
     *
     * Start Execution
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartRequest $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartAsyncWithHttpInfo($external_system_id, $job_id, $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request = null, string $contentType = self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'][0])
    {
        $returnType = '';
        $request = $this->postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartRequest($external_system_id, $job_id, $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartRequest $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStartRequest($external_system_id, $job_id, $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request = null, string $contentType = self::contentTypes['postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'
            );
        }

        // verify the required parameter 'job_id' is set
        if ($job_id === null || (is_array($job_id) && count($job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling postSyncExternalsystemsExternalSystemIdJobconfigsJobIdStart'
            );
        }



        $resourcePath = '/sync/externalsystems/{externalSystemId}/jobconfigs/{jobId}/start';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }
        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request));
            } else {
                $httpBody = $post_sync_externalsystems_external_system_id_jobconfigs_job_id_start_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSyncExternalsystemsIdTest
     *
     * Test the external system
     *
     * @param  string $external_system_id external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsIdTest'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postSyncExternalsystemsIdTest($external_system_id, string $contentType = self::contentTypes['postSyncExternalsystemsIdTest'][0])
    {
        $this->postSyncExternalsystemsIdTestWithHttpInfo($external_system_id, $contentType);
    }

    /**
     * Operation postSyncExternalsystemsIdTestWithHttpInfo
     *
     * Test the external system
     *
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsIdTest'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSyncExternalsystemsIdTestWithHttpInfo($external_system_id, string $contentType = self::contentTypes['postSyncExternalsystemsIdTest'][0])
    {
        $request = $this->postSyncExternalsystemsIdTestRequest($external_system_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PostSyncExternalsystemsIdTest400Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation postSyncExternalsystemsIdTestAsync
     *
     * Test the external system
     *
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsIdTest'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSyncExternalsystemsIdTestAsync($external_system_id, string $contentType = self::contentTypes['postSyncExternalsystemsIdTest'][0])
    {
        return $this->postSyncExternalsystemsIdTestAsyncWithHttpInfo($external_system_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSyncExternalsystemsIdTestAsyncWithHttpInfo
     *
     * Test the external system
     *
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsIdTest'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSyncExternalsystemsIdTestAsyncWithHttpInfo($external_system_id, string $contentType = self::contentTypes['postSyncExternalsystemsIdTest'][0])
    {
        $returnType = '';
        $request = $this->postSyncExternalsystemsIdTestRequest($external_system_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSyncExternalsystemsIdTest'
     *
     * @param  string $external_system_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncExternalsystemsIdTest'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSyncExternalsystemsIdTestRequest($external_system_id, string $contentType = self::contentTypes['postSyncExternalsystemsIdTest'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling postSyncExternalsystemsIdTest'
            );
        }


        $resourcePath = '/sync/externalsystems/{externalSystemId}/test';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSyncLogs
     *
     * Save Sync Logs
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostSyncLogsRequest $post_sync_logs_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncLogs'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PostSyncLogs201Response
     */
    public function postSyncLogs($post_sync_logs_request = null, string $contentType = self::contentTypes['postSyncLogs'][0])
    {
        list($response) = $this->postSyncLogsWithHttpInfo($post_sync_logs_request, $contentType);
        return $response;
    }

    /**
     * Operation postSyncLogsWithHttpInfo
     *
     * Save Sync Logs
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostSyncLogsRequest $post_sync_logs_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncLogs'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PostSyncLogs201Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSyncLogsWithHttpInfo($post_sync_logs_request = null, string $contentType = self::contentTypes['postSyncLogs'][0])
    {
        $request = $this->postSyncLogsRequest($post_sync_logs_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\StevenBuehner\ChurchTools\Model\PostSyncLogs201Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PostSyncLogs201Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PostSyncLogs201Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PostSyncLogs201Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PostSyncLogs201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation postSyncLogsAsync
     *
     * Save Sync Logs
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostSyncLogsRequest $post_sync_logs_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncLogs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSyncLogsAsync($post_sync_logs_request = null, string $contentType = self::contentTypes['postSyncLogs'][0])
    {
        return $this->postSyncLogsAsyncWithHttpInfo($post_sync_logs_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSyncLogsAsyncWithHttpInfo
     *
     * Save Sync Logs
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostSyncLogsRequest $post_sync_logs_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncLogs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSyncLogsAsyncWithHttpInfo($post_sync_logs_request = null, string $contentType = self::contentTypes['postSyncLogs'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PostSyncLogs201Response';
        $request = $this->postSyncLogsRequest($post_sync_logs_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSyncLogs'
     *
     * @param  \StevenBuehner\ChurchTools\Model\PostSyncLogsRequest $post_sync_logs_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSyncLogs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSyncLogsRequest($post_sync_logs_request = null, string $contentType = self::contentTypes['postSyncLogs'][0])
    {



        $resourcePath = '/sync/logs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_sync_logs_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_sync_logs_request));
            } else {
                $httpBody = $post_sync_logs_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putSyncExternalsystemsExternalSystemIdJobconfigs
     *
     * Update job configuration
     *
     * @param  string $external_system_id external_system_id (required)
     * @param  string $job_id job_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\JobConfiguration1 $job_configuration1 job_configuration1 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigs'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigs200Response
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigs($external_system_id, $job_id, $job_configuration1 = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigs'][0])
    {
        list($response) = $this->putSyncExternalsystemsExternalSystemIdJobconfigsWithHttpInfo($external_system_id, $job_id, $job_configuration1, $contentType);
        return $response;
    }

    /**
     * Operation putSyncExternalsystemsExternalSystemIdJobconfigsWithHttpInfo
     *
     * Update job configuration
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\JobConfiguration1 $job_configuration1 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigs'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigs200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsWithHttpInfo($external_system_id, $job_id, $job_configuration1 = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigs'][0])
    {
        $request = $this->putSyncExternalsystemsExternalSystemIdJobconfigsRequest($external_system_id, $job_id, $job_configuration1, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigs200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigs200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigs200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigs200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigs200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putSyncExternalsystemsExternalSystemIdJobconfigsAsync
     *
     * Update job configuration
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\JobConfiguration1 $job_configuration1 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsAsync($external_system_id, $job_id, $job_configuration1 = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigs'][0])
    {
        return $this->putSyncExternalsystemsExternalSystemIdJobconfigsAsyncWithHttpInfo($external_system_id, $job_id, $job_configuration1, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putSyncExternalsystemsExternalSystemIdJobconfigsAsyncWithHttpInfo
     *
     * Update job configuration
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\JobConfiguration1 $job_configuration1 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsAsyncWithHttpInfo($external_system_id, $job_id, $job_configuration1 = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigs'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigs200Response';
        $request = $this->putSyncExternalsystemsExternalSystemIdJobconfigsRequest($external_system_id, $job_id, $job_configuration1, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putSyncExternalsystemsExternalSystemIdJobconfigs'
     *
     * @param  string $external_system_id (required)
     * @param  string $job_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\JobConfiguration1 $job_configuration1 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsRequest($external_system_id, $job_id, $job_configuration1 = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigs'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling putSyncExternalsystemsExternalSystemIdJobconfigs'
            );
        }

        // verify the required parameter 'job_id' is set
        if ($job_id === null || (is_array($job_id) && count($job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling putSyncExternalsystemsExternalSystemIdJobconfigs'
            );
        }



        $resourcePath = '/sync/externalsystems/{externalSystemId}/jobconfigs/{jobId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }
        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($job_configuration1)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($job_configuration1));
            } else {
                $httpBody = $job_configuration1;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter
     *
     * Save entity filters
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {
        list($response) = $this->putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterWithHttpInfo($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request, $contentType);
        return $response;
    }

    /**
     * Operation putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterWithHttpInfo
     *
     * Save entity filters
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterWithHttpInfo($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {
        $request = $this->putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsync
     *
     * Save entity filters
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsync($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {
        return $this->putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsyncWithHttpInfo($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsyncWithHttpInfo
     *
     * Save entity filters
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterAsyncWithHttpInfo($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter200Response';
        $request = $this->putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilterRequest($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'
            );
        }

        // verify the required parameter 'job_id' is set
        if ($job_id === null || (is_array($job_id) && count($job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling putSyncExternalsystemsExternalSystemIdJobconfigsJobIdFilter'
            );
        }



        $resourcePath = '/sync/externalsystems/{externalSystemId}/jobconfigs/{jobId}/filter';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }
        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request));
            } else {
                $httpBody = $put_sync_externalsystems_external_system_id_jobconfigs_job_id_filter_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('login_token');
        if ($apiKey !== null) {
            $queryParams['login_token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties
     *
     * Save Properties, Which Should Be Synced
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {
        list($response) = $this->putSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesWithHttpInfo($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request, $contentType);
        return $response;
    }

    /**
     * Operation putSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesWithHttpInfo
     *
     * Save Properties, Which Should Be Synced
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesWithHttpInfo($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {
        $request = $this->putSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsync
     *
     * Save Properties, Which Should Be Synced
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsync($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {
        return $this->putSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsyncWithHttpInfo($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsyncWithHttpInfo
     *
     * Save Properties, Which Should Be Synced
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesAsyncWithHttpInfo($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\GetSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties200Response';
        $request = $this->putSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'
     *
     * @param  string $external_system_id External System ID (required)
     * @param  string $job_id Job Configuration ID (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putSyncExternalsystemsExternalSystemIdJobconfigsJobIdPropertiesRequest($external_system_id, $job_id, $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request = null, string $contentType = self::contentTypes['putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'][0])
    {

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'
            );
        }

        // verify the required parameter 'job_id' is set
        if ($job_id === null || (is_array($job_id) && count($job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling putSyncExternalsystemsExternalSystemIdJobconfigsJobIdProperties'
            );
        }



        $resourcePath = '/sync/externalsystems/{externalSystemId}/jobconfigs/{jobId}/properties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }
        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request));
            } else {
                $httpBody = $put_sync_externalsystems_external_system_id_jobconfigs_job_id_properties_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('login_token');
        if ($apiKey !== null) {
            $queryParams['login_token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putSyncExternalsystemsId
     *
     * Update external system
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\ExternalSystem2 $external_system2 external_system2 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function putSyncExternalsystemsId($id, $external_system2 = null, string $contentType = self::contentTypes['putSyncExternalsystemsId'][0])
    {
        $this->putSyncExternalsystemsIdWithHttpInfo($id, $external_system2, $contentType);
    }

    /**
     * Operation putSyncExternalsystemsIdWithHttpInfo
     *
     * Update external system
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\ExternalSystem2 $external_system2 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSyncExternalsystemsIdWithHttpInfo($id, $external_system2 = null, string $contentType = self::contentTypes['putSyncExternalsystemsId'][0])
    {
        $request = $this->putSyncExternalsystemsIdRequest($id, $external_system2, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation putSyncExternalsystemsIdAsync
     *
     * Update external system
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\ExternalSystem2 $external_system2 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSyncExternalsystemsIdAsync($id, $external_system2 = null, string $contentType = self::contentTypes['putSyncExternalsystemsId'][0])
    {
        return $this->putSyncExternalsystemsIdAsyncWithHttpInfo($id, $external_system2, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putSyncExternalsystemsIdAsyncWithHttpInfo
     *
     * Update external system
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\ExternalSystem2 $external_system2 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSyncExternalsystemsIdAsyncWithHttpInfo($id, $external_system2 = null, string $contentType = self::contentTypes['putSyncExternalsystemsId'][0])
    {
        $returnType = '';
        $request = $this->putSyncExternalsystemsIdRequest($id, $external_system2, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putSyncExternalsystemsId'
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\ExternalSystem2 $external_system2 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncExternalsystemsId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putSyncExternalsystemsIdRequest($id, $external_system2 = null, string $contentType = self::contentTypes['putSyncExternalsystemsId'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling putSyncExternalsystemsId'
            );
        }



        $resourcePath = '/sync/externalsystems/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($external_system2)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($external_system2));
            } else {
                $httpBody = $external_system2;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putSyncFieldMappings
     *
     * Save Mapping for Domain Type
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id external_system_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncFieldMappingsRequest $put_sync_field_mappings_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\PutSyncFieldMappings200Response
     */
    public function putSyncFieldMappings($domain_type, $external_system_id, $put_sync_field_mappings_request = null, string $contentType = self::contentTypes['putSyncFieldMappings'][0])
    {
        list($response) = $this->putSyncFieldMappingsWithHttpInfo($domain_type, $external_system_id, $put_sync_field_mappings_request, $contentType);
        return $response;
    }

    /**
     * Operation putSyncFieldMappingsWithHttpInfo
     *
     * Save Mapping for Domain Type
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncFieldMappingsRequest $put_sync_field_mappings_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\PutSyncFieldMappings200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSyncFieldMappingsWithHttpInfo($domain_type, $external_system_id, $put_sync_field_mappings_request = null, string $contentType = self::contentTypes['putSyncFieldMappings'][0])
    {
        $request = $this->putSyncFieldMappingsRequest($domain_type, $external_system_id, $put_sync_field_mappings_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\PutSyncFieldMappings200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\PutSyncFieldMappings200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\PutSyncFieldMappings200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\PutSyncFieldMappings200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\PutSyncFieldMappings200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putSyncFieldMappingsAsync
     *
     * Save Mapping for Domain Type
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncFieldMappingsRequest $put_sync_field_mappings_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSyncFieldMappingsAsync($domain_type, $external_system_id, $put_sync_field_mappings_request = null, string $contentType = self::contentTypes['putSyncFieldMappings'][0])
    {
        return $this->putSyncFieldMappingsAsyncWithHttpInfo($domain_type, $external_system_id, $put_sync_field_mappings_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putSyncFieldMappingsAsyncWithHttpInfo
     *
     * Save Mapping for Domain Type
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncFieldMappingsRequest $put_sync_field_mappings_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSyncFieldMappingsAsyncWithHttpInfo($domain_type, $external_system_id, $put_sync_field_mappings_request = null, string $contentType = self::contentTypes['putSyncFieldMappings'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\PutSyncFieldMappings200Response';
        $request = $this->putSyncFieldMappingsRequest($domain_type, $external_system_id, $put_sync_field_mappings_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putSyncFieldMappings'
     *
     * @param  string $domain_type Domatin Type (required)
     * @param  string $external_system_id (required)
     * @param  \StevenBuehner\ChurchTools\Model\PutSyncFieldMappingsRequest $put_sync_field_mappings_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSyncFieldMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putSyncFieldMappingsRequest($domain_type, $external_system_id, $put_sync_field_mappings_request = null, string $contentType = self::contentTypes['putSyncFieldMappings'][0])
    {

        // verify the required parameter 'domain_type' is set
        if ($domain_type === null || (is_array($domain_type) && count($domain_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_type when calling putSyncFieldMappings'
            );
        }

        // verify the required parameter 'external_system_id' is set
        if ($external_system_id === null || (is_array($external_system_id) && count($external_system_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_system_id when calling putSyncFieldMappings'
            );
        }



        $resourcePath = '/sync/externalsystems/{externalSystemId}/fieldmappings/{domainType}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($domain_type !== null) {
            $resourcePath = str_replace(
                '{' . 'domainType' . '}',
                ObjectSerializer::toPathValue($domain_type),
                $resourcePath
            );
        }
        // path params
        if ($external_system_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalSystemId' . '}',
                ObjectSerializer::toPathValue($external_system_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($put_sync_field_mappings_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($put_sync_field_mappings_request));
            } else {
                $httpBody = $put_sync_field_mappings_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation saveSyncConflict
     *
     * Save new detected conflict
     *
     * @param  \StevenBuehner\ChurchTools\Model\SaveSyncConflictRequest $save_sync_conflict_request   (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['saveSyncConflict'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response
     */
    public function saveSyncConflict($save_sync_conflict_request = null, string $contentType = self::contentTypes['saveSyncConflict'][0])
    {
        list($response) = $this->saveSyncConflictWithHttpInfo($save_sync_conflict_request, $contentType);
        return $response;
    }

    /**
     * Operation saveSyncConflictWithHttpInfo
     *
     * Save new detected conflict
     *
     * @param  \StevenBuehner\ChurchTools\Model\SaveSyncConflictRequest $save_sync_conflict_request   (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['saveSyncConflict'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function saveSyncConflictWithHttpInfo($save_sync_conflict_request = null, string $contentType = self::contentTypes['saveSyncConflict'][0])
    {
        $request = $this->saveSyncConflictRequest($save_sync_conflict_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation saveSyncConflictAsync
     *
     * Save new detected conflict
     *
     * @param  \StevenBuehner\ChurchTools\Model\SaveSyncConflictRequest $save_sync_conflict_request   (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['saveSyncConflict'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function saveSyncConflictAsync($save_sync_conflict_request = null, string $contentType = self::contentTypes['saveSyncConflict'][0])
    {
        return $this->saveSyncConflictAsyncWithHttpInfo($save_sync_conflict_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation saveSyncConflictAsyncWithHttpInfo
     *
     * Save new detected conflict
     *
     * @param  \StevenBuehner\ChurchTools\Model\SaveSyncConflictRequest $save_sync_conflict_request   (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['saveSyncConflict'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function saveSyncConflictAsyncWithHttpInfo($save_sync_conflict_request = null, string $contentType = self::contentTypes['saveSyncConflict'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response';
        $request = $this->saveSyncConflictRequest($save_sync_conflict_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'saveSyncConflict'
     *
     * @param  \StevenBuehner\ChurchTools\Model\SaveSyncConflictRequest $save_sync_conflict_request   (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['saveSyncConflict'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function saveSyncConflictRequest($save_sync_conflict_request = null, string $contentType = self::contentTypes['saveSyncConflict'][0])
    {



        $resourcePath = '/sync/conflicts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($save_sync_conflict_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($save_sync_conflict_request));
            } else {
                $httpBody = $save_sync_conflict_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEntityMapping
     *
     * Update or Create Mapping
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\UpdateEntityMappingRequest $update_entity_mapping_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEntityMapping'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\SyncEntityMapping
     */
    public function updateEntityMapping($id, $update_entity_mapping_request = null, string $contentType = self::contentTypes['updateEntityMapping'][0])
    {
        list($response) = $this->updateEntityMappingWithHttpInfo($id, $update_entity_mapping_request, $contentType);
        return $response;
    }

    /**
     * Operation updateEntityMappingWithHttpInfo
     *
     * Update or Create Mapping
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\UpdateEntityMappingRequest $update_entity_mapping_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEntityMapping'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\SyncEntityMapping, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEntityMappingWithHttpInfo($id, $update_entity_mapping_request = null, string $contentType = self::contentTypes['updateEntityMapping'][0])
    {
        $request = $this->updateEntityMappingRequest($id, $update_entity_mapping_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\SyncEntityMapping' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\SyncEntityMapping' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\SyncEntityMapping', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\SyncEntityMapping';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\SyncEntityMapping',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateEntityMappingAsync
     *
     * Update or Create Mapping
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\UpdateEntityMappingRequest $update_entity_mapping_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEntityMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEntityMappingAsync($id, $update_entity_mapping_request = null, string $contentType = self::contentTypes['updateEntityMapping'][0])
    {
        return $this->updateEntityMappingAsyncWithHttpInfo($id, $update_entity_mapping_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateEntityMappingAsyncWithHttpInfo
     *
     * Update or Create Mapping
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\UpdateEntityMappingRequest $update_entity_mapping_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEntityMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEntityMappingAsyncWithHttpInfo($id, $update_entity_mapping_request = null, string $contentType = self::contentTypes['updateEntityMapping'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\SyncEntityMapping';
        $request = $this->updateEntityMappingRequest($id, $update_entity_mapping_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEntityMapping'
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\UpdateEntityMappingRequest $update_entity_mapping_request  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEntityMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateEntityMappingRequest($id, $update_entity_mapping_request = null, string $contentType = self::contentTypes['updateEntityMapping'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling updateEntityMapping'
            );
        }



        $resourcePath = '/sync/entitymappings/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_entity_mapping_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_entity_mapping_request));
            } else {
                $httpBody = $update_entity_mapping_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateSyncConflict
     *
     * Update Conflict
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\UpdateSyncConflictRequest $update_sync_conflict_request update_sync_conflict_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSyncConflict'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response
     */
    public function updateSyncConflict($id, $update_sync_conflict_request = null, string $contentType = self::contentTypes['updateSyncConflict'][0])
    {
        list($response) = $this->updateSyncConflictWithHttpInfo($id, $update_sync_conflict_request, $contentType);
        return $response;
    }

    /**
     * Operation updateSyncConflictWithHttpInfo
     *
     * Update Conflict
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\UpdateSyncConflictRequest $update_sync_conflict_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSyncConflict'] to see the possible values for this operation
     *
     * @throws \StevenBuehner\ChurchTools\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSyncConflictWithHttpInfo($id, $update_sync_conflict_request = null, string $contentType = self::contentTypes['updateSyncConflict'][0])
    {
        $request = $this->updateSyncConflictRequest($id, $update_sync_conflict_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateSyncConflictAsync
     *
     * Update Conflict
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\UpdateSyncConflictRequest $update_sync_conflict_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSyncConflict'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSyncConflictAsync($id, $update_sync_conflict_request = null, string $contentType = self::contentTypes['updateSyncConflict'][0])
    {
        return $this->updateSyncConflictAsyncWithHttpInfo($id, $update_sync_conflict_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateSyncConflictAsyncWithHttpInfo
     *
     * Update Conflict
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\UpdateSyncConflictRequest $update_sync_conflict_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSyncConflict'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSyncConflictAsyncWithHttpInfo($id, $update_sync_conflict_request = null, string $contentType = self::contentTypes['updateSyncConflict'][0])
    {
        $returnType = '\StevenBuehner\ChurchTools\Model\SaveSyncConflict201Response';
        $request = $this->updateSyncConflictRequest($id, $update_sync_conflict_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateSyncConflict'
     *
     * @param  int $id ID of Entity (required)
     * @param  \StevenBuehner\ChurchTools\Model\UpdateSyncConflictRequest $update_sync_conflict_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSyncConflict'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateSyncConflictRequest($id, $update_sync_conflict_request = null, string $contentType = self::contentTypes['updateSyncConflict'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling updateSyncConflict'
            );
        }



        $resourcePath = '/sync/conflicts/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_sync_conflict_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_sync_conflict_request));
            } else {
                $httpBody = $update_sync_conflict_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
