<?php
/**
 * FinanceMasterData
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * FinanceMasterData Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class FinanceMasterData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FinanceMasterData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'account_classes' => '\StevenBuehner\ChurchTools\Model\GetAllAccountClasses200ResponseDataInner[]',
        'account_groups' => '\StevenBuehner\ChurchTools\Model\GetAllAccountGroups200ResponseDataInner[]',
        'account_types' => '\StevenBuehner\ChurchTools\Model\GetAllAccountTypes200ResponseDataInner[]',
        'accounting_periods' => '\StevenBuehner\ChurchTools\Model\GetAllAccountingPeriods200ResponseDataInner[]',
        'accounts' => '\StevenBuehner\ChurchTools\Model\GetAllAccounts200ResponseDataInner[]',
        'cash_discounts' => '\StevenBuehner\ChurchTools\Model\GetAllCashDiscounts200ResponseDataInner[]',
        'clients' => '\StevenBuehner\ChurchTools\Model\GetAllClients200ResponseDataInner[]',
        'cost_centers' => '\StevenBuehner\ChurchTools\Model\CostCenter[]',
        'tax_rates' => '\StevenBuehner\ChurchTools\Model\GetAllData200ResponseDataTaxRatesInner[]',
        'tax_types' => '\StevenBuehner\ChurchTools\Model\GetAllData200ResponseDataTaxTypesInner[]',
        'transaction_purposes' => '\StevenBuehner\ChurchTools\Model\GetAllData200ResponseDataTransactionPurposesInner[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'account_classes' => null,
        'account_groups' => null,
        'account_types' => null,
        'accounting_periods' => null,
        'accounts' => null,
        'cash_discounts' => null,
        'clients' => null,
        'cost_centers' => null,
        'tax_rates' => null,
        'tax_types' => null,
        'transaction_purposes' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'account_classes' => false,
        'account_groups' => false,
        'account_types' => false,
        'accounting_periods' => false,
        'accounts' => false,
        'cash_discounts' => false,
        'clients' => false,
        'cost_centers' => false,
        'tax_rates' => false,
        'tax_types' => false,
        'transaction_purposes' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'account_classes' => 'accountClasses',
        'account_groups' => 'accountGroups',
        'account_types' => 'accountTypes',
        'accounting_periods' => 'accountingPeriods',
        'accounts' => 'accounts',
        'cash_discounts' => 'cashDiscounts',
        'clients' => 'clients',
        'cost_centers' => 'costCenters',
        'tax_rates' => 'taxRates',
        'tax_types' => 'taxTypes',
        'transaction_purposes' => 'transactionPurposes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'account_classes' => 'setAccountClasses',
        'account_groups' => 'setAccountGroups',
        'account_types' => 'setAccountTypes',
        'accounting_periods' => 'setAccountingPeriods',
        'accounts' => 'setAccounts',
        'cash_discounts' => 'setCashDiscounts',
        'clients' => 'setClients',
        'cost_centers' => 'setCostCenters',
        'tax_rates' => 'setTaxRates',
        'tax_types' => 'setTaxTypes',
        'transaction_purposes' => 'setTransactionPurposes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'account_classes' => 'getAccountClasses',
        'account_groups' => 'getAccountGroups',
        'account_types' => 'getAccountTypes',
        'accounting_periods' => 'getAccountingPeriods',
        'accounts' => 'getAccounts',
        'cash_discounts' => 'getCashDiscounts',
        'clients' => 'getClients',
        'cost_centers' => 'getCostCenters',
        'tax_rates' => 'getTaxRates',
        'tax_types' => 'getTaxTypes',
        'transaction_purposes' => 'getTransactionPurposes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('account_classes', $data ?? [], null);
        $this->setIfExists('account_groups', $data ?? [], null);
        $this->setIfExists('account_types', $data ?? [], null);
        $this->setIfExists('accounting_periods', $data ?? [], null);
        $this->setIfExists('accounts', $data ?? [], null);
        $this->setIfExists('cash_discounts', $data ?? [], null);
        $this->setIfExists('clients', $data ?? [], null);
        $this->setIfExists('cost_centers', $data ?? [], null);
        $this->setIfExists('tax_rates', $data ?? [], null);
        $this->setIfExists('tax_types', $data ?? [], null);
        $this->setIfExists('transaction_purposes', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets account_classes
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllAccountClasses200ResponseDataInner[]|null
     */
    public function getAccountClasses()
    {
        return $this->container['account_classes'];
    }

    /**
     * Sets account_classes
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllAccountClasses200ResponseDataInner[]|null $account_classes account_classes
     *
     * @return self
     */
    public function setAccountClasses($account_classes)
    {
        if (is_null($account_classes)) {
            throw new \InvalidArgumentException('non-nullable account_classes cannot be null');
        }
        $this->container['account_classes'] = $account_classes;

        return $this;
    }

    /**
     * Gets account_groups
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllAccountGroups200ResponseDataInner[]|null
     */
    public function getAccountGroups()
    {
        return $this->container['account_groups'];
    }

    /**
     * Sets account_groups
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllAccountGroups200ResponseDataInner[]|null $account_groups account_groups
     *
     * @return self
     */
    public function setAccountGroups($account_groups)
    {
        if (is_null($account_groups)) {
            throw new \InvalidArgumentException('non-nullable account_groups cannot be null');
        }
        $this->container['account_groups'] = $account_groups;

        return $this;
    }

    /**
     * Gets account_types
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllAccountTypes200ResponseDataInner[]|null
     */
    public function getAccountTypes()
    {
        return $this->container['account_types'];
    }

    /**
     * Sets account_types
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllAccountTypes200ResponseDataInner[]|null $account_types account_types
     *
     * @return self
     */
    public function setAccountTypes($account_types)
    {
        if (is_null($account_types)) {
            throw new \InvalidArgumentException('non-nullable account_types cannot be null');
        }
        $this->container['account_types'] = $account_types;

        return $this;
    }

    /**
     * Gets accounting_periods
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllAccountingPeriods200ResponseDataInner[]|null
     */
    public function getAccountingPeriods()
    {
        return $this->container['accounting_periods'];
    }

    /**
     * Sets accounting_periods
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllAccountingPeriods200ResponseDataInner[]|null $accounting_periods accounting_periods
     *
     * @return self
     */
    public function setAccountingPeriods($accounting_periods)
    {
        if (is_null($accounting_periods)) {
            throw new \InvalidArgumentException('non-nullable accounting_periods cannot be null');
        }
        $this->container['accounting_periods'] = $accounting_periods;

        return $this;
    }

    /**
     * Gets accounts
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllAccounts200ResponseDataInner[]|null
     */
    public function getAccounts()
    {
        return $this->container['accounts'];
    }

    /**
     * Sets accounts
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllAccounts200ResponseDataInner[]|null $accounts accounts
     *
     * @return self
     */
    public function setAccounts($accounts)
    {
        if (is_null($accounts)) {
            throw new \InvalidArgumentException('non-nullable accounts cannot be null');
        }
        $this->container['accounts'] = $accounts;

        return $this;
    }

    /**
     * Gets cash_discounts
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCashDiscounts200ResponseDataInner[]|null
     */
    public function getCashDiscounts()
    {
        return $this->container['cash_discounts'];
    }

    /**
     * Sets cash_discounts
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCashDiscounts200ResponseDataInner[]|null $cash_discounts cash_discounts
     *
     * @return self
     */
    public function setCashDiscounts($cash_discounts)
    {
        if (is_null($cash_discounts)) {
            throw new \InvalidArgumentException('non-nullable cash_discounts cannot be null');
        }
        $this->container['cash_discounts'] = $cash_discounts;

        return $this;
    }

    /**
     * Gets clients
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllClients200ResponseDataInner[]|null
     */
    public function getClients()
    {
        return $this->container['clients'];
    }

    /**
     * Sets clients
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllClients200ResponseDataInner[]|null $clients clients
     *
     * @return self
     */
    public function setClients($clients)
    {
        if (is_null($clients)) {
            throw new \InvalidArgumentException('non-nullable clients cannot be null');
        }
        $this->container['clients'] = $clients;

        return $this;
    }

    /**
     * Gets cost_centers
     *
     * @return \StevenBuehner\ChurchTools\Model\CostCenter[]|null
     */
    public function getCostCenters()
    {
        return $this->container['cost_centers'];
    }

    /**
     * Sets cost_centers
     *
     * @param \StevenBuehner\ChurchTools\Model\CostCenter[]|null $cost_centers cost_centers
     *
     * @return self
     */
    public function setCostCenters($cost_centers)
    {
        if (is_null($cost_centers)) {
            throw new \InvalidArgumentException('non-nullable cost_centers cannot be null');
        }
        $this->container['cost_centers'] = $cost_centers;

        return $this;
    }

    /**
     * Gets tax_rates
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllData200ResponseDataTaxRatesInner[]|null
     */
    public function getTaxRates()
    {
        return $this->container['tax_rates'];
    }

    /**
     * Sets tax_rates
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllData200ResponseDataTaxRatesInner[]|null $tax_rates tax_rates
     *
     * @return self
     */
    public function setTaxRates($tax_rates)
    {
        if (is_null($tax_rates)) {
            throw new \InvalidArgumentException('non-nullable tax_rates cannot be null');
        }
        $this->container['tax_rates'] = $tax_rates;

        return $this;
    }

    /**
     * Gets tax_types
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllData200ResponseDataTaxTypesInner[]|null
     */
    public function getTaxTypes()
    {
        return $this->container['tax_types'];
    }

    /**
     * Sets tax_types
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllData200ResponseDataTaxTypesInner[]|null $tax_types tax_types
     *
     * @return self
     */
    public function setTaxTypes($tax_types)
    {
        if (is_null($tax_types)) {
            throw new \InvalidArgumentException('non-nullable tax_types cannot be null');
        }
        $this->container['tax_types'] = $tax_types;

        return $this;
    }

    /**
     * Gets transaction_purposes
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllData200ResponseDataTransactionPurposesInner[]|null
     */
    public function getTransactionPurposes()
    {
        return $this->container['transaction_purposes'];
    }

    /**
     * Sets transaction_purposes
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllData200ResponseDataTransactionPurposesInner[]|null $transaction_purposes transaction_purposes
     *
     * @return self
     */
    public function setTransactionPurposes($transaction_purposes)
    {
        if (is_null($transaction_purposes)) {
            throw new \InvalidArgumentException('non-nullable transaction_purposes cannot be null');
        }
        $this->container['transaction_purposes'] = $transaction_purposes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


