<?php
/**
 * GetFilesMetadata200Response
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * GetFilesMetadata200Response Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class GetFilesMetadata200Response implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'getFilesMetadata_200_response';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'bezeichnung' => 'string',
        'deletion_date' => 'string',
        'domain_id' => 'string',
        'domain_type' => 'string',
        'filename' => 'string',
        'id' => 'string',
        'image_options' => 'string',
        'modified_date' => 'string',
        'modified_pid' => 'string',
        'securitylevel_id' => 'string',
        'showonlywheneditable_yn' => 'string',
        'sortkey' => 'string',
        'url' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'bezeichnung' => null,
        'deletion_date' => null,
        'domain_id' => null,
        'domain_type' => null,
        'filename' => null,
        'id' => null,
        'image_options' => null,
        'modified_date' => null,
        'modified_pid' => null,
        'securitylevel_id' => null,
        'showonlywheneditable_yn' => null,
        'sortkey' => null,
        'url' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'bezeichnung' => false,
        'deletion_date' => false,
        'domain_id' => false,
        'domain_type' => false,
        'filename' => false,
        'id' => false,
        'image_options' => false,
        'modified_date' => false,
        'modified_pid' => false,
        'securitylevel_id' => false,
        'showonlywheneditable_yn' => false,
        'sortkey' => false,
        'url' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'bezeichnung' => 'bezeichnung',
        'deletion_date' => 'deletion_date',
        'domain_id' => 'domain_id',
        'domain_type' => 'domain_type',
        'filename' => 'filename',
        'id' => 'id',
        'image_options' => 'image_options',
        'modified_date' => 'modified_date',
        'modified_pid' => 'modified_pid',
        'securitylevel_id' => 'securitylevel_id',
        'showonlywheneditable_yn' => 'showonlywheneditable_yn',
        'sortkey' => 'sortkey',
        'url' => 'url'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'bezeichnung' => 'setBezeichnung',
        'deletion_date' => 'setDeletionDate',
        'domain_id' => 'setDomainId',
        'domain_type' => 'setDomainType',
        'filename' => 'setFilename',
        'id' => 'setId',
        'image_options' => 'setImageOptions',
        'modified_date' => 'setModifiedDate',
        'modified_pid' => 'setModifiedPid',
        'securitylevel_id' => 'setSecuritylevelId',
        'showonlywheneditable_yn' => 'setShowonlywheneditableYn',
        'sortkey' => 'setSortkey',
        'url' => 'setUrl'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'bezeichnung' => 'getBezeichnung',
        'deletion_date' => 'getDeletionDate',
        'domain_id' => 'getDomainId',
        'domain_type' => 'getDomainType',
        'filename' => 'getFilename',
        'id' => 'getId',
        'image_options' => 'getImageOptions',
        'modified_date' => 'getModifiedDate',
        'modified_pid' => 'getModifiedPid',
        'securitylevel_id' => 'getSecuritylevelId',
        'showonlywheneditable_yn' => 'getShowonlywheneditableYn',
        'sortkey' => 'getSortkey',
        'url' => 'getUrl'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('bezeichnung', $data ?? [], null);
        $this->setIfExists('deletion_date', $data ?? [], null);
        $this->setIfExists('domain_id', $data ?? [], null);
        $this->setIfExists('domain_type', $data ?? [], null);
        $this->setIfExists('filename', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('image_options', $data ?? [], null);
        $this->setIfExists('modified_date', $data ?? [], null);
        $this->setIfExists('modified_pid', $data ?? [], null);
        $this->setIfExists('securitylevel_id', $data ?? [], null);
        $this->setIfExists('showonlywheneditable_yn', $data ?? [], null);
        $this->setIfExists('sortkey', $data ?? [], null);
        $this->setIfExists('url', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets bezeichnung
     *
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->container['bezeichnung'];
    }

    /**
     * Sets bezeichnung
     *
     * @param string|null $bezeichnung bezeichnung
     *
     * @return self
     */
    public function setBezeichnung($bezeichnung)
    {
        if (is_null($bezeichnung)) {
            throw new \InvalidArgumentException('non-nullable bezeichnung cannot be null');
        }
        $this->container['bezeichnung'] = $bezeichnung;

        return $this;
    }

    /**
     * Gets deletion_date
     *
     * @return string|null
     */
    public function getDeletionDate()
    {
        return $this->container['deletion_date'];
    }

    /**
     * Sets deletion_date
     *
     * @param string|null $deletion_date deletion_date
     *
     * @return self
     */
    public function setDeletionDate($deletion_date)
    {
        if (is_null($deletion_date)) {
            throw new \InvalidArgumentException('non-nullable deletion_date cannot be null');
        }
        $this->container['deletion_date'] = $deletion_date;

        return $this;
    }

    /**
     * Gets domain_id
     *
     * @return string|null
     */
    public function getDomainId()
    {
        return $this->container['domain_id'];
    }

    /**
     * Sets domain_id
     *
     * @param string|null $domain_id domain_id
     *
     * @return self
     */
    public function setDomainId($domain_id)
    {
        if (is_null($domain_id)) {
            throw new \InvalidArgumentException('non-nullable domain_id cannot be null');
        }
        $this->container['domain_id'] = $domain_id;

        return $this;
    }

    /**
     * Gets domain_type
     *
     * @return string|null
     */
    public function getDomainType()
    {
        return $this->container['domain_type'];
    }

    /**
     * Sets domain_type
     *
     * @param string|null $domain_type domain_type
     *
     * @return self
     */
    public function setDomainType($domain_type)
    {
        if (is_null($domain_type)) {
            throw new \InvalidArgumentException('non-nullable domain_type cannot be null');
        }
        $this->container['domain_type'] = $domain_type;

        return $this;
    }

    /**
     * Gets filename
     *
     * @return string|null
     */
    public function getFilename()
    {
        return $this->container['filename'];
    }

    /**
     * Sets filename
     *
     * @param string|null $filename filename
     *
     * @return self
     */
    public function setFilename($filename)
    {
        if (is_null($filename)) {
            throw new \InvalidArgumentException('non-nullable filename cannot be null');
        }
        $this->container['filename'] = $filename;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets image_options
     *
     * @return string|null
     */
    public function getImageOptions()
    {
        return $this->container['image_options'];
    }

    /**
     * Sets image_options
     *
     * @param string|null $image_options image_options
     *
     * @return self
     */
    public function setImageOptions($image_options)
    {
        if (is_null($image_options)) {
            throw new \InvalidArgumentException('non-nullable image_options cannot be null');
        }
        $this->container['image_options'] = $image_options;

        return $this;
    }

    /**
     * Gets modified_date
     *
     * @return string|null
     */
    public function getModifiedDate()
    {
        return $this->container['modified_date'];
    }

    /**
     * Sets modified_date
     *
     * @param string|null $modified_date modified_date
     *
     * @return self
     */
    public function setModifiedDate($modified_date)
    {
        if (is_null($modified_date)) {
            throw new \InvalidArgumentException('non-nullable modified_date cannot be null');
        }
        $this->container['modified_date'] = $modified_date;

        return $this;
    }

    /**
     * Gets modified_pid
     *
     * @return string|null
     */
    public function getModifiedPid()
    {
        return $this->container['modified_pid'];
    }

    /**
     * Sets modified_pid
     *
     * @param string|null $modified_pid modified_pid
     *
     * @return self
     */
    public function setModifiedPid($modified_pid)
    {
        if (is_null($modified_pid)) {
            throw new \InvalidArgumentException('non-nullable modified_pid cannot be null');
        }
        $this->container['modified_pid'] = $modified_pid;

        return $this;
    }

    /**
     * Gets securitylevel_id
     *
     * @return string|null
     */
    public function getSecuritylevelId()
    {
        return $this->container['securitylevel_id'];
    }

    /**
     * Sets securitylevel_id
     *
     * @param string|null $securitylevel_id securitylevel_id
     *
     * @return self
     */
    public function setSecuritylevelId($securitylevel_id)
    {
        if (is_null($securitylevel_id)) {
            throw new \InvalidArgumentException('non-nullable securitylevel_id cannot be null');
        }
        $this->container['securitylevel_id'] = $securitylevel_id;

        return $this;
    }

    /**
     * Gets showonlywheneditable_yn
     *
     * @return string|null
     */
    public function getShowonlywheneditableYn()
    {
        return $this->container['showonlywheneditable_yn'];
    }

    /**
     * Sets showonlywheneditable_yn
     *
     * @param string|null $showonlywheneditable_yn showonlywheneditable_yn
     *
     * @return self
     */
    public function setShowonlywheneditableYn($showonlywheneditable_yn)
    {
        if (is_null($showonlywheneditable_yn)) {
            throw new \InvalidArgumentException('non-nullable showonlywheneditable_yn cannot be null');
        }
        $this->container['showonlywheneditable_yn'] = $showonlywheneditable_yn;

        return $this;
    }

    /**
     * Gets sortkey
     *
     * @return string|null
     */
    public function getSortkey()
    {
        return $this->container['sortkey'];
    }

    /**
     * Sets sortkey
     *
     * @param string|null $sortkey sortkey
     *
     * @return self
     */
    public function setSortkey($sortkey)
    {
        if (is_null($sortkey)) {
            throw new \InvalidArgumentException('non-nullable sortkey cannot be null');
        }
        $this->container['sortkey'] = $sortkey;

        return $this;
    }

    /**
     * Gets url
     *
     * @return string|null
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     *
     * @param string|null $url url
     *
     * @return self
     */
    public function setUrl($url)
    {
        if (is_null($url)) {
            throw new \InvalidArgumentException('non-nullable url cannot be null');
        }
        $this->container['url'] = $url;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


