<?php
/**
 * GetGlobalPermissions200ResponseData
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * GetGlobalPermissions200ResponseData Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class GetGlobalPermissions200ResponseData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'getGlobalPermissions_200_response_data';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'churchcal' => '\StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchcal',
        'churchcheckin' => '\StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchcheckin',
        'churchcore' => '\StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchcore',
        'churchdb' => '\StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchdb',
        'churchfinance' => '\StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchfinance',
        'churchreport' => '\StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchreport',
        'churchresource' => '\StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchresource',
        'churchservice' => '\StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchservice',
        'churchwiki' => '\StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchwiki',
        'finance' => '\StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataFinance'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'churchcal' => null,
        'churchcheckin' => null,
        'churchcore' => null,
        'churchdb' => null,
        'churchfinance' => null,
        'churchreport' => null,
        'churchresource' => null,
        'churchservice' => null,
        'churchwiki' => null,
        'finance' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'churchcal' => false,
        'churchcheckin' => false,
        'churchcore' => false,
        'churchdb' => false,
        'churchfinance' => false,
        'churchreport' => false,
        'churchresource' => false,
        'churchservice' => false,
        'churchwiki' => false,
        'finance' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'churchcal' => 'churchcal',
        'churchcheckin' => 'churchcheckin',
        'churchcore' => 'churchcore',
        'churchdb' => 'churchdb',
        'churchfinance' => 'churchfinance',
        'churchreport' => 'churchreport',
        'churchresource' => 'churchresource',
        'churchservice' => 'churchservice',
        'churchwiki' => 'churchwiki',
        'finance' => 'finance'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'churchcal' => 'setChurchcal',
        'churchcheckin' => 'setChurchcheckin',
        'churchcore' => 'setChurchcore',
        'churchdb' => 'setChurchdb',
        'churchfinance' => 'setChurchfinance',
        'churchreport' => 'setChurchreport',
        'churchresource' => 'setChurchresource',
        'churchservice' => 'setChurchservice',
        'churchwiki' => 'setChurchwiki',
        'finance' => 'setFinance'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'churchcal' => 'getChurchcal',
        'churchcheckin' => 'getChurchcheckin',
        'churchcore' => 'getChurchcore',
        'churchdb' => 'getChurchdb',
        'churchfinance' => 'getChurchfinance',
        'churchreport' => 'getChurchreport',
        'churchresource' => 'getChurchresource',
        'churchservice' => 'getChurchservice',
        'churchwiki' => 'getChurchwiki',
        'finance' => 'getFinance'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('churchcal', $data ?? [], null);
        $this->setIfExists('churchcheckin', $data ?? [], null);
        $this->setIfExists('churchcore', $data ?? [], null);
        $this->setIfExists('churchdb', $data ?? [], null);
        $this->setIfExists('churchfinance', $data ?? [], null);
        $this->setIfExists('churchreport', $data ?? [], null);
        $this->setIfExists('churchresource', $data ?? [], null);
        $this->setIfExists('churchservice', $data ?? [], null);
        $this->setIfExists('churchwiki', $data ?? [], null);
        $this->setIfExists('finance', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets churchcal
     *
     * @return \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchcal|null
     */
    public function getChurchcal()
    {
        return $this->container['churchcal'];
    }

    /**
     * Sets churchcal
     *
     * @param \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchcal|null $churchcal churchcal
     *
     * @return self
     */
    public function setChurchcal($churchcal)
    {
        if (is_null($churchcal)) {
            throw new \InvalidArgumentException('non-nullable churchcal cannot be null');
        }
        $this->container['churchcal'] = $churchcal;

        return $this;
    }

    /**
     * Gets churchcheckin
     *
     * @return \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchcheckin|null
     */
    public function getChurchcheckin()
    {
        return $this->container['churchcheckin'];
    }

    /**
     * Sets churchcheckin
     *
     * @param \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchcheckin|null $churchcheckin churchcheckin
     *
     * @return self
     */
    public function setChurchcheckin($churchcheckin)
    {
        if (is_null($churchcheckin)) {
            throw new \InvalidArgumentException('non-nullable churchcheckin cannot be null');
        }
        $this->container['churchcheckin'] = $churchcheckin;

        return $this;
    }

    /**
     * Gets churchcore
     *
     * @return \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchcore|null
     */
    public function getChurchcore()
    {
        return $this->container['churchcore'];
    }

    /**
     * Sets churchcore
     *
     * @param \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchcore|null $churchcore churchcore
     *
     * @return self
     */
    public function setChurchcore($churchcore)
    {
        if (is_null($churchcore)) {
            throw new \InvalidArgumentException('non-nullable churchcore cannot be null');
        }
        $this->container['churchcore'] = $churchcore;

        return $this;
    }

    /**
     * Gets churchdb
     *
     * @return \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchdb|null
     */
    public function getChurchdb()
    {
        return $this->container['churchdb'];
    }

    /**
     * Sets churchdb
     *
     * @param \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchdb|null $churchdb churchdb
     *
     * @return self
     */
    public function setChurchdb($churchdb)
    {
        if (is_null($churchdb)) {
            throw new \InvalidArgumentException('non-nullable churchdb cannot be null');
        }
        $this->container['churchdb'] = $churchdb;

        return $this;
    }

    /**
     * Gets churchfinance
     *
     * @return \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchfinance|null
     */
    public function getChurchfinance()
    {
        return $this->container['churchfinance'];
    }

    /**
     * Sets churchfinance
     *
     * @param \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchfinance|null $churchfinance churchfinance
     *
     * @return self
     */
    public function setChurchfinance($churchfinance)
    {
        if (is_null($churchfinance)) {
            throw new \InvalidArgumentException('non-nullable churchfinance cannot be null');
        }
        $this->container['churchfinance'] = $churchfinance;

        return $this;
    }

    /**
     * Gets churchreport
     *
     * @return \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchreport|null
     */
    public function getChurchreport()
    {
        return $this->container['churchreport'];
    }

    /**
     * Sets churchreport
     *
     * @param \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchreport|null $churchreport churchreport
     *
     * @return self
     */
    public function setChurchreport($churchreport)
    {
        if (is_null($churchreport)) {
            throw new \InvalidArgumentException('non-nullable churchreport cannot be null');
        }
        $this->container['churchreport'] = $churchreport;

        return $this;
    }

    /**
     * Gets churchresource
     *
     * @return \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchresource|null
     */
    public function getChurchresource()
    {
        return $this->container['churchresource'];
    }

    /**
     * Sets churchresource
     *
     * @param \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchresource|null $churchresource churchresource
     *
     * @return self
     */
    public function setChurchresource($churchresource)
    {
        if (is_null($churchresource)) {
            throw new \InvalidArgumentException('non-nullable churchresource cannot be null');
        }
        $this->container['churchresource'] = $churchresource;

        return $this;
    }

    /**
     * Gets churchservice
     *
     * @return \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchservice|null
     */
    public function getChurchservice()
    {
        return $this->container['churchservice'];
    }

    /**
     * Sets churchservice
     *
     * @param \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchservice|null $churchservice churchservice
     *
     * @return self
     */
    public function setChurchservice($churchservice)
    {
        if (is_null($churchservice)) {
            throw new \InvalidArgumentException('non-nullable churchservice cannot be null');
        }
        $this->container['churchservice'] = $churchservice;

        return $this;
    }

    /**
     * Gets churchwiki
     *
     * @return \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchwiki|null
     */
    public function getChurchwiki()
    {
        return $this->container['churchwiki'];
    }

    /**
     * Sets churchwiki
     *
     * @param \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataChurchwiki|null $churchwiki churchwiki
     *
     * @return self
     */
    public function setChurchwiki($churchwiki)
    {
        if (is_null($churchwiki)) {
            throw new \InvalidArgumentException('non-nullable churchwiki cannot be null');
        }
        $this->container['churchwiki'] = $churchwiki;

        return $this;
    }

    /**
     * Gets finance
     *
     * @return \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataFinance|null
     */
    public function getFinance()
    {
        return $this->container['finance'];
    }

    /**
     * Sets finance
     *
     * @param \StevenBuehner\ChurchTools\Model\GetGlobalPermissions200ResponseDataFinance|null $finance finance
     *
     * @return self
     */
    public function setFinance($finance)
    {
        if (is_null($finance)) {
            throw new \InvalidArgumentException('non-nullable finance cannot be null');
        }
        $this->container['finance'] = $finance;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


