<?php
/**
 * GetGroupHomepage200Response
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * GetGroupHomepage200Response Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class GetGroupHomepage200Response implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'getGroupHomepage_200_response';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'default_view' => 'string',
        'filter' => 'object[]',
        'groups' => '\StevenBuehner\ChurchTools\Model\PublicGroup1[]',
        'id' => 'int',
        'is_enabled' => 'bool',
        'meta' => 'object',
        'order_direction' => 'string',
        'parent_group' => 'int',
        'random_url' => 'string',
        'show_filter' => 'bool',
        'show_group_images' => 'bool',
        'show_leader' => 'bool',
        'show_map' => 'bool',
        'sort_by' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'default_view' => null,
        'filter' => null,
        'groups' => null,
        'id' => null,
        'is_enabled' => null,
        'meta' => null,
        'order_direction' => null,
        'parent_group' => null,
        'random_url' => null,
        'show_filter' => null,
        'show_group_images' => null,
        'show_leader' => null,
        'show_map' => null,
        'sort_by' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'default_view' => false,
        'filter' => false,
        'groups' => false,
        'id' => false,
        'is_enabled' => false,
        'meta' => false,
        'order_direction' => false,
        'parent_group' => false,
        'random_url' => false,
        'show_filter' => false,
        'show_group_images' => false,
        'show_leader' => false,
        'show_map' => false,
        'sort_by' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'default_view' => 'defaultView',
        'filter' => 'filter',
        'groups' => 'groups',
        'id' => 'id',
        'is_enabled' => 'isEnabled',
        'meta' => 'meta',
        'order_direction' => 'orderDirection',
        'parent_group' => 'parentGroup',
        'random_url' => 'randomUrl',
        'show_filter' => 'showFilter',
        'show_group_images' => 'showGroupImages',
        'show_leader' => 'showLeader',
        'show_map' => 'showMap',
        'sort_by' => 'sortBy'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'default_view' => 'setDefaultView',
        'filter' => 'setFilter',
        'groups' => 'setGroups',
        'id' => 'setId',
        'is_enabled' => 'setIsEnabled',
        'meta' => 'setMeta',
        'order_direction' => 'setOrderDirection',
        'parent_group' => 'setParentGroup',
        'random_url' => 'setRandomUrl',
        'show_filter' => 'setShowFilter',
        'show_group_images' => 'setShowGroupImages',
        'show_leader' => 'setShowLeader',
        'show_map' => 'setShowMap',
        'sort_by' => 'setSortBy'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'default_view' => 'getDefaultView',
        'filter' => 'getFilter',
        'groups' => 'getGroups',
        'id' => 'getId',
        'is_enabled' => 'getIsEnabled',
        'meta' => 'getMeta',
        'order_direction' => 'getOrderDirection',
        'parent_group' => 'getParentGroup',
        'random_url' => 'getRandomUrl',
        'show_filter' => 'getShowFilter',
        'show_group_images' => 'getShowGroupImages',
        'show_leader' => 'getShowLeader',
        'show_map' => 'getShowMap',
        'sort_by' => 'getSortBy'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ORDER_DIRECTION_ASC = 'ASC';
    public const ORDER_DIRECTION_DESC = 'DESC';
    public const SORT_BY_NAME = 'name';
    public const SORT_BY_DATE_OF_FOUNDATION = 'dateOfFoundation';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getOrderDirectionAllowableValues()
    {
        return [
            self::ORDER_DIRECTION_ASC,
            self::ORDER_DIRECTION_DESC,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSortByAllowableValues()
    {
        return [
            self::SORT_BY_NAME,
            self::SORT_BY_DATE_OF_FOUNDATION,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('default_view', $data ?? [], null);
        $this->setIfExists('filter', $data ?? [], null);
        $this->setIfExists('groups', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('is_enabled', $data ?? [], null);
        $this->setIfExists('meta', $data ?? [], null);
        $this->setIfExists('order_direction', $data ?? [], null);
        $this->setIfExists('parent_group', $data ?? [], null);
        $this->setIfExists('random_url', $data ?? [], null);
        $this->setIfExists('show_filter', $data ?? [], null);
        $this->setIfExists('show_group_images', $data ?? [], null);
        $this->setIfExists('show_leader', $data ?? [], null);
        $this->setIfExists('show_map', $data ?? [], null);
        $this->setIfExists('sort_by', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['groups'] === null) {
            $invalidProperties[] = "'groups' can't be null";
        }
        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['is_enabled'] === null) {
            $invalidProperties[] = "'is_enabled' can't be null";
        }
        if ($this->container['meta'] === null) {
            $invalidProperties[] = "'meta' can't be null";
        }
        $allowedValues = $this->getOrderDirectionAllowableValues();
        if (!is_null($this->container['order_direction']) && !in_array($this->container['order_direction'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'order_direction', must be one of '%s'",
                $this->container['order_direction'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['parent_group'] === null) {
            $invalidProperties[] = "'parent_group' can't be null";
        }
        if ($this->container['random_url'] === null) {
            $invalidProperties[] = "'random_url' can't be null";
        }
        if ($this->container['show_group_images'] === null) {
            $invalidProperties[] = "'show_group_images' can't be null";
        }
        if ($this->container['show_leader'] === null) {
            $invalidProperties[] = "'show_leader' can't be null";
        }
        if ($this->container['show_map'] === null) {
            $invalidProperties[] = "'show_map' can't be null";
        }
        $allowedValues = $this->getSortByAllowableValues();
        if (!is_null($this->container['sort_by']) && !in_array($this->container['sort_by'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'sort_by', must be one of '%s'",
                $this->container['sort_by'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets default_view
     *
     * @return string|null
     */
    public function getDefaultView()
    {
        return $this->container['default_view'];
    }

    /**
     * Sets default_view
     *
     * @param string|null $default_view Type how groups are listed on the page.
     *
     * @return self
     */
    public function setDefaultView($default_view)
    {
        if (is_null($default_view)) {
            throw new \InvalidArgumentException('non-nullable default_view cannot be null');
        }
        $this->container['default_view'] = $default_view;

        return $this;
    }

    /**
     * Gets filter
     *
     * @return object[]|null
     */
    public function getFilter()
    {
        return $this->container['filter'];
    }

    /**
     * Sets filter
     *
     * @param object[]|null $filter Specifies all filters that can be applied for this group homepage.
     *
     * @return self
     */
    public function setFilter($filter)
    {
        if (is_null($filter)) {
            throw new \InvalidArgumentException('non-nullable filter cannot be null');
        }
        $this->container['filter'] = $filter;

        return $this;
    }

    /**
     * Gets groups
     *
     * @return \StevenBuehner\ChurchTools\Model\PublicGroup1[]
     */
    public function getGroups()
    {
        return $this->container['groups'];
    }

    /**
     * Sets groups
     *
     * @param \StevenBuehner\ChurchTools\Model\PublicGroup1[] $groups Array of groups to be displayed on the group homepage.
     *
     * @return self
     */
    public function setGroups($groups)
    {
        if (is_null($groups)) {
            throw new \InvalidArgumentException('non-nullable groups cannot be null');
        }
        $this->container['groups'] = $groups;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id Group Homepage ID
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets is_enabled
     *
     * @return bool
     */
    public function getIsEnabled()
    {
        return $this->container['is_enabled'];
    }

    /**
     * Sets is_enabled
     *
     * @param bool $is_enabled Wheather the group homepage is enabled. Clients should not display the group homepage if it is not enabled.
     *
     * @return self
     */
    public function setIsEnabled($is_enabled)
    {
        if (is_null($is_enabled)) {
            throw new \InvalidArgumentException('non-nullable is_enabled cannot be null');
        }
        $this->container['is_enabled'] = $is_enabled;

        return $this;
    }

    /**
     * Gets meta
     *
     * @return object
     */
    public function getMeta()
    {
        return $this->container['meta'];
    }

    /**
     * Sets meta
     *
     * @param object $meta Entity meta data
     *
     * @return self
     */
    public function setMeta($meta)
    {
        if (is_null($meta)) {
            throw new \InvalidArgumentException('non-nullable meta cannot be null');
        }
        $this->container['meta'] = $meta;

        return $this;
    }

    /**
     * Gets order_direction
     *
     * @return string|null
     */
    public function getOrderDirection()
    {
        return $this->container['order_direction'];
    }

    /**
     * Sets order_direction
     *
     * @param string|null $order_direction Direction if groups are sorted ascending or descending.
     *
     * @return self
     */
    public function setOrderDirection($order_direction)
    {
        if (is_null($order_direction)) {
            throw new \InvalidArgumentException('non-nullable order_direction cannot be null');
        }
        $allowedValues = $this->getOrderDirectionAllowableValues();
        if (!in_array($order_direction, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'order_direction', must be one of '%s'",
                    $order_direction,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['order_direction'] = $order_direction;

        return $this;
    }

    /**
     * Gets parent_group
     *
     * @return int
     */
    public function getParentGroup()
    {
        return $this->container['parent_group'];
    }

    /**
     * Sets parent_group
     *
     * @param int $parent_group ID of the parent group of all groups that should be displayed in the group homepage
     *
     * @return self
     */
    public function setParentGroup($parent_group)
    {
        if (is_null($parent_group)) {
            throw new \InvalidArgumentException('non-nullable parent_group cannot be null');
        }
        $this->container['parent_group'] = $parent_group;

        return $this;
    }

    /**
     * Gets random_url
     *
     * @return string
     */
    public function getRandomUrl()
    {
        return $this->container['random_url'];
    }

    /**
     * Sets random_url
     *
     * @param string $random_url The group homepage identifier (same as provided as hash request parameter).
     *
     * @return self
     */
    public function setRandomUrl($random_url)
    {
        if (is_null($random_url)) {
            throw new \InvalidArgumentException('non-nullable random_url cannot be null');
        }
        $this->container['random_url'] = $random_url;

        return $this;
    }

    /**
     * Gets show_filter
     *
     * @return bool|null
     */
    public function getShowFilter()
    {
        return $this->container['show_filter'];
    }

    /**
     * Sets show_filter
     *
     * @param bool|null $show_filter If true, selected filters are displayed.
     *
     * @return self
     */
    public function setShowFilter($show_filter)
    {
        if (is_null($show_filter)) {
            throw new \InvalidArgumentException('non-nullable show_filter cannot be null');
        }
        $this->container['show_filter'] = $show_filter;

        return $this;
    }

    /**
     * Gets show_group_images
     *
     * @return bool
     */
    public function getShowGroupImages()
    {
        return $this->container['show_group_images'];
    }

    /**
     * Sets show_group_images
     *
     * @param bool $show_group_images If true, the group homepage is set to display group images.
     *
     * @return self
     */
    public function setShowGroupImages($show_group_images)
    {
        if (is_null($show_group_images)) {
            throw new \InvalidArgumentException('non-nullable show_group_images cannot be null');
        }
        $this->container['show_group_images'] = $show_group_images;

        return $this;
    }

    /**
     * Gets show_leader
     *
     * @return bool
     */
    public function getShowLeader()
    {
        return $this->container['show_leader'];
    }

    /**
     * Sets show_leader
     *
     * @param bool $show_leader If true, the group homepage is set to display the leaders of each group.
     *
     * @return self
     */
    public function setShowLeader($show_leader)
    {
        if (is_null($show_leader)) {
            throw new \InvalidArgumentException('non-nullable show_leader cannot be null');
        }
        $this->container['show_leader'] = $show_leader;

        return $this;
    }

    /**
     * Gets show_map
     *
     * @return bool
     */
    public function getShowMap()
    {
        return $this->container['show_map'];
    }

    /**
     * Sets show_map
     *
     * @param bool $show_map If true, the group homepage is set to display an overview map of all groups.
     *
     * @return self
     */
    public function setShowMap($show_map)
    {
        if (is_null($show_map)) {
            throw new \InvalidArgumentException('non-nullable show_map cannot be null');
        }
        $this->container['show_map'] = $show_map;

        return $this;
    }

    /**
     * Gets sort_by
     *
     * @return string|null
     */
    public function getSortBy()
    {
        return $this->container['sort_by'];
    }

    /**
     * Sets sort_by
     *
     * @param string|null $sort_by Group field to sort list of groups by.
     *
     * @return self
     */
    public function setSortBy($sort_by)
    {
        if (is_null($sort_by)) {
            throw new \InvalidArgumentException('non-nullable sort_by cannot be null');
        }
        $allowedValues = $this->getSortByAllowableValues();
        if (!in_array($sort_by, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'sort_by', must be one of '%s'",
                    $sort_by,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['sort_by'] = $sort_by;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


