<?php
/**
 * GetSyncExecutions200ResponseDataInner
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * GetSyncExecutions200ResponseDataInner Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class GetSyncExecutions200ResponseDataInner implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'get_sync_executions_200_response_data_inner';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'both' => '\StevenBuehner\ChurchTools\Model\GetSyncExecutions200ResponseDataInnerBoth',
        'end_date' => 'string',
        'error_count' => 'int',
        'es' => '\StevenBuehner\ChurchTools\Model\GetSyncExecutions200ResponseDataInnerEs',
        'execution_id' => 'string',
        'is_dry_run' => 'bool',
        'job_id' => 'int',
        'master' => '\StevenBuehner\ChurchTools\Model\GetSyncExecutions200ResponseDataInnerEs',
        'start_date' => 'string',
        'status' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'both' => null,
        'end_date' => null,
        'error_count' => null,
        'es' => null,
        'execution_id' => null,
        'is_dry_run' => null,
        'job_id' => null,
        'master' => null,
        'start_date' => null,
        'status' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'both' => false,
        'end_date' => false,
        'error_count' => true,
        'es' => false,
        'execution_id' => false,
        'is_dry_run' => false,
        'job_id' => false,
        'master' => false,
        'start_date' => false,
        'status' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'both' => 'both',
        'end_date' => 'endDate',
        'error_count' => 'errorCount',
        'es' => 'es',
        'execution_id' => 'executionId',
        'is_dry_run' => 'isDryRun',
        'job_id' => 'jobId',
        'master' => 'master',
        'start_date' => 'startDate',
        'status' => 'status'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'both' => 'setBoth',
        'end_date' => 'setEndDate',
        'error_count' => 'setErrorCount',
        'es' => 'setEs',
        'execution_id' => 'setExecutionId',
        'is_dry_run' => 'setIsDryRun',
        'job_id' => 'setJobId',
        'master' => 'setMaster',
        'start_date' => 'setStartDate',
        'status' => 'setStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'both' => 'getBoth',
        'end_date' => 'getEndDate',
        'error_count' => 'getErrorCount',
        'es' => 'getEs',
        'execution_id' => 'getExecutionId',
        'is_dry_run' => 'getIsDryRun',
        'job_id' => 'getJobId',
        'master' => 'getMaster',
        'start_date' => 'getStartDate',
        'status' => 'getStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('both', $data ?? [], null);
        $this->setIfExists('end_date', $data ?? [], null);
        $this->setIfExists('error_count', $data ?? [], null);
        $this->setIfExists('es', $data ?? [], null);
        $this->setIfExists('execution_id', $data ?? [], null);
        $this->setIfExists('is_dry_run', $data ?? [], null);
        $this->setIfExists('job_id', $data ?? [], null);
        $this->setIfExists('master', $data ?? [], null);
        $this->setIfExists('start_date', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['end_date'] === null) {
            $invalidProperties[] = "'end_date' can't be null";
        }
        if ((mb_strlen($this->container['end_date']) < 1)) {
            $invalidProperties[] = "invalid value for 'end_date', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['execution_id'] === null) {
            $invalidProperties[] = "'execution_id' can't be null";
        }
        if ((mb_strlen($this->container['execution_id']) < 1)) {
            $invalidProperties[] = "invalid value for 'execution_id', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['job_id'] === null) {
            $invalidProperties[] = "'job_id' can't be null";
        }
        if ($this->container['start_date'] === null) {
            $invalidProperties[] = "'start_date' can't be null";
        }
        if ((mb_strlen($this->container['start_date']) < 1)) {
            $invalidProperties[] = "invalid value for 'start_date', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        if ((mb_strlen($this->container['status']) < 1)) {
            $invalidProperties[] = "invalid value for 'status', the character length must be bigger than or equal to 1.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets both
     *
     * @return \StevenBuehner\ChurchTools\Model\GetSyncExecutions200ResponseDataInnerBoth|null
     */
    public function getBoth()
    {
        return $this->container['both'];
    }

    /**
     * Sets both
     *
     * @param \StevenBuehner\ChurchTools\Model\GetSyncExecutions200ResponseDataInnerBoth|null $both both
     *
     * @return self
     */
    public function setBoth($both)
    {
        if (is_null($both)) {
            throw new \InvalidArgumentException('non-nullable both cannot be null');
        }
        $this->container['both'] = $both;

        return $this;
    }

    /**
     * Gets end_date
     *
     * @return string
     */
    public function getEndDate()
    {
        return $this->container['end_date'];
    }

    /**
     * Sets end_date
     *
     * @param string $end_date end_date
     *
     * @return self
     */
    public function setEndDate($end_date)
    {
        if (is_null($end_date)) {
            throw new \InvalidArgumentException('non-nullable end_date cannot be null');
        }

        if ((mb_strlen($end_date) < 1)) {
            throw new \InvalidArgumentException('invalid length for $end_date when calling GetSyncExecutions200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['end_date'] = $end_date;

        return $this;
    }

    /**
     * Gets error_count
     *
     * @return int|null
     */
    public function getErrorCount()
    {
        return $this->container['error_count'];
    }

    /**
     * Sets error_count
     *
     * @param int|null $error_count error_count
     *
     * @return self
     */
    public function setErrorCount($error_count)
    {
        if (is_null($error_count)) {
            array_push($this->openAPINullablesSetToNull, 'error_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('error_count', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['error_count'] = $error_count;

        return $this;
    }

    /**
     * Gets es
     *
     * @return \StevenBuehner\ChurchTools\Model\GetSyncExecutions200ResponseDataInnerEs|null
     */
    public function getEs()
    {
        return $this->container['es'];
    }

    /**
     * Sets es
     *
     * @param \StevenBuehner\ChurchTools\Model\GetSyncExecutions200ResponseDataInnerEs|null $es es
     *
     * @return self
     */
    public function setEs($es)
    {
        if (is_null($es)) {
            throw new \InvalidArgumentException('non-nullable es cannot be null');
        }
        $this->container['es'] = $es;

        return $this;
    }

    /**
     * Gets execution_id
     *
     * @return string
     */
    public function getExecutionId()
    {
        return $this->container['execution_id'];
    }

    /**
     * Sets execution_id
     *
     * @param string $execution_id execution_id
     *
     * @return self
     */
    public function setExecutionId($execution_id)
    {
        if (is_null($execution_id)) {
            throw new \InvalidArgumentException('non-nullable execution_id cannot be null');
        }

        if ((mb_strlen($execution_id) < 1)) {
            throw new \InvalidArgumentException('invalid length for $execution_id when calling GetSyncExecutions200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['execution_id'] = $execution_id;

        return $this;
    }

    /**
     * Gets is_dry_run
     *
     * @return bool|null
     */
    public function getIsDryRun()
    {
        return $this->container['is_dry_run'];
    }

    /**
     * Sets is_dry_run
     *
     * @param bool|null $is_dry_run is_dry_run
     *
     * @return self
     */
    public function setIsDryRun($is_dry_run)
    {
        if (is_null($is_dry_run)) {
            throw new \InvalidArgumentException('non-nullable is_dry_run cannot be null');
        }
        $this->container['is_dry_run'] = $is_dry_run;

        return $this;
    }

    /**
     * Gets job_id
     *
     * @return int
     */
    public function getJobId()
    {
        return $this->container['job_id'];
    }

    /**
     * Sets job_id
     *
     * @param int $job_id job_id
     *
     * @return self
     */
    public function setJobId($job_id)
    {
        if (is_null($job_id)) {
            throw new \InvalidArgumentException('non-nullable job_id cannot be null');
        }
        $this->container['job_id'] = $job_id;

        return $this;
    }

    /**
     * Gets master
     *
     * @return \StevenBuehner\ChurchTools\Model\GetSyncExecutions200ResponseDataInnerEs|null
     */
    public function getMaster()
    {
        return $this->container['master'];
    }

    /**
     * Sets master
     *
     * @param \StevenBuehner\ChurchTools\Model\GetSyncExecutions200ResponseDataInnerEs|null $master master
     *
     * @return self
     */
    public function setMaster($master)
    {
        if (is_null($master)) {
            throw new \InvalidArgumentException('non-nullable master cannot be null');
        }
        $this->container['master'] = $master;

        return $this;
    }

    /**
     * Gets start_date
     *
     * @return string
     */
    public function getStartDate()
    {
        return $this->container['start_date'];
    }

    /**
     * Sets start_date
     *
     * @param string $start_date start_date
     *
     * @return self
     */
    public function setStartDate($start_date)
    {
        if (is_null($start_date)) {
            throw new \InvalidArgumentException('non-nullable start_date cannot be null');
        }

        if ((mb_strlen($start_date) < 1)) {
            throw new \InvalidArgumentException('invalid length for $start_date when calling GetSyncExecutions200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['start_date'] = $start_date;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }

        if ((mb_strlen($status) < 1)) {
            throw new \InvalidArgumentException('invalid length for $status when calling GetSyncExecutions200ResponseDataInner., must be bigger than or equal to 1.');
        }

        $this->container['status'] = $status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


