<?php
/**
 * PatchGroupsGroupIdRolesRoleIdRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * PatchGroupsGroupIdRolesRoleIdRequest Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PatchGroupsGroupIdRolesRoleIdRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'patch_groups_groupId_roles_roleId_request';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'can_read_chat' => 'bool',
        'can_write_chat' => 'bool',
        'force_two_factor_auth' => 'bool',
        'grow_path_id' => 'int',
        'is_active' => 'bool',
        'receive_qr_code' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'can_read_chat' => null,
        'can_write_chat' => null,
        'force_two_factor_auth' => null,
        'grow_path_id' => null,
        'is_active' => null,
        'receive_qr_code' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'can_read_chat' => false,
        'can_write_chat' => false,
        'force_two_factor_auth' => false,
        'grow_path_id' => false,
        'is_active' => false,
        'receive_qr_code' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'can_read_chat' => 'canReadChat',
        'can_write_chat' => 'canWriteChat',
        'force_two_factor_auth' => 'forceTwoFactorAuth',
        'grow_path_id' => 'growPathId',
        'is_active' => 'isActive',
        'receive_qr_code' => 'receiveQRCode'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'can_read_chat' => 'setCanReadChat',
        'can_write_chat' => 'setCanWriteChat',
        'force_two_factor_auth' => 'setForceTwoFactorAuth',
        'grow_path_id' => 'setGrowPathId',
        'is_active' => 'setIsActive',
        'receive_qr_code' => 'setReceiveQrCode'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'can_read_chat' => 'getCanReadChat',
        'can_write_chat' => 'getCanWriteChat',
        'force_two_factor_auth' => 'getForceTwoFactorAuth',
        'grow_path_id' => 'getGrowPathId',
        'is_active' => 'getIsActive',
        'receive_qr_code' => 'getReceiveQrCode'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('can_read_chat', $data ?? [], null);
        $this->setIfExists('can_write_chat', $data ?? [], null);
        $this->setIfExists('force_two_factor_auth', $data ?? [], null);
        $this->setIfExists('grow_path_id', $data ?? [], null);
        $this->setIfExists('is_active', $data ?? [], null);
        $this->setIfExists('receive_qr_code', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets can_read_chat
     *
     * @return bool|null
     */
    public function getCanReadChat()
    {
        return $this->container['can_read_chat'];
    }

    /**
     * Sets can_read_chat
     *
     * @param bool|null $can_read_chat can_read_chat
     *
     * @return self
     */
    public function setCanReadChat($can_read_chat)
    {
        if (is_null($can_read_chat)) {
            throw new \InvalidArgumentException('non-nullable can_read_chat cannot be null');
        }
        $this->container['can_read_chat'] = $can_read_chat;

        return $this;
    }

    /**
     * Gets can_write_chat
     *
     * @return bool|null
     */
    public function getCanWriteChat()
    {
        return $this->container['can_write_chat'];
    }

    /**
     * Sets can_write_chat
     *
     * @param bool|null $can_write_chat can_write_chat
     *
     * @return self
     */
    public function setCanWriteChat($can_write_chat)
    {
        if (is_null($can_write_chat)) {
            throw new \InvalidArgumentException('non-nullable can_write_chat cannot be null');
        }
        $this->container['can_write_chat'] = $can_write_chat;

        return $this;
    }

    /**
     * Gets force_two_factor_auth
     *
     * @return bool|null
     */
    public function getForceTwoFactorAuth()
    {
        return $this->container['force_two_factor_auth'];
    }

    /**
     * Sets force_two_factor_auth
     *
     * @param bool|null $force_two_factor_auth force_two_factor_auth
     *
     * @return self
     */
    public function setForceTwoFactorAuth($force_two_factor_auth)
    {
        if (is_null($force_two_factor_auth)) {
            throw new \InvalidArgumentException('non-nullable force_two_factor_auth cannot be null');
        }
        $this->container['force_two_factor_auth'] = $force_two_factor_auth;

        return $this;
    }

    /**
     * Gets grow_path_id
     *
     * @return int|null
     */
    public function getGrowPathId()
    {
        return $this->container['grow_path_id'];
    }

    /**
     * Sets grow_path_id
     *
     * @param int|null $grow_path_id grow_path_id
     *
     * @return self
     */
    public function setGrowPathId($grow_path_id)
    {
        if (is_null($grow_path_id)) {
            throw new \InvalidArgumentException('non-nullable grow_path_id cannot be null');
        }
        $this->container['grow_path_id'] = $grow_path_id;

        return $this;
    }

    /**
     * Gets is_active
     *
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->container['is_active'];
    }

    /**
     * Sets is_active
     *
     * @param bool|null $is_active is_active
     *
     * @return self
     */
    public function setIsActive($is_active)
    {
        if (is_null($is_active)) {
            throw new \InvalidArgumentException('non-nullable is_active cannot be null');
        }
        $this->container['is_active'] = $is_active;

        return $this;
    }

    /**
     * Gets receive_qr_code
     *
     * @return bool|null
     */
    public function getReceiveQrCode()
    {
        return $this->container['receive_qr_code'];
    }

    /**
     * Sets receive_qr_code
     *
     * @param bool|null $receive_qr_code receive_qr_code
     *
     * @return self
     */
    public function setReceiveQrCode($receive_qr_code)
    {
        if (is_null($receive_qr_code)) {
            throw new \InvalidArgumentException('non-nullable receive_qr_code cannot be null');
        }
        $this->container['receive_qr_code'] = $receive_qr_code;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


