<?php
/**
 * PostSyncLogsRequestLogsInner
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * PostSyncLogsRequestLogsInner Class Doc Comment
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PostSyncLogsRequestLogsInner implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'post_sync_logs_request_logs_inner';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'args' => 'object',
        'changes' => '\StevenBuehner\ChurchTools\Model\PostSyncLogsRequestLogsInnerChangesInner[]',
        'date' => '\DateTime',
        'domain_id' => 'string',
        'domain_type' => 'string',
        'is_dry_run' => 'bool',
        'job_id' => 'int',
        'level' => 'string',
        'message_key' => 'string',
        'source_entity_id' => 'string',
        'system' => 'string',
        'type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'args' => null,
        'changes' => null,
        'date' => 'date-time',
        'domain_id' => null,
        'domain_type' => null,
        'is_dry_run' => null,
        'job_id' => null,
        'level' => null,
        'message_key' => null,
        'source_entity_id' => null,
        'system' => null,
        'type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'args' => false,
        'changes' => false,
        'date' => false,
        'domain_id' => true,
        'domain_type' => true,
        'is_dry_run' => false,
        'job_id' => false,
        'level' => false,
        'message_key' => false,
        'source_entity_id' => true,
        'system' => false,
        'type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'args' => 'args',
        'changes' => 'changes',
        'date' => 'date',
        'domain_id' => 'domainId',
        'domain_type' => 'domainType',
        'is_dry_run' => 'isDryRun',
        'job_id' => 'jobId',
        'level' => 'level',
        'message_key' => 'messageKey',
        'source_entity_id' => 'sourceEntityId',
        'system' => 'system',
        'type' => 'type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'args' => 'setArgs',
        'changes' => 'setChanges',
        'date' => 'setDate',
        'domain_id' => 'setDomainId',
        'domain_type' => 'setDomainType',
        'is_dry_run' => 'setIsDryRun',
        'job_id' => 'setJobId',
        'level' => 'setLevel',
        'message_key' => 'setMessageKey',
        'source_entity_id' => 'setSourceEntityId',
        'system' => 'setSystem',
        'type' => 'setType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'args' => 'getArgs',
        'changes' => 'getChanges',
        'date' => 'getDate',
        'domain_id' => 'getDomainId',
        'domain_type' => 'getDomainType',
        'is_dry_run' => 'getIsDryRun',
        'job_id' => 'getJobId',
        'level' => 'getLevel',
        'message_key' => 'getMessageKey',
        'source_entity_id' => 'getSourceEntityId',
        'system' => 'getSystem',
        'type' => 'getType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const LEVEL_DEBUG = 'debug';
    public const LEVEL_INFO = 'info';
    public const LEVEL_NOTICE = 'notice';
    public const LEVEL_WARNING = 'warning';
    public const LEVEL_ERROR = 'error';
    public const LEVEL_CRITICAL = 'critical';
    public const LEVEL_ALERT = 'alert';
    public const LEVEL_EMERGENCY = 'emergency';
    public const SYSTEM_ES = 'es';
    public const SYSTEM_MASTER = 'master';
    public const SYSTEM_BOTH = 'both';
    public const TYPE_CREATE = 'create';
    public const TYPE_UPDATE = 'update';
    public const TYPE_LINK = 'link';
    public const TYPE_DELETE = 'delete';
    public const TYPE_EXECUTION = 'execution';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getLevelAllowableValues()
    {
        return [
            self::LEVEL_DEBUG,
            self::LEVEL_INFO,
            self::LEVEL_NOTICE,
            self::LEVEL_WARNING,
            self::LEVEL_ERROR,
            self::LEVEL_CRITICAL,
            self::LEVEL_ALERT,
            self::LEVEL_EMERGENCY,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSystemAllowableValues()
    {
        return [
            self::SYSTEM_ES,
            self::SYSTEM_MASTER,
            self::SYSTEM_BOTH,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_CREATE,
            self::TYPE_UPDATE,
            self::TYPE_LINK,
            self::TYPE_DELETE,
            self::TYPE_EXECUTION,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('args', $data ?? [], null);
        $this->setIfExists('changes', $data ?? [], null);
        $this->setIfExists('date', $data ?? [], null);
        $this->setIfExists('domain_id', $data ?? [], null);
        $this->setIfExists('domain_type', $data ?? [], null);
        $this->setIfExists('is_dry_run', $data ?? [], null);
        $this->setIfExists('job_id', $data ?? [], null);
        $this->setIfExists('level', $data ?? [], null);
        $this->setIfExists('message_key', $data ?? [], null);
        $this->setIfExists('source_entity_id', $data ?? [], null);
        $this->setIfExists('system', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['args'] === null) {
            $invalidProperties[] = "'args' can't be null";
        }
        if ($this->container['date'] === null) {
            $invalidProperties[] = "'date' can't be null";
        }
        if ((mb_strlen($this->container['date']) < 1)) {
            $invalidProperties[] = "invalid value for 'date', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['domain_id'] === null) {
            $invalidProperties[] = "'domain_id' can't be null";
        }
        if ((mb_strlen($this->container['domain_id']) < 1)) {
            $invalidProperties[] = "invalid value for 'domain_id', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['domain_type'] === null) {
            $invalidProperties[] = "'domain_type' can't be null";
        }
        if ((mb_strlen($this->container['domain_type']) < 1)) {
            $invalidProperties[] = "invalid value for 'domain_type', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['is_dry_run'] === null) {
            $invalidProperties[] = "'is_dry_run' can't be null";
        }
        if ($this->container['job_id'] === null) {
            $invalidProperties[] = "'job_id' can't be null";
        }
        if ($this->container['level'] === null) {
            $invalidProperties[] = "'level' can't be null";
        }
        $allowedValues = $this->getLevelAllowableValues();
        if (!is_null($this->container['level']) && !in_array($this->container['level'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'level', must be one of '%s'",
                $this->container['level'],
                implode("', '", $allowedValues)
            );
        }

        if ((mb_strlen($this->container['level']) < 1)) {
            $invalidProperties[] = "invalid value for 'level', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['message_key'] === null) {
            $invalidProperties[] = "'message_key' can't be null";
        }
        if ((mb_strlen($this->container['message_key']) < 1)) {
            $invalidProperties[] = "invalid value for 'message_key', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['source_entity_id'] === null) {
            $invalidProperties[] = "'source_entity_id' can't be null";
        }
        if ((mb_strlen($this->container['source_entity_id']) < 1)) {
            $invalidProperties[] = "invalid value for 'source_entity_id', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['system'] === null) {
            $invalidProperties[] = "'system' can't be null";
        }
        $allowedValues = $this->getSystemAllowableValues();
        if (!is_null($this->container['system']) && !in_array($this->container['system'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'system', must be one of '%s'",
                $this->container['system'],
                implode("', '", $allowedValues)
            );
        }

        if ((mb_strlen($this->container['system']) < 1)) {
            $invalidProperties[] = "invalid value for 'system', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        if ((mb_strlen($this->container['type']) < 1)) {
            $invalidProperties[] = "invalid value for 'type', the character length must be bigger than or equal to 1.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets args
     *
     * @return object
     */
    public function getArgs()
    {
        return $this->container['args'];
    }

    /**
     * Sets args
     *
     * @param object $args Arguments for Translation Key
     *
     * @return self
     */
    public function setArgs($args)
    {
        if (is_null($args)) {
            throw new \InvalidArgumentException('non-nullable args cannot be null');
        }
        $this->container['args'] = $args;

        return $this;
    }

    /**
     * Gets changes
     *
     * @return \StevenBuehner\ChurchTools\Model\PostSyncLogsRequestLogsInnerChangesInner[]|null
     */
    public function getChanges()
    {
        return $this->container['changes'];
    }

    /**
     * Sets changes
     *
     * @param \StevenBuehner\ChurchTools\Model\PostSyncLogsRequestLogsInnerChangesInner[]|null $changes changes
     *
     * @return self
     */
    public function setChanges($changes)
    {
        if (is_null($changes)) {
            throw new \InvalidArgumentException('non-nullable changes cannot be null');
        }
        $this->container['changes'] = $changes;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime $date date
     *
     * @return self
     */
    public function setDate($date)
    {
        if (is_null($date)) {
            throw new \InvalidArgumentException('non-nullable date cannot be null');
        }

        if ((mb_strlen($date) < 1)) {
            throw new \InvalidArgumentException('invalid length for $date when calling PostSyncLogsRequestLogsInner., must be bigger than or equal to 1.');
        }

        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets domain_id
     *
     * @return string
     */
    public function getDomainId()
    {
        return $this->container['domain_id'];
    }

    /**
     * Sets domain_id
     *
     * @param string $domain_id domain_id
     *
     * @return self
     */
    public function setDomainId($domain_id)
    {
        if (is_null($domain_id)) {
            array_push($this->openAPINullablesSetToNull, 'domain_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('domain_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($domain_id) && (mb_strlen($domain_id) < 1)) {
            throw new \InvalidArgumentException('invalid length for $domain_id when calling PostSyncLogsRequestLogsInner., must be bigger than or equal to 1.');
        }

        $this->container['domain_id'] = $domain_id;

        return $this;
    }

    /**
     * Gets domain_type
     *
     * @return string
     */
    public function getDomainType()
    {
        return $this->container['domain_type'];
    }

    /**
     * Sets domain_type
     *
     * @param string $domain_type domain_type
     *
     * @return self
     */
    public function setDomainType($domain_type)
    {
        if (is_null($domain_type)) {
            array_push($this->openAPINullablesSetToNull, 'domain_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('domain_type', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($domain_type) && (mb_strlen($domain_type) < 1)) {
            throw new \InvalidArgumentException('invalid length for $domain_type when calling PostSyncLogsRequestLogsInner., must be bigger than or equal to 1.');
        }

        $this->container['domain_type'] = $domain_type;

        return $this;
    }

    /**
     * Gets is_dry_run
     *
     * @return bool
     */
    public function getIsDryRun()
    {
        return $this->container['is_dry_run'];
    }

    /**
     * Sets is_dry_run
     *
     * @param bool $is_dry_run is_dry_run
     *
     * @return self
     */
    public function setIsDryRun($is_dry_run)
    {
        if (is_null($is_dry_run)) {
            throw new \InvalidArgumentException('non-nullable is_dry_run cannot be null');
        }
        $this->container['is_dry_run'] = $is_dry_run;

        return $this;
    }

    /**
     * Gets job_id
     *
     * @return int
     */
    public function getJobId()
    {
        return $this->container['job_id'];
    }

    /**
     * Sets job_id
     *
     * @param int $job_id job_id
     *
     * @return self
     */
    public function setJobId($job_id)
    {
        if (is_null($job_id)) {
            throw new \InvalidArgumentException('non-nullable job_id cannot be null');
        }
        $this->container['job_id'] = $job_id;

        return $this;
    }

    /**
     * Gets level
     *
     * @return string
     */
    public function getLevel()
    {
        return $this->container['level'];
    }

    /**
     * Sets level
     *
     * @param string $level level
     *
     * @return self
     */
    public function setLevel($level)
    {
        if (is_null($level)) {
            throw new \InvalidArgumentException('non-nullable level cannot be null');
        }
        $allowedValues = $this->getLevelAllowableValues();
        if (!in_array($level, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'level', must be one of '%s'",
                    $level,
                    implode("', '", $allowedValues)
                )
            );
        }

        if ((mb_strlen($level) < 1)) {
            throw new \InvalidArgumentException('invalid length for $level when calling PostSyncLogsRequestLogsInner., must be bigger than or equal to 1.');
        }

        $this->container['level'] = $level;

        return $this;
    }

    /**
     * Gets message_key
     *
     * @return string
     */
    public function getMessageKey()
    {
        return $this->container['message_key'];
    }

    /**
     * Sets message_key
     *
     * @param string $message_key Translation Key
     *
     * @return self
     */
    public function setMessageKey($message_key)
    {
        if (is_null($message_key)) {
            throw new \InvalidArgumentException('non-nullable message_key cannot be null');
        }

        if ((mb_strlen($message_key) < 1)) {
            throw new \InvalidArgumentException('invalid length for $message_key when calling PostSyncLogsRequestLogsInner., must be bigger than or equal to 1.');
        }

        $this->container['message_key'] = $message_key;

        return $this;
    }

    /**
     * Gets source_entity_id
     *
     * @return string
     */
    public function getSourceEntityId()
    {
        return $this->container['source_entity_id'];
    }

    /**
     * Sets source_entity_id
     *
     * @param string $source_entity_id source_entity_id
     *
     * @return self
     */
    public function setSourceEntityId($source_entity_id)
    {
        if (is_null($source_entity_id)) {
            array_push($this->openAPINullablesSetToNull, 'source_entity_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('source_entity_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($source_entity_id) && (mb_strlen($source_entity_id) < 1)) {
            throw new \InvalidArgumentException('invalid length for $source_entity_id when calling PostSyncLogsRequestLogsInner., must be bigger than or equal to 1.');
        }

        $this->container['source_entity_id'] = $source_entity_id;

        return $this;
    }

    /**
     * Gets system
     *
     * @return string
     */
    public function getSystem()
    {
        return $this->container['system'];
    }

    /**
     * Sets system
     *
     * @param string $system system
     *
     * @return self
     */
    public function setSystem($system)
    {
        if (is_null($system)) {
            throw new \InvalidArgumentException('non-nullable system cannot be null');
        }
        $allowedValues = $this->getSystemAllowableValues();
        if (!in_array($system, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'system', must be one of '%s'",
                    $system,
                    implode("', '", $allowedValues)
                )
            );
        }

        if ((mb_strlen($system) < 1)) {
            throw new \InvalidArgumentException('invalid length for $system when calling PostSyncLogsRequestLogsInner., must be bigger than or equal to 1.');
        }

        $this->container['system'] = $system;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }

        if ((mb_strlen($type) < 1)) {
            throw new \InvalidArgumentException('invalid length for $type when calling PostSyncLogsRequestLogsInner., must be bigger than or equal to 1.');
        }

        $this->container['type'] = $type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


