<?php
/**
 * ProfileUpdate
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * ProfileUpdate Class Doc Comment
 *
 * @category Class
 * @description 
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProfileUpdate implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProfileUpdate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'address' => '\StevenBuehner\ChurchTools\Model\UpdateCampusRequestAddress',
        'association_id' => 'int',
        'denomination' => '\StevenBuehner\ChurchTools\Model\UpdateCampusRequestDenomination',
        'description' => 'string',
        'email' => 'string',
        'groups' => '\StevenBuehner\ChurchTools\Model\UpdateCampusRequestGroupsInner[]',
        'is_published' => 'bool',
        'name' => 'string',
        'phone' => 'string',
        'services' => '\StevenBuehner\ChurchTools\Model\UpdateCampusRequestServicesInner[]',
        'short_name' => 'string',
        'shorty' => 'string',
        'sign_up_group' => '\StevenBuehner\ChurchTools\Model\UpdateCampusRequestSignUpGroup',
        'slug' => 'string',
        'social_media' => '\StevenBuehner\ChurchTools\Model\UpdateCampusRequestSocialMedia',
        'sort_key' => 'int',
        'tags' => 'string[]',
        'team' => '\StevenBuehner\ChurchTools\Model\UpdateCampusRequestTeamInner[]',
        'team_title' => 'string',
        'visitors' => 'int',
        'website' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'address' => null,
        'association_id' => null,
        'denomination' => null,
        'description' => null,
        'email' => null,
        'groups' => null,
        'is_published' => null,
        'name' => null,
        'phone' => null,
        'services' => null,
        'short_name' => null,
        'shorty' => null,
        'sign_up_group' => null,
        'slug' => null,
        'social_media' => null,
        'sort_key' => null,
        'tags' => null,
        'team' => null,
        'team_title' => null,
        'visitors' => null,
        'website' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'address' => false,
        'association_id' => false,
        'denomination' => false,
        'description' => false,
        'email' => false,
        'groups' => false,
        'is_published' => false,
        'name' => false,
        'phone' => false,
        'services' => false,
        'short_name' => false,
        'shorty' => false,
        'sign_up_group' => false,
        'slug' => false,
        'social_media' => false,
        'sort_key' => false,
        'tags' => false,
        'team' => false,
        'team_title' => false,
        'visitors' => false,
        'website' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'address' => 'address',
        'association_id' => 'associationId',
        'denomination' => 'denomination',
        'description' => 'description',
        'email' => 'email',
        'groups' => 'groups',
        'is_published' => 'isPublished',
        'name' => 'name',
        'phone' => 'phone',
        'services' => 'services',
        'short_name' => 'shortName',
        'shorty' => 'shorty',
        'sign_up_group' => 'signUpGroup',
        'slug' => 'slug',
        'social_media' => 'socialMedia',
        'sort_key' => 'sortKey',
        'tags' => 'tags',
        'team' => 'team',
        'team_title' => 'teamTitle',
        'visitors' => 'visitors',
        'website' => 'website'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'address' => 'setAddress',
        'association_id' => 'setAssociationId',
        'denomination' => 'setDenomination',
        'description' => 'setDescription',
        'email' => 'setEmail',
        'groups' => 'setGroups',
        'is_published' => 'setIsPublished',
        'name' => 'setName',
        'phone' => 'setPhone',
        'services' => 'setServices',
        'short_name' => 'setShortName',
        'shorty' => 'setShorty',
        'sign_up_group' => 'setSignUpGroup',
        'slug' => 'setSlug',
        'social_media' => 'setSocialMedia',
        'sort_key' => 'setSortKey',
        'tags' => 'setTags',
        'team' => 'setTeam',
        'team_title' => 'setTeamTitle',
        'visitors' => 'setVisitors',
        'website' => 'setWebsite'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'address' => 'getAddress',
        'association_id' => 'getAssociationId',
        'denomination' => 'getDenomination',
        'description' => 'getDescription',
        'email' => 'getEmail',
        'groups' => 'getGroups',
        'is_published' => 'getIsPublished',
        'name' => 'getName',
        'phone' => 'getPhone',
        'services' => 'getServices',
        'short_name' => 'getShortName',
        'shorty' => 'getShorty',
        'sign_up_group' => 'getSignUpGroup',
        'slug' => 'getSlug',
        'social_media' => 'getSocialMedia',
        'sort_key' => 'getSortKey',
        'tags' => 'getTags',
        'team' => 'getTeam',
        'team_title' => 'getTeamTitle',
        'visitors' => 'getVisitors',
        'website' => 'getWebsite'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const VISITORS_0 = 0;
    public const VISITORS_1 = 1;
    public const VISITORS_50 = 50;
    public const VISITORS_100 = 100;
    public const VISITORS_250 = 250;
    public const VISITORS_500 = 500;
    public const VISITORS_1000 = 1000;

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getVisitorsAllowableValues()
    {
        return [
            self::VISITORS_0,
            self::VISITORS_1,
            self::VISITORS_50,
            self::VISITORS_100,
            self::VISITORS_250,
            self::VISITORS_500,
            self::VISITORS_1000,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('address', $data ?? [], null);
        $this->setIfExists('association_id', $data ?? [], null);
        $this->setIfExists('denomination', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('groups', $data ?? [], null);
        $this->setIfExists('is_published', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('phone', $data ?? [], null);
        $this->setIfExists('services', $data ?? [], null);
        $this->setIfExists('short_name', $data ?? [], null);
        $this->setIfExists('shorty', $data ?? [], null);
        $this->setIfExists('sign_up_group', $data ?? [], null);
        $this->setIfExists('slug', $data ?? [], null);
        $this->setIfExists('social_media', $data ?? [], null);
        $this->setIfExists('sort_key', $data ?? [], 0);
        $this->setIfExists('tags', $data ?? [], null);
        $this->setIfExists('team', $data ?? [], null);
        $this->setIfExists('team_title', $data ?? [], null);
        $this->setIfExists('visitors', $data ?? [], null);
        $this->setIfExists('website', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['address'] === null) {
            $invalidProperties[] = "'address' can't be null";
        }
        if ($this->container['association_id'] === null) {
            $invalidProperties[] = "'association_id' can't be null";
        }
        if ($this->container['denomination'] === null) {
            $invalidProperties[] = "'denomination' can't be null";
        }
        if ($this->container['description'] === null) {
            $invalidProperties[] = "'description' can't be null";
        }
        if ((mb_strlen($this->container['description']) > 1000)) {
            $invalidProperties[] = "invalid value for 'description', the character length must be smaller than or equal to 1000.";
        }

        if ((mb_strlen($this->container['description']) < 1)) {
            $invalidProperties[] = "invalid value for 'description', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['email'] === null) {
            $invalidProperties[] = "'email' can't be null";
        }
        if ((mb_strlen($this->container['email']) < 1)) {
            $invalidProperties[] = "invalid value for 'email', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['groups'] === null) {
            $invalidProperties[] = "'groups' can't be null";
        }
        if ((count($this->container['groups']) < 1)) {
            $invalidProperties[] = "invalid value for 'groups', number of items must be greater than or equal to 1.";
        }

        if ($this->container['is_published'] === null) {
            $invalidProperties[] = "'is_published' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ((mb_strlen($this->container['name']) < 1)) {
            $invalidProperties[] = "invalid value for 'name', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['phone'] === null) {
            $invalidProperties[] = "'phone' can't be null";
        }
        if ((mb_strlen($this->container['phone']) < 1)) {
            $invalidProperties[] = "invalid value for 'phone', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['services'] === null) {
            $invalidProperties[] = "'services' can't be null";
        }
        if ((count($this->container['services']) < 1)) {
            $invalidProperties[] = "invalid value for 'services', number of items must be greater than or equal to 1.";
        }

        if ($this->container['short_name'] === null) {
            $invalidProperties[] = "'short_name' can't be null";
        }
        if ((mb_strlen($this->container['short_name']) < 1)) {
            $invalidProperties[] = "invalid value for 'short_name', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['shorty'] === null) {
            $invalidProperties[] = "'shorty' can't be null";
        }
        if ((mb_strlen($this->container['shorty']) < 1)) {
            $invalidProperties[] = "invalid value for 'shorty', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['sign_up_group'] === null) {
            $invalidProperties[] = "'sign_up_group' can't be null";
        }
        if ($this->container['slug'] === null) {
            $invalidProperties[] = "'slug' can't be null";
        }
        if ((mb_strlen($this->container['slug']) < 1)) {
            $invalidProperties[] = "invalid value for 'slug', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['social_media'] === null) {
            $invalidProperties[] = "'social_media' can't be null";
        }
        if ($this->container['sort_key'] === null) {
            $invalidProperties[] = "'sort_key' can't be null";
        }
        if ($this->container['tags'] === null) {
            $invalidProperties[] = "'tags' can't be null";
        }
        if ($this->container['team'] === null) {
            $invalidProperties[] = "'team' can't be null";
        }
        if ((count($this->container['team']) < 1)) {
            $invalidProperties[] = "invalid value for 'team', number of items must be greater than or equal to 1.";
        }

        if ($this->container['team_title'] === null) {
            $invalidProperties[] = "'team_title' can't be null";
        }
        if ((mb_strlen($this->container['team_title']) < 1)) {
            $invalidProperties[] = "invalid value for 'team_title', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['visitors'] === null) {
            $invalidProperties[] = "'visitors' can't be null";
        }
        $allowedValues = $this->getVisitorsAllowableValues();
        if (!is_null($this->container['visitors']) && !in_array($this->container['visitors'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'visitors', must be one of '%s'",
                $this->container['visitors'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['website'] === null) {
            $invalidProperties[] = "'website' can't be null";
        }
        if ((mb_strlen($this->container['website']) < 1)) {
            $invalidProperties[] = "invalid value for 'website', the character length must be bigger than or equal to 1.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets address
     *
     * @return \StevenBuehner\ChurchTools\Model\UpdateCampusRequestAddress
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     *
     * @param \StevenBuehner\ChurchTools\Model\UpdateCampusRequestAddress $address address
     *
     * @return self
     */
    public function setAddress($address)
    {
        if (is_null($address)) {
            throw new \InvalidArgumentException('non-nullable address cannot be null');
        }
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets association_id
     *
     * @return int
     */
    public function getAssociationId()
    {
        return $this->container['association_id'];
    }

    /**
     * Sets association_id
     *
     * @param int $association_id association_id
     *
     * @return self
     */
    public function setAssociationId($association_id)
    {
        if (is_null($association_id)) {
            throw new \InvalidArgumentException('non-nullable association_id cannot be null');
        }
        $this->container['association_id'] = $association_id;

        return $this;
    }

    /**
     * Gets denomination
     *
     * @return \StevenBuehner\ChurchTools\Model\UpdateCampusRequestDenomination
     */
    public function getDenomination()
    {
        return $this->container['denomination'];
    }

    /**
     * Sets denomination
     *
     * @param \StevenBuehner\ChurchTools\Model\UpdateCampusRequestDenomination $denomination denomination
     *
     * @return self
     */
    public function setDenomination($denomination)
    {
        if (is_null($denomination)) {
            throw new \InvalidArgumentException('non-nullable denomination cannot be null');
        }
        $this->container['denomination'] = $denomination;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        if ((mb_strlen($description) > 1000)) {
            throw new \InvalidArgumentException('invalid length for $description when calling ProfileUpdate., must be smaller than or equal to 1000.');
        }
        if ((mb_strlen($description) < 1)) {
            throw new \InvalidArgumentException('invalid length for $description when calling ProfileUpdate., must be bigger than or equal to 1.');
        }

        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string $email email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }

        if ((mb_strlen($email) < 1)) {
            throw new \InvalidArgumentException('invalid length for $email when calling ProfileUpdate., must be bigger than or equal to 1.');
        }

        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets groups
     *
     * @return \StevenBuehner\ChurchTools\Model\UpdateCampusRequestGroupsInner[]
     */
    public function getGroups()
    {
        return $this->container['groups'];
    }

    /**
     * Sets groups
     *
     * @param \StevenBuehner\ChurchTools\Model\UpdateCampusRequestGroupsInner[] $groups Either array of group IDs or array of objects with group-property, which is a domain object wiht 'domainIdentifier'
     *
     * @return self
     */
    public function setGroups($groups)
    {
        if (is_null($groups)) {
            throw new \InvalidArgumentException('non-nullable groups cannot be null');
        }


        if ((count($groups) < 1)) {
            throw new \InvalidArgumentException('invalid length for $groups when calling ProfileUpdate., number of items must be greater than or equal to 1.');
        }
        $this->container['groups'] = $groups;

        return $this;
    }

    /**
     * Gets is_published
     *
     * @return bool
     */
    public function getIsPublished()
    {
        return $this->container['is_published'];
    }

    /**
     * Sets is_published
     *
     * @param bool $is_published is_published
     *
     * @return self
     */
    public function setIsPublished($is_published)
    {
        if (is_null($is_published)) {
            throw new \InvalidArgumentException('non-nullable is_published cannot be null');
        }
        $this->container['is_published'] = $is_published;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }

        if ((mb_strlen($name) < 1)) {
            throw new \InvalidArgumentException('invalid length for $name when calling ProfileUpdate., must be bigger than or equal to 1.');
        }

        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string $phone phone
     *
     * @return self
     */
    public function setPhone($phone)
    {
        if (is_null($phone)) {
            throw new \InvalidArgumentException('non-nullable phone cannot be null');
        }

        if ((mb_strlen($phone) < 1)) {
            throw new \InvalidArgumentException('invalid length for $phone when calling ProfileUpdate., must be bigger than or equal to 1.');
        }

        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets services
     *
     * @return \StevenBuehner\ChurchTools\Model\UpdateCampusRequestServicesInner[]
     */
    public function getServices()
    {
        return $this->container['services'];
    }

    /**
     * Sets services
     *
     * @param \StevenBuehner\ChurchTools\Model\UpdateCampusRequestServicesInner[] $services services
     *
     * @return self
     */
    public function setServices($services)
    {
        if (is_null($services)) {
            throw new \InvalidArgumentException('non-nullable services cannot be null');
        }


        if ((count($services) < 1)) {
            throw new \InvalidArgumentException('invalid length for $services when calling ProfileUpdate., number of items must be greater than or equal to 1.');
        }
        $this->container['services'] = $services;

        return $this;
    }

    /**
     * Gets short_name
     *
     * @return string
     */
    public function getShortName()
    {
        return $this->container['short_name'];
    }

    /**
     * Sets short_name
     *
     * @param string $short_name short_name
     *
     * @return self
     */
    public function setShortName($short_name)
    {
        if (is_null($short_name)) {
            throw new \InvalidArgumentException('non-nullable short_name cannot be null');
        }

        if ((mb_strlen($short_name) < 1)) {
            throw new \InvalidArgumentException('invalid length for $short_name when calling ProfileUpdate., must be bigger than or equal to 1.');
        }

        $this->container['short_name'] = $short_name;

        return $this;
    }

    /**
     * Gets shorty
     *
     * @return string
     */
    public function getShorty()
    {
        return $this->container['shorty'];
    }

    /**
     * Sets shorty
     *
     * @param string $shorty shorty
     *
     * @return self
     */
    public function setShorty($shorty)
    {
        if (is_null($shorty)) {
            throw new \InvalidArgumentException('non-nullable shorty cannot be null');
        }

        if ((mb_strlen($shorty) < 1)) {
            throw new \InvalidArgumentException('invalid length for $shorty when calling ProfileUpdate., must be bigger than or equal to 1.');
        }

        $this->container['shorty'] = $shorty;

        return $this;
    }

    /**
     * Gets sign_up_group
     *
     * @return \StevenBuehner\ChurchTools\Model\UpdateCampusRequestSignUpGroup
     */
    public function getSignUpGroup()
    {
        return $this->container['sign_up_group'];
    }

    /**
     * Sets sign_up_group
     *
     * @param \StevenBuehner\ChurchTools\Model\UpdateCampusRequestSignUpGroup $sign_up_group sign_up_group
     *
     * @return self
     */
    public function setSignUpGroup($sign_up_group)
    {
        if (is_null($sign_up_group)) {
            throw new \InvalidArgumentException('non-nullable sign_up_group cannot be null');
        }
        $this->container['sign_up_group'] = $sign_up_group;

        return $this;
    }

    /**
     * Gets slug
     *
     * @return string
     */
    public function getSlug()
    {
        return $this->container['slug'];
    }

    /**
     * Sets slug
     *
     * @param string $slug slug
     *
     * @return self
     */
    public function setSlug($slug)
    {
        if (is_null($slug)) {
            throw new \InvalidArgumentException('non-nullable slug cannot be null');
        }

        if ((mb_strlen($slug) < 1)) {
            throw new \InvalidArgumentException('invalid length for $slug when calling ProfileUpdate., must be bigger than or equal to 1.');
        }

        $this->container['slug'] = $slug;

        return $this;
    }

    /**
     * Gets social_media
     *
     * @return \StevenBuehner\ChurchTools\Model\UpdateCampusRequestSocialMedia
     */
    public function getSocialMedia()
    {
        return $this->container['social_media'];
    }

    /**
     * Sets social_media
     *
     * @param \StevenBuehner\ChurchTools\Model\UpdateCampusRequestSocialMedia $social_media social_media
     *
     * @return self
     */
    public function setSocialMedia($social_media)
    {
        if (is_null($social_media)) {
            throw new \InvalidArgumentException('non-nullable social_media cannot be null');
        }
        $this->container['social_media'] = $social_media;

        return $this;
    }

    /**
     * Gets sort_key
     *
     * @return int
     */
    public function getSortKey()
    {
        return $this->container['sort_key'];
    }

    /**
     * Sets sort_key
     *
     * @param int $sort_key sort_key
     *
     * @return self
     */
    public function setSortKey($sort_key)
    {
        if (is_null($sort_key)) {
            throw new \InvalidArgumentException('non-nullable sort_key cannot be null');
        }
        $this->container['sort_key'] = $sort_key;

        return $this;
    }

    /**
     * Gets tags
     *
     * @return string[]
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     *
     * @param string[] $tags List of tags.
     *
     * @return self
     */
    public function setTags($tags)
    {
        if (is_null($tags)) {
            throw new \InvalidArgumentException('non-nullable tags cannot be null');
        }
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets team
     *
     * @return \StevenBuehner\ChurchTools\Model\UpdateCampusRequestTeamInner[]
     */
    public function getTeam()
    {
        return $this->container['team'];
    }

    /**
     * Sets team
     *
     * @param \StevenBuehner\ChurchTools\Model\UpdateCampusRequestTeamInner[] $team team
     *
     * @return self
     */
    public function setTeam($team)
    {
        if (is_null($team)) {
            throw new \InvalidArgumentException('non-nullable team cannot be null');
        }


        if ((count($team) < 1)) {
            throw new \InvalidArgumentException('invalid length for $team when calling ProfileUpdate., number of items must be greater than or equal to 1.');
        }
        $this->container['team'] = $team;

        return $this;
    }

    /**
     * Gets team_title
     *
     * @return string
     */
    public function getTeamTitle()
    {
        return $this->container['team_title'];
    }

    /**
     * Sets team_title
     *
     * @param string $team_title team_title
     *
     * @return self
     */
    public function setTeamTitle($team_title)
    {
        if (is_null($team_title)) {
            throw new \InvalidArgumentException('non-nullable team_title cannot be null');
        }

        if ((mb_strlen($team_title) < 1)) {
            throw new \InvalidArgumentException('invalid length for $team_title when calling ProfileUpdate., must be bigger than or equal to 1.');
        }

        $this->container['team_title'] = $team_title;

        return $this;
    }

    /**
     * Gets visitors
     *
     * @return int
     */
    public function getVisitors()
    {
        return $this->container['visitors'];
    }

    /**
     * Sets visitors
     *
     * @param int $visitors Single integer, which represents a range.
     *
     * @return self
     */
    public function setVisitors($visitors)
    {
        if (is_null($visitors)) {
            throw new \InvalidArgumentException('non-nullable visitors cannot be null');
        }
        $allowedValues = $this->getVisitorsAllowableValues();
        if (!in_array($visitors, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'visitors', must be one of '%s'",
                    $visitors,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['visitors'] = $visitors;

        return $this;
    }

    /**
     * Gets website
     *
     * @return string
     */
    public function getWebsite()
    {
        return $this->container['website'];
    }

    /**
     * Sets website
     *
     * @param string $website website
     *
     * @return self
     */
    public function setWebsite($website)
    {
        if (is_null($website)) {
            throw new \InvalidArgumentException('non-nullable website cannot be null');
        }

        if ((mb_strlen($website) < 1)) {
            throw new \InvalidArgumentException('invalid length for $website when calling ProfileUpdate., must be bigger than or equal to 1.');
        }

        $this->container['website'] = $website;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


