<?php
/**
 * PutCheckinPersons200ResponseData
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * PutCheckinPersons200ResponseData Class Doc Comment
 *
 * @category Class
 * @description A person object includes all fields the logged in user may see depending on the security level. Additional DB fields, created by the admin, are also part of the response. Those fields have the same name as the column name.
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PutCheckinPersons200ResponseData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'put_checkin_persons_200_response_data';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'address_addition' => 'string',
        'baptised_by' => 'string',
        'birth_name' => 'string',
        'birthday' => '\DateTime',
        'birthplace' => 'string',
        'campus_id' => 'int',
        'can_chat' => 'bool',
        'chat_active' => 'bool',
        'city' => 'string',
        'cms_user_id' => 'string',
        'country' => '\StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerAddressCountry',
        'date_of_baptism' => '\DateTime',
        'date_of_belonging' => '\DateTime',
        'date_of_entry' => '\DateTime',
        'date_of_resign' => '\DateTime',
        'department_ids' => 'int[]',
        'edit_security_level_for_person' => 'int',
        'email' => 'string',
        'emails' => '\StevenBuehner\ChurchTools\Model\PutCheckinPersons200ResponseDataEmailsInner[]',
        'family_image_url' => 'string',
        'family_status_id' => 'int',
        'fax' => 'string',
        'first_contact' => '\DateTime',
        'first_name' => 'string',
        'grow_path_id' => 'int',
        'guid' => 'string',
        'id' => 'int',
        'image_url' => 'string',
        'invitation_status' => 'string',
        'is_archived' => 'bool',
        'job' => 'string',
        'last_name' => 'string',
        'latitude' => 'float',
        'latitude_loose' => 'float',
        'longitude' => 'float',
        'longitude_loose' => 'float',
        'meta' => '\StevenBuehner\ChurchTools\Model\GetBookings200ResponseDataInnerBaseMeta',
        'mobile' => 'string',
        'nationality_id' => 'int',
        'nickname' => 'string',
        'optigem_id' => 'string',
        'phone_private' => 'string',
        'phone_work' => 'string',
        'place_of_baptism' => 'string',
        'privacy_policy_agreement' => '\StevenBuehner\ChurchTools\Model\PutCheckinPersons200ResponseDataPrivacyPolicyAgreement',
        'referred_by' => 'string',
        'referred_to' => 'string',
        'security_level_for_person' => 'int',
        'sex_id' => 'int',
        'status_id' => 'int',
        'street' => 'string',
        'title' => 'string',
        'wedding_date' => '\DateTime',
        'zip' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'address_addition' => null,
        'baptised_by' => null,
        'birth_name' => null,
        'birthday' => 'date',
        'birthplace' => null,
        'campus_id' => null,
        'can_chat' => null,
        'chat_active' => null,
        'city' => null,
        'cms_user_id' => null,
        'country' => null,
        'date_of_baptism' => 'date',
        'date_of_belonging' => 'date',
        'date_of_entry' => 'date-time',
        'date_of_resign' => 'date-time',
        'department_ids' => null,
        'edit_security_level_for_person' => null,
        'email' => null,
        'emails' => null,
        'family_image_url' => null,
        'family_status_id' => null,
        'fax' => null,
        'first_contact' => 'date-time',
        'first_name' => null,
        'grow_path_id' => null,
        'guid' => null,
        'id' => null,
        'image_url' => null,
        'invitation_status' => null,
        'is_archived' => null,
        'job' => null,
        'last_name' => null,
        'latitude' => 'float',
        'latitude_loose' => 'float',
        'longitude' => 'float',
        'longitude_loose' => 'float',
        'meta' => null,
        'mobile' => null,
        'nationality_id' => null,
        'nickname' => null,
        'optigem_id' => null,
        'phone_private' => null,
        'phone_work' => null,
        'place_of_baptism' => null,
        'privacy_policy_agreement' => null,
        'referred_by' => null,
        'referred_to' => null,
        'security_level_for_person' => null,
        'sex_id' => null,
        'status_id' => null,
        'street' => null,
        'title' => null,
        'wedding_date' => 'date',
        'zip' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'address_addition' => false,
        'baptised_by' => false,
        'birth_name' => false,
        'birthday' => true,
        'birthplace' => false,
        'campus_id' => false,
        'can_chat' => false,
        'chat_active' => false,
        'city' => false,
        'cms_user_id' => false,
        'country' => false,
        'date_of_baptism' => true,
        'date_of_belonging' => true,
        'date_of_entry' => true,
        'date_of_resign' => true,
        'department_ids' => false,
        'edit_security_level_for_person' => false,
        'email' => false,
        'emails' => false,
        'family_image_url' => true,
        'family_status_id' => false,
        'fax' => false,
        'first_contact' => true,
        'first_name' => false,
        'grow_path_id' => false,
        'guid' => false,
        'id' => false,
        'image_url' => true,
        'invitation_status' => true,
        'is_archived' => false,
        'job' => false,
        'last_name' => false,
        'latitude' => true,
        'latitude_loose' => true,
        'longitude' => true,
        'longitude_loose' => true,
        'meta' => false,
        'mobile' => false,
        'nationality_id' => false,
        'nickname' => false,
        'optigem_id' => false,
        'phone_private' => false,
        'phone_work' => false,
        'place_of_baptism' => false,
        'privacy_policy_agreement' => false,
        'referred_by' => false,
        'referred_to' => false,
        'security_level_for_person' => false,
        'sex_id' => false,
        'status_id' => false,
        'street' => false,
        'title' => false,
        'wedding_date' => true,
        'zip' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'address_addition' => 'addressAddition',
        'baptised_by' => 'baptisedBy',
        'birth_name' => 'birthName',
        'birthday' => 'birthday',
        'birthplace' => 'birthplace',
        'campus_id' => 'campusId',
        'can_chat' => 'canChat',
        'chat_active' => 'chatActive',
        'city' => 'city',
        'cms_user_id' => 'cmsUserId',
        'country' => 'country',
        'date_of_baptism' => 'dateOfBaptism',
        'date_of_belonging' => 'dateOfBelonging',
        'date_of_entry' => 'dateOfEntry',
        'date_of_resign' => 'dateOfResign',
        'department_ids' => 'departmentIds',
        'edit_security_level_for_person' => 'editSecurityLevelForPerson',
        'email' => 'email',
        'emails' => 'emails',
        'family_image_url' => 'familyImageUrl',
        'family_status_id' => 'familyStatusId',
        'fax' => 'fax',
        'first_contact' => 'firstContact',
        'first_name' => 'firstName',
        'grow_path_id' => 'growPathId',
        'guid' => 'guid',
        'id' => 'id',
        'image_url' => 'imageUrl',
        'invitation_status' => 'invitationStatus',
        'is_archived' => 'isArchived',
        'job' => 'job',
        'last_name' => 'lastName',
        'latitude' => 'latitude',
        'latitude_loose' => 'latitudeLoose',
        'longitude' => 'longitude',
        'longitude_loose' => 'longitudeLoose',
        'meta' => 'meta',
        'mobile' => 'mobile',
        'nationality_id' => 'nationalityId',
        'nickname' => 'nickname',
        'optigem_id' => 'optigemId',
        'phone_private' => 'phonePrivate',
        'phone_work' => 'phoneWork',
        'place_of_baptism' => 'placeOfBaptism',
        'privacy_policy_agreement' => 'privacyPolicyAgreement',
        'referred_by' => 'referredBy',
        'referred_to' => 'referredTo',
        'security_level_for_person' => 'securityLevelForPerson',
        'sex_id' => 'sexId',
        'status_id' => 'statusId',
        'street' => 'street',
        'title' => 'title',
        'wedding_date' => 'weddingDate',
        'zip' => 'zip'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'address_addition' => 'setAddressAddition',
        'baptised_by' => 'setBaptisedBy',
        'birth_name' => 'setBirthName',
        'birthday' => 'setBirthday',
        'birthplace' => 'setBirthplace',
        'campus_id' => 'setCampusId',
        'can_chat' => 'setCanChat',
        'chat_active' => 'setChatActive',
        'city' => 'setCity',
        'cms_user_id' => 'setCmsUserId',
        'country' => 'setCountry',
        'date_of_baptism' => 'setDateOfBaptism',
        'date_of_belonging' => 'setDateOfBelonging',
        'date_of_entry' => 'setDateOfEntry',
        'date_of_resign' => 'setDateOfResign',
        'department_ids' => 'setDepartmentIds',
        'edit_security_level_for_person' => 'setEditSecurityLevelForPerson',
        'email' => 'setEmail',
        'emails' => 'setEmails',
        'family_image_url' => 'setFamilyImageUrl',
        'family_status_id' => 'setFamilyStatusId',
        'fax' => 'setFax',
        'first_contact' => 'setFirstContact',
        'first_name' => 'setFirstName',
        'grow_path_id' => 'setGrowPathId',
        'guid' => 'setGuid',
        'id' => 'setId',
        'image_url' => 'setImageUrl',
        'invitation_status' => 'setInvitationStatus',
        'is_archived' => 'setIsArchived',
        'job' => 'setJob',
        'last_name' => 'setLastName',
        'latitude' => 'setLatitude',
        'latitude_loose' => 'setLatitudeLoose',
        'longitude' => 'setLongitude',
        'longitude_loose' => 'setLongitudeLoose',
        'meta' => 'setMeta',
        'mobile' => 'setMobile',
        'nationality_id' => 'setNationalityId',
        'nickname' => 'setNickname',
        'optigem_id' => 'setOptigemId',
        'phone_private' => 'setPhonePrivate',
        'phone_work' => 'setPhoneWork',
        'place_of_baptism' => 'setPlaceOfBaptism',
        'privacy_policy_agreement' => 'setPrivacyPolicyAgreement',
        'referred_by' => 'setReferredBy',
        'referred_to' => 'setReferredTo',
        'security_level_for_person' => 'setSecurityLevelForPerson',
        'sex_id' => 'setSexId',
        'status_id' => 'setStatusId',
        'street' => 'setStreet',
        'title' => 'setTitle',
        'wedding_date' => 'setWeddingDate',
        'zip' => 'setZip'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'address_addition' => 'getAddressAddition',
        'baptised_by' => 'getBaptisedBy',
        'birth_name' => 'getBirthName',
        'birthday' => 'getBirthday',
        'birthplace' => 'getBirthplace',
        'campus_id' => 'getCampusId',
        'can_chat' => 'getCanChat',
        'chat_active' => 'getChatActive',
        'city' => 'getCity',
        'cms_user_id' => 'getCmsUserId',
        'country' => 'getCountry',
        'date_of_baptism' => 'getDateOfBaptism',
        'date_of_belonging' => 'getDateOfBelonging',
        'date_of_entry' => 'getDateOfEntry',
        'date_of_resign' => 'getDateOfResign',
        'department_ids' => 'getDepartmentIds',
        'edit_security_level_for_person' => 'getEditSecurityLevelForPerson',
        'email' => 'getEmail',
        'emails' => 'getEmails',
        'family_image_url' => 'getFamilyImageUrl',
        'family_status_id' => 'getFamilyStatusId',
        'fax' => 'getFax',
        'first_contact' => 'getFirstContact',
        'first_name' => 'getFirstName',
        'grow_path_id' => 'getGrowPathId',
        'guid' => 'getGuid',
        'id' => 'getId',
        'image_url' => 'getImageUrl',
        'invitation_status' => 'getInvitationStatus',
        'is_archived' => 'getIsArchived',
        'job' => 'getJob',
        'last_name' => 'getLastName',
        'latitude' => 'getLatitude',
        'latitude_loose' => 'getLatitudeLoose',
        'longitude' => 'getLongitude',
        'longitude_loose' => 'getLongitudeLoose',
        'meta' => 'getMeta',
        'mobile' => 'getMobile',
        'nationality_id' => 'getNationalityId',
        'nickname' => 'getNickname',
        'optigem_id' => 'getOptigemId',
        'phone_private' => 'getPhonePrivate',
        'phone_work' => 'getPhoneWork',
        'place_of_baptism' => 'getPlaceOfBaptism',
        'privacy_policy_agreement' => 'getPrivacyPolicyAgreement',
        'referred_by' => 'getReferredBy',
        'referred_to' => 'getReferredTo',
        'security_level_for_person' => 'getSecurityLevelForPerson',
        'sex_id' => 'getSexId',
        'status_id' => 'getStatusId',
        'street' => 'getStreet',
        'title' => 'getTitle',
        'wedding_date' => 'getWeddingDate',
        'zip' => 'getZip'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('address_addition', $data ?? [], null);
        $this->setIfExists('baptised_by', $data ?? [], null);
        $this->setIfExists('birth_name', $data ?? [], null);
        $this->setIfExists('birthday', $data ?? [], null);
        $this->setIfExists('birthplace', $data ?? [], null);
        $this->setIfExists('campus_id', $data ?? [], null);
        $this->setIfExists('can_chat', $data ?? [], null);
        $this->setIfExists('chat_active', $data ?? [], null);
        $this->setIfExists('city', $data ?? [], null);
        $this->setIfExists('cms_user_id', $data ?? [], null);
        $this->setIfExists('country', $data ?? [], null);
        $this->setIfExists('date_of_baptism', $data ?? [], null);
        $this->setIfExists('date_of_belonging', $data ?? [], null);
        $this->setIfExists('date_of_entry', $data ?? [], null);
        $this->setIfExists('date_of_resign', $data ?? [], null);
        $this->setIfExists('department_ids', $data ?? [], null);
        $this->setIfExists('edit_security_level_for_person', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('emails', $data ?? [], null);
        $this->setIfExists('family_image_url', $data ?? [], null);
        $this->setIfExists('family_status_id', $data ?? [], null);
        $this->setIfExists('fax', $data ?? [], null);
        $this->setIfExists('first_contact', $data ?? [], null);
        $this->setIfExists('first_name', $data ?? [], null);
        $this->setIfExists('grow_path_id', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('image_url', $data ?? [], null);
        $this->setIfExists('invitation_status', $data ?? [], null);
        $this->setIfExists('is_archived', $data ?? [], null);
        $this->setIfExists('job', $data ?? [], null);
        $this->setIfExists('last_name', $data ?? [], null);
        $this->setIfExists('latitude', $data ?? [], null);
        $this->setIfExists('latitude_loose', $data ?? [], null);
        $this->setIfExists('longitude', $data ?? [], null);
        $this->setIfExists('longitude_loose', $data ?? [], null);
        $this->setIfExists('meta', $data ?? [], null);
        $this->setIfExists('mobile', $data ?? [], null);
        $this->setIfExists('nationality_id', $data ?? [], null);
        $this->setIfExists('nickname', $data ?? [], null);
        $this->setIfExists('optigem_id', $data ?? [], null);
        $this->setIfExists('phone_private', $data ?? [], null);
        $this->setIfExists('phone_work', $data ?? [], null);
        $this->setIfExists('place_of_baptism', $data ?? [], null);
        $this->setIfExists('privacy_policy_agreement', $data ?? [], null);
        $this->setIfExists('referred_by', $data ?? [], null);
        $this->setIfExists('referred_to', $data ?? [], null);
        $this->setIfExists('security_level_for_person', $data ?? [], null);
        $this->setIfExists('sex_id', $data ?? [], null);
        $this->setIfExists('status_id', $data ?? [], null);
        $this->setIfExists('street', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('wedding_date', $data ?? [], null);
        $this->setIfExists('zip', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets address_addition
     *
     * @return string|null
     */
    public function getAddressAddition()
    {
        return $this->container['address_addition'];
    }

    /**
     * Sets address_addition
     *
     * @param string|null $address_addition address_addition
     *
     * @return self
     */
    public function setAddressAddition($address_addition)
    {
        if (is_null($address_addition)) {
            throw new \InvalidArgumentException('non-nullable address_addition cannot be null');
        }
        $this->container['address_addition'] = $address_addition;

        return $this;
    }

    /**
     * Gets baptised_by
     *
     * @return string|null
     */
    public function getBaptisedBy()
    {
        return $this->container['baptised_by'];
    }

    /**
     * Sets baptised_by
     *
     * @param string|null $baptised_by baptised_by
     *
     * @return self
     */
    public function setBaptisedBy($baptised_by)
    {
        if (is_null($baptised_by)) {
            throw new \InvalidArgumentException('non-nullable baptised_by cannot be null');
        }
        $this->container['baptised_by'] = $baptised_by;

        return $this;
    }

    /**
     * Gets birth_name
     *
     * @return string|null
     */
    public function getBirthName()
    {
        return $this->container['birth_name'];
    }

    /**
     * Sets birth_name
     *
     * @param string|null $birth_name birth_name
     *
     * @return self
     */
    public function setBirthName($birth_name)
    {
        if (is_null($birth_name)) {
            throw new \InvalidArgumentException('non-nullable birth_name cannot be null');
        }
        $this->container['birth_name'] = $birth_name;

        return $this;
    }

    /**
     * Gets birthday
     *
     * @return \DateTime|null
     */
    public function getBirthday()
    {
        return $this->container['birthday'];
    }

    /**
     * Sets birthday
     *
     * @param \DateTime|null $birthday birthday
     *
     * @return self
     */
    public function setBirthday($birthday)
    {
        if (is_null($birthday)) {
            array_push($this->openAPINullablesSetToNull, 'birthday');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('birthday', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['birthday'] = $birthday;

        return $this;
    }

    /**
     * Gets birthplace
     *
     * @return string|null
     */
    public function getBirthplace()
    {
        return $this->container['birthplace'];
    }

    /**
     * Sets birthplace
     *
     * @param string|null $birthplace birthplace
     *
     * @return self
     */
    public function setBirthplace($birthplace)
    {
        if (is_null($birthplace)) {
            throw new \InvalidArgumentException('non-nullable birthplace cannot be null');
        }
        $this->container['birthplace'] = $birthplace;

        return $this;
    }

    /**
     * Gets campus_id
     *
     * @return int|null
     */
    public function getCampusId()
    {
        return $this->container['campus_id'];
    }

    /**
     * Sets campus_id
     *
     * @param int|null $campus_id campus_id
     *
     * @return self
     */
    public function setCampusId($campus_id)
    {
        if (is_null($campus_id)) {
            throw new \InvalidArgumentException('non-nullable campus_id cannot be null');
        }
        $this->container['campus_id'] = $campus_id;

        return $this;
    }

    /**
     * Gets can_chat
     *
     * @return bool|null
     */
    public function getCanChat()
    {
        return $this->container['can_chat'];
    }

    /**
     * Sets can_chat
     *
     * @param bool|null $can_chat can_chat
     *
     * @return self
     */
    public function setCanChat($can_chat)
    {
        if (is_null($can_chat)) {
            throw new \InvalidArgumentException('non-nullable can_chat cannot be null');
        }
        $this->container['can_chat'] = $can_chat;

        return $this;
    }

    /**
     * Gets chat_active
     *
     * @return bool|null
     */
    public function getChatActive()
    {
        return $this->container['chat_active'];
    }

    /**
     * Sets chat_active
     *
     * @param bool|null $chat_active chat_active
     *
     * @return self
     */
    public function setChatActive($chat_active)
    {
        if (is_null($chat_active)) {
            throw new \InvalidArgumentException('non-nullable chat_active cannot be null');
        }
        $this->container['chat_active'] = $chat_active;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string|null $city city
     *
     * @return self
     */
    public function setCity($city)
    {
        if (is_null($city)) {
            throw new \InvalidArgumentException('non-nullable city cannot be null');
        }
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets cms_user_id
     *
     * @return string|null
     */
    public function getCmsUserId()
    {
        return $this->container['cms_user_id'];
    }

    /**
     * Sets cms_user_id
     *
     * @param string|null $cms_user_id cms_user_id
     *
     * @return self
     */
    public function setCmsUserId($cms_user_id)
    {
        if (is_null($cms_user_id)) {
            throw new \InvalidArgumentException('non-nullable cms_user_id cannot be null');
        }
        $this->container['cms_user_id'] = $cms_user_id;

        return $this;
    }

    /**
     * Gets country
     *
     * @return \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerAddressCountry|null
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param \StevenBuehner\ChurchTools\Model\GetAllCampuses200ResponseDataInnerAddressCountry|null $country country
     *
     * @return self
     */
    public function setCountry($country)
    {
        if (is_null($country)) {
            throw new \InvalidArgumentException('non-nullable country cannot be null');
        }
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets date_of_baptism
     *
     * @return \DateTime|null
     */
    public function getDateOfBaptism()
    {
        return $this->container['date_of_baptism'];
    }

    /**
     * Sets date_of_baptism
     *
     * @param \DateTime|null $date_of_baptism date_of_baptism
     *
     * @return self
     */
    public function setDateOfBaptism($date_of_baptism)
    {
        if (is_null($date_of_baptism)) {
            array_push($this->openAPINullablesSetToNull, 'date_of_baptism');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_of_baptism', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_of_baptism'] = $date_of_baptism;

        return $this;
    }

    /**
     * Gets date_of_belonging
     *
     * @return \DateTime|null
     */
    public function getDateOfBelonging()
    {
        return $this->container['date_of_belonging'];
    }

    /**
     * Sets date_of_belonging
     *
     * @param \DateTime|null $date_of_belonging date_of_belonging
     *
     * @return self
     */
    public function setDateOfBelonging($date_of_belonging)
    {
        if (is_null($date_of_belonging)) {
            array_push($this->openAPINullablesSetToNull, 'date_of_belonging');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_of_belonging', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_of_belonging'] = $date_of_belonging;

        return $this;
    }

    /**
     * Gets date_of_entry
     *
     * @return \DateTime|null
     */
    public function getDateOfEntry()
    {
        return $this->container['date_of_entry'];
    }

    /**
     * Sets date_of_entry
     *
     * @param \DateTime|null $date_of_entry date_of_entry
     *
     * @return self
     */
    public function setDateOfEntry($date_of_entry)
    {
        if (is_null($date_of_entry)) {
            array_push($this->openAPINullablesSetToNull, 'date_of_entry');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_of_entry', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_of_entry'] = $date_of_entry;

        return $this;
    }

    /**
     * Gets date_of_resign
     *
     * @return \DateTime|null
     */
    public function getDateOfResign()
    {
        return $this->container['date_of_resign'];
    }

    /**
     * Sets date_of_resign
     *
     * @param \DateTime|null $date_of_resign date_of_resign
     *
     * @return self
     */
    public function setDateOfResign($date_of_resign)
    {
        if (is_null($date_of_resign)) {
            array_push($this->openAPINullablesSetToNull, 'date_of_resign');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_of_resign', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_of_resign'] = $date_of_resign;

        return $this;
    }

    /**
     * Gets department_ids
     *
     * @return int[]|null
     */
    public function getDepartmentIds()
    {
        return $this->container['department_ids'];
    }

    /**
     * Sets department_ids
     *
     * @param int[]|null $department_ids List of department IDs
     *
     * @return self
     */
    public function setDepartmentIds($department_ids)
    {
        if (is_null($department_ids)) {
            throw new \InvalidArgumentException('non-nullable department_ids cannot be null');
        }
        $this->container['department_ids'] = $department_ids;

        return $this;
    }

    /**
     * Gets edit_security_level_for_person
     *
     * @return int|null
     */
    public function getEditSecurityLevelForPerson()
    {
        return $this->container['edit_security_level_for_person'];
    }

    /**
     * Sets edit_security_level_for_person
     *
     * @param int|null $edit_security_level_for_person Eidt security level of the current user. The user can edit fields upto this level.
     *
     * @return self
     */
    public function setEditSecurityLevelForPerson($edit_security_level_for_person)
    {
        if (is_null($edit_security_level_for_person)) {
            throw new \InvalidArgumentException('non-nullable edit_security_level_for_person cannot be null');
        }
        $this->container['edit_security_level_for_person'] = $edit_security_level_for_person;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets emails
     *
     * @return \StevenBuehner\ChurchTools\Model\PutCheckinPersons200ResponseDataEmailsInner[]|null
     */
    public function getEmails()
    {
        return $this->container['emails'];
    }

    /**
     * Sets emails
     *
     * @param \StevenBuehner\ChurchTools\Model\PutCheckinPersons200ResponseDataEmailsInner[]|null $emails emails
     *
     * @return self
     */
    public function setEmails($emails)
    {
        if (is_null($emails)) {
            throw new \InvalidArgumentException('non-nullable emails cannot be null');
        }
        $this->container['emails'] = $emails;

        return $this;
    }

    /**
     * Gets family_image_url
     *
     * @return string|null
     */
    public function getFamilyImageUrl()
    {
        return $this->container['family_image_url'];
    }

    /**
     * Sets family_image_url
     *
     * @param string|null $family_image_url family_image_url
     *
     * @return self
     */
    public function setFamilyImageUrl($family_image_url)
    {
        if (is_null($family_image_url)) {
            array_push($this->openAPINullablesSetToNull, 'family_image_url');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('family_image_url', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['family_image_url'] = $family_image_url;

        return $this;
    }

    /**
     * Gets family_status_id
     *
     * @return int|null
     */
    public function getFamilyStatusId()
    {
        return $this->container['family_status_id'];
    }

    /**
     * Sets family_status_id
     *
     * @param int|null $family_status_id family_status_id
     *
     * @return self
     */
    public function setFamilyStatusId($family_status_id)
    {
        if (is_null($family_status_id)) {
            throw new \InvalidArgumentException('non-nullable family_status_id cannot be null');
        }
        $this->container['family_status_id'] = $family_status_id;

        return $this;
    }

    /**
     * Gets fax
     *
     * @return string|null
     */
    public function getFax()
    {
        return $this->container['fax'];
    }

    /**
     * Sets fax
     *
     * @param string|null $fax fax
     *
     * @return self
     */
    public function setFax($fax)
    {
        if (is_null($fax)) {
            throw new \InvalidArgumentException('non-nullable fax cannot be null');
        }
        $this->container['fax'] = $fax;

        return $this;
    }

    /**
     * Gets first_contact
     *
     * @return \DateTime|null
     */
    public function getFirstContact()
    {
        return $this->container['first_contact'];
    }

    /**
     * Sets first_contact
     *
     * @param \DateTime|null $first_contact first_contact
     *
     * @return self
     */
    public function setFirstContact($first_contact)
    {
        if (is_null($first_contact)) {
            array_push($this->openAPINullablesSetToNull, 'first_contact');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('first_contact', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['first_contact'] = $first_contact;

        return $this;
    }

    /**
     * Gets first_name
     *
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param string|null $first_name first_name
     *
     * @return self
     */
    public function setFirstName($first_name)
    {
        if (is_null($first_name)) {
            throw new \InvalidArgumentException('non-nullable first_name cannot be null');
        }
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets grow_path_id
     *
     * @return int|null
     */
    public function getGrowPathId()
    {
        return $this->container['grow_path_id'];
    }

    /**
     * Sets grow_path_id
     *
     * @param int|null $grow_path_id grow_path_id
     *
     * @return self
     */
    public function setGrowPathId($grow_path_id)
    {
        if (is_null($grow_path_id)) {
            throw new \InvalidArgumentException('non-nullable grow_path_id cannot be null');
        }
        $this->container['grow_path_id'] = $grow_path_id;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets image_url
     *
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->container['image_url'];
    }

    /**
     * Sets image_url
     *
     * @param string|null $image_url image_url
     *
     * @return self
     */
    public function setImageUrl($image_url)
    {
        if (is_null($image_url)) {
            array_push($this->openAPINullablesSetToNull, 'image_url');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('image_url', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['image_url'] = $image_url;

        return $this;
    }

    /**
     * Gets invitation_status
     *
     * @return string|null
     */
    public function getInvitationStatus()
    {
        return $this->container['invitation_status'];
    }

    /**
     * Sets invitation_status
     *
     * @param string|null $invitation_status invitation_status
     *
     * @return self
     */
    public function setInvitationStatus($invitation_status)
    {
        if (is_null($invitation_status)) {
            array_push($this->openAPINullablesSetToNull, 'invitation_status');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('invitation_status', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['invitation_status'] = $invitation_status;

        return $this;
    }

    /**
     * Gets is_archived
     *
     * @return bool|null
     */
    public function getIsArchived()
    {
        return $this->container['is_archived'];
    }

    /**
     * Sets is_archived
     *
     * @param bool|null $is_archived is_archived
     *
     * @return self
     */
    public function setIsArchived($is_archived)
    {
        if (is_null($is_archived)) {
            throw new \InvalidArgumentException('non-nullable is_archived cannot be null');
        }
        $this->container['is_archived'] = $is_archived;

        return $this;
    }

    /**
     * Gets job
     *
     * @return string|null
     */
    public function getJob()
    {
        return $this->container['job'];
    }

    /**
     * Sets job
     *
     * @param string|null $job job
     *
     * @return self
     */
    public function setJob($job)
    {
        if (is_null($job)) {
            throw new \InvalidArgumentException('non-nullable job cannot be null');
        }
        $this->container['job'] = $job;

        return $this;
    }

    /**
     * Gets last_name
     *
     * @return string|null
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param string|null $last_name last_name
     *
     * @return self
     */
    public function setLastName($last_name)
    {
        if (is_null($last_name)) {
            throw new \InvalidArgumentException('non-nullable last_name cannot be null');
        }
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets latitude
     *
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->container['latitude'];
    }

    /**
     * Sets latitude
     *
     * @param float|null $latitude latitude
     *
     * @return self
     */
    public function setLatitude($latitude)
    {
        if (is_null($latitude)) {
            array_push($this->openAPINullablesSetToNull, 'latitude');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('latitude', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['latitude'] = $latitude;

        return $this;
    }

    /**
     * Gets latitude_loose
     *
     * @return float|null
     */
    public function getLatitudeLoose()
    {
        return $this->container['latitude_loose'];
    }

    /**
     * Sets latitude_loose
     *
     * @param float|null $latitude_loose latitude_loose
     *
     * @return self
     */
    public function setLatitudeLoose($latitude_loose)
    {
        if (is_null($latitude_loose)) {
            array_push($this->openAPINullablesSetToNull, 'latitude_loose');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('latitude_loose', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['latitude_loose'] = $latitude_loose;

        return $this;
    }

    /**
     * Gets longitude
     *
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->container['longitude'];
    }

    /**
     * Sets longitude
     *
     * @param float|null $longitude longitude
     *
     * @return self
     */
    public function setLongitude($longitude)
    {
        if (is_null($longitude)) {
            array_push($this->openAPINullablesSetToNull, 'longitude');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('longitude', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['longitude'] = $longitude;

        return $this;
    }

    /**
     * Gets longitude_loose
     *
     * @return float|null
     */
    public function getLongitudeLoose()
    {
        return $this->container['longitude_loose'];
    }

    /**
     * Sets longitude_loose
     *
     * @param float|null $longitude_loose longitude_loose
     *
     * @return self
     */
    public function setLongitudeLoose($longitude_loose)
    {
        if (is_null($longitude_loose)) {
            array_push($this->openAPINullablesSetToNull, 'longitude_loose');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('longitude_loose', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['longitude_loose'] = $longitude_loose;

        return $this;
    }

    /**
     * Gets meta
     *
     * @return \StevenBuehner\ChurchTools\Model\GetBookings200ResponseDataInnerBaseMeta|null
     */
    public function getMeta()
    {
        return $this->container['meta'];
    }

    /**
     * Sets meta
     *
     * @param \StevenBuehner\ChurchTools\Model\GetBookings200ResponseDataInnerBaseMeta|null $meta meta
     *
     * @return self
     */
    public function setMeta($meta)
    {
        if (is_null($meta)) {
            throw new \InvalidArgumentException('non-nullable meta cannot be null');
        }
        $this->container['meta'] = $meta;

        return $this;
    }

    /**
     * Gets mobile
     *
     * @return string|null
     */
    public function getMobile()
    {
        return $this->container['mobile'];
    }

    /**
     * Sets mobile
     *
     * @param string|null $mobile mobile
     *
     * @return self
     */
    public function setMobile($mobile)
    {
        if (is_null($mobile)) {
            throw new \InvalidArgumentException('non-nullable mobile cannot be null');
        }
        $this->container['mobile'] = $mobile;

        return $this;
    }

    /**
     * Gets nationality_id
     *
     * @return int|null
     */
    public function getNationalityId()
    {
        return $this->container['nationality_id'];
    }

    /**
     * Sets nationality_id
     *
     * @param int|null $nationality_id nationality_id
     *
     * @return self
     */
    public function setNationalityId($nationality_id)
    {
        if (is_null($nationality_id)) {
            throw new \InvalidArgumentException('non-nullable nationality_id cannot be null');
        }
        $this->container['nationality_id'] = $nationality_id;

        return $this;
    }

    /**
     * Gets nickname
     *
     * @return string|null
     */
    public function getNickname()
    {
        return $this->container['nickname'];
    }

    /**
     * Sets nickname
     *
     * @param string|null $nickname nickname
     *
     * @return self
     */
    public function setNickname($nickname)
    {
        if (is_null($nickname)) {
            throw new \InvalidArgumentException('non-nullable nickname cannot be null');
        }
        $this->container['nickname'] = $nickname;

        return $this;
    }

    /**
     * Gets optigem_id
     *
     * @return string|null
     */
    public function getOptigemId()
    {
        return $this->container['optigem_id'];
    }

    /**
     * Sets optigem_id
     *
     * @param string|null $optigem_id String with Optigem ID or empty string if no ID is set.
     *
     * @return self
     */
    public function setOptigemId($optigem_id)
    {
        if (is_null($optigem_id)) {
            throw new \InvalidArgumentException('non-nullable optigem_id cannot be null');
        }
        $this->container['optigem_id'] = $optigem_id;

        return $this;
    }

    /**
     * Gets phone_private
     *
     * @return string|null
     */
    public function getPhonePrivate()
    {
        return $this->container['phone_private'];
    }

    /**
     * Sets phone_private
     *
     * @param string|null $phone_private phone_private
     *
     * @return self
     */
    public function setPhonePrivate($phone_private)
    {
        if (is_null($phone_private)) {
            throw new \InvalidArgumentException('non-nullable phone_private cannot be null');
        }
        $this->container['phone_private'] = $phone_private;

        return $this;
    }

    /**
     * Gets phone_work
     *
     * @return string|null
     */
    public function getPhoneWork()
    {
        return $this->container['phone_work'];
    }

    /**
     * Sets phone_work
     *
     * @param string|null $phone_work phone_work
     *
     * @return self
     */
    public function setPhoneWork($phone_work)
    {
        if (is_null($phone_work)) {
            throw new \InvalidArgumentException('non-nullable phone_work cannot be null');
        }
        $this->container['phone_work'] = $phone_work;

        return $this;
    }

    /**
     * Gets place_of_baptism
     *
     * @return string|null
     */
    public function getPlaceOfBaptism()
    {
        return $this->container['place_of_baptism'];
    }

    /**
     * Sets place_of_baptism
     *
     * @param string|null $place_of_baptism place_of_baptism
     *
     * @return self
     */
    public function setPlaceOfBaptism($place_of_baptism)
    {
        if (is_null($place_of_baptism)) {
            throw new \InvalidArgumentException('non-nullable place_of_baptism cannot be null');
        }
        $this->container['place_of_baptism'] = $place_of_baptism;

        return $this;
    }

    /**
     * Gets privacy_policy_agreement
     *
     * @return \StevenBuehner\ChurchTools\Model\PutCheckinPersons200ResponseDataPrivacyPolicyAgreement|null
     */
    public function getPrivacyPolicyAgreement()
    {
        return $this->container['privacy_policy_agreement'];
    }

    /**
     * Sets privacy_policy_agreement
     *
     * @param \StevenBuehner\ChurchTools\Model\PutCheckinPersons200ResponseDataPrivacyPolicyAgreement|null $privacy_policy_agreement privacy_policy_agreement
     *
     * @return self
     */
    public function setPrivacyPolicyAgreement($privacy_policy_agreement)
    {
        if (is_null($privacy_policy_agreement)) {
            throw new \InvalidArgumentException('non-nullable privacy_policy_agreement cannot be null');
        }
        $this->container['privacy_policy_agreement'] = $privacy_policy_agreement;

        return $this;
    }

    /**
     * Gets referred_by
     *
     * @return string|null
     */
    public function getReferredBy()
    {
        return $this->container['referred_by'];
    }

    /**
     * Sets referred_by
     *
     * @param string|null $referred_by referred_by
     *
     * @return self
     */
    public function setReferredBy($referred_by)
    {
        if (is_null($referred_by)) {
            throw new \InvalidArgumentException('non-nullable referred_by cannot be null');
        }
        $this->container['referred_by'] = $referred_by;

        return $this;
    }

    /**
     * Gets referred_to
     *
     * @return string|null
     */
    public function getReferredTo()
    {
        return $this->container['referred_to'];
    }

    /**
     * Sets referred_to
     *
     * @param string|null $referred_to referred_to
     *
     * @return self
     */
    public function setReferredTo($referred_to)
    {
        if (is_null($referred_to)) {
            throw new \InvalidArgumentException('non-nullable referred_to cannot be null');
        }
        $this->container['referred_to'] = $referred_to;

        return $this;
    }

    /**
     * Gets security_level_for_person
     *
     * @return int|null
     */
    public function getSecurityLevelForPerson()
    {
        return $this->container['security_level_for_person'];
    }

    /**
     * Sets security_level_for_person
     *
     * @param int|null $security_level_for_person Security level of the current user. The user sees fields upto this level.
     *
     * @return self
     */
    public function setSecurityLevelForPerson($security_level_for_person)
    {
        if (is_null($security_level_for_person)) {
            throw new \InvalidArgumentException('non-nullable security_level_for_person cannot be null');
        }
        $this->container['security_level_for_person'] = $security_level_for_person;

        return $this;
    }

    /**
     * Gets sex_id
     *
     * @return int|null
     */
    public function getSexId()
    {
        return $this->container['sex_id'];
    }

    /**
     * Sets sex_id
     *
     * @param int|null $sex_id sex_id
     *
     * @return self
     */
    public function setSexId($sex_id)
    {
        if (is_null($sex_id)) {
            throw new \InvalidArgumentException('non-nullable sex_id cannot be null');
        }
        $this->container['sex_id'] = $sex_id;

        return $this;
    }

    /**
     * Gets status_id
     *
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->container['status_id'];
    }

    /**
     * Sets status_id
     *
     * @param int|null $status_id status_id
     *
     * @return self
     */
    public function setStatusId($status_id)
    {
        if (is_null($status_id)) {
            throw new \InvalidArgumentException('non-nullable status_id cannot be null');
        }
        $this->container['status_id'] = $status_id;

        return $this;
    }

    /**
     * Gets street
     *
     * @return string|null
     */
    public function getStreet()
    {
        return $this->container['street'];
    }

    /**
     * Sets street
     *
     * @param string|null $street street
     *
     * @return self
     */
    public function setStreet($street)
    {
        if (is_null($street)) {
            throw new \InvalidArgumentException('non-nullable street cannot be null');
        }
        $this->container['street'] = $street;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title title
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            throw new \InvalidArgumentException('non-nullable title cannot be null');
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets wedding_date
     *
     * @return \DateTime|null
     */
    public function getWeddingDate()
    {
        return $this->container['wedding_date'];
    }

    /**
     * Sets wedding_date
     *
     * @param \DateTime|null $wedding_date wedding_date
     *
     * @return self
     */
    public function setWeddingDate($wedding_date)
    {
        if (is_null($wedding_date)) {
            array_push($this->openAPINullablesSetToNull, 'wedding_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('wedding_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['wedding_date'] = $wedding_date;

        return $this;
    }

    /**
     * Gets zip
     *
     * @return string|null
     */
    public function getZip()
    {
        return $this->container['zip'];
    }

    /**
     * Sets zip
     *
     * @param string|null $zip zip
     *
     * @return self
     */
    public function setZip($zip)
    {
        if (is_null($zip)) {
            throw new \InvalidArgumentException('non-nullable zip cannot be null');
        }
        $this->container['zip'] = $zip;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


