<?php
/**
 * Widget1
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * ChurchTools REST API
 *
 * The ChurchTools REST API is the best entry point for developers to access ChurchTools. <br><br> **Authentication:** You need to be authorized to use some endpoints. Those endpoints are marked by a gray lock symbol. If you view the documentation, while you are logged into ChurchTools, all requests are already authorized. If you want to authorized a request, you need to provide a `Login Token` as `Authorization` header in the format `Authorization: Login<token>` or send a valid cookie. You can use the green \"Authorize\" dialog to enter those details and see how a request would look like in detail. <br><br> **Missing Endpoints:** Not all features are yet available by our new REST API. This documentation will grow in the future. We are working hard to add new endpoints with every ChurchTools version. The documentation will always show only those endpoints you can use with your ChurchTools installation.
 *
 * The version of the OpenAPI document: 0.1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace StevenBuehner\ChurchTools\Model;

use \ArrayAccess;
use \StevenBuehner\ChurchTools\ObjectSerializer;

/**
 * Widget1 Class Doc Comment
 *
 * @category Class
 * @description Container for the widget-system
 * @package  StevenBuehner\ChurchTools
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Widget1 implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Widget_1';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'actions' => '\StevenBuehner\ChurchTools\Model\WidgetAction1[]',
        'empty_strategy' => 'string',
        'empty_text' => 'string',
        'filter' => '\StevenBuehner\ChurchTools\Model\Widget1Filter',
        'items' => '\StevenBuehner\ChurchTools\Model\WidgetItem1[]',
        'key' => 'string',
        'title' => 'string',
        'widget_settings' => '\StevenBuehner\ChurchTools\Model\Widget1WidgetSettings',
        'widget_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'actions' => null,
        'empty_strategy' => null,
        'empty_text' => null,
        'filter' => null,
        'items' => null,
        'key' => null,
        'title' => null,
        'widget_settings' => null,
        'widget_type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'actions' => false,
        'empty_strategy' => false,
        'empty_text' => false,
        'filter' => false,
        'items' => false,
        'key' => false,
        'title' => false,
        'widget_settings' => false,
        'widget_type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'actions' => 'actions',
        'empty_strategy' => 'emptyStrategy',
        'empty_text' => 'emptyText',
        'filter' => 'filter',
        'items' => 'items',
        'key' => 'key',
        'title' => 'title',
        'widget_settings' => 'widgetSettings',
        'widget_type' => 'widgetType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'actions' => 'setActions',
        'empty_strategy' => 'setEmptyStrategy',
        'empty_text' => 'setEmptyText',
        'filter' => 'setFilter',
        'items' => 'setItems',
        'key' => 'setKey',
        'title' => 'setTitle',
        'widget_settings' => 'setWidgetSettings',
        'widget_type' => 'setWidgetType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'actions' => 'getActions',
        'empty_strategy' => 'getEmptyStrategy',
        'empty_text' => 'getEmptyText',
        'filter' => 'getFilter',
        'items' => 'getItems',
        'key' => 'getKey',
        'title' => 'getTitle',
        'widget_settings' => 'getWidgetSettings',
        'widget_type' => 'getWidgetType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const EMPTY_STRATEGY_SHOW = 'SHOW';
    public const EMPTY_STRATEGY_HIDE = 'HIDE';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getEmptyStrategyAllowableValues()
    {
        return [
            self::EMPTY_STRATEGY_SHOW,
            self::EMPTY_STRATEGY_HIDE,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('actions', $data ?? [], null);
        $this->setIfExists('empty_strategy', $data ?? [], null);
        $this->setIfExists('empty_text', $data ?? [], null);
        $this->setIfExists('filter', $data ?? [], null);
        $this->setIfExists('items', $data ?? [], null);
        $this->setIfExists('key', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('widget_settings', $data ?? [], null);
        $this->setIfExists('widget_type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getEmptyStrategyAllowableValues();
        if (!is_null($this->container['empty_strategy']) && !in_array($this->container['empty_strategy'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'empty_strategy', must be one of '%s'",
                $this->container['empty_strategy'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['items'] === null) {
            $invalidProperties[] = "'items' can't be null";
        }
        if ($this->container['key'] === null) {
            $invalidProperties[] = "'key' can't be null";
        }
        if ($this->container['widget_type'] === null) {
            $invalidProperties[] = "'widget_type' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets actions
     *
     * @return \StevenBuehner\ChurchTools\Model\WidgetAction1[]|null
     */
    public function getActions()
    {
        return $this->container['actions'];
    }

    /**
     * Sets actions
     *
     * @param \StevenBuehner\ChurchTools\Model\WidgetAction1[]|null $actions actions
     *
     * @return self
     */
    public function setActions($actions)
    {
        if (is_null($actions)) {
            throw new \InvalidArgumentException('non-nullable actions cannot be null');
        }


        $this->container['actions'] = $actions;

        return $this;
    }

    /**
     * Gets empty_strategy
     *
     * @return string|null
     */
    public function getEmptyStrategy()
    {
        return $this->container['empty_strategy'];
    }

    /**
     * Sets empty_strategy
     *
     * @param string|null $empty_strategy empty_strategy
     *
     * @return self
     */
    public function setEmptyStrategy($empty_strategy)
    {
        if (is_null($empty_strategy)) {
            throw new \InvalidArgumentException('non-nullable empty_strategy cannot be null');
        }
        $allowedValues = $this->getEmptyStrategyAllowableValues();
        if (!in_array($empty_strategy, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'empty_strategy', must be one of '%s'",
                    $empty_strategy,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['empty_strategy'] = $empty_strategy;

        return $this;
    }

    /**
     * Gets empty_text
     *
     * @return string|null
     */
    public function getEmptyText()
    {
        return $this->container['empty_text'];
    }

    /**
     * Sets empty_text
     *
     * @param string|null $empty_text empty_text
     *
     * @return self
     */
    public function setEmptyText($empty_text)
    {
        if (is_null($empty_text)) {
            throw new \InvalidArgumentException('non-nullable empty_text cannot be null');
        }
        $this->container['empty_text'] = $empty_text;

        return $this;
    }

    /**
     * Gets filter
     *
     * @return \StevenBuehner\ChurchTools\Model\Widget1Filter|null
     */
    public function getFilter()
    {
        return $this->container['filter'];
    }

    /**
     * Sets filter
     *
     * @param \StevenBuehner\ChurchTools\Model\Widget1Filter|null $filter filter
     *
     * @return self
     */
    public function setFilter($filter)
    {
        if (is_null($filter)) {
            throw new \InvalidArgumentException('non-nullable filter cannot be null');
        }
        $this->container['filter'] = $filter;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \StevenBuehner\ChurchTools\Model\WidgetItem1[]
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \StevenBuehner\ChurchTools\Model\WidgetItem1[] $items items
     *
     * @return self
     */
    public function setItems($items)
    {
        if (is_null($items)) {
            throw new \InvalidArgumentException('non-nullable items cannot be null');
        }
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets key
     *
     * @return string
     */
    public function getKey()
    {
        return $this->container['key'];
    }

    /**
     * Sets key
     *
     * @param string $key key
     *
     * @return self
     */
    public function setKey($key)
    {
        if (is_null($key)) {
            throw new \InvalidArgumentException('non-nullable key cannot be null');
        }
        $this->container['key'] = $key;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title title
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            throw new \InvalidArgumentException('non-nullable title cannot be null');
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets widget_settings
     *
     * @return \StevenBuehner\ChurchTools\Model\Widget1WidgetSettings|null
     */
    public function getWidgetSettings()
    {
        return $this->container['widget_settings'];
    }

    /**
     * Sets widget_settings
     *
     * @param \StevenBuehner\ChurchTools\Model\Widget1WidgetSettings|null $widget_settings widget_settings
     *
     * @return self
     */
    public function setWidgetSettings($widget_settings)
    {
        if (is_null($widget_settings)) {
            throw new \InvalidArgumentException('non-nullable widget_settings cannot be null');
        }
        $this->container['widget_settings'] = $widget_settings;

        return $this;
    }

    /**
     * Gets widget_type
     *
     * @return string
     */
    public function getWidgetType()
    {
        return $this->container['widget_type'];
    }

    /**
     * Sets widget_type
     *
     * @param string $widget_type widget_type
     *
     * @return self
     */
    public function setWidgetType($widget_type)
    {
        if (is_null($widget_type)) {
            throw new \InvalidArgumentException('non-nullable widget_type cannot be null');
        }
        $this->container['widget_type'] = $widget_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


